! f90 include file

!_______________________________________________________________________
!
   function is_EQ_rows( v1, v2 ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for real vectors: '=='
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size_col_ind
         i = abs(col_ind(j))
         if( v1(i) /= v2(i) ) then
            bool = .false.
            return
         end if
      end do
      bool = .true.

#endif
   end function is_EQ_rows
!_______________________________________________________________________
!
   function is_EQ_rows_int( v1, v2 ) result( bool )

      integer, intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for integer vectors: '=='
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size_col_ind
         i = abs(col_ind(j))
         if( v1(i) /= v2(i) ) then
            bool = .false.
            return
         end if
      end do
      bool = .true.

#endif
   end function is_EQ_rows_int
   !____________________________________________________________________
   !
   function is_GT_rows( v1, v2 ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for real vectors: '>'
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

   !------ end of declarations -- execution starts hereafter  ------

      bool = is_GT_rows_work( v1, v2, start=1 )

#endif
   end function is_GT_rows
   !____________________________________________________________________
   !
   function is_GT_rows_int( v1, v2 ) result( bool )

      integer, intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for integer vectors: '>'
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

   !------ end of declarations -- execution starts hereafter  ------

      bool = is_GT_rows_int_work( v1, v2, start=1 )

#endif
   end function is_GT_rows_int
   !____________________________________________________________________
   !
   function is_GE_rows( v1, v2 ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for real vectors: '>='
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

   !------ end of declarations -- execution starts hereafter  ------

      bool = is_GE_rows_work( v1, v2, start=1 )

#endif
   end function is_GE_rows
   !____________________________________________________________________
   !
   function is_GE_rows_int( v1, v2 ) result( bool )

      integer, intent(in) :: v1(:), v2(:)
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! Order relation for integer vectors: '>='
      !
      ! Compares two vectors: first, compares the element in the first
      ! position given by col_ind(:), then if they are equal, the element
      ! in the second position given by col_ind(:), and so on, up to
      ! process all elements in col_ind(:).

   !------ end of declarations -- execution starts hereafter  ------

      bool = is_GE_rows_int_work( v1, v2, start=1 )

#endif
   end function is_GE_rows_int
   !____________________________________________________________________
   !
   recursive function is_GT_rows_work( v1, v2, start ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      integer,              intent(in) :: start
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! work-horse routine for 'is_GT_rows'
      ! 'start' is the index of col_ind(:)
      ! default sort is ascending ; if the 'col_ind' index is negative,
      ! then the sort will be descending.

      integer :: i, dir

   !------ end of declarations -- execution starts hereafter  ------

      i = col_ind(start)
      dir = sign( 1, i )
      i = abs( i )

      if( dir*(v1(i) - v2(i)) > 0 ) then
         bool = .true.
      else if( dir*(v1(i) - v2(i)) < 0 ) then
         bool = .false.
      else ! v1(i) = v2(i)
         if( start == size_col_ind ) then
            bool = .false.
            return
         end if
         bool = is_GT_rows_work( v1, v2, start=start+1 )
      end if

#endif
   end function is_GT_rows_work
   !____________________________________________________________________
   !
   recursive function is_GT_rows_int_work( v1, v2, start ) result( bool )

      integer, intent(in) :: v1(:), v2(:)
      integer, intent(in) :: start
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! work-horse routine for 'is_GT_rows_int'
      ! 'start' is the index of col_ind(:)
      ! default sort is ascending ; if the 'col_ind' index is negative,
      ! then the sort will be descending.

      integer :: i, dir

   !------ end of declarations -- execution starts hereafter  ------

      i = col_ind(start)
      dir = sign( 1, i )
      i = abs( i )

      if( dir*(v1(i) - v2(i)) > 0 ) then
         bool = .true.
      else if( dir*(v1(i) - v2(i)) < 0 ) then
         bool = .false.
      else ! v1(i) = v2(i)
         if( start == size_col_ind ) then
            bool = .false.
            return
         end if
         bool = is_GT_rows_int_work( v1, v2, start=start+1 )
      end if

#endif
   end function is_GT_rows_int_work
   !____________________________________________________________________
   !
   recursive function is_GE_rows_work( v1, v2, start ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      integer,              intent(in) :: start
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! work-horse routine for 'is_GE_rows'
      ! 'start' is the index of col_ind(:)
      ! default sort is ascending ; if the 'col_ind' index is negative,
      ! then the sort will be descending.

      integer :: i, dir

   !------ end of declarations -- execution starts hereafter  ------

      i = col_ind(start)
      dir = sign( 1, i )
      i = abs( i )

      if( dir*(v1(i) - v2(i)) > 0 ) then
         bool = .true.
      else if( dir*(v1(i) - v2(i)) < 0 ) then
         bool = .false.
      else ! v1(i) = v2(i)
         if( start == size_col_ind ) then
            bool = .true.
            return
         end if
         bool = is_GE_rows_work( v1, v2, start=start+1 )
      end if

#endif
   end function is_GE_rows_work
   !____________________________________________________________________
   !
   recursive function is_GE_rows_int_work( v1, v2, start ) result( bool )

      integer, intent(in) :: v1(:), v2(:)
      integer, intent(in) :: start
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
      ! work-horse routine for 'is_GE_rows_int'
      ! 'start' is the index of col_ind(:)
      ! default sort is ascending ; if the 'col_ind' index is negative,
      ! then the sort will be descending.

      integer :: i, dir

   !------ end of declarations -- execution starts hereafter  ------

      i = col_ind(start)
      dir = sign( 1, i )
      i = abs( i )

      if( dir*(v1(i) - v2(i)) > 0 ) then
         bool = .true.
      else if( dir*(v1(i) - v2(i)) < 0 ) then
         bool = .false.
      else ! v1(i) = v2(i)
         if( start == size_col_ind ) then
            bool = .true.
            return
         end if
         bool = is_GE_rows_int_work( v1, v2, start=start+1 )
      end if

#endif
   end function is_GE_rows_int_work
   !____________________________________________________________________
   !
   recursive subroutine quick_sortrows_1( A )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      !------ API end ------

      ! Entry point.
      ! Recursive Fortran quicksort routine
      !   sorts real vectors into order specified by the sign of
      !   col_ind indices
      ! Uses the following order functions:
      !   is_EQ_rows()
      !   is_GT_rows()
      !   is_GE_rows()
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: ipiv, nrows
      real(kind=MF_DOUBLE) :: temp( size(A,2) )

   !------ end of declarations -- execution starts hereafter  ------

!### not optimized! the following instructions are called many times
!    => move them in the calling routine
      nrows = size(A,1)
      if( .not. allocated(col_ind) ) then
         write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR."
         write(STDERR,*) "                         'col_ind' vector is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if
      size_col_ind = size(col_ind)
!### ###

      if( nrows > 2 ) then
         call partition_sortrows_1( A, ipiv )
         if( 2 <= ipiv-1 ) then
            call quick_sortrows_1( A(:ipiv-1,:) )
         end if
         if( ipiv+1 <= nrows-1 ) then
            call quick_sortrows_1( A(ipiv+1:,:) )
         end if
      else if( nrows == 2 ) then
         if( is_GT_rows( A(1,:), A(2,:) ) ) then
            temp = A(1,:)
            A(1,:) = A(2,:)
            A(2,:) = temp
         end if
      end if

   end subroutine quick_sortrows_1
   !____________________________________________________________________
   !
   subroutine partition_sortrows_1( A, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      integer,              intent(out)    :: ipiv
      !------ API end ------

      ! Auxiliary routine for 'quick_sortrows_1'
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: i, j, nrows
      real(kind=MF_DOUBLE) :: temp( size(A,2) )
      real(kind=MF_DOUBLE) :: piv( size(A,2) ) ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      nrows = size(A,1)
      piv = A(nrows/2+1,:)
      i = 1
      j = nrows

      do
         do
            if( is_GE_rows( A(i,:), piv ) ) exit
            i = i + 1
         end do
         do
            if( .not. is_GT_rows( A(j,:), piv ) ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( .not. is_EQ_rows( A(i,:), A(j,:) ) ) then
               ! exchange A(i) and A(j)
               temp = A(i,:)
               A(i,:) = A(j,:)
               A(j,:) = temp
            else
               i = i + 1
            end if
         else
            if( is_EQ_rows( A(i,:), piv ) ) then
               ipiv = i
            else
!### ici, c'est un garde-fou ! Si on suppose l'algorithme juste, alors
!    il est inutile de faire ce test (qui pénalise l'effacité de l'algo)
               if( .not. is_EQ_rows( A(j,:), piv ) ) then
                  write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR:"
                  write(STDERR,*) "                         pb in partition_sortrows_1"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
!### ###
               ipiv = j
            end if
            return
         end if
     end do

   end subroutine partition_sortrows_1
   !____________________________________________________________________
   !
   recursive subroutine quick_sortrows_2( A, ind )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      real(kind=MF_DOUBLE), intent(in out) :: ind(:)
      !------ API end ------

      ! Entry point.
      ! Recursive Fortran quicksort routine
      !   sorts real vectors into order specified by the sign of
      !   col_ind indices
      ! Uses the following order functions:
      !   is_EQ_rows()
      !   is_GT_rows()
      !   is_GE_rows()
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: ipiv, nrows
      real(kind=MF_DOUBLE) :: tmp, temp( size(A,2) )

   !------ end of declarations -- execution starts hereafter  ------

!### not optimized! the following instructions are called many times
!    => move them in the calling routine
      nrows = size(A,1)
      if( .not. allocated(col_ind) ) then
         write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR."
         write(STDERR,*) "                         'col_ind' vector is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if
      size_col_ind = size(col_ind)
!### ###

      if( nrows > 2 ) then
         call partition_sortrows_2( A, ind, ipiv )
         if( 2 <= ipiv-1 ) then
            call quick_sortrows_2( A(:ipiv-1,:), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= nrows-1 ) then
            call quick_sortrows_2( A(ipiv+1:,:), ind(ipiv+1:) )
         end if
      else if( nrows == 2 ) then
         if( is_GT_rows( A(1,:), A(2,:) ) ) then
            temp = A(1,:)
            A(1,:) = A(2,:)
            A(2,:) = temp
            tmp = ind(1)
            ind(1) = ind(2)
            ind(2) = tmp
         end if
      end if

   end subroutine quick_sortrows_2
   !____________________________________________________________________
   !
   subroutine partition_sortrows_2( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      real(kind=MF_DOUBLE), intent(in out) :: ind(:)
      integer,              intent(out)    :: ipiv
      !------ API end ------

      ! Auxiliary routine for 'quick_sortrows_2'
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: i, j, nrows
      real(kind=MF_DOUBLE) :: tmp, temp( size(A,2) )
      real(kind=MF_DOUBLE) :: piv( size(A,2) ) ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      nrows = size(A,1)
      piv = A(nrows/2+1,:)
      i = 1
      j = nrows

      do
         do
            if( is_GE_rows( A(i,:), piv ) ) exit
            i = i + 1
         end do
         do
            if( .not. is_GT_rows( A(j,:), piv ) ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( .not. is_EQ_rows( A(i,:), A(j,:) ) ) then
               ! exchange A(i) and A(j)
               temp = A(i,:)
               A(i,:) = A(j,:)
               A(j,:) = temp

               tmp = ind(i)
               ind(i) = ind(j)
               ind(j) = tmp
            else
               i = i + 1
            end if
         else
            if( is_EQ_rows( A(i,:), piv ) ) then
               ipiv = i
            else
!### ici, c'est un garde-fou ! Si on suppose l'algorithme juste, alors
!    il est inutile de faire ce test (qui pénalise l'effacité de l'algo)
               if( .not. is_EQ_rows( A(j,:), piv ) ) then
                  write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR:"
                  write(STDERR,*) "                         pb in partition_sortrows_2"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
!### ###
               ipiv = j
            end if
            return
         end if
     end do

   end subroutine partition_sortrows_2
   !____________________________________________________________________
   !
   recursive subroutine quick_sortrows_3( A, ind )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      integer,              intent(in out) :: ind(:)
      !------ API end ------

      ! Entry point.
      ! Recursive Fortran quicksort routine
      !   sorts real vectors into order specified by the sign of
      !   col_ind indices
      ! Uses the following order functions:
      !   is_EQ_rows()
      !   is_GT_rows()
      !   is_GE_rows()
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: ipiv, nrows, itmp
      real(kind=MF_DOUBLE) :: temp( size(A,2) )

   !------ end of declarations -- execution starts hereafter  ------

!### not optimized! the following instructions are called many times
!    => move them in the calling routine
      nrows = size(A,1)
      if( .not. allocated(col_ind) ) then
         write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR."
         write(STDERR,*) "                         'col_ind' vector is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if
      size_col_ind = size(col_ind)
!### ###

      if( nrows > 2 ) then
         call partition_sortrows_3( A, ind, ipiv )
         if( 2 <= ipiv-1 ) then
            call quick_sortrows_3( A(:ipiv-1,:), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= nrows-1 ) then
            call quick_sortrows_3( A(ipiv+1:,:), ind(ipiv+1:) )
         end if
      else if( nrows == 2 ) then
         if( is_GT_rows( A(1,:), A(2,:) ) ) then
            temp = A(1,:)
            A(1,:) = A(2,:)
            A(2,:) = temp
            itmp = ind(1)
            ind(1) = ind(2)
            ind(2) = itmp
         end if
      end if

   end subroutine quick_sortrows_3
   !____________________________________________________________________
   !
   subroutine partition_sortrows_3( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:,:)
      integer,              intent(in out) :: ind(:)
      integer,              intent(out)    :: ipiv
      !------ API end ------

      ! Auxiliary routine for 'quick_sortrows_3'
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: i, j, nrows, itmp
      real(kind=MF_DOUBLE) :: temp( size(A,2) )
      real(kind=MF_DOUBLE) :: piv( size(A,2) ) ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      nrows = size(A,1)
      piv = A(nrows/2+1,:)
      i = 1
      j = nrows

      do
         do
            if( is_GE_rows( A(i,:), piv ) ) exit
            i = i + 1
         end do
         do
            if( .not. is_GT_rows( A(j,:), piv ) ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( .not. is_EQ_rows( A(i,:), A(j,:) ) ) then
               ! exchange A(i) and A(j)
               temp = A(i,:)
               A(i,:) = A(j,:)
               A(j,:) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( is_EQ_rows( A(i,:), piv ) ) then
               ipiv = i
            else
!### ici, c'est un garde-fou ! Si on suppose l'algorithme juste, alors
!    il est inutile de faire ce test (qui pénalise l'effacité de l'algo)
               if( .not. is_EQ_rows( A(j,:), piv ) ) then
                  write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR:"
                  write(STDERR,*) "                         pb in partition_sortrows_3"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
!### ###
               ipiv = j
            end if
            return
         end if
     end do

   end subroutine partition_sortrows_3
   !____________________________________________________________________
   !
   recursive subroutine quick_sortrows_1_int( A )

      integer, intent(in out) :: A(:,:)
      !------ API end ------

      ! Entry point.
      ! Recursive Fortran quicksort routine
      !   sorts integer vectors into order specified by the sign of
      !   col_ind indices
      ! Uses the following order functions:
      !   is_EQ_rows_int()
      !   is_GT_rows_int()
      !   is_GE_rows_int()
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: ipiv, nrows
      integer :: itmp( size(A,2) )

   !------ end of declarations -- execution starts hereafter  ------

!### not optimized! the following instructions are called many times
!    => move them in the calling routine
      nrows = size(A,1)
      if( .not. allocated(col_ind) ) then
         write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR."
         write(STDERR,*) "                         'col_ind' vector is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if
      size_col_ind = size(col_ind)
!### ###

      if( nrows > 2 ) then
         call partition_sortrows_1_int( A, ipiv )
         if( 2 <= ipiv-1 ) then
            call quick_sortrows_1_int( A(:ipiv-1,:) )
         end if
         if( ipiv+1 <= nrows-1 ) then
            call quick_sortrows_1_int( A(ipiv+1:,:) )
         end if
      else if( nrows == 2 ) then
         if( is_GT_rows_int( A(1,:), A(2,:) ) ) then
            itmp = A(1,:)
            A(1,:) = A(2,:)
            A(2,:) = itmp
         end if
      end if

   end subroutine quick_sortrows_1_int
   !____________________________________________________________________
   !
   subroutine partition_sortrows_1_int( A, ipiv )

      integer, intent(in out) :: A(:,:)
      integer, intent(out) :: ipiv
      !------ API end ------

      ! Auxiliary routine for 'quick_sortrows_1_int'
      ! -------------------
      ! É. Canot -- 2025-05-19

      integer :: i, j, nrows
      integer :: itmp( size(A,2) )
      integer :: piv( size(A,2) ) ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      nrows = size(A,1)
      piv = A(nrows/2+1,:)
      i = 1
      j = nrows

      do
         do
            if( is_GE_rows_int( A(i,:), piv ) ) exit
            i = i + 1
         end do
         do
            if( .not. is_GT_rows_int( A(j,:), piv ) ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( .not. is_EQ_rows_int( A(i,:), A(j,:) ) ) then
               ! exchange A(i) and A(j)
               itmp = A(i,:)
               A(i,:) = A(j,:)
               A(j,:) = itmp
            else
               i = i + 1
            end if
         else
            if( is_EQ_rows_int( A(i,:), piv ) ) then
               ipiv = i
            else
!### ici, c'est un garde-fou ! Si on suppose l'algorithme juste, alors
!    il est inutile de faire ce test (qui pénalise l'effacité de l'algo)
               if( .not. is_EQ_rows_int( A(j,:), piv ) ) then
                  write(STDERR,*) "(MUESLI quick_sortrows:) internal ERROR:"
                  write(STDERR,*) "                         pb in partition_sortrows_1_int"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
!### ###
               ipiv = j
            end if
            return
         end if
     end do

   end subroutine partition_sortrows_1_int
