! f90 include file

!-----------------------------------------------------------------------
! visual progress barre using print of '#' inside the terminal
!
! Copyright É. Canot 2003-2025 -- IPR/CNRS
!_______________________________________________________________________
!
   subroutine msPrepHashes_int( start, end )

      integer, intent(in) :: start, end
      !------ API end ------

#ifdef _DEVLP
      ! special case where arguments 'start' and 'end' are integers

      call msPrepHashes_dble( dble(start), dble(end) )

#endif
   end subroutine msPrepHashes_int
!_______________________________________________________________________
!
   subroutine msPrepHashes_dble( start, end )

      real(kind=MF_DOUBLE), intent(in):: start, end
      !------ API end ------

#ifdef _DEVLP
      ! (call must be placed just before the loop)

      !  preparing constant data used by 'msPrintHashes'
      !
      !  values monitoring the loop in the calling program:
      !  start (in) : start value
      !  end   (in) : end value
      !
      !  constants initialized here are passed to other routines
      !  via a common.

      real(kind=MF_DOUBLE) :: ph_start, fact
      integer :: N, nh_already_printed
      common /mf_echo_hashes/ ph_start, fact,                           &
                              N, nh_already_printed

   !------ end of declarations -- execution starts hereafter  ------

      N = mfGetTermWidth()
      ph_start = start
      nh_already_printed = 0
      fact = N/(end-start)

#endif
   end subroutine msPrepHashes_dble
!_______________________________________________________________________
!
   subroutine msPrintHashes_int( val )

      integer, intent(in) :: val
      !------ API end ------

#ifdef _DEVLP
      call msPrintHashes_dble( dble(val) )

#endif
   end subroutine msPrintHashes_int
!_______________________________________________________________________
!
   subroutine msPrintHashes_dble( val )

      real(kind=MF_DOUBLE), intent(in) :: val
      !------ API end ------

#ifdef _DEVLP
      ! printing some '#' on STDOUT
      !
      ! at each call of the current routine, some '#' are printed.

      real(kind=MF_DOUBLE) :: ph_start, fact
      integer :: N, nh_already_printed
      common /mf_echo_hashes/ ph_start, fact,                           &
                              N, nh_already_printed

      integer :: k, nh, nh_current
      character(len=32) :: fmt

      ! on some screen, the terminal width may be large...
      ! (much more than 80)
      character(len=320) :: string

   !------ end of declarations -- execution starts hereafter  ------

      ! start -> 0 '#'
      ! end   -> N '#'
      ! val   -> (val-start)*N/(end-start) '#'

      ! compute the current value
      nh_current = int( (val-ph_start)*fact )

      ! nh to be printed
      nh = nh_current - nh_already_printed
      if( nh <= 0 ) return

      write(string,"(I0)") nh
      fmt = "(" // trim(string) // "(A))"

#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
      write(string,fmt) ("#",k=1,nh)
      call put_string_on_term_no_adv( trim(string)//char(0) )
#else
      write(STDOUT,fmt,advance="no") ("#",k=1,nh)
      call msFlush(STDOUT)
#endif

      nh_already_printed = nh_current

#endif
   end subroutine msPrintHashes_dble
!_______________________________________________________________________
!
   subroutine msPostHashes()
      !------ API end ------

#ifdef _DEVLP
      ! complementary print of '#' after the loop

      real(kind=MF_DOUBLE) :: ph_start, fact
      integer :: N, nh_already_printed
      common /mf_echo_hashes/ ph_start, fact,                           &
                              N, nh_already_printed

      integer :: k, nh
      character(len=32) :: fmt

      ! on some screen, the terminal width may be large...
      ! (much more than 80)
      character(len=320) :: string

   !------ end of declarations -- execution starts hereafter  ------

      ! nh to be printed
      nh = N - nh_already_printed
      if( nh <= 0 ) return

      write(string,"(I0)") nh
      fmt = "(" // trim(string) // "(A))"

#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
      write(string,fmt) ("#",k=1,nh)
      call put_string_on_term_no_adv( trim(string)//char(0) )
#else
      write(STDOUT,"(A)",advance="no") ("#",k=1,nh)
      call msFlush(STDOUT)
#endif

      print "()"

#endif
   end subroutine msPostHashes
