! f90 include file

!_______________________________________________________________________
!
   subroutine Implem_msDisp_mf_sparse_bool( x_arg, string )

      type(mfArray) :: x_arg
      character(len=*), intent(in) :: string
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: x
      logical :: x_allocated

      integer :: m, n, i, j, nz, nzmax

      character(len=80) :: fmt

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x_arg )

      ! warning, 'x_arg' is the argument name, but in the following
      ! we are working with 'x'
      x%data_type = x_arg%data_type
      x%shape = x_arg%shape
      x%units = x_arg%units
      x_allocated = .false.

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      write(STDOUT,"()")

      if( .not. x_allocated ) then
         x%a => x_arg%a
      end if

      ! eventually, one of the two dimension can be zero (used, e. g.,
      ! when we concat a matrix iteratively by a column vector),
      ! but not both.
      if( all( x%shape == [ 0, 0 ] ) ) then
         call PrintMessage( "msDisplay", "W",                           &
                            "all dims of the mfArray 'x' are zero!" )
         go to 99
      end if

      m = x%shape(1)
      n = x%shape(2)

      write(STDOUT,"(5X,A,I0,A,I0)") "real sparse matrix of shape : ", m, ", ", n
      if( size(x_arg%j) > n+1 ) then
         write(STDOUT,"(5X,A,I0,A)") "(ncolmax : ", size(x_arg%j)-1, ")"
      end if
      ! check validity of the CSC structure
      nz = x_arg%j(n+1)-1
      nzmax = size(x_arg%a)
      write(STDOUT,"(5X,A,I0,A,I0)") "nz : ", nz, ", nzmax : ", nzmax
      if( nz > nzmax ) then
         write(STDERR,*) "(MUESLI msDisplay:) internal error:"
         write(STDERR,*) "                    in the current CSC structure:"
         write(STDERR,*) "                    nz > nzmax!"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if

      fmt = "(5X,'(',I0,',',I0,')',2X,L4)"

      do j = 1, n
         do i = x_arg%j(j), x_arg%j(j+1)-1
            write(STDOUT,fmt) x_arg%i(i), j, x%a(i)==1.0d0
         end do
      end do

 99   continue

      write(STDOUT,"()")

      if( x_allocated ) then
         deallocate( x%a )

      end if

      call msFreeArgs( x_arg )
      call msAutoRelease( x_arg )

#endif
   end subroutine Implem_msDisp_mf_sparse_bool
