! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_mf_Int_List( x, string, compact )

      type(mf_Int_List), intent(in)           :: x
      character(len=*),  intent(in), optional :: string
      logical,           intent(in), optional :: compact
      !------ API end ------

#ifdef _DEVLP
      integer :: n, len_fmt, ncol_shell, xmax
      character(len=10) :: fmt_int
      character(len=1024) :: line
      character(len=20) :: str_tmp
      integer :: j, l, len_number
      logical :: fmt_compact

   !------ end of declarations -- execution starts hereafter  ------

      if( present(string) ) then
         write(STDOUT,"()")
         write(STDOUT,*) trim(string), " ="
      end if
      write(STDOUT,"()")

      if( allocated(x%list) ) then
         n = size(x%list)
      else
         n = 0
      end if

      if( n == 0 ) then
         write(STDOUT,*)  " <EMPTY>"
         go to 99
      end if

      if( present(compact) ) then
         fmt_compact = compact
      else
         fmt_compact = .false.
      end if

      if( fmt_compact ) then
         fmt_int = "(I0)"
      else
         xmax = maxval(abs(x%list))
         if( xmax == 0 ) then
            ! avoid negative infinite
            len_fmt = 1
         else
            len_fmt = log10(real(xmax)) + 1
         end if
         write(fmt_int,"('(I',I0,')')") len_fmt
      end if

      ncol_shell = mfGetTermWidth()
      line = ""
      l = 0
      j = 1
      do
         ! filling 'line' up to its end
         write(str_tmp,fmt_int) x%list(j)
         len_number = len_trim(str_tmp)
         if( l+len_number+2+4 > ncol_shell ) then
            line(ncol_shell-3:ncol_shell) = " ..."
            write(STDOUT,"(A)") trim(line)
            line = ""
            l = 0
         end if
         line = trim(line) // "  " // trim(str_tmp)
         l = l + len_number + 2
         j = j + 1
         if( j > n ) exit
      end do
      ! flush the remain of the numbers
      write(STDOUT,"(A)") trim(line)

 99   continue

      write(STDOUT,"()")

#endif
   end subroutine msDisplay_mf_Int_List
