! f90 include file

!_______________________________________________________________________
!
   function mfDisplayColumns( x_arg, unit ) result( out )

      type(mfArray) :: x_arg
      type(mfUnit), intent(in), optional :: unit
      integer :: out
      !------ API end ------

#ifdef _DEVLP
      ! returns the number of values printed by the routine 'msDisplay'
      ! per line.
      !
      ! it depends on the actual width of the terminal (or MF_COLUMNS),
      ! and the kind of 'format' used.

      type(mfArray) :: x
      logical :: x_allocated

      integer :: len_fmt_int_small = 4
      integer :: len_fmt_int_large = 10
      integer :: len_fmt_short     = 9
      integer :: len_fmt_sci_short = 11
      integer :: len_fmt_long      = 18
      integer :: len_fmt_sci_long  = 21

      integer :: len_fmt_short_re  = 8
      integer :: len_fmt_short_im  = 7
      integer :: len_fmt_long_re   = 18
      integer :: len_fmt_long_im   = 17
      real(kind=MF_DOUBLE) :: log10_x_max, max_val_abs, power_threshold, &
                              max_val_abs_re, max_val_abs_im
      integer :: power_scale, len_fmt, len_fmt_re, len_fmt_im
      logical :: integer_fmt, integer_small, float_small

      real(kind=MF_DOUBLE), allocatable :: x_abs(:,:)
      logical, allocatable :: x_mask(:,:)
      integer :: m, n, x_count
      integer :: ncol_shell
      character(len=75) :: phys_dim_str, phys_unit_str, phys_dim_req_str
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x_arg%data_type == MF_DT_EMPTY .or.                           &
          x_arg%data_type == MF_DT_SP_DBLE .or.                         &
          x_arg%data_type == MF_DT_SP_CMPLX ) then
         out = -1
         return
      end if

      if( x_arg%data_type == MF_DT_BOOL ) then
         out = ncol_shell / ( 4 + 2 )
         return
      end if

      ncol_shell = mfGetTermWidth()

      call msInitArgs( x_arg )

      ! warning, 'x_arg' is the argument name, but in the following
      ! we are working with 'x'
      x%data_type = x_arg%data_type
      x%shape = x_arg%shape
      x%units = x_arg%units
      x_allocated = .false.

      if( x%data_type == MF_DT_DBLE ) then

         if( mf_phys_units ) then
            if( present(unit) ) then
               if( unit%abbrev /= "S.I." ) then
                  call process_units( x%units, phys_dim_str, unit, phys_unit_str )
                  call verif_adim( x%units, unit%units, status )
                  if( status /= 0 ) then
                     call process_units( unit%units, phys_dim_req_str )
                     call PrintMessage( "msDisplayColumns", "E",        &
                                        "required unit for printing not consistent", &
                                        "with the physical dimension of the mfArray!", &
                                        "Current physical dimension is : " // trim(phys_dim_str), &
                                        "Required unit for printing is : " // trim(phys_dim_req_str) )
                     go to 99
                  end if
               end if
               ! 'x' is modified only if the required physical unit
               ! is different from an SI unit.
               if( unit%value /= 1.0d0 ) then
                  m = x%shape(1)
                  n = x%shape(2)
                  allocate( x%double(m,n) )

                  x%double(:,:) = x_arg%double(:,:) / unit%value
                  x_allocated = .true.
               end if
            end if
         end if

         if( .not. x_allocated ) then
            x%double => x_arg%double
         end if

         if( any( x%shape == [ 0, 0 ] ) ) then
            out = 0
            go to 99
         end if

         m = x%shape(1)
         n = x%shape(2)

         allocate( x_abs(m,n) )
         allocate( x_mask(m,n) )
         x_abs(:,:) = abs(x%double)
         x_mask(:,:) = mf_isfinite(x_abs)
         x_count = count( x_mask )
         if( x_count == 0 ) then
            ! All values are Inf and/or NaN
            max_val_abs = 0.0d0
         else
            ! avoid special IEEE values (Inf, NaN)
            max_val_abs = maxval(x_abs,MASK=x_mask)
         end if

         float_small = .true.
         integer_fmt = .false.
         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
            if( max_val_abs == 0.0d0 ) then
               log10_x_max = 0.0d0
            else
               log10_x_max = log10(max_val_abs)
            end if
            if( mf_short_mantissa ) then
               power_threshold = 3.0d0
            else
               power_threshold = 2.0d0
            end if
            if( abs(log10_x_max) >= power_threshold ) then
               float_small = .false.
            end if
            power_scale = int(log10_x_max)
            if( mf_display_exponent == "eng" ) then
               if( int(log10_x_max) < 0 ) then
                  power_scale = ((power_scale)/3)*3
               else
                  power_scale = ((power_scale+1)/3)*3
               end if
               if( power_scale /= 0 ) then
                  float_small = .false.
               else
                  float_small = .true.
               end if
            end if
         end if

         if( mf_display_exponent == "auto" ) then
            if( all( int(x%double) == x%double) ) then
               integer_fmt = .true.
               if( log10_x_max < 3.0d0 ) then
                  integer_small = .true.
               else
                  integer_small = .false.
               end if
               if( log10_x_max < 3.0d0 ) then
                  len_fmt = len_fmt_int_small
               else if( log10_x_max < 8.0d0 ) then
                  len_fmt = len_fmt_int_large
               else
                  integer_fmt = .false.
               end if
            else ! float
               integer_fmt = .false.
            end if
         end if

         if( integer_fmt ) then
            out = ncol_shell / ( len_fmt + 2 )
         else ! float format
            if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
               if( mf_short_mantissa ) then
                  len_fmt = len_fmt_short
               else ! long mantissa
                  len_fmt = len_fmt_long
               end if
            else ! "sci"
               if( mf_short_mantissa ) then
                  len_fmt = len_fmt_sci_short
               else ! long mantissa
                  len_fmt = len_fmt_sci_long
               end if
            end if
            out = ncol_shell / ( len_fmt + 1 )
         end if

      else if( x%data_type == MF_DT_CMPLX ) then

         if( mf_phys_units ) then
            if( present(unit) ) then
               if( unit%abbrev /= "S.I." ) then
                  call process_units( x%units, phys_dim_str, unit, phys_unit_str )
                  call verif_adim( x%units, unit%units, status )
                  if( status /= 0 ) then
                     call process_units( unit%units, phys_dim_req_str )
                     call PrintMessage( "msDisplayColumns", "E",        &
                                        "required unit for printing not consistent", &
                                        "with the physical dimension of the mfArray!", &
                                        "Current physical dimension is : " // trim(phys_dim_str), &
                                        "Required unit for printing is : " // trim(phys_dim_req_str) )
                     go to 99
                  end if
               end if
               ! modifying 'x' only if the physical unit required is
               ! really different from the SI unit.
               if( unit%value /= 1.0d0 ) then
                  m = x%shape(1)
                  n = x%shape(2)
                  allocate( x%cmplx(m,n) )

                  x%double(:,:) = dble(x_arg%cmplx(:,:)) / unit%value
                  x_allocated = .true.
               end if
            end if
         end if

         if( .not. x_allocated ) then
            x%cmplx => x_arg%cmplx
         end if

         if( any( x%shape == [ 0, 0 ] ) ) then
            out = 0
            go to 99
         end if

         m = x%shape(1)
         n = x%shape(2)

         allocate( x_abs(m,n) )
         allocate( x_mask(m,n) )
         ! real part...
         x_abs(:,:) = abs(real(x%cmplx))
         x_mask(:,:) = mf_isfinite(x_abs)
         x_count = count( x_mask )
         if( x_count == 0 ) then
            ! All values are Inf and/or NaN
            max_val_abs_re = 0.0d0
         else
            ! avoid special IEEE values (Inf, NaN)
            max_val_abs_re = maxval(x_abs,MASK=x_mask)
         end if
         ! imag part...
         x_abs(:,:) = abs(aimag(x%cmplx))
         x_mask(:,:) = mf_isfinite(x_abs)
         x_count = count( x_mask )
         if( x_count == 0 ) then
            ! All values are Inf and/or NaN
            max_val_abs_im = 0.0d0
         else
            ! avoid special IEEE values (Inf, NaN)
            max_val_abs_im = maxval(x_abs,MASK=x_mask)
         end if
         max_val_abs = max( max_val_abs_re, max_val_abs_im )

         float_small = .true.
         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"

            if( max_val_abs == 0.0d0 ) then
               log10_x_max = 0.0d0
            else
               log10_x_max = log10(max_val_abs)
            end if
            if( mf_short_mantissa ) then
               power_threshold = 2.0d0
            else
               power_threshold = 2.0d0
            end if
            if( abs(log10_x_max) >= power_threshold ) then
               float_small = .false.
            end if
            power_scale = int(log10_x_max)
            if( mf_display_exponent == "eng" ) then
               if( int(log10_x_max) < 0 ) then
                  power_scale = ((power_scale)/3)*3
               else
                  power_scale = ((power_scale+1)/3)*3
               end if
               if( power_scale /= 0 ) then
                  float_small = .false.
               else
                  float_small = .true.
               end if
            end if

            if( mf_short_mantissa ) then
               len_fmt_re = len_fmt_short_re
               len_fmt_im = len_fmt_short_im
            else ! long mantissa
               len_fmt_re = len_fmt_long_re
               len_fmt_im = len_fmt_long_im
            end if

         else if( mf_display_exponent == "sci" ) then

            if( mf_short_mantissa ) then
               len_fmt_re = len_fmt_sci_short
               len_fmt_im = len_fmt_sci_short
            else ! long mantissa
               len_fmt_re = len_fmt_sci_long
               len_fmt_im = len_fmt_sci_long
            end if

         end if

         len_fmt = len_fmt_re + len_fmt_im + 3
         out = ncol_shell / ( len_fmt + 1 )

      end if

 99   continue

      if( x_allocated ) then
         deallocate( x%double )

      end if

      call msFreeArgs( x_arg )
      call msAutoRelease( x_arg )

#endif
   end function mfDisplayColumns
