! f90 include file

!_______________________________________________________________________
!
   subroutine msAssign_scalar_int( left, right )

      type(mfArray), intent(in out) :: left
      integer,       intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_int:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double = right

      left%prop%symm = TRUE
      if( right > 0 ) then
         left%prop%posd = TRUE
      else
         left%prop%posd = FALSE
      end if
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_int
!_______________________________________________________________________
!
   subroutine msAssign_vector_int( left, right )

      type(mfArray), intent(in out) :: left
      integer,       intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_vector_int:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(1,:) = right(:)

      left%prop%symm = FALSE
      left%prop%posd = FALSE
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_int
!_______________________________________________________________________
!
   subroutine msAssign_matrix_int( left, right )

      type(mfArray), intent(in out) :: left
      integer,       intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_int:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(:,:) = right(:,:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_int
!_______________________________________________________________________
!
   subroutine msAssign_scalar_single( left, right )

      type(mfArray), intent(in out) :: left
      real,          intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_single:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double = right

      left%prop%symm = TRUE
      if( right > 0 ) then
         left%prop%posd = TRUE
      else
         left%prop%posd = FALSE
      end if
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_single
!_______________________________________________________________________
!
   subroutine msAssign_vector_single( left, right )

      type(mfArray), intent(in out) :: left
      real,          intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI ...:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(1,:) = right(:)

      left%prop%symm = FALSE
      left%prop%posd = FALSE
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_single
!_______________________________________________________________________
!
   subroutine msAssign_matrix_single( left, right )

      type(mfArray), intent(in out) :: left
      real,          intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_single:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(:,:) = right(:,:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_single
!_______________________________________________________________________
!
   subroutine msAssign_scalar_double( left, right )

      type(mfArray),        intent(in out) :: left
      real(kind=MF_DOUBLE), intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_double:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double = right

      left%prop%symm = TRUE
      if( right > 0 ) then
         left%prop%posd = TRUE
      else
         left%prop%posd = FALSE
      end if
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_double
!_______________________________________________________________________
!
   subroutine msAssign_vector_double( left, right )

      type(mfArray),        intent(in out) :: left
      real(kind=MF_DOUBLE), intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_vector_double:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(1,:) = right(:)

      left%prop%symm = FALSE
      left%prop%posd = FALSE
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_double
!_______________________________________________________________________
!
   subroutine msAssign_matrix_double( left, right )

      type(mfArray),        intent(in out) :: left
      real(kind=MF_DOUBLE), intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_double:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double(:,:) = right(:,:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_double
!_______________________________________________________________________
!
   subroutine msAssign_scalar_cmplx( left, right )

      type(mfArray),  intent(in out) :: left
      complex,        intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx = right

      if( aimag(right) == 0.0 ) then
         left%prop%symm = TRUE
      else
         left%prop%symm = FALSE
      end if
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_vector_cmplx( left, right )

      type(mfArray),  intent(in out) :: left
      complex,        intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_vector_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx(1,:) = right(:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_matrix_cmplx( left, right )

      type(mfArray),  intent(in out) :: left
      complex,        intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx(:,:) = right(:,:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_scalar_double_cmplx( left, right )

      type(mfArray),           intent(in out) :: left
      complex(kind=MF_DOUBLE), intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_double_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx = right

      if( aimag(right) == 0.0d0 ) then
         left%prop%symm = TRUE
      else
         left%prop%symm = FALSE
      end if
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_double_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_vector_double_cmplx( left, right )

      type(mfArray),           intent(in out) :: left
      complex(kind=MF_DOUBLE), intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_vector_double_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx(1,:) = right(:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_double_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_matrix_double_cmplx( left, right )

      type(mfArray),           intent(in out) :: left
      complex(kind=MF_DOUBLE), intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_CMPLX ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            deallocate( left%double )

            left%double => null()
         case( MF_DT_CMPLX )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%cmplx )

            else
               do_alloc = .false.
            end if
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_double_cmplx:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_CMPLX
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

      end if
      left%cmplx(:,:) = right(:,:)

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_double_cmplx
!_______________________________________________________________________
!
   subroutine msAssign_scalar_bool( left, right )

      type(mfArray), intent(in out) :: left
      logical,       intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_BOOL ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_scalar_bool:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_BOOL
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      if( right ) then
         left%double = TRUE
      else
         left%double = FALSE
      end if

      left%prop%symm = TRUE
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_scalar_bool
!_______________________________________________________________________
!
   subroutine msAssign_vector_bool( left, right )

      type(mfArray), intent(in out) :: left
      logical,       intent(in)     :: right(:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, size(right) ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_BOOL ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, size(right) ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_vector_bool:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_BOOL
      if( do_alloc ) then
         left%shape = [ 1, size(right) ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      where( right )
         left%double(1,:) = TRUE
      elsewhere
         left%double(1,:) = FALSE
      end where

      left%prop%symm = FALSE
      left%prop%posd = FALSE
      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_vector_bool
!_______________________________________________________________________
!
   subroutine msAssign_matrix_bool( left, right )

      type(mfArray), intent(in out) :: left
      logical,       intent(in)     :: right(:,:)
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=shape(right)) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_BOOL ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=shape(right)) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_matrix_bool:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_BOOL
      if( do_alloc ) then
         left%shape = shape(right)
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      where( right )
         left%double(:,:) = TRUE
      elsewhere
         left%double(:,:) = FALSE
      end where

      left%units(:) = UNIT_ZERO_DIM(:)

#endif
   end subroutine msAssign_matrix_bool
!_______________________________________________________________________
!
   subroutine msAssign_mfUnit( left, right )

      type(mfArray), intent(in out) :: left
      type(mfUnit),  intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      logical :: do_alloc

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      if( left%status_restricted ) then

         if( any(left%shape/=[ 1, 1 ]) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array." )
            return
         end if

         if( left%data_type/=MF_DT_DBLE ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array." )
            return
         end if

      end if

      do_alloc = .true.
      select case( left%data_type )
         case( MF_DT_EMPTY )
            ! do nothing
         case( MF_DT_DBLE, MF_DT_BOOL )
            if( any(left%shape/=[ 1, 1 ]) ) then
               deallocate( left%double )

            else
               do_alloc = .false.
            end if
         case( MF_DT_CMPLX )
            deallocate( left%cmplx )

            left%cmplx => null()
         case( MF_DT_SP_DBLE )
            deallocate( left%a )

            deallocate( left%i )

            deallocate( left%j )

            left%a => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_d( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_SP_CMPLX )
            deallocate( left%z )

            deallocate( left%i )

            deallocate( left%j )

            left%z => null()
            left%i => null()
            left%j => null()
            if( associated( left%umf4_ptr_numeric ) ) then
               call umf4fnum_z( left%umf4_ptr_numeric )
               deallocate( left%umf4_ptr_numeric )

            end if
         case( MF_DT_PERM_VEC )
            deallocate( left%i )

            left%i => null()
         case default
            write(STDERR,*) "(MUESLI msAssign_mfUnit:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      left%data_type = MF_DT_DBLE
      if( do_alloc ) then
         left%shape = [ 1, 1 ]
         allocate( left%double(left%shape(1),left%shape(2)) )

      end if
      left%double = right%value

      left%prop%symm = TRUE
      if( right%value > 0 ) then
         left%prop%posd = TRUE
      else
         left%prop%posd = FALSE
      end if

      if( .not. mf_phys_units ) then
         call PrintMessage( "assignment(=)", "W",                       &
                            "Physical Units are currently used in this program,", &
                            "but they are not activated (see msUsePhysUnits)." )
      end if

      if( mf_phys_units ) then
         left%units(:) = right%units(:)
      else
         left%units(:) = UNIT_ZERO_DIM(:)
      end if

#endif
   end subroutine msAssign_mfUnit
!_______________________________________________________________________
!
   subroutine msAssign_mfArray_copy( left, right )

      type(mfArray), intent(in out) :: left
      type(mfArray), intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      ! usual form of the assignment : left = right
      ! which always do a copy

      integer :: ncol, nnz

#if defined _INTEL_IFC & defined _64_BITS
      integer :: i, j
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      ! special case if 'left' points to a f90_array (msEquiv)
      if( left%status_restricted ) then
         if( left%data_type /= right%data_type ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a restricted array.", &
                               "[use of msEquiv]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have the same type
         if( any( left%shape/=right%shape) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a restricted array.", &
                               "[use of msEquiv]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have moreover the same shape;
         ! 'left' is already associated
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
            left%double(:,:) = right%double(:,:)
         else if( right%data_type == MF_DT_CMPLX ) then
            left%cmplx(:,:) = right%cmplx(:,:)
         else
            call PrintMessage( "assignment(=)", "E",                    &
                               "bad data type for RHS!",                &
                               "[LHS is a restricted array via msEquiv]" )
            return
         end if
         call msAutoRelease( right )
         return
      end if

      ! special case if a f90_array points to 'left' (msPointer)
      if( left%level_locked /= 0 ) then
         if( left%data_type /= right%data_type ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot change type of LHS! it is a locked array.", &
                               "[use of msPointer]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have the same type
         if( any( left%shape/=right%shape) ) then
            call PrintMessage( "assignment(=)", "E",                    &
                               "cannot reshape LHS! it is a locked array.", &
                               "[use of msPointer]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have moreover the same shape
         ! 'left' is already associated
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
            left%double(:,:) = right%double(:,:)
         else if( right%data_type == MF_DT_CMPLX ) then
            left%cmplx(:,:) = right%cmplx(:,:)
         else
            call PrintMessage( "assignment(=)", "E",                    &
                               "bad data type for RHS!",                &
                               "[LHS is a locked array via msPointer]" )
            return
         end if
         call msAutoRelease( right )
         return
      end if

      if( right%data_type == MF_DT_EMPTY ) then
         call PrintMessage( "assignment(=)", "I",                       &
                            "RHS empty!" )
         ! left = MF_EMPTY or MF_COLON
         call msSilentRelease( left )
         left%shape = right%shape
         return
      end if

      ! Here, we have to release 'left'
      if( associated(left%double) ) then
         deallocate( left%double )

      end if
      if( associated(left%cmplx) ) then
         deallocate( left%cmplx )

      end if

      if( associated(left%a) ) then
         deallocate( left%a )

         if( associated( left%umf4_ptr_numeric ) ) then
            call umf4fnum_d( left%umf4_ptr_numeric )
            deallocate( left%umf4_ptr_numeric )

         end if
      end if
      if( associated(left%z) ) then
         deallocate( left%z )

         if( associated( left%umf4_ptr_numeric ) ) then
            call umf4fnum_z( left%umf4_ptr_numeric )
            deallocate( left%umf4_ptr_numeric )

         end if
      end if
      if( associated(left%i) ) then
         deallocate( left%i )

      end if
      if( associated(left%j) ) then
         deallocate( left%j )

      end if
      ! End of release

      left%data_type         = right%data_type
      left%shape             = right%shape
      left%row_sorted        = right%row_sorted
      left%prop              = right%prop
      left%level_locked      = zero_kind_1
      left%crc_stored        = .false.
      left%crc               = 0
      left%status_temporary  = .false.
      ! keeping the protected level
      ! ('left' may be located inside a routine...)
      ! left%level_protected   = zero_kind_1
      left%status_restricted = .false.
      if( mf_phys_units ) then
         left%units(:) = right%units(:)
      else
         left%units(:) = UNIT_ZERO_DIM(:)
      end if

      if( right%status_temporary ) then
         call PrintMessage( "assignment(=)", "I",                       &
                            "you are using the simple form of assignment 'a=tempo', with a temporary", &
                            "right-hand-side. You could use the other form: 'call msAssign(a,tempo)',", &
                            "which only points to data, and therefore is much more efficient!" )
      end if

      call mf_save_and_disable_fpe( )

      ! hereafter: data is copied
      if( right%data_type == MF_DT_DBLE .or.                            &
          right%data_type == MF_DT_BOOL      ) then
         allocate( left%double(left%shape(1),left%shape(2)) )

#if defined _INTEL_IFC & defined _64_BITS
! bug avec INTEL-ifort 12.0.4 (X86_64)
         ncol = left%shape(2)
         do j = 1, ncol
            left%double(:,j) = right%double(:,j)
         end do
#else
         left%double(:,:) = right%double(:,:)
#endif
      else if( right%data_type == MF_DT_CMPLX ) then
         allocate( left%cmplx(left%shape(1),left%shape(2)) )

         left%cmplx(:,:) = right%cmplx(:,:)
      else if( right%data_type == MF_DT_SP_DBLE .or.                    &
               right%data_type == MF_DT_SP_BOOL ) then
         ncol = right%shape(2)
         nnz = right%j(ncol+1)-1
         allocate( left%a(size(right%a)) )

#if defined _INTEL_IFC & defined _64_BITS
! bug avec INTEL-ifort 12.0.4 (X86_64)
         do i = 1, nnz
            left%a(i) = right%a(i)
         end do
#else
         left%a(1:nnz) = right%a(1:nnz)
#endif
         allocate( left%i(size(right%i)) )

#if defined _INTEL_IFC & defined _64_BITS
! bug avec INTEL-ifort 12.0.4 (X86_64)
         do i = 1, nnz
            left%i(i) = right%i(i)
         end do
#else
         left%i(1:nnz) = right%i(1:nnz)
#endif
         allocate( left%j(size(right%j)) )

         left%j(1:ncol+1) = right%j(1:ncol+1)
      else if( right%data_type == MF_DT_SP_CMPLX ) then
         ncol = right%shape(2)
         nnz = right%j(ncol+1)-1
         allocate( left%z(size(right%z)) )

         left%z(1:nnz) = right%z(1:nnz)
         allocate( left%i(size(right%i)) )

         left%i(1:nnz) = right%i(1:nnz)
         allocate( left%j(size(right%j)) )

         left%j(1:ncol+1) = right%j(1:ncol+1)
      else if( right%data_type == MF_DT_PERM_VEC ) then
         allocate( left%i(left%shape(1)) )

         left%i(:) = right%i(:)
      else
         write(STDERR,*) "(MUESLI msAssign_mfArray_copy:) internal error: unknown data_type!"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if
      ! End of copy

      call msAutoRelease( right )

      call mf_restore_fpe( )

#endif
   end subroutine msAssign_mfArray_copy
!_______________________________________________________________________
!
   subroutine msAssign_mfArray( left, right )

      type(mfArray) :: left
      type(mfArray) :: right
      !------ API end ------

#ifdef _DEVLP
      ! subroutine form of the assignment : call msAssign(left,right),
      ! which is a special case of: left = right.

      integer :: ncol, nnz

#if defined _INTEL_IFC & defined _64_BITS
      integer :: j
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( left%parameter ) then
         call PrintMessage( "msAssign", "E",                            &
                            "cannot change LHS! it is a protected array (pseudo-parameter)." )
         return
      end if

      ! special case if 'left' points to a f90_array (via msEquiv)
      if( left%status_restricted ) then
         if( left%data_type /= right%data_type ) then
            call PrintMessage( "msAssign", "E",                         &
                               "cannot change type of LHS! it is a restricted array [via msEquiv]." )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have the same type
         if( any( left%shape/=right%shape) ) then
            call PrintMessage( "msAssign", "E",                         &
                               "cannot reshape LHS! it is a restricted array [via msEquiv]." )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' further have the same shape
         ! left is already associated
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
            left%double(:,:) = right%double(:,:)
         else if( right%data_type == MF_DT_CMPLX ) then
            left%cmplx(:,:) = right%cmplx(:,:)
         else
            call PrintMessage( "msAssign", "E",                         &
                               "bad data type for RHS!",                &
                               "[LHS is a restricted array via msEquiv]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         call msAutoRelease( right )
         return
      end if

      ! special case if a f90_array points to 'left' (via msPointer)
      if( left%level_locked /= 0 ) then
         if( left%data_type /= right%data_type ) then
            call PrintMessage( "msAssign", "E",                         &
                               "cannot change type of LHS! it is a locked array [via msPointer]." )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' have the same type
         if( any( left%shape/=right%shape) ) then
            call PrintMessage( "msAssign", "E",                         &
                               "cannot reshape LHS! it is a locked array [via msPointer]." )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         ! 'left' and 'right' further have the same shape
         ! left is already associated
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
#if defined _INTEL_IFC & defined _64_BITS
! avoid a seg. fault
            ncol = left%shape(2)
            do j = 1, ncol
               left%double(:,j) = right%double(:,j)
            end do
#else
            left%double(:,:) = right%double(:,:)
#endif
         else if( right%data_type == MF_DT_CMPLX ) then
            left%cmplx(:,:) = right%cmplx(:,:)
         else
            call PrintMessage( "msAssign", "E",                         &
                               "bad data type for RHS!",                &
                               "[LHS is a locked array via msPointer]" )
            ! if 'right' is tempo, we must not forget to free it !
            call msAutoRelease( right )
            return
         end if
         call msAutoRelease( right )
         return
      end if

      if( right%data_type == MF_DT_EMPTY ) then
         call PrintMessage( "msAssign", "I",                            &
                            "RHS empty!" )
         ! left = MF_EMPTY or MF_COLON
         call msSilentRelease( left )
         left%shape = right%shape
         return
      end if

      ! Here, we have to release 'left'
      if( associated(left%double) ) then
         deallocate( left%double )

      end if
      if( associated(left%cmplx) ) then
         deallocate( left%cmplx )

      end if

      if( associated(left%a) ) then
         deallocate( left%a )

         if( associated( left%umf4_ptr_numeric ) ) then
            call umf4fnum_d( left%umf4_ptr_numeric )
            deallocate( left%umf4_ptr_numeric )

         end if
      end if
      if( associated(left%z) ) then
         deallocate( left%z )

         if( associated( left%umf4_ptr_numeric ) ) then
            call umf4fnum_z( left%umf4_ptr_numeric )
            deallocate( left%umf4_ptr_numeric )

         end if
      end if
      if( associated(left%i) ) then
         deallocate( left%i )

      end if
      if( associated(left%j) ) then
         deallocate( left%j )

      end if
      ! End of release

      left%data_type         = right%data_type
      left%shape             = right%shape
      left%row_sorted        = right%row_sorted
      left%prop              = right%prop
      left%level_locked      = zero_kind_1
      left%crc_stored        = .false.
      left%crc               = 0
      left%status_temporary  = .false.
      ! keeping the protected level
      ! ('left' may be located inside a routine...)
      ! left%level_protected   = zero_kind_1
      left%status_restricted = .false.
      if( mf_phys_units ) then
         left%units(:) = right%units(:)
      else
         left%units(:) = UNIT_ZERO_DIM(:)
      end if

      if( right%status_temporary ) then
         ! a temporary mfArray (e.g. returned by a function):
         ! using a pointer to the data, and the tempo flag is removed.
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
            left%double => right%double
         else if( right%data_type == MF_DT_CMPLX ) then
            left%cmplx => right%cmplx
         else if( right%data_type == MF_DT_SP_BOOL ) then
            left%a => right%a
            left%i => right%i
            left%j => right%j
         else if( right%data_type == MF_DT_SP_DBLE ) then
            left%a => right%a
            left%i => right%i
            left%j => right%j
         else if( right%data_type == MF_DT_SP_CMPLX ) then
            left%z => right%z
            left%i => right%i
            left%j => right%j
         else if( right%data_type == MF_DT_PERM_VEC ) then
            left%i => right%i
         else
            write(STDERR,*) "(MUESLI msAssign_mfArray:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
         end if
         right%status_temporary = .false.

      else
         ! ordinary mfArray : data is copied
         if( right%data_type == MF_DT_DBLE .or.                         &
             right%data_type == MF_DT_BOOL      ) then
            allocate( left%double(left%shape(1),left%shape(2)) )

            left%double(:,:) = right%double(:,:)
         else if( right%data_type == MF_DT_CMPLX ) then
            allocate( left%cmplx(left%shape(1),left%shape(2)) )

            left%cmplx(:,:) = right%cmplx(:,:)
         else if( right%data_type == MF_DT_SP_BOOL ) then
            ncol = right%shape(2)
            nnz = right%j(ncol+1)-1
            allocate( left%a(size(right%a)) )

            left%a(1:nnz) = right%a(1:nnz)
            allocate( left%i(size(right%i)) )

            left%i(1:nnz) = right%i(1:nnz)
            allocate( left%j(size(right%j)) )

            left%j(1:ncol+1) = right%j(1:ncol+1)
         else if( right%data_type == MF_DT_SP_DBLE ) then
            ncol = right%shape(2)
            nnz = right%j(ncol+1)-1
            allocate( left%a(size(right%a)) )

            left%a(1:nnz) = right%a(1:nnz)
            allocate( left%i(size(right%i)) )

            left%i(1:nnz) = right%i(1:nnz)
            allocate( left%j(size(right%j)) )

            left%j(1:ncol+1) = right%j(1:ncol+1)
         else if( right%data_type == MF_DT_SP_CMPLX ) then
            ncol = right%shape(2)
            nnz = right%j(ncol+1)-1
            allocate( left%z(size(right%z)) )

            left%z(1:nnz) = right%z(1:nnz)
            allocate( left%i(size(right%i)) )

            left%i(1:nnz) = right%i(1:nnz)
            allocate( left%j(size(right%j)) )

            left%j(1:ncol+1) = right%j(1:ncol+1)
         else if( right%data_type == MF_DT_PERM_VEC ) then
            allocate( left%i(left%shape(1)) )

            left%i(:) = right%i(:)
         else
            write(STDERR,*) "(MUESLI msAssign_mfArray:) internal error: unknown data_type!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
         end if
      end if

#endif
   end subroutine msAssign_mfArray
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_int( left, right )

      integer, intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer, mfArray must be dense!" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer, mfArray must be numeric!" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer, mfArray must be scalar!" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = int( right%double(1,1) )
         if( dble(left) /= right%double(1,1) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double to an integer!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = int( right%cmplx(1,1) )
         if( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,1) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a complex to an integer!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_int
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_int( left, right )

      integer,       intent(in out) :: left(:)
      type(mfArray), intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      ! extension of this routine: from version 2.6.0, RHS may be
      ! a (integer) permutation vector.

      integer :: dim, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer vector, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric or a permutation vector
      if( .not. mfIsNumeric(right) .and. .not. mfIsPerm(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer vector,",     &
                            "mfArray must be either numeric or a permutation vector" )
         go to 99
      end if

      ! mfArray must be a vector (or a scalar)
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer vector, sizes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         if( dim == 1 ) then
            left(:) = int( right%double(:,1) )
            if( any( dble(left) /= right%double(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double to an integer!" )
            end if
         else
            left(:) = int( right%double(1,:) )
            if( any( dble(left) /= right%double(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double to an integer!" )
            end if
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         if( dim == 1 ) then
            left = int( right%cmplx(:,1) )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to an integer!" )
            end if
         else
            left = int( right%cmplx(1,:) )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to an integer!" )
            end if
         end if
      else if( right%data_type == MF_DT_PERM_VEC ) then
         left(:) = right%i(:)
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_int
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_int( left, right )

      integer, intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer matrix, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to an integer matrix, shapes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = int( right%double )
         if( any( dble(left) /= right%double ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double to an integer!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = int( right%cmplx )
         if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a complex to an integer!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_int
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_real( left, right )

      real, intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real, mfArray must be scalar" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = real( right%double(1,1) )
         if( dble(left) /= right%double(1,1) ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "precision loss during assignment of a double to a real!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = real( right%cmplx(1,1), kind=MF_SINGLE )
         if( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,1) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double complex to a real!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_real
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_real( left, right )

      real, intent(in out) :: left(:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: dim, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real vector, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real vector, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a vector
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real vector, sizes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         if( dim == 1 ) then
            left(:) = real( right%double(:,1) )
            if( any( dble(left) /= right%double(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double to a real!" )
            end if
         else
            left(:) = real( right%double(1,:) )
            if( any( dble(left) /= right%double(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double to a real!" )
            end if
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         if( dim == 1 ) then
            left = real( right%cmplx(:,1), kind=MF_SINGLE )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to a real!" )
            end if
         else
            left = real( right%cmplx(1,:), kind=MF_SINGLE )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to a real!" )
            end if
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_real
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_real( left, right )

      real, intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real matrix, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real matrix, shapes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = real( right%double )
         if( any( dble(left) /= right%double ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double to a real!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = real( right%cmplx, kind=MF_SINGLE )
         if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a complex to a real!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_real
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_dble( left, right )

      real(kind=MF_DOUBLE), intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double, mfArray must be scalar" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = right%double(1,1)
      else if( right%data_type == MF_DT_CMPLX ) then
         left = dble( right%cmplx(1,1) )
         if( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,1) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a complex to a real double!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_dble
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_dble( left, right )

      real(kind=MF_DOUBLE), intent(in out) :: left(:)
      type(mfArray),        intent(in)     :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: dim, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double vector, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double vector, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a vector
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double vector, sizes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         if( dim == 1 ) then
            left(:) = right%double(:,1)
         else
            left(:) = right%double(1,:)
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         if( dim == 1 ) then
            left = dble( right%cmplx(:,1) )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to a real double!" )
            end if
         else
            left = dble( right%cmplx(1,:) )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a complex to a real double!" )
            end if
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_dble
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_dble( left, right )

      real(kind=MF_DOUBLE), intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double matrix, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a real double matrix, shapes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = right%double
      else if( right%data_type == MF_DT_CMPLX ) then
         left = dble( right%cmplx )
         if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a complex to a real double!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_dble
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_cmplx( left, right )

      complex, intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex, mfArray must be scalar" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = cmplx( right%double(1,1), kind=MF_SINGLE )
         if( dble(left) /= right%double(1,1) ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "precision loss during assignment of a double real to a complex!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = cmplx( right%cmplx(1,1), kind=MF_SINGLE )
         if( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,1) ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "precision loss during assignment of a double complex to a complex!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_cmplx( left, right )

      complex, intent(in out) :: left(:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: dim, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex vector, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex vector, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a vector
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex vector, sizes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         if( dim == 1 ) then
            left(:) = cmplx( right%double(:,1), kind=MF_SINGLE )
            if( any( dble(left) /= right%double(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double real to a complex!" )
            end if
         else
            left(:) = cmplx( right%double(1,:), kind=MF_SINGLE )
            if( any( dble(left) /= right%double(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double real to a complex!" )
            end if
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         if( dim == 1 ) then
            left = cmplx( right%cmplx(:,1), kind=MF_SINGLE )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double complex to a complex!" )
            end if
         else
            left = cmplx( right%cmplx(1,:), kind=MF_SINGLE )
            if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double complex to a complex!" )
            end if
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_cmplx( left, right )

      complex, intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex matrix, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex matrix, shapes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = cmplx(right%double,kind=MF_SINGLE)
         if( any( dble(left) /= right%double ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double to a complex!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = cmplx(right%cmplx,kind=MF_SINGLE)
         if( any( cmplx(left,kind=MF_DOUBLE) /= right%cmplx ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double complex to a complex!" )
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_dble_cmplx( left, right )

      complex(kind=MF_DOUBLE), intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double, mfArray must be scalar" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = right%double(1,1)
         if( dble(left) /= right%double(1,1) ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "precision loss during assignment of a double to a complex double!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = right%cmplx(1,1)
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_dble_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_dble_cmplx( left, right )

      complex(kind=MF_DOUBLE), intent(in out) :: left(:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: dim, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double vector, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double vector, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a vector
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double vector, sizes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         if( dim == 1 ) then
            left(:) = right%double(:,1)
            if( any( dble(left) /= right%double(:,1) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double real to a complex!" )
            end if
         else
            left(:) = right%double(1,:)
            if( any( dble(left) /= right%double(1,:) ) ) then
               call PrintMessage( "assignment(=)", "W",                 &
                                  "precision loss during assignment of a double real to a complex!" )
            end if
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         if( dim == 1 ) then
            left = right%cmplx(:,1)
         else
            left = right%cmplx(1,:)
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_dble_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_dble_cmplx( left, right )

      complex(kind=MF_DOUBLE), intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be dense
      if( mfIsSparse(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double matrix, mfArray must be dense" )
         go to 99
      end if

      ! mfArray must be numeric
      if( .not. mfIsNumeric(right) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a complex double matrix, shapes must match" )
         go to 99
      end if

      if( right%data_type == MF_DT_DBLE ) then
         left = right%double
         if( any( dble(left) /= right%double ) ) then
            call PrintMessage( "assignment(=)", "W",                    &
                               "precision loss during assignment of a double to a double complex!" )
         end if
      else if( right%data_type == MF_DT_CMPLX ) then
         left = right%cmplx
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( right%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "assignment(=)", "I",                    &
                               "the physical unit of the mfArray is lost!" )
         end if
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_dble_cmplx
!_______________________________________________________________________
!
   subroutine mfArray_to_scalar_bool( left, right )

      logical, intent(in out) :: left
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      ! mfArray must be boolean
      if( right%data_type /= MF_DT_BOOL ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical, mfArray must be boolean" )
         go to 99
      end if

      ! mfArray must be scalar
      if( any( right%shape /= [1,1] ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical, mfArray must be scalar" )
         go to 99
      end if

      left = right%double(1,1) /= FALSE

 99   continue

      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_scalar_bool
!_______________________________________________________________________
!
   subroutine mfArray_to_vector_bool( left, right )

      logical, intent(in out) :: left(:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
      integer :: dim

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be boolean
      if( right%data_type /= MF_DT_BOOL ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical vector, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a vector
      if( right%shape(1) == 1 .and. right%shape(2) /= 1 ) then
         dim = 2
      else if( right%shape(1) /= 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else if( right%shape(1) == 1 .and. right%shape(2) == 1 ) then
         dim = 1
      else
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical vector, mfArray must be a vector" )
         go to 99
      end if

      ! sizes must match
      if( size(left) /= right%shape(dim) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical vector, sizes must match" )
         go to 99
      end if

      if( dim == 1 ) then
         left(:) = right%double(:,1) /= FALSE
      else
         left(:) = right%double(1,:) /= FALSE
      end if

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_vector_bool
!_______________________________________________________________________
!
   subroutine mfArray_to_matrix_bool( left, right )

      logical, intent(in out) :: left(:,:)
      type(mfArray), intent(in) :: right
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( right )

      ! mfArray must be boolean
      if( right%data_type /= MF_DT_BOOL ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical matrix, mfArray must be numeric" )
         go to 99
      end if

      ! mfArray must be a matrix
      if( any( right%shape == 1 ) ) then
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical matrix, mfArray must be matrix" )
         go to 99
      end if

      ! shapes must match
#if defined _GNU_GFC
!### TODO 2: check for all version >= 4.5
! bug work-around (4.3.1)
      if( size(left,1) /= size(right,1) .or.                            &
          size(left,2) /= size(right,2)      ) then
#else
      if( any( shape(left) /= shape(right) ) ) then
#endif
         call PrintMessage( "assignment(=)", "E",                       &
                            "when assigning to a logical matrix, shapes must match" )
         go to 99
      end if

      left = right%double /= FALSE

 99   continue

      call msFreeArgs( right )
      call msAutoRelease( right )

#endif
   end subroutine mfArray_to_matrix_bool
