! f90 include file

!_______________________________________________________________________
!
   function mf__scal_int( x ) result( out )

      integer, intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, 1 ]
      allocate( out%double(out%shape(1),out%shape(2)) )

      out%double = x

      out%prop%symm = TRUE
      if( x > 0.0d0 ) then
         out%prop%posd = TRUE
      else
         out%prop%posd = FALSE
      end if

      out%status_temporary = .true.

#endif
   end function mf__scal_int
!_______________________________________________________________________
!
   function mf__vect_int( x, transpose ) result( out )

      integer, intent(in)           :: x(:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         out%double(:,1) = x(:)
      else
         out%double(1,:) = x(:)
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mf__vect_int
!_______________________________________________________________________
!
   function mf__matr_int( x, transpose ) result( out )

      integer, intent(in)           :: x(:,:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               out%double(i,j) = x(j,i)
            end do
         end do
      else
         out%double(:,:) = x(:,:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_int
!_______________________________________________________________________
!
   function mf__scal_single( x ) result( out )

      real, intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, 1 ]
      allocate( out%double(out%shape(1),out%shape(2)) )

      out%double = x

      out%prop%symm = TRUE
      if( x > 0.0d0 ) then
         out%prop%posd = TRUE
      else
         out%prop%posd = FALSE
      end if

      out%status_temporary = .true.

#endif
   end function mf__scal_single
!_______________________________________________________________________
!
   function mf__vect_single( x, transpose ) result( out )

      real,    intent(in)           :: x(:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         out%double(:,1) = x(:)
      else
         out%double(1,:) = x(:)
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mf__vect_single
!_______________________________________________________________________
!
   function mf__matr_single( x, transpose ) result( out )

      real,    intent(in)           :: x(:,:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               out%double(i,j) = x(j,i)
            end do
         end do
      else
         out%double(:,:) = x(:,:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_single
!_______________________________________________________________________
!
   function mf__scal_double( x ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, 1 ]
      allocate( out%double(out%shape(1),out%shape(2)) )

      out%double = x

      out%prop%symm = TRUE
      if( x > 0.0d0 ) then
         out%prop%posd = TRUE
      else
         out%prop%posd = FALSE
      end if

      out%status_temporary = .true.

      call mf_restore_fpe( )

#endif
   end function mf__scal_double
!_______________________________________________________________________
!
   function mf__vect_double( x, transpose ) result( out )

      real(kind=MF_DOUBLE), intent(in)           :: x(:)
      logical,              intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      call mf_save_and_disable_fpe( )

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         out%double(:,1) = x(:)
      else
         out%double(1,:) = x(:)
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

      call mf_restore_fpe( )

#endif
   end function mf__vect_double
!_______________________________________________________________________
!
   function mf__matr_double( x, transpose ) result( out )

      real(kind=MF_DOUBLE), intent(in)           :: x(:,:)
      logical,              intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_DBLE
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               out%double(i,j) = x(j,i)
            end do
         end do
      else
         out%double(:,:) = x(:,:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_double
!_______________________________________________________________________
!
   function mf__scal_cmplx( x ) result( out )

      complex, intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_CMPLX
      out%shape = [ 1, 1 ]
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      out%cmplx = x

      if( aimag(x) == 0.0 ) then
         out%prop%symm = TRUE
      else
         out%prop%symm = FALSE
      end if

      out%status_temporary = .true.

#endif
   end function mf__scal_cmplx
!_______________________________________________________________________
!
   function mf__vect_cmplx( x, transpose ) result( out )

      complex, intent(in)           :: x(:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_CMPLX
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( transp ) then
         out%cmplx(:,1) = x(:)
      else
         out%cmplx(1,:) = x(:)
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mf__vect_cmplx
!_______________________________________________________________________
!
   function mf__matr_cmplx( x, transpose ) result( out )

      complex, intent(in)           :: x(:,:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_CMPLX
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               out%cmplx(i,j) = x(j,i)
            end do
         end do
      else
         out%cmplx(:,:) = x(:,:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_cmplx
!_______________________________________________________________________
!
   function mf__scal_double_cmplx( x ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_CMPLX
      out%shape = [ 1, 1 ]
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      out%cmplx = x

      if( aimag(x) == 0.0d0 ) then
         out%prop%symm = TRUE
      else
         out%prop%symm = FALSE
      end if

      out%status_temporary = .true.

#endif
   end function mf__scal_double_cmplx
!_______________________________________________________________________
!
   function mf__vect_double_cmplx( x, transpose ) result( out )

      complex(kind=MF_DOUBLE), intent(in)           :: x(:)
      logical,                 intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_CMPLX
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( transp ) then
         out%cmplx(:,1) = x(:)
      else
         out%cmplx(1,:) = x(:)
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mf__vect_double_cmplx
!_______________________________________________________________________
!
   function mf__matr_double_cmplx( x, transpose ) result( out )

      complex(kind=MF_DOUBLE), intent(in)           :: x(:,:)
      logical,                 intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_CMPLX
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               out%cmplx(i,j) = x(j,i)
            end do
         end do
      else
         out%cmplx(:,:) = x(:,:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_double_cmplx
!_______________________________________________________________________
!
   function mf__scal_bool( x ) result( out )

      logical, intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_BOOL
      out%shape = [ 1, 1 ]
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( x ) then
         out%double = TRUE
      else
         out%double = FALSE
      end if

      out%prop%symm = TRUE

      out%status_temporary = .true.

#endif
   end function mf__scal_bool
!_______________________________________________________________________
!
   function mf__vect_bool( x, transpose ) result( out )

      logical, intent(in)           :: x(:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_BOOL
      if( transp ) then
         out%shape = [ size(x), 1 ]
      else
         out%shape = [ 1, size(x) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         where( x )
            out%double(:,1) = TRUE
         elsewhere
            out%double(:,1) = FALSE
         end where
      else
         where( x )
            out%double(1,:) = TRUE
         elsewhere
            out%double(1,:) = FALSE
         end where
      end if

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mf__vect_bool
!_______________________________________________________________________
!
   function mf__matr_bool( x, transpose ) result( out )

      logical, intent(in)           :: x(:,:)
      logical, intent(in), optional :: transpose
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
      logical :: transp
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      if( size(x) == 0 ) return

      if( present(transpose) ) then
         transp = transpose
      else
         transp = .false.
      end if

      out%data_type = MF_DT_BOOL
      if( transp ) then
         out%shape = [ size(x,2), size(x,1) ]
      else
         out%shape = [ size(x,1), size(x,2) ]
      end if
      allocate( out%double(out%shape(1),out%shape(2)) )

      if( transp ) then
         do i = 1, out%shape(1)
            do j = 1, out%shape(2)
               if( x(j,i) ) then
                  out%double(i,j) = TRUE
               else
                  out%double(i,j) = FALSE
               end if
            end do
         end do
      else
         where( x )
            out%double(:,:) = TRUE
         elsewhere
            out%double(:,:) = FALSE
         end where
      end if

      out%status_temporary = .true.

#endif
   end function mf__matr_bool
!_______________________________________________________________________
!
   function mf__mfUnit( x ) result( out )

      type(mfUnit), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, 1 ]
      allocate( out%double(out%shape(1),out%shape(2)) )

      out%double = x%value

      out%prop%symm = TRUE
      if( x%value > 0.0d0 ) then
         out%prop%posd = TRUE
      else
         out%prop%posd = FALSE
      end if

      if( mf_phys_units ) then
         out%units(:) = x%units(:)
      end if

      out%status_temporary = .true.

#endif
   end function mf__mfUnit
