module fml

   ! Part of MUESLI Numerical Library
   ! Copyright É. Canot 2003-2025 -- IPR/CNRS

   use mod_fileio

   use mod_funfun

   use mod_polyfun

#ifdef _SPREAD_MOD
! WARNING: cf. docs/modules_graph/INTEL-ifort.redist

   use mod_matfun

   use mod_specfun

   use mod_datafun

   use mod_elmat

   use mod_ops

   use mod_elfun

   use mod_sparse

   use mod_core

   use mod_physunits

   use mod_mfarray

   use mod_mfdebug

   use mod_arpack
#endif

   implicit none

#ifndef _SPREAD_MOD
   ! from mod_mfdebug
   private :: mf_traceback_level, mf_debug_user_bool, mf_fp_rounding_mode, &
              MF_ADDRESS

   ! from mod_mfaux
   private :: seq_def, func_ptr, &
              rank_1_to_2_real8, rank_1_to_2_cmplx, rank_2_to_1_real8, &
              rank_2_to_1_cmplx, index_in_vector, term_col, build_int_seq, &
              build_tri_conn, build_tri_conn_min, find_in_face_n, &
              partition_in_disjoint_zones, &
              is_in_triangle, adj_triangle, diag_length, &
              digit_round, no_duplicates, to_lower, to_upper, find_unit, &
              mf_max_omitNaN, mf_max_includeNaN, &
              mf_min_omitNaN, mf_min_includeNaN, &
              mf_maxval_omitNaN, mf_maxval_includeNaN, &
              mf_minval_omitNaN, mf_minval_includeNaN, &
              ms_maxval_loc_omitNaN, ms_maxval_loc_includeNaN, &
              ms_minval_loc_omitNaN, ms_minval_loc_includeNaN, &
              full_chk_der_ode, full_chk_der_dae, &
              check_and_remove_trailing_zero

   private :: tsearch

   private :: quick_sort_1_int, quick_sort_1, quick_sort_3

   ! from mod_physunits
   private :: fundam_name, UNIT_ZERO_DIM, num_base_units

   ! from mod_ieee
   private :: int8 ! because it may clashes with iso_fortran_env module.

   ! from mod_mfarray
   private :: umfpack_ordering_used, umfpack_strategy_symmetric, &
              umfpack_scale_none, umfpack_scale, umfpack_strategy_used, &
              umfpack_strategy, validate_csc, mf_arnoldi_iter_max

   ! from mod_core
   private :: mf_blas_lib_strlen, mf_lapack_lib_strlen, mf_ln_10, &
              mf_long_int, mf_return, mf_tab, &
              mf_dt_sp_cmplx, mf_dt_bool, mf_dt_dble, mf_dt_empty, &
              mf_dt_cmplx, mf_dt_sp_bool, mf_dt_sp_dble, mf_dt_perm_vec, &
              mf_divbyzero_exc, mf_invalid_exc, mf_overflow_exc, &
              mf_underflow_exc, named_eqn_ptr, named_eqn_presence, &
              named_var_presence, named_var_ptr, op2_pattern_prop, &
              print_mfarray_double_alone, print_debug_mfarray, &
              mf_nan_single, mf_inf_single, &
              mf_short_mantissa, mf_display_exponent, ncol_term_val, &
              ncol_term_is_known, rand_exp, randn, rng_delete_stream, &
              rng_increased_precis, rng_create_stream, rng_set_seed, &
              rng_rand_u01, rng_get_state, rngstream_init, &
              search_index_in_eqn_groups, search_index_in_var_groups, &
              set_status_restr_to_false, &
              mf_display_head_length, mf_display_hexa, &
              mf_display_tail_length, mf_display_line_head_or_tail, &
              mf_papi_flpins_old, mf_papi_available, mf_papi_init_ok, &
              crc, mf_auto_complex, can_use_memory, same_address, lep, &
              manual_dealloc_vec, set_status_tempo_to_false, &
              get_address_of_out_args, get_address_of_in_args, &
              next_face_on_boundary, next_node_and_face_on_boundary, &
              sp_del_0_and_compact_r8, sp_del_0_and_compact_z8, &
              sqbanded2csc_nnz

   ! from mod_sparse
   private :: MF_SP_AUTO_ROW_SORTED, MF_CHOLMOD_NATURAL, MF_CHOLMOD_GIVEN, &
              MF_CHOLMOD_AMD, MF_CHOLMOD_METIS, MF_CHOLMOD_NESDIS, &
              MF_CHOLMOD_COLAMD, process_dupl_entries

   ! from f90_gzlib
   private :: gz_filedes, gzwrite, gzread, gzopen, gzclose, filedes_is_null

   ! from mod_fileio
   private :: MF_BIN_SIGN_22, MF_BIN_SIGN_23, MF_BIN_SIGN_24, &
              MF_BIN_SIGN_25, MF_ENDIAN_NATIVE, MF_ENDIAN_SWAP, &
              fileio_get_tok, &
              post_chk_der, post_full_chk_der, swap_4bytes_rat, &
              swap_4bytes, swap_8bytes

   ! from mod_mf_gsl
   private :: mf_gsl_complex_tan, mf_gsl_complex_arccos_real, &
              mf_gsl_complex_arccos, mf_gsl_complex_arcsin_real, &
              mf_gsl_complex_arcsin, mf_gsl_complex_arctan, &
              mf_gsl_complex_cosh, mf_gsl_complex_sinh, &
              mf_gsl_complex_tanh, mf_gsl_complex_arccosh_real, &
              mf_gsl_complex_arccosh, mf_gsl_complex_arcsinh, &
              mf_gsl_complex_arctanh_real, mf_gsl_complex_arctanh

   ! from mod_elfun
#if defined _INTEL_IFC | defined _GNU_GFC
#else
   private :: hypot
#endif

   ! from mod_specfun
   private :: MF_PN_MAX_LIMIT, MF_PN_MAX, MF_PN_NB, prime_numbers, &
              cei_double, derfcx, erfcinv, erfinv, fourier_cos, fourier_sin, &
              inv_fourier_cos, inv_fourier_sin

   ! from bezier
   private :: quadratic_bezier, cubic_bezier

   ! from splines
   private :: cub_spl, int_spl, som_spl

   ! from mod_ops
   private :: nnzamub, amub, colperm, rowperm, colscale, rowscale

#endif

   private :: verif_adim, process_units

   ! from mod_sparse
   private :: amib, amib_cmplx_cmplx, amib_real_cmplx, amib_cmplx_real, &
              amib1, amib1_cmplx_cmplx, amib1_real_cmplx, amib1_cmplx_real, &
              amub_real_cmplx, amub_cmplx_real, amub_cmplx_cmplx, &
              amux, amux_real_cmplx, amux_cmplx_real, amux_cmplx_cmplx, &
              aplb, aplb_cmplx_cmplx, aplb_real_cmplx, aplb_cmplx_real, &
              aplb1, aplb1_cmplx_cmplx, aplb1_real_cmplx, aplb1_cmplx_real, &
              aplib, aplib1, atmub, chgcol, chgcol_cmplx, chgcol_cmplx_r8, &
              colconcat, colconcat_real_cmplx, colconcat_cmplx_real, &
              colconcat_cmplx_cmplx, colconcat_ip, colconcat_ip_cmplx, &
              colpinv, colperm2, colpinv2, colperm_cmplx, colpinv_cmplx, &
              colperm2_cmplx, colpinv2_cmplx, colscale2, colscale_cmplx, &
              colscale2_cmplx, coo2csc, coo2csc_cmplx, coo2csc_struct_only, &
              dns2csc, dns2csc_cmplx, getdia, getdia_cmplx, getelm, &
              getelm_cmplx, getl_nnz, getl, getl_cmplx, getu_nnz, getu, &
              getu_cmplx, isdiag, istril, istriu, &
              maxab_omitNaN, maxab_includeNaN, &
              maxab1_omitNaN, maxab1_includeNaN, max_diag_At_A, &
              minab_omitNaN, minab_includeNaN, minab1_omitNaN, &
              minab1_includeNaN, nnzaplb, nnzatmub, nnzxtrcols, norm1_real, &
              norm1_cmplx, norminf_real, norminf_cmplx, normcols, prtmt, &
              readmt, reshape_sparse, reshape_sparse_cmplx, reshape_sp_inplace, &
              rowconcat, rowconcat_real_cmplx, rowconcat_cmplx_real, &
              rowconcat_cmplx_cmplx, rowpinv, rowperm2, rowpinv2, &
              rowperm_cmplx, rowpinv_cmplx, rowscale2, rowscale_cmplx, &
              rowscale2_cmplx, setelm, setelm_cmplx, row_sorted, &
              weak_row_sorted, unique_entries, remove_dupl_entries, &
              remove_dupl_entries_cmplx, remove_dupl_entries_struct_only, &
              add_dupl_entries, add_dupl_entries_cmplx, replace_dupl_entries, &
              replace_dupl_entries_cmplx, row_sort, row_sort_cmplx, &
              row_sort_struct_only, ivpinv, dvpinv, zvpinv, matcolperm, &
              matcolperm_cmplx, matrowperm, matrowperm_cmplx, spcut_nnz, &
              spcut_nnz_cmplx, spcut, spcut_cmplx, sqbanded2csc, submat_nnz, &
              submat, submat_cmplx, sumcols, sumcols_cmplx, sumrows, &
              sumrows_cmplx, symmpattern, csc_transp, csc_transp_struct_only, &
              csc_transp_cmplx, csc_ctransp_cmplx, trilsol, trilsol_c_c, &
              trilsol_r_c, trilsol_nrhs, trilsol_nrhs_c_c, trilsol_nrhs_r_c, &
              trilsol_transp, trilsol_transp_c_c, trilsol_transp_r_c, &
              trilsol_transp_nrhs, trilsol_transp_nrhs_c_c, &
              trilsol_transp_nrhs_r_c, triusol, triusol_c_c, triusol_r_c, &
              triusol_nrhs, triusol_nrhs_c_c, triusol_nrhs_r_c, &
              triusol_transp, triusol_transp_c_c, triusol_transp_r_c, &
              triusol_transp_nrhs, triusol_transp_nrhs_c_c, &
              triusol_transp_nrhs_r_c, xmua, xmua_real_cmplx, &
              xmua_cmplx_real, xmua_cmplx_cmplx, xtrcol, xtrcol_cmplx, &
              xtrcols, xtrcols_cmplx, xtrrow, xtrrow_cmplx

   ! from mod_mfarray
   private :: PrintMessage

   ! from mod_mfdebug
   private :: muesli_trace

   ! from mod_ddebd2
   private :: nnz, pd, ipd, jpd, jac_ipd_crc, spjac_const_struct, &
              first_call_to_sp_lu, ipd_C, jpd_C, numeric, symbolic, &
              control, infos, yp_init_ddassl, n_times, save_times, &
              times_solve, ddajac_failed, ddajac_must_quit, transp_Jac, &
              dgeco_z, ddajac_FJAC, ddajac_err, current_time, current_percent, &
              unit_monitor_y, unit_monitor_yp, monitoryind, monitorypind, &
              format_monitor_y, format_monitor_yp, monitor_pause, &
              jac_symm_pos_def, c_addr, LL_addr, AA_addr, &
              sp_lu_fact, sp_lu_solv, ddebd2_free, sp_chol_fact, &
              sp_chol_solv, ddebd2_free2, yy, rwork, iwork, &
              len_dbl_ddebd1, len_int_ddebd1, orders_solve, save_orders

   ! from misc/arpack_util
   private :: dmout, icnteq, iset, ivout, zmout, dvout, icopy, iswap, &
              arscnd, zvout

   ! from misc/arpack_src
   private :: dgetv0, dsaitr, dsortc, znaupd, dnaitr, dsapps, dsortr, zneigh, &
              dnapps, dsaup2, dstatn, zneupd, dnaup2, dsaupd, dstats, zngets, &
              dnaupd, dsconv, dstqrb, zsortc, dnconv, dseigt, zgetv0, zstatn, &
              dneigh, dsesrt, znaitr, dneupd, dseupd, znapps, dngets, dsgets, &
              znaup2

   ! from misc/GFT
   private :: GFT_R4, GFT_R8, GFT_R16, GFT_prec, copyright, GFT_CC, GFT_RCR, &
              GFT_MCC, GFT_MRCR, GFT_Error, GFT_Warning, GFT_CopyRight, &
              jmtable, jmfact, jmdecoup, jmdecoup3, jmccm1d, jmccm1d2, &
              jmccm1d3, jmccm1d4, jmccm1d5, jmccm1dp, jmcsm1d, jmcsm1dxy, &
              jmscm1d, jmscm1dxy, jmtransp, jmcctranspcs, jmsetnwork, &
              jmgetnwork, jmgetsetnwork, jmgeterreur, jmerreur0, jmerreur1, &
              jmerreur2, jmerreur3, jmerreur4, jmgetstop, jmgetsetstop, &
              jmgetmessage, jmsetcode, jmgetsetcode, jmgetseterreur

   ! from misc/minpack
   private :: REUSE_SPJAC_STRUCT, chkder, dogleg, dogleg_sp, enorm, fdjac1, &
              fdjac2, fdjac2_funfit, full_chk_der, full_chk_der_2, hybrd, &
              hybrj_mf, hybrj_sp, lmder_mf, lmdif, lmdif1_funfit, lmdif_funfit, &
              lmpar, qform, qrfac, qrsolv, r1mpyq, r1updt

   ! from misc/slatec/mod_slatec_aux
   private :: d1mach, fdump, i1mach, j4save, xercnt, xerhlt, xermsg, xerprn, &
              xersve, xgetua, xsetf

   ! from misc/slatec/mod_slatec_fun
   private :: d9aimp, d9lgmc, dai, daie, dasyik, dasyjy, dbesi, dbesj, dbesk, &
              dbesk0, dbesk1, dbesi0, dbesi1, dbesy, dbi, dbie, dbsi0e, dbsi1e, &
              dbsk0e, dbsk1e, dbsknu, dbsynu, dcsevl, de1, dexprl, dgamlm, &
              dgamln, dgamma, djairy, dlngam, dlnrel, dqag, dqag_2, dqag_3, &
              dqage, dqage_2, dqage_3, dqags, dqagse, dqelg, dqk15, dqk21, &
              dqk31, dqk41, dqk51, dqk61, dqk15_2, dqk21_2, dqk31_2, dqk41_2, &
              dqk51_2, dqk61_2, dqk15_3, dqk21_3, dqk31_3, dqk41_3, dqk51_3, &
              dqk61_3, dqpsrt, dyairy, initds, zabs, zacai, zacon, zairy, zasyi, &
              zbesh, zbesi, zbesj, zbesk, zbesy, zbinu, zbiry, zbknu, zbuni, &
              zbunk, zdiv, zexp, zkscl, zlog, zmlt, zmlri, zrati, zs1s2, zseri, &
              zshch, zsqrt, zuchk, zunhj, zuni1, zuni2, zunik, zunk1, zunk2, &
              zuoik, zwrsk

   ! from misc/slatec/mod_slatec_solve
   private :: dhstrt, dhvnrm, ddeabm, ddes, dintp, dsteps, dderkf, drkfs, dfehl, &
              dgbfa, dgefa, dgbsl, dgesl, dgeco, dpbfa, dpbsl, dpoco, dpofa, &
              dposl, ddebdf, dlsod, dintyd, dstod, dcfod, dpjac, dvnrms, dslvs, &
              ddassl, ddaini, ddajac, ddanrm, ddaslv, ddastp, ddatrp, ddawts

   ! from misc/suitesparse (cholmod wrapper)
   private :: cholmod_pos_def, cholmod_llt_prep, cholmod_llt_prep2, &
              cholmod_llt_symb, cholmod_llt_num, cholmod_ldlt_prep, &
              cholmod_get_factor, cholmod_get_diag, cholmod_solve_f90, &
              cholmod_free_factor_f90, cholmod_free_factor_2, &
              cholmod_solve_factor, cholmod_solve_factor_nRHS, &
              cholmod_spsol_fact_nRHS_prep, cholmod_get_sol_nRHS, &
              cholmod_cmplx_pos_def, cholmod_cmplx_llt_prep, &
              cholmod_cmplx_llt_prep2, cholmod_cmplx_llt_symb, &
              cholmod_cmplx_llt_num, cholmod_cmplx_get_factor, &
              cholmod_cmplx_solve, cholmod_cmplx_solve_factor, &
              cholmod_cmplx_solve_factor_nrhs

   ! from misc/suitesparse (spqr wrapper)
   private :: spqr_solve_lsq, spqr_tsolve_lsq, spqr_solve_min2norm, &
              spqr_tsolve_min2norm, spqr_q_less_prep, spqr_get_r, &
              spqr_qr_prep, spqr_get_q_r, spqr_get_q_r_p, spqhr_qr_prep, &
              spqr_get_sparse_entries, spqhr_get_r_p, spqhr_mleft_dense, &
              spqhr_mright_dense, spqhr_mleft_sparse_prep, &
              spqhr_mright_sparse_prep, spqr_free_long_vec, &
              spqr_free_common, spqr_free_dense, spqr_free_sparse

   ! from misc/suitesparse (umf4 wrapper)
   private :: umf4def_d, umf4sym_d, umf4qsym_d, umf4num_d, umf4sol_d, &
              umf4wsol_d, umf4solr_d, umf4nzudiag_d, umf4getudiag_d, &
              umf4nzlu_d, umf4getlu_d, umf4getlupqr_d, umf4fsym_d, &
              umf4fnum_d, umf4def_z, umf4sym_z, umf4num_z, umf4sol_z, &
              umf4wsol_z, umf4nzudiag_z, umf4getudiag_z, umf4nzlu_z, &
              umf4getlu_z, umf4getlupqr_z, umf4fsym_z, umf4fnum_z, &
              get_suitesparse_version

   ! from misc/iso_varying_string
   private :: varying_string, var_str, get, put, put_line, extract, insert, &
              remove, replace, split, VS_elem_is_blank, VS_elem_is_same

   ! from misc/rational_numbers
   private :: rational, RAT_0, RAT_1, RAT_M1, RAT_2, RAT_M2, RAT_3, RAT_M3, &
              RAT_4, rat_num_prec, rational_add, rational_sub, rational_mul, &
              rational_div

   ! from mod_ops
   private :: mfColon_int, mfColon_single, mfColon_double, &
              mfTranspose_mfArray, mfTranspose_vec_int, mfTranspose_vec_real8, &
              mfTranspose_array_int, mfTranspose_array_real8, &
              mfCTranspose_mfArray, mfCTranspose_vec_cmplx8, &
              mfCTranspose_array_cmplx8, mfMul_A_B, plus_mfArray, &
              mfAdd_mfArray_mfArray, mfAdd_mfArray_int, &
              mfAdd_int_mfArray, mfAdd_mfArray_real4, mfAdd_real4_mfArray, &
              mfAdd_mfArray_real8, mfAdd_real8_mfArray, mfAdd_mfArray_cmplx4, &
              mfAdd_cmplx4_mfArray, mfAdd_mfArray_cmplx8, mfAdd_cmplx8_mfArray, &
              mfAdd_mfArray_mfUnit, mfAdd_mfUnit_mfArray, minus_mfArray, &
              mfSub_mfArray_mfArray, mfSub_mfArray_int, mfSub_int_mfArray, &
              mfSub_mfArray_real4, mfSub_real4_mfArray, mfSub_mfArray_real8, &
              mfSub_real8_mfArray, mfSub_mfArray_cmplx4, mfSub_cmplx4_mfArray, &
              mfSub_mfArray_cmplx8, mfSub_cmplx8_mfArray, &
              mfSub_mfArray_mfUnit, mfSub_mfUnit_mfArray, &
              mfMul_mfArray_mfArray, mfMul_mfArray_int, mfMul_int_mfArray, &
              mfMul_mfArray_real4, mfMul_real4_mfArray, mfMul_mfArray_real8, &
              mfMul_real8_mfArray, mfMul_mfArray_cmplx4, mfMul_cmplx4_mfArray, &
              mfMul_mfArray_cmplx8, mfMul_cmplx8_mfArray, mfMul_mfArray_mfUnit, &
              mfMul_mfUnit_mfArray, mfDiv_mfArray_mfArray, mfDiv_mfArray_int, &
              mfDiv_int_mfArray, mfDiv_mfArray_real4, mfDiv_real4_mfArray, &
              mfDiv_mfArray_real8, mfDiv_real8_mfArray, mfDiv_mfArray_cmplx4, &
              mfDiv_cmplx4_mfArray, mfDiv_mfArray_cmplx8, mfDiv_cmplx8_mfArray, &
              mfDiv_mfArray_mfUnit, mfDiv_mfUnit_mfArray, mfPow_mfArray_int, &
              mfPow_mfArray_real8, mfPow_int_mfArray, mfPow_real8_mfArray, &
              mfPow_mfArray_mfArray, not_mfArray, and_mfArray_mfArray, &
              or_mfArray_mfArray, eqv_mfArray_mfArray, neqv_mfArray_mfArray, &
              mfArray_equal_mfArray, mfArray_equal_real8, mfArray_equal_cmplx, &
              mfArray_not_equal_mfArray, mfArray_not_equal_real8, &
              mfArray_not_equal_cmplx, mfGreater_mfArray_mfArray, &
              mfGreater_mfArray_real8, mfGreaterStrict_mfArray_mfArray, &
              mfGreaterStrict_mfArray_real8, mfLess_mfArray_mfArray, &
              mfLess_mfArray_real8, mfLessStrict_mfArray_mfArray, &
              mfLessStrict_mfArray_real8, mfMul_transp

   ! from mod_funfun
   private :: dummy_dae_jac, dummy_dae_spjac, process_tol_for_daesolve, &
              process_singular_jacobian, fzero_intv, mf_de_free, &
              mf_nl_free, mffsolve_jacdf, mffsolve_jacuser, &
              mffsolve_jacusersp, msdaesolve_finalize, &
              msdaesolve_saverest_mf, msdaesolve_saverest_sp_mf, &
              msfsolve_jacdf, msfsolve_jacuser, msfsolve_jacusersp, &
              msodesolve_finalize, msodesolve_saverest_full, &
              msodesolve_saverest_sp, sls_dense_a, sls_dense_b, &
              sls_dense_c, sls_sparse

   ! from mod_core
   private :: f90readline_max_length

   ! from mod_datafun
   private :: mfMax_mfArray, mfMax_mfArray_mfArray, mfMax_mfArray_real8, &
              mfMin_mfArray, mfMin_mfArray_mfArray, mfMin_mfArray_real8, &
              mfSort_vec, mfSort_matrix, msSort_vec, msSort_matrix, &
              msSort_vec_out, msSort_matrix_out, &
              mfGradient_real8, mfGradient_mfArray, mfIsSorted_vec

   ! from mod_elmat
   private :: RngStream_initialized, Rng_Stream_g_addr, Rng_Stream_seed

   ! from mod_matfun
   private :: mfLDiv_A, mfRDiv_A, mfNorm_int, mfNorm_char, mfFunm_intr, &
              mfFunm_user, msFunm_intr, msFunm_user, mfSVDS_which, &
              msSVDS_which, mfLDiv_two_mf, mfLDiv_three_mf, mfLDiv_four_mf, &
              mfLDiv_mfMatFactor, mfRDiv_two_mf, mfRDiv_three_mf, &
              mfRDiv_four_mf, mfRDiv_mfMatFactor, mfPowm_integer, &
              mfPowm_real, UMFPACK_STATUS, UMFPACK_WARNING_singular_matrix, &
              is_pos_def_sp_complex, is_pos_def_real, is_pos_def_sp_real, &
              is_pos_def_complex, max_diag_at_a_cmplx, mf_mat_vec, &
              mf_mat_vec_2steps, mf_mat_vec_2steps_inv_cmplx, &
              mf_mat_vec_2steps_inv_factor, mf_mat_vec_2steps_inv_factor_cmplx, &
              mf_mat_vec_2steps_cmplx, mf_mat_vec_inv, &
              mf_mat_vec_inv_chol_cmplx, mf_mat_vec_inv_chol, &
              mf_mat_vec_inv_cmplx, mf_mat_vec_inv_factor, &
              mf_mat_vec_inv_lu, mf_mat_vec_inv_spchol, &
              mf_mat_vec_inv_spchol_cmplx, mf_mat_vec_inv_factor_cmplx, &
              mf_mat_vec_cmplx, mfldiv_spd, mfldiv_triang, mfrdiv_spd, &
              mfrdiv_triang, mschol_mfarray, mschol_mfmatfactor, &
              mslu_mfarray, mslu_mfmatfactor, msqr_mfarray, &
              msqr_mfmatfactor, powm_optim_mult, rsf2csf, svds_which_worker, &
              undupli

   ! the following lines should be uncommented only for the 'test_internal'
   ! programs...
   private :: mfnormest1_inv_l_u_p, mfnormest1_inv_u

   ! from mod_mfarray
   private :: zero_kind_1, one_kind_1

   ! from mod_mfaux
   private :: mf_full_trapping, fpu_flags_saved, fpe_nested_call, &
              is_sorted_ascend_real8, is_sorted_descend_real8, &
              is_sorted_ascend_cmplx8, is_sorted_descend_cmplx8, &
              issorted_cmplx_by_phase_angle, sort_cmplx_by_phase_angle, &
              sort_cmplx_by_phase_angle_2, ms_minval_loc_int_omitnan

   ! from mod_mfdebug
   private :: mf_message_displayed, mf_colored_messages, MF_UF_LONG, kind_1

   ! from mod_polyfun
   private :: mfTriSearch_mfarray, mfTriSearch_double, mfNodeSearch_mfarray, &
              mfNodeSearch_double, mfTetraSearch_mfarray, mfTetraSearch_double, &
              mfNodeSearch3D_mfarray, mfNodeSearch3D_double, &
              msPrepProgress_int, msPrepProgress_dble, msPrintProgress_int, &
              msPrintProgress_dble, mfInterp1_real, mfInterp1_bool, &
              mfInterp2_real, mfInterp2_bool, mfPPVal_real, mfPPVal_bool, &
              mfPPDer_real, mfPPDer_bool, mfDelaunay3D_vec, &
              mfDelaunay3D_mat, msBuildTetraConnect_vec, &
              msBuildTetraConnect_mat, delaunay3d_addr, &
              cubic_interp, build_tri_from_rect, fcn_lmdif_funfit, &
              fourier_leg, inv_fourier_leg, msDelaunay_PLdomain, &
              msdelaunay_xy, mspostprogress

   ! from mod_prop
   private :: properties, PROP_ALL_UNKNOWN, prop_equal_prop, reset_prop, &
              hide_prop, unhide_prop

   ! from misc/ConvexHull
   private :: CH_convex_hull, CH_isLeftOf

end module fml
