!_______________________________________________________________________
!
   subroutine msZoom( )

      !------ API end ------

      ! Zoom into the axes, taking care of lin/log axes, inverted axes
      ! and presence of a legend frame.

      real(kind=MF_DOUBLE) :: xref, yref, xc, yc
      real(kind=MF_DOUBLE) :: x_left_init, x_right_init, y_bottom_init, y_top_init
      real(kind=MF_DOUBLE) :: d_x_init, d_y_init, ratio, x_center, y_center, d_x, d_y
      real(kind=MF_DOUBLE) :: x_left, x_right, y_bottom, y_top, dir_x, dir_y
      real(kind=MF_DOUBLE) :: x_left_z, x_right_z, y_bottom_z, y_top_z
      real(kind=MF_DOUBLE) :: x_left_ze, x_right_ze, y_bottom_ze, y_top_ze
      real(kind=MF_DOUBLE) :: x1, x2, y1, y2
      character :: ch
      character(len=4) :: win_id_char
      real(kind=MF_DOUBLE) :: range(4), zoom_factor
      integer :: itmp
      real(kind=MF_DOUBLE) :: dx_factor, dy_factor, dl, dx_old, dy_old
      logical :: intern_val_ready
      real(kind=MF_DOUBLE) :: leg_xmin, leg_xmax, leg_ymin, leg_ymax
      real(kind=MF_DOUBLE) :: dx_axes, dy_axes
      real(kind=MF_DOUBLE) :: current_axes(4)
      real(kind=MF_DOUBLE) :: x_factor, y_factor

      integer :: leg_imin_dev, leg_imax_dev, leg_jmin_dev, leg_jmax_dev
      integer :: px_win_height, px_xoff, px_yoff
      double precision :: rbuf(1)
      integer :: ibuf(4), lchr
      character(len=16) :: chr

      character(len=*), parameter :: ROUTINE_NAME = "msZoom"

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 ) then
         print *, "(MUESLI FGL:) msZoom: internal error."
         print *, "              x-axis scale undefined!"
         pause "only for debugging purpose"
         stop
      end if

      if( win%axis_scale_y == 0 ) then
         print *, "(MUESLI FGL:) msZoom: internal error."
         print *, "              y-axis scale undefined!"
         pause "only for debugging purpose"
         stop
      end if

      call set_focus_mfplot_win( 1 )

      write(STDOUT,*)
      write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                               CURRENT_WIN_ID, " ... (ESC to quit)"
      write(STDOUT,*) " [Zoom: click and drag to zoom in the axes]"
      write(STDOUT,*)

      ! switch to 'manual' axis
      ! (for printing, the selected subview must be the current view
      !  -> axis_manual must be TRUE)
      win%axis_manual_x = 1
      win%axis_manual_y = 1

      ! saving initial view before zoom
      x_left_init = win%current_axes(1)
      x_right_init = win%current_axes(2)
      y_bottom_init = win%current_axes(3)
      y_top_init = win%current_axes(4)

      current_axes(:) = win%current_axes(:)
      if( win%axis_scale_x == 2 ) then ! log scale
         current_axes(1:2) = log10( current_axes(1:2) )
      end if
      if( win%axis_scale_y == 2 ) then ! log scale
         current_axes(3:4) = log10( current_axes(3:4) )
      end if

      dx_axes = current_axes(2) - current_axes(1)
      dy_axes = current_axes(4) - current_axes(3)

      ! memorise axis direction (signs)
      if( x_left_init < x_right_init ) then
         dir_x = +1.0d0
      else
         dir_x = -1.0d0
      end if
      if( y_bottom_init < y_top_init ) then
         dir_y = +1.0d0
      else
         dir_y = -1.0d0
      end if

      d_x_init = abs(x_right_init - x_left_init)
      d_y_init = abs(y_top_init - y_bottom_init)
      if( d_x_init == 0.0d0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "failed!",                                  &
                            "(invalid range for the X-axis)" )
         go to 99
      end if
      if( d_y_init == 0.0d0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "failed!",                                  &
                            "(invalid range for the Y-axis)" )
         go to 99
      end if
      ratio = d_y_init / d_x_init

      x_left   = x_left_init
      x_right  = x_right_init
      y_bottom = y_bottom_init
      y_top    = y_top_init

      if( associated(win%legend) ) then
         ! compute the Legend BBOX in world coordinates...
         leg_xmin = win%legend%xmin * dx_axes + current_axes(1)
         leg_xmax = win%legend%xmax * dx_axes + current_axes(1)
         leg_ymin = win%legend%ymin * dy_axes + current_axes(3)
         leg_ymax = win%legend%ymax * dy_axes + current_axes(3)
         ! ... and in device coordinates
         px_xoff = nint(0.25d0*pgxpin(pgid))
         px_yoff = nint(0.25d0*pgypin(pgid))
         call grexec( grgtyp, GET_WIN_SIZE_PIX, rbuf, ibuf, chr, lchr )
         px_win_height = ibuf(4)
         leg_imin_dev = nint(pgxorg(pgid) + leg_xmin*pgxscl(pgid)) + px_xoff
         leg_imax_dev = nint(pgxorg(pgid) + leg_xmax*pgxscl(pgid)) + px_xoff
         leg_jmax_dev = px_win_height                                   &
                      - ( nint(pgyorg(pgid) + leg_ymin*pgyscl(pgid)) + px_yoff )
         leg_jmin_dev = px_win_height                                   &
                      - ( nint(pgyorg(pgid) + leg_ymax*pgyscl(pgid)) + px_yoff )
      end if

      do

         if( win%axis_scale_x == 1 ) then ! lin scale
            x_left_z = x_left
            x_right_z = x_right
         else ! log scale
            x_left_z = log10(x_left)
            x_right_z = log10(x_right)
         end if
         if( win%axis_scale_y == 1 ) then ! lin scale
            y_bottom_z = y_bottom
            y_top_z = y_top
         else ! log scale
            y_bottom_z = log10(y_bottom)
            y_top_z = log10(y_top)
         end if
         intern_val_ready = .true.

         ! wait for a click (mouse down) or a key pressed
         if( associated(win%legend) ) then
            itmp = pgband_dyn_plus_exclude( MF_ZOOM_CURSOR,             &
                      x_left_z, x_right_z, y_bottom_z, y_top_z,         &
                      leg_imin_dev, leg_imax_dev, leg_jmin_dev, leg_jmax_dev, &
                      xc, yc, ch, win%axis_scale_x, win%axis_scale_y )
         else
            itmp = pgband_dyn( MF_ZOOM_CURSOR,                          &
                               x_left_z, x_right_z, y_bottom_z, y_top_z, &
                               xc, yc, ch, win%axis_scale_x, win%axis_scale_y )
         end if
         if( itmp == 0 ) then
            write(win_id_char,"(I0)") CURRENT_WIN_ID
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
            return
         end if

         ch = to_upper(ch)

         if( ch == "R" ) then ! right button click (down)

            ! wait for a click (mouse up)
            itmp = pgband( MF_WATCH_CURSOR, 0, 0, xref, yref,           &
                           xc, yc, ch, .false. )
            if( itmp == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            ! reset to initial view
            x_left = x_left_init
            x_right = x_right_init
            y_bottom = y_bottom_init
            y_top = y_top_init

            intern_val_ready = .false.

         else if( ch == "M" .or. ch == "5" ) then ! middle button click (down)

            if( ch == "M" ) then ! click without modifier
               zoom_factor = sqrt(2.0d0)
            else if( ch == "5" ) then ! control-click
               zoom_factor = sqrt(sqrt(2.0d0))
            end if

            ! wait for a click (mouse up)
            itmp = pgband( MF_ZOOM_CURSOR, 0, 0, xref, yref, xc, yc, ch, &
                           .false.)
            if( itmp == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            if( win%axis_scale_x == 1 ) then
               ! linear scale
               x_center = xc
               d_x = zoom_factor*abs(x_right - x_left)
               x_left = x_center - dir_x*d_x / 2.0d0
               x_right = x_center + dir_x*d_x / 2.0d0
            else ! log scale
               ! (intermediate computations are made in linear)
               x_center = ( log10(x_left) + log10(x_right) ) / 2.0d0
               d_x = zoom_factor*( log10(x_right) - log10(x_left) )
               if( d_x > 25.0d0 ) then
                  ! avoid too many ticks along axis
                  d_x = 25.0d0
                  call PrintMessage( trim(ROUTINE_NAME), "W",           &
                                     "Too large view for the X-axis: upper limit reached!" )
               end if
               x_left = 10.0d0**( x_center - d_x / 2.0d0 )
               x_right = 10.0d0**( x_center + d_x / 2.0d0 )
            end if

            if( win%axis_scale_y == 1 ) then
               ! linear scale
               y_center = yc
               d_y = zoom_factor*abs(y_top - y_bottom)
               y_bottom = y_center - dir_y*d_y / 2.0d0
               y_top = y_center + dir_y*d_y / 2.0d0
            else ! log scale
               ! (intermediate computations are made in linear)
               y_center = ( log10(y_bottom) + log10(y_top) ) / 2.0d0
               d_y = zoom_factor*( log10(y_top) - log10(y_bottom) )
               if( d_y > 25.0d0 ) then
                  ! avoid too many ticks along axis
                  d_y = 25.0d0
                  call PrintMessage( trim(ROUTINE_NAME), "W",           &
                                     "Too large view for the X-axis: upper limit reached!" )
               end if
               y_bottom = 10.0d0**( y_center - d_y / 2.0d0 )
               y_top = 10.0d0**( y_center + d_y / 2.0d0 )
            end if
            intern_val_ready = .false.

         else if( ch == "L" .or. ch == "4" ) then ! left button click (down)

            if( ch == "L" ) then ! click without modifier
               zoom_factor = sqrt(0.5d0)
            else if( ch == "4" ) then ! control-click
               zoom_factor = sqrt(sqrt(0.5d0))
            end if

            xref = xc
            yref = yc

            ! wait for a click (mouse up)
            itmp = pgband( MF_ZOOM_CURSOR, 2, 0, xref, yref, xc, yc, ch, &
                           .false., win%axis_scale_x, win%axis_scale_y )
            if( itmp == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            if( xc == xref .and. yc == yref ) then
               ! single click detected : zoom by a constant factor
               !                         which depends on the modifier

               x_center = xref
               y_center = yref

               if( win%axis_scale_x == 1 ) then
                  ! linear scale
                  d_x = abs( x_right - x_left ) / 2.0d0 * zoom_factor
               else ! log scale
                  ! (intermediate computations are made in linear)
                  d_x = ( log10(x_right) - log10(x_left) ) / 2.0d0 * zoom_factor
               end if

               if( win%axis_scale_y == 1 ) then
                  ! linear scale
                  d_y = abs( y_top - y_bottom ) / 2.0d0 * zoom_factor
               else ! log scale
                  ! (intermediate computations are made in linear)
                  d_y = ( log10(y_top) - log10(y_bottom) ) / 2.0d0 * zoom_factor
               end if

               xref = x_center - dir_x*d_x
               xc   = x_center + dir_x*d_x
               yref = y_center - dir_y*d_y
               yc   = y_center + dir_y*d_y

            else if( xc == xref .or. yc == yref ) then
               ! bad use : discarded
               cycle
            end if

            ! hereafter, the wish rectangle is defined by :
            !  ( xref, xc, yref, yc )

            if( win%axis_equal ) then
               ! assume that x-y axes are always linear
               x_center = ( xref + xc ) / 2.0d0
               y_center = ( yref + yc ) / 2.0d0
               d_x = abs( xref - xc )
               d_y = abs( yref - yc )
               if( d_y > ratio*d_x ) then
                 d_x = d_y / ratio
               else
                 d_y = ratio * d_x
               end if
               x_left = x_center - dir_x*d_x / 2.0d0
               x_right = x_center + dir_x*d_x / 2.0d0
               y_bottom = y_center - dir_y*d_y / 2.0d0
               y_top = y_center + dir_y*d_y / 2.0d0
               call fix_min_max_for_axes( x_left, x_right )
               d_x = abs( x_left - x_right )
               d_y = ratio * d_x
               y_bottom = y_center - dir_y*d_y / 2.0d0
               y_top = y_center + dir_y*d_y / 2.0d0
            else
               if( win%axis_scale_x == 1 ) then
                  ! linear scale
                  if( dir_x > 0.0d0 ) then
                     x_left = min(xc,xref)
                     x_right = max(xc,xref)
                  else
                     x_left = max(xc,xref)
                     x_right = min(xc,xref)
                  end if
                  call fix_min_max_for_axes( x_left, x_right )
               else ! log
                  x1 = min(xref,xc)
                  x2 = max(xref,xc)
                  call fix_min_max_for_axes( x1, x2 )
                  ! log scale
                  x_left = 10.0d0**x1
                  x_right = 10.0d0**x2
               end if
               if( win%axis_scale_y == 1 ) then
                  ! linear scale
                  if( dir_y > 0.0d0 ) then
                     y_bottom = min(yc,yref)
                     y_top = max(yc,yref)
                  else
                     y_bottom = max(yc,yref)
                     y_top = min(yc,yref)
                  end if
                  call fix_min_max_for_axes( y_bottom, y_top )
               else ! log
                  y1 = min(yref,yc)
                  y2 = max(yref,yc)
                  call fix_min_max_for_axes( y1, y2 )
                  ! log scale
                  y_bottom = 10.0d0**y1
                  y_top = 10.0d0**y2
               end if
            end if
            intern_val_ready = .false.

         else if( ch == "6" ) then ! '6' key or ctrl-right click

            ! wait for a click (mouse up)
            if( pgband(MF_ZOOM_CURSOR,0,0,xref,yref,xc,yc,ch,           &
                       .false.) == 0 ) then
               write(win_id_char,"(I0)") CURRENT_WIN_ID
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "no cursor device for win ID: " // trim(adjustl(win_id_char)) )
               return
            end if

            ! set the view to max area (englobing all graphic obj.)
            range(:) = get_true_min_max(CURRENT_WIN_ID)
            if( all( range(:)==0.0d0 ) ) then
               range(:) = [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ]
            end if

            ! _z suffix concerns internal (always linear) coordinates
            x_left_z = range(1)
            x_right_z = range(2)
            y_bottom_z = range(3)
            y_top_z = range(4)
            if( win%axis_scale_x == 2 ) then ! log scale
               x_left_z = log10(x_left_z)
               x_right_z = log10(x_right_z)
            end if
            if( win%axis_scale_y == 2 ) then ! log scale
               y_bottom_z = log10(y_bottom_z)
               y_top_z = log10(y_top_z)
            end if

!### TODO 1: à ne mettre que pour les axes linéaires ?
            ! add 1% margins (isolated point may be hidden by axes)
            x_left_ze = x_left_z - 0.01d0*(x_right_z-x_left_z)
            x_right_ze = x_right_z + 0.01d0*(x_right_z-x_left_z)
            y_bottom_ze = y_bottom_z - 0.01d0*(y_top_z-y_bottom_z)
            y_top_ze = y_top_z + 0.01d0*(y_top_z-y_bottom_z)
            x_left_z = x_left_ze
            x_right_z = x_right_ze
            y_bottom_z = y_bottom_ze
            y_top_z = y_top_ze
            intern_val_ready = .true.

            x_left = x_left_z
            x_right = x_right_z
            y_bottom = y_bottom_z
            y_top = y_top_z
            if( win%axis_scale_x == 2 ) then ! log scale
               x_left = 10.0d0**x_left
               x_right = 10.0d0**x_right
            end if
            if( win%axis_scale_y == 2 ) then ! log scale
               y_bottom = 10.0d0**y_bottom
               y_top = 10.0d0**y_top
            end if

         else if( ichar(ch) == 27 ) then ! ESCAPE key pressed

            exit ! do loop

         else

            cycle ! avoid redrawing

         end if

         if( .not. intern_val_ready ) then
            ! _z suffix concerns internal (always linear) coordinates
            x_left_z = x_left
            x_right_z = x_right
            y_bottom_z = y_bottom
            y_top_z = y_top
            if( win%axis_scale_x == 2 ) then ! log scale
               x_left_z = log10(x_left_z)
               x_right_z = log10(x_right_z)
            end if
            if( win%axis_scale_y == 2 ) then ! log scale
               y_bottom_z = log10(y_bottom_z)
               y_top_z = log10(y_top_z)
            end if
         end if

         win%current_axes(:) = [ x_left, x_right, y_bottom, y_top ]

         ! compute absolute zoom level (for the arrow head)
         x_factor = abs(x_right_init-x_left_init)/abs(x_right-x_left)
         y_factor = abs(y_top_init-y_bottom_init)/abs(y_top-y_bottom)
         win%abs_zoom_factor = ( x_factor + y_factor )/2.0d0

         call mf_win_redraw( CURRENT_WIN_ID )

      end do

 99   continue

      itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )

      call set_focus_mfplot_win( 0 )

   end subroutine msZoom
