#ifdef _MF_FUNC
   function mfXLabel( xlabel ) result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msXLabel( xlabel )
#endif

      character(len=*), intent(in) :: xlabel

      integer :: handle
      !------ API end ------

      ! X label is always internally stored, but is displayed only
      ! if axis in "on".

      ! Blanks present at the end of string are removed.

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      type(grobj_struct), pointer :: grobj2

      character(len=96) :: text_latin_1
      integer :: i, j, n, len_text, len_text_latin_1, hdle
      character(len=96) :: text
      logical :: must_be_redrawn

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=1) :: chr

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfXLabel"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msXLabel"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%blank ) then
         if( win%axis_on ) then
            call mf_win_draw_box( CURRENT_WIN_ID ) ! if needed
         end if
      end if

      if( UTF8_ENCODING ) then
         text_latin_1  = utf8_to_latin_1( trim(xlabel) )
      else
         text_latin_1 = trim(xlabel)
      end if

      must_be_redrawn = .false.

      if( .not. win%xlabel_exist ) then
         if( win%colorbar > 0 ) then
            if( win%colorbar_pos(1:1) == "b" ) then
               must_be_redrawn = .true.
            end if
         end if
      end if

#ifdef _MF_SUBR
      ! Quick return if the text to be displayed is exactly the same
      ! as another one previously drawn.
      if( associated(win%xlabel_grobj) ) then
         if( associated(win%xlabel_grobj%text) ) then
            len_text = size(win%xlabel_grobj%text)
         else
            len_text = 0
         end if
         if( len_text /= 0 ) then
            do j = 1, len_text
               text(j:j) = win%xlabel_grobj%text(j)
            end do
            if( text(1:len_text) == trim(text_latin_1) ) then
               return
            end if
         end if
      else
         len_text = 0
      end if
      if( len_text > 0 ) then
         must_be_redrawn = .true.
      end if
      len_text_latin_1 = len_trim(text_latin_1)
      if( associated(win%xlabel_grobj) ) then
         if( len_text /= len_text_latin_1 ) then
            deallocate( win%xlabel_grobj%text )
            allocate( win%xlabel_grobj%text(len_text_latin_1) )
         end if
      else
         allocate( grobj2 )
         win%xlabel_grobj => grobj2
         allocate( win%xlabel_grobj%text(len_text_latin_1) )
      end if
      ! copy
      do j = 1, len_text_latin_1
         win%xlabel_grobj%text(j) = text_latin_1(j:j)
      end do
      win%xlabel_exist = .true.
#endif

#ifdef _MF_FUNC
      ! Create a new grobj (multiple x-labels may exist)
      call create_grobj( win, grobj )

      grobj%struct%cmd = "xlabel"
      len_text = len_trim(text_latin_1)
      allocate( grobj%struct%text(len_text) )
      do i = 1, len_text
         grobj%struct%text(i) = text_latin_1(i:i)
      end do

      hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
      win%handles(hdle)%ptr => grobj
      grobj%struct%hdle = hdle
      handle = encode_handle( CURRENT_WIN_ID, hdle )
      win%xlabel_exist = .true.
#endif

      ! Ici, on pratique l'économie : on ne change les choses, temporairement,
      ! que si c'est nécessaire
      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 0 ! no clipping
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
      end if

#ifdef _MF_SUBR
      ! overwrite mode : if anything exist previously, it must be erased
      if( .not. must_be_redrawn ) then
         if( win%axis_on ) then
            call grsci( 1 ) ! default foreground color
            if( win%char_height_factor < 0.0d0 ) then
               ! must be defined
               call char_height_factor_update( CURRENT_WIN_ID )
            end if
            call pgsch( win%label_font_size * win%char_height_factor ) ! character height
            if( win%axis_mode_xy ) then
               call pglab( trim(text_latin_1), 1, "", "" )
            else
               call pglab( trim(text_latin_1), 2, "", "" )
            end if
         end if
      end if
#endif

#ifdef _MF_FUNC
      if( win%axis_on ) then
         call grsci( 1 ) ! default foreground color
         if( win%char_height_factor < 0.0d0 ) then
            ! must be defined
            call char_height_factor_update( CURRENT_WIN_ID )
         end if
         call pgsch( win%label_font_size * win%char_height_factor ) ! character height
         if( win%axis_mode_xy ) then
            call pglab( trim(text_latin_1), 1, "", "" )
         else
            call pglab( trim(text_latin_1), 2, "", "" )
         end if
      end if
#endif

      if( must_be_redrawn ) then
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

      if( CLIPPING_IN_AXES ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
      end if

#ifdef _MF_FUNC
   end function mfXLabel
#endif
#ifdef _MF_SUBR
   end subroutine msXLabel
#endif
