!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriStreamline_color_str( x, y, u, v, start, tri, tri_connect, &
                                       direction, n_arrow, color, linestyle, &
                                       linewidth, arrow_head, npt_max,  &
                                       curv_tol, stop_zone )            &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriStreamline_color_str( x, y, u, v, start, tri, tri_connect, &
                                         direction, n_arrow, color, linestyle, &
                                         linewidth, arrow_head, npt_max, &
                                         curv_tol, stop_zone )
#endif

      type(mfArray)                                    :: x, y, u, v, start
      type(mfArray), target,                  optional :: tri
      type(mfTriConnect), target, intent(in), optional :: tri_connect
      integer,                    intent(in), optional :: n_arrow
      character(len=*),           intent(in)           :: color
      character(len=*),           intent(in), optional :: linestyle
      character(len=*),           intent(in), optional :: direction
      real(kind=MF_DOUBLE),       intent(in), optional :: linewidth, arrow_head
      integer,                    intent(in), optional :: npt_max
      real(kind=MF_DOUBLE),       intent(in), optional :: curv_tol
                                              optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! Streamline sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)

      integer :: p_dim, nn, i_curve, n_curve
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, ier, handle_0, npt_max_0
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfArray) :: xx, yy

      type(mfArray), pointer :: tri_mf_ptr
      type(mfTriConnect), pointer :: tri_connect_mf_ptr

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, u, v, start )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'u' is a vector
      if( size(u_ptr,1)/=1 .and. size(u_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be a vector!" )
         go to 99
      end if

      ! checking that 'v' is a vector
      if( size(v_ptr,1)/=1 .and. size(v_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y', 'u' and 'v' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(u_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(v_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y', 'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x_ptr ) ! x_min
      range(2) = maxval( x_ptr ) ! x_max
      range(3) = minval( y_ptr ) ! y_min
      range(4) = maxval( y_ptr ) ! y_max

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1 ! lin
      win%axis_scale_y = 1 ! lin

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)

      ! build unstructured coordinates
      allocate( x_long(nn), y_long(nn), u_long(nn), v_long(nn) )
      if( p_dim == 1 ) then
         x_long(:) = x_ptr(:,1)
         y_long(:) = y_ptr(:,1)
         u_long(:) = u_ptr(:,1)
         v_long(:) = v_ptr(:,1)
      else
         x_long(:) = x_ptr(1,:)
         y_long(:) = y_ptr(1,:)
         u_long(:) = u_ptr(1,:)
         v_long(:) = v_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      if( present(tri) ) then
         tri_mf_ptr => tri
      else
         ! when connectivity is provided, it contains all information;
         ! no need to compute again the triangulation
         if( .not. present(tri_connect) ) then
            allocate( tri_mf_ptr )
!### TODO: appeler la procédure interne de muesli
            xx = x_long ! it is not possible to call mfDelaunay with mf(x) and mf(y)
            yy = y_long
            tri_mf_ptr = mfDelaunay( xx, yy )
         end if
      end if

      if( present(tri_connect) ) then
         tri_connect_mf_ptr => tri_connect
      else
         allocate( tri_connect_mf_ptr )
!### TODO: appeler la procédure interne de muesli
         ! triangles mesh connectivity
         call msBuildTriConnect( mf(x_long), mf(y_long),                &
                                 tri_mf_ptr, tri_connect_mf_ptr )
      end if

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve
         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect_mf_ptr, &
                              range, npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      if( present(tri) ) then
         call msAutoRelease( tri )
      else
         if( .not. present(tri_connect) ) then
            call msRelease( tri_mf_ptr )
            deallocate( tri_mf_ptr )
            call msRelease( xx, yy )
         end if
      end if

      if( present(tri_connect) ) then
      else
         call msRelease( tri_connect_mf_ptr )
         deallocate( tri_connect_mf_ptr )
      end if

 99   continue

      call msFreeArgs( x, y, u, v, start )
      call msAutoRelease( x, y, u, v, start )

#ifdef _MF_FUNC
   end function mfTriStreamline_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msTriStreamline_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriStreamline_color_rgb( x, y, u, v, start, tri, tri_connect, &
                                       direction, n_arrow, color, linestyle, &
                                       linewidth, arrow_head, npt_max,  &
                                       curv_tol, stop_zone )            &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriStreamline_color_rgb( x, y, u, v, start, tri, tri_connect, &
                                         direction, n_arrow, color, linestyle, &
                                         linewidth, arrow_head, npt_max, &
                                         curv_tol, stop_zone )
#endif

      type(mfArray)                                    :: x, y, u, v, start
      type(mfArray), target,                  optional :: tri
      type(mfTriConnect), target, intent(in), optional :: tri_connect
      integer,                    intent(in), optional :: n_arrow
      real(kind=MF_DOUBLE),       intent(in), optional :: color(3)
      character(len=*),           intent(in), optional :: linestyle
      character(len=*),           intent(in), optional :: direction
      real(kind=MF_DOUBLE),       intent(in), optional :: linewidth, arrow_head
      integer,                    intent(in), optional :: npt_max
      real(kind=MF_DOUBLE),       intent(in), optional :: curv_tol
                                              optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! Streamline sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)

      integer :: p_dim, nn, i_curve, n_curve
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, handle_0, npt_max_0
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfArray) :: xx, yy

      type(mfArray), pointer :: tri_mf_ptr
      type(mfTriConnect), pointer :: tri_connect_mf_ptr

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, u, v, start )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'u' is a vector
      if( size(u_ptr,1)/=1 .and. size(u_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be a vector!" )
         go to 99
      end if

      ! checking that 'v' is a vector
      if( size(v_ptr,1)/=1 .and. size(v_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y', 'u' and 'v' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(u_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(v_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y', 'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x_ptr ) ! x_min
      range(2) = maxval( x_ptr ) ! x_max
      range(3) = minval( y_ptr ) ! y_min
      range(4) = maxval( y_ptr ) ! y_max

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1 ! lin
      win%axis_scale_y = 1 ! lin

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)

      ! build unstructured coordinates
      allocate( x_long(nn), y_long(nn), u_long(nn), v_long(nn) )
      if( p_dim == 1 ) then
         x_long(:) = x_ptr(:,1)
         y_long(:) = y_ptr(:,1)
         u_long(:) = u_ptr(:,1)
         v_long(:) = v_ptr(:,1)
      else
         x_long(:) = x_ptr(1,:)
         y_long(:) = y_ptr(1,:)
         u_long(:) = u_ptr(1,:)
         v_long(:) = v_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      if( present(tri) ) then
         tri_mf_ptr => tri
      else
         ! when connectivity is provided, it contains all information;
         ! no need to compute again the triangulation
         if( .not. present(tri_connect) ) then
            allocate( tri_mf_ptr )
!### TODO: appeler la procédure interne de muesli
            xx = x_long ! it is not possible to call mfDelaunay with mf(x) and mf(y)
            yy = y_long
            tri_mf_ptr = mfDelaunay( xx, yy )
         end if
      end if

      if( present(tri_connect) ) then
         tri_connect_mf_ptr => tri_connect
      else
         allocate( tri_connect_mf_ptr )
!### TODO: appeler la procédure interne de muesli
         ! triangles mesh connectivity
         call msBuildTriConnect( mf(x_long), mf(y_long),                &
                                 tri_mf_ptr, tri_connect_mf_ptr )
      end if

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve
         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect_mf_ptr, &
                              range, npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      if( present(tri) ) then
         call msAutoRelease( tri )
      else
         if( .not. present(tri_connect) ) then
            call msRelease( tri_mf_ptr )
            deallocate( tri_mf_ptr )
            call msRelease( xx, yy )
         end if
      end if

      if( present(tri_connect) ) then
      else
         call msRelease( tri_connect_mf_ptr )
         deallocate( tri_connect_mf_ptr )
      end if

 99   continue

      call msFreeArgs( x, y, u, v, start )
      call msAutoRelease( x, y, u, v, start )

#ifdef _MF_FUNC
   end function mfTriStreamline_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msTriStreamline_color_rgb
#endif
