!_______________________________________________________________________
!
   subroutine mf_tri_quiver_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "tri_quiver"

      type(mf_win_info), pointer :: win

      integer :: i, nn, hdle
      real(kind=MF_DOUBLE) :: x_start_pg, y_start_pg, x_end_pg, y_end_pg
      real(kind=MF_DOUBLE) :: fact, arrow_head

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Quiver", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Quiver", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      nn = size(grobj%struct%abs_mat,1)
      fact = grobj%struct%x_text
      call grsci(grobj%struct%color)
      call grslw(1.0d0)
      arrow_head = grobj%struct%y_text
      ! *** under a zoom, we must increase the arrow head size...
      arrow_head = arrow_head * win%abs_zoom_factor
      call pgsch(arrow_head)
      do i = 1, nn
         ! Quick return if any component is NaN
         if( isnan(grobj%struct%ord_mat(i,1)) ) cycle
         if( isnan(grobj%struct%ord_mat(i,2)) ) cycle
         x_start_pg = grobj%struct%abs_mat(i,1)
         y_start_pg = grobj%struct%abs_mat(i,2)
         x_end_pg = x_start_pg + fact*grobj%struct%ord_mat(i,1)
         y_end_pg = y_start_pg + fact*grobj%struct%ord_mat(i,2)
         ! Quick return (but not optimized!)
         if( MF_QR_in_aux_pixmap ) then
            ! x_..._QR , y_..._QR defined in Pan or PanAndZoom
         else
            x_left_QR   = win%current_axes(1)
            x_right_QR  = win%current_axes(2)
            y_bottom_QR = win%current_axes(3)
            y_top_QR    = win%current_axes(4)
         end if
         if( win%current_axes(1) > win%current_axes(2) ) then ! x inverted
            if( max(x_start_pg,x_end_pg) < x_right_QR ) cycle
            if( min(x_start_pg,x_end_pg) > x_left_QR ) cycle
         else ! x not inverted
            if( max(x_start_pg,x_end_pg) < x_left_QR ) cycle
            if( min(x_start_pg,x_end_pg) > x_right_QR ) cycle
         end if
         if( win%current_axes(3) > win%current_axes(4) ) then ! y inverted
            if( max(y_start_pg,y_end_pg) < y_top_QR ) cycle
            if( min(y_start_pg,y_end_pg) > y_bottom_QR ) cycle
         else ! y not inverted
            if( max(y_start_pg,y_end_pg) < y_bottom_QR ) cycle
            if( min(y_start_pg,y_end_pg) > y_top_QR ) cycle
         end if
         call pgarro( x_start_pg, y_start_pg, x_end_pg, y_end_pg,       &
                      clipping=.true. )
      end do
      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Quiver", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Quiver", 0 )
         end if
      end if

   end subroutine mf_tri_quiver_draw
