!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriQuiver( x, y, u, v,                                    &
                         color, arrow_length, arrow_head )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriQuiver( x, y, u, v,                                  &
                           color, arrow_length, arrow_head )
#endif

      type(mfArray)                              :: x, y, u, v
      character(len=*),     intent(in), optional :: color
      real(kind=MF_DOUBLE), intent(in), optional :: arrow_length, arrow_head

      integer :: handle
      !------ API end ------

      ! Quiver sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), uv_sto_pg(:,:)

      integer :: icol
      real(kind=MF_DOUBLE) :: arrow_length_0
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriQuiver"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriQuiver"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, u, v )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      call msPointer( v, v_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'u' is a vector
      if( size(u_ptr,1)/=1 .and. size(u_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be a vector!" )
         go to 99
      end if

      ! checking that 'v' is a vector
      if( size(v_ptr,1)/=1 .and. size(v_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y', 'u' and 'v' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(u_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(v_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y', 'u' and 'v' must have the same shape!" )
         go to 99
      end if

      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if
      if( present(color) ) then
         call decode_colorspec( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(arrow_length) ) then
         arrow_length_0 = arrow_length
      else
         arrow_length_0 = 1.0 ! default arrow length factor
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = -1.0
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)

      allocate( xy_sto_pg(nn,2) )

      allocate( uv_sto_pg(nn,2) )

      if( p_dim == 1 ) then
         xy_sto_pg(:,1) = x_ptr(:,1)
         xy_sto_pg(:,2) = y_ptr(:,1)
         uv_sto_pg(:,1) = u_ptr(:,1)
         uv_sto_pg(:,2) = v_ptr(:,1)
      else
         xy_sto_pg(:,1) = x_ptr(1,:)
         xy_sto_pg(:,2) = y_ptr(1,:)
         uv_sto_pg(:,1) = u_ptr(1,:)
         uv_sto_pg(:,2) = v_ptr(1,:)
      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      handle = QuiverTri( xy_sto_pg, uv_sto_pg,                         &
                          icol, arrow_length_0, arrow_head_0 )

 99   continue

      call msFreeArgs( x, y, u, v )
      call msAutoRelease( x, y, u, v )

#ifdef _MF_FUNC
   end function mfTriQuiver
#endif
#ifdef _MF_SUBR
   end subroutine msTriQuiver
#endif
