!_______________________________________________________________________
!
   subroutine mf_tri_pcolor_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "tri_pcolor"

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE) :: fact
      real(kind=MF_DOUBLE) :: x_pg_3(3), y_pg_3(3)
      integer :: c_pg_3(3), ntri, i, k1, k2, k3, nb_nodes, tp
      real(kind=MF_DOUBLE), allocatable :: x_dble(:), y_dble(:)
      integer, allocatable :: c_pg_tmp(:)
      logical :: flat

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Pcolor", 0 )
         end if
         call EPS_clip_on_viewport_beg()
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Pcolor", 0 )
         end if
         call PDF_clip_on_viewport_beg()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      fact = (win%colormap_ci_high-win%colormap_ci_low) /               &
             (win%color_axes(2)-win%color_axes(1))

      ntri = grobj%struct%npt

      if( (PRINTING_EPS .or. PRINTING_PDF) .and. win%shading /= "flat" ) then

         ! using a mesh structure to reduce the file size
         ! (this is very important for PDF)
         nb_nodes = size(grobj%struct%abs_mat,1)
         allocate( x_dble(nb_nodes), y_dble(nb_nodes), c_pg_tmp(nb_nodes) )
         x_dble(:) = grobj%struct%abs_mat(:,1)
         y_dble(:) = grobj%struct%abs_mat(:,2)
         c_pg_tmp(:) = win%colormap_ci_low +                            &
                     fact*(grobj%struct%abs_mat(:,3)-win%color_axes(1))
         if( any( c_pg_tmp < win%colormap_ci_low .or.                   &
                  win%colormap_ci_high < c_pg_tmp ) ) then
            call PrintMessage( "TriPcolor", "E",                        &
                               "Color index overflow: please choose appropriate 'Color axes'!", &
                               "(Graphic object cannot be printed)" )
            return
         end if
         ! grobj%struct%abs_mat contains coords (x, y) and z (color)
         !                               in the 3 column vectors
         ! grobj%struct%val_mat contains the triangle numbering
         !                               (3 indices per line)
         call PatchTriMesh_PS_PDF_shad( x_dble, y_dble, c_pg_tmp,       &
                                        grobj%struct%val_mat )
         deallocate( x_dble, y_dble, c_pg_tmp )

      else

         ! In this routine, z is a height, and c_pg are indices of the
         ! colormap.

         do i = 1, ntri
            ! type_of_patch: only for EPS & PDF Shading
            tp = 0
            if( i == 1 ) then
               tp = tp + 1
            end if
            if( i == ntri ) then
               tp = tp + 2
            end if

            k1 = grobj%struct%val_mat(i,1)
            k2 = grobj%struct%val_mat(i,2)
            k3 = grobj%struct%val_mat(i,3)

            x_pg_3(:) = grobj%struct%abs_mat([k1,k2,k3],1)
            y_pg_3(:) = grobj%struct%abs_mat([k1,k2,k3],2)
            if( any( grobj%struct%abs_mat([k1,k2,k3],3) < win%color_axes(1) .or. &
                     win%color_axes(2) < grobj%struct%abs_mat([k1,k2,k3],3) ) ) then
               c_pg_3(:) = 1
            else
               c_pg_3(:) = win%colormap_ci_low +                        &
                           fact*( grobj%struct%abs_mat([k1,k2,k3],3)    &
                                  - win%color_axes(1) )
            end if

            if( win%shading == "flat" ) then
               flat = .true.
               c_pg_3(:) = sum(c_pg_3(:))/3.
            else
               flat = .false.
            end if

            call PatchTriCore( x_pg_3, y_pg_3, c_pg_3,                  &
                               opacity=1.0d0, flat=flat, type_of_patch=tp )

         end do

      end if

      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_end()
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Pcolor", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call PDF_clip_on_viewport_end()
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Pcolor", 0 )
         end if
      end if

   end subroutine mf_tri_pcolor_draw
