!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriPcolor( x, y, z, tri )                                 &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriPcolor( x, y, z, tri )
#endif

      type(mfArray)                              :: x, y, z, tri

      integer :: handle
      !------ API end ------

      ! Pcolor sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:), &
                                   tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xyz_sto_pg(:,:), tri_sto_pg(:,:)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriPcolor"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriPcolor"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call msInitArgs( x, y, z, tri )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y' and 'z' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(z_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'z' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      allocate( xyz_sto_pg(nn,3) )

      allocate( tri_sto_pg(ntri,3) )

      if( p_dim == 1 ) then
         xyz_sto_pg(:,1) = x_ptr(:,1)
         xyz_sto_pg(:,2) = y_ptr(:,1)
         xyz_sto_pg(:,3) = z_ptr(:,1)
      else
         xyz_sto_pg(:,1) = x_ptr(1,:)
         xyz_sto_pg(:,2) = y_ptr(1,:)
         xyz_sto_pg(:,3) = z_ptr(1,:)
      end if
      tri_sto_pg(:,:) = tri_ptr(:,:)

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( z, z_ptr )
      call msFreePointer( tri, tri_ptr )

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "Colormap has not yet been defined!",       &
                            "(default colormap is selected)" )
         call msColormap( "rainbow" )
      end if

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      handle = PcolorTri( xyz_sto_pg, tri_sto_pg )

 99   continue

      call msFreeArgs( x, y, z, tri )
      call msAutoRelease( x, y, z, tri )

#ifdef _MF_FUNC
   end function mfTriPcolor
#endif
#ifdef _MF_SUBR
   end subroutine msTriPcolor
#endif
