!_______________________________________________________________________
!
   subroutine mf_trimesh_by_tri_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "trimesh_by_tri"

      type(mf_win_info), pointer :: win

      integer :: i, ntri, nn, k1, k2, k3, icol_txt, tb, nstr
      character(len=10) :: str
      real(kind=MF_DOUBLE) :: xc, yc

      real(kind=MF_DOUBLE) :: x_pg_4(4), y_pg_4(4)
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (by triangles)", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (by triangles)", 0 )
         end if
         call gresc( "q" ) ! = gsave
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(1) ! line style: continuous
      ntri = grobj%struct%npt
      do i = 1, ntri
         k1 = grobj%struct%tab_2d_1(i,1)
         k2 = grobj%struct%tab_2d_1(i,2)
         k3 = grobj%struct%tab_2d_1(i,3)
         x_pg_4(:) = [ grobj%struct%abs_mat(k1,1),                      &
                       grobj%struct%abs_mat(k2,1),                      &
                       grobj%struct%abs_mat(k3,1),                      &
                       grobj%struct%abs_mat(k1,1) ]
         y_pg_4(:) = [ grobj%struct%abs_mat(k1,2),                      &
                       grobj%struct%abs_mat(k2,2),                      &
                       grobj%struct%abs_mat(k3,2),                      &
                       grobj%struct%abs_mat(k1,2) ]
         call pgline( 4, x_pg_4, y_pg_4 )
      end do

      if( grobj%struct%bool1 ) then
         ! Write the triangles' number
         ntri = grobj%struct%npt2
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%linestyle
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, ntri
            k1 = grobj%struct%tab_2d_1(i,1)
            k2 = grobj%struct%tab_2d_1(i,2)
            k3 = grobj%struct%tab_2d_1(i,3)
            ! Find center of the label
            xc = ( sum(grobj%struct%abs_mat([k1,k2,k3],1)) ) / 3.0d0
            yc = ( sum(grobj%struct%abs_mat([k1,k2,k3],2)) ) / 3.0d0
            ! Write the label in a string
            write(str,"(I0)") i
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=trim(str),      &
                         clipping=.true. )
         end do
      end if

      if( grobj%struct%bool2 ) then
         ! Write the nodes' number
         nn = grobj%struct%npt3
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%marker
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, nn
            ! Find center of the label
            xc = grobj%struct%abs_mat(i,1)
            yc = grobj%struct%abs_mat(i,2)
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (by triangles)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (by triangles)", 0 )
         end if
      end if

   end subroutine mf_trimesh_by_tri_draw
!_______________________________________________________________________
!
   subroutine mf_trimesh_by_fac_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "trimesh_by_fac"

      type(mf_win_info), pointer :: win

      integer :: i, ntri, nf, nn, node, k1, k2, k3, icol_txt, tb, nstr
      integer, pointer :: p(:)
      character(len=10) :: str
      real(kind=MF_DOUBLE) :: xc, yc

      real(kind=MF_DOUBLE) :: x_pg_2(2), y_pg_2(2)
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (by faces)", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (by faces)", 0 )
         end if
         call gresc( "q" ) ! = gsave
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(1) ! line style: continuous
      nf = grobj%struct%npt
      do i = 1, nf
         node = grobj%struct%tab_2d_1(i,1)
         x_pg_2(1) = grobj%struct%abs_mat(node,1)
         y_pg_2(1) = grobj%struct%abs_mat(node,2)
         node = grobj%struct%tab_2d_1(i,2)
         x_pg_2(2) = grobj%struct%abs_mat(node,1)
         y_pg_2(2) = grobj%struct%abs_mat(node,2)
         call pgline( 2, x_pg_2, y_pg_2 )
      end do

      if( grobj%struct%bool1 ) then
         ! Write the triangles' number
         ntri = grobj%struct%npt2
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%linestyle
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, ntri
            k1 = grobj%struct%tab_2d_2(i,1)
            k2 = grobj%struct%tab_2d_2(i,2)
            k3 = grobj%struct%tab_2d_2(i,3)
            ! Find center of the label
            xc = ( sum(grobj%struct%abs_mat([k1,k2,k3],1)) ) / 3.0d0
            yc = ( sum(grobj%struct%abs_mat([k1,k2,k3],2)) ) / 3.0d0
            ! Write the label in a string
            write(str,"(I0)") i
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=trim(str),      &
                         clipping=.true. )
         end do
      end if

      if( grobj%struct%bool2 ) then
         ! Write the nodes' number
         nn = grobj%struct%npt3
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%marker
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, nn
            ! Find center of the label
            xc = grobj%struct%abs_mat(i,1)
            yc = grobj%struct%abs_mat(i,2)
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( grobj%struct%bool3 ) then
         ! Write the faces' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%alpha_transp
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         p => grobj%struct%ir ! permutation of face numbering
         do i = 1, nf
            k1 = grobj%struct%tab_2d_1(i,1)
            k2 = grobj%struct%tab_2d_1(i,2)
            ! Find center of the label
            xc = ( grobj%struct%abs_mat(k1,1) +                         &
                   grobj%struct%abs_mat(k2,1) ) / 2.0d0
            yc = ( grobj%struct%abs_mat(k1,2) +                         &
                   grobj%struct%abs_mat(k2,2) ) / 2.0d0
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") p(i) ! i
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (by faces)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (by faces)", 0 )
         end if
      end if

   end subroutine mf_trimesh_by_fac_draw
!_______________________________________________________________________
!
   subroutine mf_boundary_mesh_unstruct_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "trimesh_by_tri"

      type(mf_win_info), pointer :: win

      integer :: i, nf_edge, nn, k, k1, k2, icol_txt, tb, nstr,         &
                 nb_curves, n1, n2
      character(len=10) :: str
      real(kind=MF_DOUBLE) :: xc, yc

      real(kind=MF_DOUBLE) :: x_pg_2(2), y_pg_2(2)
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (boundary only)", 0 )
         end if
         call gresc( "q" ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Mesh (boundary only)", 0 )
         end if
         call gresc( "q" ) ! = gsave
         gr_pdf_color_intent = 1 ! Stroke
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! set line width
      call grsls(1) ! line style: continuous
      nf_edge = grobj%struct%npt
      ! Draw subparts (the boundary may consist in many closed curves,
      ! either interior or exterior)
      nb_curves = size(grobj%struct%jc)
      k1 = 1
      do k = 1, nb_curves
         k2 = grobj%struct%jc(k)
         ! all faces but the curve will remain opened
         call pgline( k2-k1+1, grobj%struct%abs_mat(k1:k2,1),           &
                               grobj%struct%abs_mat(k1:k2,2) )
         ! close the curve
         x_pg_2(:) = [ grobj%struct%abs_mat(k2,1),                      &
                       grobj%struct%abs_mat(k1,1) ]
         y_pg_2(:) = [ grobj%struct%abs_mat(k2,2),                      &
                       grobj%struct%abs_mat(k1,2) ]
         call pgline( 2, x_pg_2, y_pg_2 )
         k1 = k2 + 1
      end do

      if( grobj%struct%bool1 ) then
         ! Write the nodes' number
         nn = nf_edge
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%marker
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         do i = 1, nn
            ! Find center of the label
            xc = grobj%struct%abs_mat(i,1)
            yc = grobj%struct%abs_mat(i,2)
            ! Save current text background and set to erase
            ! anything under the textbox.
            call pgqtbg(tb)
            call pgstbg(0)
            ! Write the label in a string
            write(str,"(I0)") grobj%struct%ir(i)
            str = " " // str
            nstr = len_trim(str) + 1
            call pgptxt( xc, yc, angle=0.0d0,                           &
                         hjust=0.5d0, vjust=0.5d0, text=str(1:nstr),    &
                         to_be_trimmed=.false., clipping=.true. )
            ! Restore text background
            call pgstbg(tb)
         end do
      end if

      if( grobj%struct%bool2 ) then
         ! Write the faces' number
         gr_pdf_color_intent = 3 ! Stroke & Fill
         icol_txt = grobj%struct%alpha_transp
         call grsci(icol_txt)
!### TODO ?:
! setting default value (not adapted if enlarging window),
! moreover, doesn't match the current symbol size ...
         call pgsch( grobj%struct%height_text ) ! char. height
         k1 = 1
         do k = 1, nb_curves
            k2 = grobj%struct%jc(k)
            do i = k1, k2
               n1 = i
               n2 = i+1
               if( i == k2 ) then
                  n2 = k1
               end if
               ! Find center of the label
               xc = ( grobj%struct%abs_mat(n1,1) +                      &
                      grobj%struct%abs_mat(n2,1) ) / 2.0d0
               yc = ( grobj%struct%abs_mat(n1,2) +                      &
                      grobj%struct%abs_mat(n2,2) ) / 2.0d0
               ! Save current text background and set to erase
               ! anything under the textbox.
               call pgqtbg(tb)
               call pgstbg(0)
               ! Write the label in a string
               write(str,"(I0)") grobj%struct%col_tab(i)
               str = " " // str
               nstr = len_trim(str) + 1
               call pgptxt( xc, yc, angle=0.0d0,                        &
                            hjust=0.5d0, vjust=0.5d0, text=str(1:nstr), &
                            to_be_trimmed=.false., clipping=.true. )
               ! Restore text background
               call pgstbg(tb)
            end do
            k1 = k2 + 1
         end do
      end if

      if( PRINTING_EPS ) then
         call gresc( "Q" ) ! = grestore
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (boundary only)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call gresc( "Q" ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Mesh (boundary only)", 0 )
         end if
      end if

   end subroutine mf_boundary_mesh_unstruct_draw
