!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriMesh_tri_color_str( x, y, tri,                         &
                                     color, linewidth, height,          &
                                     tri_num, nod_num,                  &
                                     boundary_only )                    &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriMesh_tri_color_str( x, y, tri,                       &
                                       color, linewidth, height,        &
                                       tri_num, nod_num,                &
                                       boundary_only )
#endif

      type(mfArray)                              :: x, y, tri
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, height
      logical,              intent(in), optional :: tri_num, nod_num,   &
                                                    boundary_only

      integer :: handle
      !------ API end ------

      integer :: icol, ier
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: tri_num_0, nod_num_0, boundary_only_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriMesh"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriMesh"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad 'color' argument!",                 &
                               "(line color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(tri_num) ) then
         tri_num_0 = tri_num
      else
         tri_num_0 = .false.
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(boundary_only) ) then
         boundary_only_0 = boundary_only
         if( tri_num_0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "the 'tri_num' argument will have no effect!", &
                               "(only the boundary line is drawn)" )
         end if
      else
         boundary_only_0 = .false.
      end if

      handle = TriMesh_tri( x, y, tri, icol,                            &
                            linewidth_0, height_0,                      &
                            tri_num_0, nod_num_0,                       &
                            boundary_only_0 )

#ifdef _MF_FUNC
   end function mfTriMesh_tri_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msTriMesh_tri_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriMesh_tri_color_rgb( x, y, tri,                         &
                                     color, linewidth, height,          &
                                     tri_num, nod_num,                  &
                                     boundary_only )                    &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriMesh_tri_color_rgb( x, y, tri,                       &
                                       color, linewidth, height,        &
                                       tri_num, nod_num,                &
                                       boundary_only )
#endif

      type(mfArray)                              :: x, y, tri
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, height
      logical,              intent(in), optional :: tri_num, nod_num,   &
                                                    boundary_only

      integer :: handle
      !------ API end ------

      integer :: icol
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: tri_num_0, nod_num_0, boundary_only_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriMesh"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriMesh"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(tri_num) ) then
         tri_num_0 = tri_num
      else
         tri_num_0 = .false.
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(boundary_only) ) then
         boundary_only_0 = boundary_only
         if( tri_num_0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "the 'tri_num' argument will have no effect!", &
                               "(only the boundary line is drawn)" )
         end if
      else
         boundary_only_0 = .false.
      end if

      handle = TriMesh_tri( x, y, tri, icol,                            &
                            linewidth_0, height_0,                      &
                            tri_num_0, nod_num_0,                       &
                            boundary_only_0 )

#ifdef _MF_FUNC
   end function mfTriMesh_tri_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msTriMesh_tri_color_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriMesh_fac_color_str( tri_connect,                       &
                                     color, linewidth, height,          &
                                     tri_num, nod_num, fac_num,         &
                                     boundary_only )                    &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriMesh_fac_color_str( tri_connect,                     &
                                       color, linewidth, height,        &
                                       tri_num, nod_num, fac_num,       &
                                       boundary_only )
#endif

      type(mfTriConnect),   intent(in)           :: tri_connect
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, height
      logical,              intent(in), optional :: tri_num, nod_num,   &
                                                    fac_num, boundary_only

      integer :: handle
      !------ API end ------

      integer :: icol, ier
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: tri_num_0, nod_num_0, fac_num_0, boundary_only_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriMesh"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriMesh"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad 'color' argument!",                 &
                               "(line color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(tri_num) ) then
         tri_num_0 = tri_num
      else
         tri_num_0 = .false.
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(fac_num) ) then
         fac_num_0 = fac_num
      else
         fac_num_0 = .false.
      end if

      if( present(boundary_only) ) then
         boundary_only_0 = boundary_only
         if( tri_num_0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "the 'tri_num' argument will have no effect!", &
                               "(only the boundary line is drawn)" )
         end if
      else
         boundary_only_0 = .false.
      end if

      handle = TriMesh_fac( tri_connect, icol,                          &
                            linewidth_0, height_0,                      &
                            tri_num_0, nod_num_0, fac_num_0,            &
                            boundary_only_0 )

#ifdef _MF_FUNC
   end function mfTriMesh_fac_color_str
#endif
#ifdef _MF_SUBR
   end subroutine msTriMesh_fac_color_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriMesh_fac_color_rgb( tri_connect,                       &
                                     color, linewidth, height,          &
                                     tri_num, nod_num, fac_num,         &
                                     boundary_only )                    &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriMesh_fac_color_rgb( tri_connect,                     &
                                       color, linewidth, height,        &
                                       tri_num, nod_num, fac_num,       &
                                       boundary_only )
#endif

      type(mfTriConnect),   intent(in)           :: tri_connect
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, height
      logical,              intent(in), optional :: tri_num, nod_num,   &
                                                    fac_num, boundary_only

      integer :: handle
      !------ API end ------

      integer :: icol
      real(kind=MF_DOUBLE) :: linewidth_0, height_0
      logical :: tri_num_0, nod_num_0, fac_num_0, boundary_only_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriMesh"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriMesh"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( BLACK_ON_WHITE == -1 ) then
         if( CURRENT_WIN_ID == 0 ) then
            call msFigure()
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "cannot plot: no window created!" )
               handle = 0
               return
            end if
         end if
      end if

      ! default values
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(height) ) then
         height_0 = height
      else
         height_0 = 1.0
      end if

      if( present(tri_num) ) then
         tri_num_0 = tri_num
      else
         tri_num_0 = .false.
      end if

      if( present(nod_num) ) then
         nod_num_0 = nod_num
      else
         nod_num_0 = .false.
      end if

      if( present(fac_num) ) then
         fac_num_0 = fac_num
      else
         fac_num_0 = .false.
      end if

      if( present(boundary_only) ) then
         boundary_only_0 = boundary_only
         if( tri_num_0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "the 'tri_num' argument will have no effect!", &
                               "(only the boundary line is drawn)" )
         end if
      else
         boundary_only_0 = .false.
      end if

      handle = TriMesh_fac( tri_connect, icol,                          &
                            linewidth_0, height_0,                      &
                            tri_num_0, nod_num_0, fac_num_0,            &
                            boundary_only_0 )

#ifdef _MF_FUNC
   end function mfTriMesh_fac_color_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msTriMesh_fac_color_rgb
#endif
