!_______________________________________________________________________
!
   subroutine mf_tri_fill_draw( grobj )

      type(grobj_elem), intent(in)   :: grobj
      !------ API end ------

      ! grobj type = "tri_fill"

      type(mf_win_info), pointer :: win

      integer :: i, ntri, k1, k2, k3
      real(kind=MF_DOUBLE) :: fact
      real(kind=MF_DOUBLE) :: x_pg_3(3), y_pg_3(3)
      integer :: color, color_old

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Fill", 0 )
         end if
         call eps_driver( ESCAPE, rbuf, ibuf, "q", 0 ) ! = gsave
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Fill", 0 )
         end if
         call pdf_driver( ESCAPE, rbuf, ibuf, "q", 0 ) ! = gsave
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      fact = (win%colormap_ci_high-win%colormap_ci_low) /               &
             (win%color_axes(2)-win%color_axes(1))
      ntri = grobj%struct%npt
      call pgsfs(1) ! set fill-area style : solid (default)
      gr_pdf_color_intent = 2 ! Fill
      color_old = -1
      do i = 1, ntri
         if( isnan(grobj%struct%abs_tab(i)) ) cycle
         k1 = grobj%struct%val_mat(i,1)
         k2 = grobj%struct%val_mat(i,2)
         k3 = grobj%struct%val_mat(i,3)
         x_pg_3(:) = [ grobj%struct%abs_mat(k1,1),                      &
                       grobj%struct%abs_mat(k2,1),                      &
                       grobj%struct%abs_mat(k3,1) ]
         y_pg_3(:) = [ grobj%struct%abs_mat(k1,2),                      &
                       grobj%struct%abs_mat(k2,2),                      &
                       grobj%struct%abs_mat(k3,2) ]
         color = win%colormap_ci_low +                                  &
                 fact*(grobj%struct%abs_tab(i)-win%color_axes(1))
         if( color /= color_old ) then
            call grsci(color) ! set color index
         end if
         color_old = color
         call pgpoly( 3, x_pg_3, y_pg_3 )
      end do

      if( PRINTING_EPS ) then
         call eps_driver( ESCAPE, rbuf, ibuf, "Q", 0 ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Fill", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         call pdf_driver( ESCAPE, rbuf, ibuf, "Q", 0 ) ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Fill", 0 )
         end if
      end if

   end subroutine mf_tri_fill_draw
