!_______________________________________________________________________
!
   function FillTri( xy_sto_pg, val_sto_pg, tri_sto_pg )                             &
   result( handle )

      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), val_sto_pg(:),   &
                                       tri_sto_pg(:,:)

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: ntri, hdle

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( xy_sto_pg(:,1) )
      range(2) = maxval( xy_sto_pg(:,1) )
      range(3) = minval( xy_sto_pg(:,2) )
      range(4) = maxval( xy_sto_pg(:,2) )
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ntri = size(tri_sto_pg,1)

      call pgbbuf()

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "tri_fill"
      grobj%struct%range = range
      grobj%struct%abs_mat => xy_sto_pg
      grobj%struct%abs_tab => val_sto_pg
      grobj%struct%val_mat => tri_sto_pg
      grobj%struct%npt = ntri

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_tri_fill_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function FillTri
