!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriFill( x, y, val, tri )                                 &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriFill( x, y, val, tri )
#endif

      type(mfArray) :: x, y, val, tri

      integer :: handle
      !------ API end ------

      ! Fill sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       val_ptr(:,:),  tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), val_sto_pg(:), tri_sto_pg(:,:)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriFill"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriFill"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call msInitArgs( x, y, val, tri )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'val' is allocated
      if( mfIsEqual(val,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'val' not allocated!" )
         go to 99
      end if

      ! 'val' must be Real
      if( .not. mfIsReal(val) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'val' must be real!" )
         go to 99
      end if

      ! 'val' cannot be sparse
      if( mfIsSparse(val) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'val' cannot be sparse!" )
         go to 99
      end if

      call msPointer( val, val_ptr, no_crc=.true. )

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'val' is a vector
      if( size(val_ptr,1)/=1 .and. size(val_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'val' must be a vector!" )
         go to 99
      end if

      ! checking that 'x' and 'y' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' and 'y' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'val' and 'tri' have the same nb of rows
      if( size(val,1) /= ntri ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'val' and 'tri' must have the same nb of rows!" )
         go to 99
      end if

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      allocate( xy_sto_pg(nn,2) )

      allocate( val_sto_pg(ntri) )

      allocate( tri_sto_pg(ntri,3) )

      if( p_dim == 1 ) then
         xy_sto_pg(:,1) = x_ptr(:,1)
         xy_sto_pg(:,2) = y_ptr(:,1)
      else
         xy_sto_pg(:,1) = x_ptr(1,:)
         xy_sto_pg(:,2) = y_ptr(1,:)
      end if
      val_sto_pg(:) = val_ptr(:,1)
      tri_sto_pg(:,:) = tri_ptr(:,:)

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( val, val_ptr )
      call msFreePointer( tri, tri_ptr )

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
      end if

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      handle = FillTri( xy_sto_pg, val_sto_pg, tri_sto_pg )

 99   continue

      call msFreeArgs( x, y, val, tri )
      call msAutoRelease( x, y, val, tri )

#ifdef _MF_FUNC
   end function mfTriFill
#endif
#ifdef _MF_SUBR
   end subroutine msTriFill
#endif
