!_______________________________________________________________________
!
   subroutine mf_tri_contour_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "tri_contour"

      integer :: i, k, k_max, n, n_level
      integer :: icolor, icolor_old
      real(kind=MF_DOUBLE) :: lev
      logical :: found

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Contour", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Contour", 0 )
         end if
         gr_pdf_color_intent = 1 ! stroke
      end if

      call grslw( grobj%struct%linewidth ) ! set line width
      call grsls( grobj%struct%linestyle ) ! set line style

      ! All contours have been computed in TriContour_aux.
      n_level = grobj%struct%npt

      ! Contour draw
      k = 0 ! current position
      k_max = size( grobj%struct%abs_mat, 2 )
      icolor_old = -1
      do ! loop over contours

         ! get infos for this contour
         k = k + 1
         if( k > k_max ) exit
         lev = grobj%struct%abs_mat(1,k) ! level value
         n = grobj%struct%abs_mat(2,k) ! nb of points
         if( n == 0 ) cycle

         ! find level number from level value
         found = .false.
         do i = 1, n_level
            if( grobj%struct%lev_tab(i) == lev ) then
               found = .true.
               exit
            end if
         end do
         if( .not. found ) then
            print "(/,A)", "(MUESLI:) FGL: mf_tri_contour_draw: internal error."
            print "(A,ES10.3,A)",   "          -> level ", lev, " not found in stored contours!"
            call msDisplay( .t. mf(grobj%struct%lev_tab), "Levels' array" )
            pause "for debugging purpose only"
            stop
         end if

         icolor = grobj%struct%col_tab(i)
         if( icolor /= icolor_old ) then
            call grsci( icolor ) ! set color index
         end if
         icolor_old = icolor

         call pgline( n, grobj%struct%abs_mat(1,k+1:k+n),               &
                        grobj%struct%abs_mat(2,k+1:k+n) )

         k = k + n

      end do

      if( grobj%struct%bool1 ) then
         call mf_contour_labelling( grobj )
      end if

      call grslw( 1.0d0 ) ! default line width
      call grsls( 1 ) ! default line style

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Contour", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Contour", 0 )
         end if
      end if

   end subroutine mf_tri_contour_draw
