!_______________________________________________________________________
!
   function ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg, n_level,       &
                        draw_labels, lab_color, lab_size,               &
                        icolor, present_color, istyle,                  &
                        linewidth, levels_sto_pg )                                 &
   result( handle )

      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer,              pointer :: tri_sto_pg(:,:)
      integer,                     intent(in) :: n_level
      logical,                     intent(in) :: draw_labels, present_color
      integer,                     intent(in) :: lab_color, icolor, istyle
      real(kind=MF_DOUBLE),        intent(in) :: lab_size, linewidth
      real(kind=MF_DOUBLE), pointer, optional :: levels_sto_pg(:)

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: j, nn, hdle
      real(kind=MF_DOUBLE) :: fact_icol, fact_level, z_lev
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      integer, pointer :: icol_array(:)
      character(len=20) :: string

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      logical :: tri_renumbering, equil_face_orientation,               &
                 check_tri_orientation, tri_modified
      integer, pointer :: face_n(:,:)
      integer, pointer :: face_tri(:,:)
      integer, pointer :: tri_f(:,:)
      integer, pointer :: n_tri(:)
      integer :: nb_disconn_tri

      integer :: n_points, n
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( xy_sto_pg(:,1) )
      range(2) = maxval( xy_sto_pg(:,1) )
      range(3) = minval( xy_sto_pg(:,2) )
      range(4) = maxval( xy_sto_pg(:,2) )

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msTriContour", "W",                  &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; please use the msCAxis routine to set an appropriate interval!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! color setting
      allocate( icol_array(n_level) )

      if( present_color ) then
         icol_array(:) = icolor
      else
         do j = 1, n_level
            if( present(levels_sto_pg) ) then
               z_lev = levels_sto_pg(j)
            else
               z_lev = level_array(j)
            end if
            fact_icol = (z_lev-win%color_axes(1))/(win%color_axes(2)-win%color_axes(1))
            icol_array(j) = win%colormap_ci_low +                       &
                            fact_icol*(win%colormap_ci_high-win%colormap_ci_low)
         end do
      end if

      nn = size(xy_sto_pg,1)

      ! here, only computation of the contours.

      ! on ré-initialise si besoin le stockage des contours
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      ! Connectivity of the triangular mesh.
      ! Only: face_n, face_tri, tri_n and tri_f must be known.

      check_tri_orientation = .true. ! not sure that all triangle are
                                     ! correctly orientated.
      tri_renumbering = .false. ! no need to change the triangle numbering
      equil_face_orientation = .false. ! no need (tag as 'not useful' in the
                                       ! header of the routine)

!!call msFigure(9)
!!call msAxis( "equal" )
!!call msAxis( [ -2.2d0, 2.2d0, -2.2d0, 2.2d0] )
!!call msTriMesh( mf(xy_sto_pg(:,1)), mf(xy_sto_pg(:,2)), &
!!                mf(tri_sto_pg), nod_num=.true. )
!!call msTitle( "tmp fig / opened in TriContour_aux.f90, line 128" )
!!call msPause( "in ContourTri, line 134" )
!!call msFigure(1)
      call build_tri_conn( xy_sto_pg, tri_sto_pg,                       &
                           face_n, face_tri, tri_f, n_tri,              &
                           check_tri_orientation, tri_modified,         &
                           nb_disconn_tri, tri_renumbering,             &
                           equil_face_orientation )

      deallocate( n_tri )

      call pgtricnsc_ec( xy_sto_pg, z_sto_pg, nn,                       &
                         level_array, n_level,                          &
                         face_n, face_tri, tri_sto_pg, tri_f )

      deallocate( face_tri, face_n, tri_f, tri_sto_pg )
      deallocate( xy_sto_pg, z_sto_pg )

      ! on finalise le dernier contour (si besoin)
      if( .not. XY_contour_finalized ) then
         n_points = XY_cont_current_pos - XY_cont_current_beg
         XY_cont(2,XY_cont_current_beg) = n_points
      end if

      if( XY_cont_nb_cont == 0 ) then
         call pgebuf()
         handle = 0
         call PrintMessage( "msTriContour", "W",                        &
                "There is nothing to draw.",                            &
                "No grobj is created, so the returned handle is 0.",    &
                "(therefore, you cannot use it)" )
         return
      end if

      allocate( XXYY_cont(2,XY_cont_current_pos) )
      XXYY_cont(:,:) = XY_cont(:,1:XY_cont_current_pos)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "tri_contour"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XY_cont_nb_cont
      grobj%struct%npt3 = XY_cont_current_pos

      grobj%struct%abs_mat => XXYY_cont

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color
      grobj%struct%height_text = lab_size ! relat. size actually

      grobj%struct%lev_tab => level_array

      grobj%struct%col_tab => icol_array
      grobj%struct%linewidth = linewidth
      grobj%struct%linestyle = istyle

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_tri_contour_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function ContourTri
!_______________________________________________________________________
!
   function ContourTriConnect( n_xy, z_sto_pg, tri_n, face_n, face_tri, &
                               tri_f, draw_labels, lab_color, lab_size, &
                               icolor, present_color, istyle,           &
                               linewidth, n_level, levels_sto_pg )                                 &
   result( handle )

      real(kind=MF_DOUBLE), intent(in) :: n_xy(:,:)
      real(kind=MF_DOUBLE), pointer :: z_sto_pg(:)
      integer,              intent(in) :: tri_n(:,:), face_n(:,:),      &
                                          face_tri(:,:), tri_f(:,:)
      logical,              intent(in) :: draw_labels, present_color
      integer,              intent(in) :: lab_color, icolor, istyle
      real(kind=MF_DOUBLE), intent(in) :: lab_size, linewidth
      integer,              intent(in) :: n_level
      real(kind=MF_DOUBLE), pointer, optional :: levels_sto_pg(:)

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: j, nn, hdle
      real(kind=MF_DOUBLE) :: fact_icol, fact_level, z_lev
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      integer, pointer :: icol_array(:)
      character(len=20) :: string

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      integer :: n_points, n
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( n_xy(:,1) )
      range(2) = maxval( n_xy(:,1) )
      range(3) = minval( n_xy(:,2) )
      range(4) = maxval( n_xy(:,2) )

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msTriContour", "W",                  &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; therefore the corresponding level curve", &
                      "will not be drawn!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! color setting
      allocate( icol_array(n_level) )

      if( present_color ) then
         icol_array(:) = icolor
      else
         do j = 1, n_level
            if( present(levels_sto_pg) ) then
               z_lev = levels_sto_pg(j)
            else
               z_lev = level_array(j)
            end if
            fact_icol = (z_lev-win%color_axes(1))/(win%color_axes(2)-win%color_axes(1))
            icol_array(j) = win%colormap_ci_low +                       &
                            fact_icol*(win%colormap_ci_high-win%colormap_ci_low)
         end do
      end if

      nn = size(n_xy,1)

      ! here, only computation of the contours.

      ! on ré-initialise si besoin le stockage des contours
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      call pgtricnsc_ec( n_xy, z_sto_pg, nn, level_array, n_level,      &
                         face_n, face_tri, tri_n, tri_f )

      deallocate( z_sto_pg )

      ! on finalise le dernier contour (si besoin)
      if( .not. XY_contour_finalized ) then
         n_points = XY_cont_current_pos - XY_cont_current_beg
         XY_cont(2,XY_cont_current_beg) = n_points
      end if

      if( XY_cont_nb_cont == 0 ) then
         call pgebuf()
         handle = 0
         call PrintMessage( "msTriContour", "W",                        &
                "There is nothing to draw.",                            &
                "No grobj is created, so the returned handle is 0.",    &
                "(therefore, you cannot use it)" )
         return
      end if

      allocate( XXYY_cont(2,XY_cont_current_pos) )
      XXYY_cont(:,:) = XY_cont(:,1:XY_cont_current_pos)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "tri_contour"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XY_cont_nb_cont
      grobj%struct%npt3 = XY_cont_current_pos

      grobj%struct%abs_mat => XXYY_cont

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color
      grobj%struct%height_text = lab_size ! relat. size actually

      grobj%struct%lev_tab => level_array

      grobj%struct%col_tab => icol_array
      grobj%struct%linewidth = linewidth
      grobj%struct%linestyle = istyle

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_tri_contour_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function ContourTriConnect
!_______________________________________________________________________
!
   subroutine clean_x_y_z_tri( x, y, z, tri,                            &
                               xy_out, z_out, tri_out, status )

      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:), z(:)
      integer,              intent(in) :: tri(:,:)
      real(kind=MF_DOUBLE), pointer    :: xy_out(:,:), z_out(:)
      integer,              pointer    :: tri_out(:,:)
      integer                          :: status
      !------ API end ------

      ! status is returned equal to 0 if valid triangles remain.
      ! If there is no valid triangles, status is set to -1.

      integer, allocatable :: vec_z(:), vec_tri(:)
      integer :: i, j, k, nn, ntri, nb_not_finite, nb_bad_tri,          &
                 nn_new, ntri_new, n1, n2, n3

   !------ end of declarations -- execution starts hereafter  ------

      status = 0

      nn = size(x)
      ntri = size(tri,1)

      allocate( vec_z(nn) )

      ! Check the 'z' array
      nb_not_finite = 0
      do i = 1, nn
         if( isfinite(z(i)) ) then
            vec_z(i) = i
         else
            vec_z(i) = 0
            nb_not_finite = nb_not_finite + 1
         end if
      end do

      allocate( vec_tri(ntri) )

      ! Check the 'tri' table
      nb_bad_tri = 0
loop_tri: do i = 1, ntri
         do j = 1, 3
            k = tri(i,j)
            if( vec_z(k) == 0 ) then
               vec_tri(i) = 0
               nb_bad_tri = nb_bad_tri + 1
               cycle loop_tri
            end if
         end do
         vec_tri(i) = i
      end do loop_tri

      nn_new   = nn - nb_not_finite
      allocate( xy_out(nn_new,2), z_out(nn_new) )

      k = 0
      do i = 1, nn
         if( vec_z(i) == 0 ) cycle
         k = k + 1
         xy_out(k,:) = [ x(i), y(i) ]
         z_out(k)    = z(i)
      end do
      if( k /= nn_new ) then
         print *, "clean_x_y_z_tri: internal error"
         print *, "  -> k /= nn_new"
         pause "for debugging purpose only..."
         stop
      end if

      ntri_new = ntri - nb_bad_tri
      if( ntri_new == 0 ) then
         status = -1
         deallocate( xy_out, z_out )
         return
      end if
      allocate( tri_out(ntri_new,3) )

      ! Shift values in vec_z to contain the new numbering
      k = 0
      do i = 1, nn
         if( vec_z(i) == 0 ) cycle
         k = k + 1
         vec_z(i) = k
      end do

      k = 0
      do i = 1, ntri
         if( vec_tri(i) == 0 ) cycle
         k = k + 1
         n1 = tri(i,1)
         n2 = tri(i,2)
         n3 = tri(i,3)
         tri_out(k,:) = [ vec_z(n1), vec_z(n2), vec_z(n3) ]
      end do
      if( k /= ntri_new ) then
         print *, "clean_x_y_z_tri: internal error"
         print *, "  -> k /= ntri_new"
         pause "for debugging purpose only..."
         stop
      end if

      deallocate( vec_z, vec_tri )

   end subroutine clean_x_y_z_tri
