!_______________________________________________________________________
!
   subroutine mf_tri_contourF_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "tri_contour_filled"

      integer :: i, j, nbi, k_max, n_level, ipos
      logical :: has_internal_boundaries, local_background

      integer :: ii, jj, ncurves, nl, nb_colors, icol, offset, I_jj,    &
                 i_deb, i_fin
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: r_area, c_axis_min, c_axis_max,           &
                              col_rgb(3), level, new_lev

      real(kind=MF_DOUBLE), pointer :: CS(:,:)
      integer, pointer :: IA(:), Ind(:)
      logical, pointer :: positive_area(:)
      real(kind=MF_DOUBLE), pointer :: intern_bnd_x(:), intern_bnd_y(:)
      integer,              pointer :: intern_bnd_ptr(:,:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Contour_Filled", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Tri_Contour_Filled", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      ! All contours have been computed in TriContourF_aux.
      n_level = grobj%struct%npt

      ! Get effective size
      k_max = grobj%struct%npt2
      CS => grobj%struct%ord_mat ! CS used size is (2,k_max)

      ! Get indices
      IA  => grobj%struct%ir
      Ind => grobj%struct%jc
      positive_area => grobj%struct%bool_vec

      ncurves = size(IA)

      local_background = grobj%struct%bool3

      ! Plot patches in order of decreasing area. This makes sure that
      ! all the levels get drawn, not matter if we are going up a hill or
      ! down into a hole. When going down we shift levels though, you can
      ! tell whether we are going up or down by checking the sign of the
      ! area (since curves are oriented so that the high side is always
      ! the same side). Lowest curve is largest and always encloses higher
      ! data.

      win => mf_win_db(CURRENT_WIN_ID)
      offset = win%colormap_ci_low - 1
      nb_colors = win%colormap_ci_high - offset
      c_axis_min = win%color_axes(1)
      c_axis_max = win%color_axes(2)

      do j = 1, ncurves

         jj = IA(j)
         I_jj = Ind(jj)
         nl = CS(2,I_jj)
         level = CS(1,I_jj)

         ! compute colormap index
         if( positive_area(jj) ) then
            icol = (level-c_axis_min)/(c_axis_max-c_axis_min)*(nb_colors-1) + 1
         else
            ! Color must be down-shifted by 1
            do ipos = 1, n_level
               if( level == grobj%struct%lev_tab(ipos) ) exit
            end do
            if( ipos > 1 ) then
               ! Get previous color
               new_lev = grobj%struct%lev_tab(ipos-1)
               icol = (new_lev-c_axis_min)/(c_axis_max-c_axis_min)*(nb_colors-1) + 1
            else
               ! Set color to white or lowest in the colormap
               ! (depends on the drawing background)
               if( local_background ) then
                  icol = 1
               else
                  icol = 0
               end if
            end if
         end if

         if( icol == 0 ) then
            call grsci( icol ) ! set color index
         else
            call grsci( icol+offset ) ! set color index
         end if

         call pgpoly( nl, CS(1,I_jj+1:I_jj+nl),                         &
                          CS(2,I_jj+1:I_jj+nl) )

      end do

      has_internal_boundaries = grobj%struct%bool2
      if( has_internal_boundaries ) then
         intern_bnd_ptr => grobj%struct%tab_2d_1
         intern_bnd_x   => grobj%struct%tm1_tab
         intern_bnd_y   => grobj%struct%tm2_tab
         call grsci( 0 ) ! set color index to background
         nbi = size(intern_bnd_ptr,1)
         do i = 1, nbi
            i_deb = intern_bnd_ptr(i,1)
            i_fin = intern_bnd_ptr(i,2)
            nl = i_fin - i_deb + 1
            call pgpoly( nl, intern_bnd_x(i_deb:i_fin),                 &
                             intern_bnd_y(i_deb:i_fin) )
         end do
      end if

      call grslw( grobj%struct%linewidth ) ! set line width

      call grsci( 1 ) ! set color index
      do j = 1, ncurves
         jj = Ind(j)
         nl = CS(2,jj)
         call pgline( nl, CS(1,jj+1:jj+nl),                             &
                          CS(2,jj+1:jj+nl) )
      end do

      if( has_internal_boundaries ) then
         do i = 1, nbi
            i_deb = intern_bnd_ptr(i,1)
            i_fin = intern_bnd_ptr(i,2)
            nl = i_fin - i_deb + 2
            call pgline( nl, [intern_bnd_x(i_deb:i_fin),intern_bnd_x(i_deb)], &
                             [intern_bnd_y(i_deb:i_fin),intern_bnd_y(i_deb)] )
         end do
      end if

      if( grobj%struct%bool1 ) then
         call mf_contour_labelling( grobj )
      end if

      call grslw( 1.0d0 ) ! default line width
      call grsls( 1 ) ! default line style

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Contour_Filled", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Tri_Contour_Filled", 0 )
         end if
      end if

   end subroutine mf_tri_contourF_draw
