!_______________________________________________________________________
!
   subroutine ProcessAllContours( tc, z_sto_pg, level_array, n_level,   &
                                  XY, XY_new, XY_pos, z_min, z_max )

      type(mfTriConnect)            :: tc
      real(kind=MF_DOUBLE), pointer :: z_sto_pg(:)
      integer                       :: n_level
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      real(kind=MF_DOUBLE), pointer :: XY(:,:), XY_new(:,:)
      integer                       :: XY_pos
      real(kind=MF_DOUBLE), optional :: z_min, z_max
      !------ API end ------

      integer :: nn, nb_boundaries, n_points, k_level, n_opened_cont,   &
                 n_closed_cont, nb_curves, XY_cn_size
      integer, allocatable :: XY_opened_offset(:), XY_closed_offset(:), &
                              lev_ptr(:)

      integer :: n_ext_boundary, n2, i, ii, j, k, n, shift, i_stack,    &
                 item(2), n_add, nb_total_max, i_cont, i_off, node,     &
                 i_begin, k_max, k1, k2, j1, j2, n_tot
      real(kind=MF_DOUBLE) :: level
      integer, allocatable :: perm(:), sub_perm(:)
      integer, allocatable :: stack(:,:) ! stack for tag elements
      type(mfArray) :: val, ind, tmp
      logical :: bool, found, in_repet

      integer :: j_bnd, i_deb, i_fin, j_deb, j_fin, last_face, itag,    &
                 fac_i, fac_j, i_bnd, nb_EP, nb_node, nb_pts, face,     &
                 i_bnd_begin, i_bnd_new, jj
      real(kind=MF_DOUBLE) :: lambda

      integer, allocatable :: EP_tag(:), EP_bnd(:), EP_lnk(:), EP_fac(:)
      real(kind=MF_DOUBLE), allocatable :: EP_x(:), EP_y(:), EP_lambda(:)
      real(kind=MF_DOUBLE), allocatable :: EP_x_save(:), EP_y_save(:)
      integer, allocatable :: EP_ptr(:,:)

      type :: Boundary_Desc
         ! The following tables (one per boundary) contain the link to know
         ! where first EPs go, where come from the last EPs (-1 for mesh nodes).
         integer, allocatable :: pts_lst(:)
         integer, allocatable :: lnk_bnd(:)
         integer, allocatable :: bnd_pos(:)
      end type

      type(Boundary_Desc), allocatable :: Boundaries(:)

      integer, allocatable :: nb(:) ! nb of points on each boundary (EP + nodes)
      logical, allocatable :: EP_free(:) ! to be sure that all points are treated
      real(kind=MF_DOUBLE) :: xx, yy, x1, y1, x2, y2

   !------ end of declarations -- execution starts hereafter  ------

      nn = size(tc%n_xy,1)

      ! Check the convexity (this is required to know whether the domain
      ! has holes or not...)
      call msCheckDomainConvexity( tc )
      nb_boundaries = size(tc%faces_boundary_ptr,1)

      XY_contour_finalized = .true.

      call pgtricnsc_ec( tc%n_xy, z_sto_pg, nn, level_array, n_level,   &
                         tc%face_n, tc%face_tri, tc%tri_n, tc%tri_f )

      deallocate( z_sto_pg )
      if( XY_cont_nb_cont == 0 ) then
         ! Quick return... mais... cela n'arrive jamais désormais, car
         ! tout level conduit à une courbe (éventuellement sans aucun
         ! point)
         return
      end if

      ! Finalize last contour (if needed)
      if( .not. XY_contour_finalized ) then
         n_points = XY_cont_current_pos - XY_cont_current_beg
         XY_cont(2,XY_cont_current_beg) = n_points
      end if

      allocate( XY(2,XY_cont_current_pos) )
      XY(:,:) = XY_cont(:,1:XY_cont_current_pos)

      ! Compute the pointer to each different level in XY
      allocate( lev_ptr(n_level) )
      call build_lev_ptr( )

      ! XY_new(2,*) is the new multi-array: it will be extended
      ! on demand...
      XY_cn_size = 100
      allocate( XY_new(2,XY_cn_size) )
      XY_pos = 0

      ! Pour la fusion des nœuds de frontière et des EP, dans une
      ! nouvelle structure
      allocate( Boundaries(0:nb_boundaries-1) )

      allocate( nb(0:nb_boundaries-1) )

      do k_level = 1, n_level ! loop over levels

         ! Get the number of opened contours for this level
         n_opened_cont = opened_cont_nb( )

         ! Get the number of closed contours
         n_closed_cont = closed_cont_nb( )

         if( n_opened_cont > 0 ) then ! opened contours exist

            ! Compute the offsets of opened and closed contours
            if( allocated(XY_opened_offset) ) then
               deallocate( XY_opened_offset, XY_closed_offset )
            end if
            allocate( XY_opened_offset(n_opened_cont),                  &
                      XY_closed_offset(n_closed_cont) )
            call set_cont_offset( )

            nb_curves = n_opened_cont
            allocate( EP_tag(2*nb_curves), EP_bnd(2*nb_curves),         &
                      EP_x(2*nb_curves), EP_y(2*nb_curves),             &
                      EP_lambda(2*nb_curves), EP_fac(2*nb_curves) )

            ! Get just the end-points of each opened contour and copy their
            ! coordinates in EP_x(:) and EP_y(:) arrays.
            call fill_EP_xy( )

            do k = 1, nb_curves
               i = 2*k - 1
               EP_tag(i) = +k
               call find_EP_in_bnd( EP_x(i), EP_y(i), EP_bnd(i),        &
                                    EP_fac(i), EP_lambda(i) )
               i = 2*k
               EP_tag(i) = -k
               call find_EP_in_bnd( EP_x(i), EP_y(i), EP_bnd(i),        &
                                    EP_fac(i), EP_lambda(i) )
            end do

            EP_bnd = EP_bnd - 1 ! boundary numbering begins at 0

            allocate( EP_x_save(2*nb_curves), EP_y_save(2*nb_curves) )
            ! coordinates are required to test if some EP or nodes are colinear.
            EP_x_save = EP_x; EP_y_save = EP_y

            ! Maintenant que les lambda sont calculés, on a plus besoin des
            ! coordonnées (x,y) des points.
            deallocate( EP_x, EP_y )

            ! On trie enfin le tableau EP_bnd(:) de manière que les EP
            ! soient regroupés par numéro de frontière (0, 1, 2, ...).
            call msSort( mfOut(val,ind), mf(EP_bnd) )
            allocate( perm(2*nb_curves) )
            perm = ind

            ! Apply permutation to all EP arrays...
            EP_tag(:) = EP_tag(perm)
            EP_bnd(:) = EP_bnd(perm)
            EP_fac(:) = EP_fac(perm)
            EP_lambda(:) = EP_lambda(perm)
            deallocate( perm )

            ! Determine ptr to know the sublists of each boundary
            allocate( EP_ptr(0:nb_boundaries-1,2) )
            EP_ptr = 0

            i = 1
            k = EP_bnd(i)
            EP_ptr(k,1) = 1
            do i = 2, 2*nb_curves
               if( EP_bnd(i) > k ) then
                  EP_ptr(k,2) = i - 1
                  k = EP_bnd(i)
                  EP_ptr(k,1) = i
               end if
            end do
            EP_ptr(k,2) = 2*nb_curves

            ! Ici, on n'a plus besoin de EP_bnd
            deallocate( EP_bnd )

            ! On fait un sous-tri par ordre d'apparition des faces
            do k = 1, nb_boundaries
               i_deb = tc%faces_boundary_ptr(k,1)
               i_fin = tc%faces_boundary_ptr(k,2)
               j_deb = EP_ptr(k-1,1)
               if( j_deb == 0 ) then
                  ! there are no EPs in this boundary
                  cycle
               end if
               j_fin = EP_ptr(k-1,2)
               call sub_sort_dble_list( tc%faces_boundary, i_deb, i_fin,         &
                                       EP_fac, j_deb, j_fin, perm )
               ! Apply the internal change
               EP_tag(j_deb:j_fin) = EP_tag(perm)
               EP_fac(j_deb:j_fin) = EP_fac(perm)
               EP_lambda(j_deb:j_fin) = EP_lambda(perm)
               deallocate( perm )
            end do

            ! Last check: fix of the position when many EPs share the
            ! same face.
            ! -> we have to sort the arrays according EP_lambda (no need
            !    to process each boundary separately).
            i_deb = 1
            last_face = EP_fac(1)
            in_repet = .false.
            do i = 2, 2*nb_curves
               if( EP_fac(i) == last_face ) then
                  in_repet = .true.
               else
                  if( in_repet ) then
                     i_fin = i - 1
                     ! must process the interval: i_deb -> i_fin,
                     ! i.e. sort the EP_lambda values in this interval
                     call msSort( mfOut(val,ind), mf(EP_lambda(i_deb:i_fin)) )
                     n = i_fin-i_deb+1
                     allocate( sub_perm(n) )
                     sub_perm = ind
                     ! make it using global indices
                     sub_perm = sub_perm + (i_deb-1)
                     ! Applying a partial permutation only if it is not
                     ! identity
                     if( any( sub_perm /= [(i,i=1,n)]+(i_deb-1) ) ) then
                        EP_tag(i_deb:i_fin) = EP_tag(sub_perm)
                        EP_fac(i_deb:i_fin) = EP_fac(sub_perm)
                        EP_lambda(i_deb:i_fin) = EP_lambda(sub_perm)
                     end if
                     deallocate( sub_perm )
                     in_repet = .false.
                  end if
                  i_deb = i
               end if
               last_face = EP_fac(i)
            end do

            ! Ici, on n'a plus besoin des lambda
            deallocate( EP_lambda )

            ! En revanche, il faut définir EP_lnk : pour chaque EP, on
            ! cherche sur quelle frontière est l'autre extrémité du contour.
            allocate( EP_lnk(2*nb_curves) )
            do i = 1, 2*nb_curves
               itag = EP_tag(i)
               ! searching for -itag in the whole EP_tag array
               found = .false.
               do j = 1, 2*nb_curves
                  if( EP_tag(j) == -itag ) then
                     found = .true.
                     exit
                  end if
               end do
               if( .not. found ) then
                  print *, "TriContourF_aux: internal error"
                  print *, "         -> tag ", -itag, " not found in EP_tag array!"
                  pause "for debugging purpose only..."
                  stop
               end if
               ! Convert position 'j' in boundary numbering
               do k = 0, nb_boundaries-1
                  if( EP_ptr(k,1) <= j .and. j <= EP_ptr(k,2) ) then
                     EP_lnk(i) = k
                     exit
                  end if
               end do
            end do

            do i_bnd = 0, nb_boundaries-1

               if( EP_ptr(i_bnd,1) == 0 ) then
                  nb_EP = 0
               else
                  nb_EP = EP_ptr(i_bnd,2) - EP_ptr(i_bnd,1) + 1
               end if
               nb_pts = nb_EP
               ! ajout des nœuds du maillage
               nb_node = tc%faces_boundary_ptr(i_bnd+1,2)                        &
                     - tc%faces_boundary_ptr(i_bnd+1,1) + 1
               if( nb_EP == 0 ) then
                  ! economy mode: no EP in this boundary, therefore
                  ! no need to store boundary nodes!
                  nb_pts = 0
               else
                  nb_pts = nb_EP + nb_node
               end if

               allocate( Boundaries(i_bnd)%pts_lst(nb_pts) )
               allocate( Boundaries(i_bnd)%lnk_bnd(nb_pts) )
               allocate( Boundaries(i_bnd)%bnd_pos(nb_pts) )
               if( nb_pts == 0 ) cycle
               Boundaries(i_bnd)%bnd_pos = 0

               ! Pour le remplissage, on parcourt donc les deux listes
               ! (nodes et EP) et on insère ces points à leur place
               ! définitive :
               !   concernant les faces du maillage, on insère toujours
               !   le 1er nœud -> on donne priorité au nœud du maillage

               i_deb = tc%faces_boundary_ptr(i_bnd+1,1)
               i_fin = tc%faces_boundary_ptr(i_bnd+1,2)
               j_deb = EP_ptr(i_bnd,1)
               j_fin = EP_ptr(i_bnd,2)

               j = j_deb
               k = 0
               do i = i_fin, i_deb, -1
                  fac_i = tc%faces_boundary(i)
                  ! insertion inconditionnelle de ce nœud
                  k = k + 1
                  Boundaries(i_bnd)%pts_lst(k) = tc%face_n(fac_i,1)
                  Boundaries(i_bnd)%lnk_bnd(k) = -1 ! ordinary node
                  ! test d'insertion d'un ou plusieurs EP
                  if( j_deb /= 0 ) then
                     ! no EP in this boundary
                     if( j <= j_fin ) then
                        do
                           fac_j = EP_fac(j)
                           if( fac_j == fac_i ) then
                              k = k + 1
                              Boundaries(i_bnd)%pts_lst(k) = EP_tag(j)
                              Boundaries(i_bnd)%lnk_bnd(k) = EP_lnk(j)
                              j = j + 1
                              if( j > j_fin ) exit
                           else
                              exit
                           end if
                        end do
                     end if
                  end if
               end do

            end do

            deallocate( EP_tag, EP_fac, EP_lnk, EP_ptr )

            ! Il reste enfin le remplissage des tables bnd_pos
            do i_bnd = 0, nb_boundaries-1

               nb_pts = size(Boundaries(i_bnd)%pts_lst)
               do i = 1, nb_pts
                  j_bnd = Boundaries(i_bnd)%lnk_bnd(i)
                  if( j_bnd /= -1 ) then
                     itag = Boundaries(i_bnd)%pts_lst(i)
                     ! search the exact position of the other end of this EP
                     n = size(Boundaries(j_bnd)%pts_lst)
                     do j = 1, n
                        if( Boundaries(j_bnd)%pts_lst(j) == -itag ) then
                           if( Boundaries(j_bnd)%lnk_bnd(j) /= -1 ) then
                              Boundaries(i_bnd)%bnd_pos(i) = j
                              exit
                           end if
                        end if
                     end do
                  end if
               end do

            end do

            ! Process the points (both EPs and nodes) along the boundary.
            ! The exterior boundary is travelled in anticlockwise direction;
            ! it's first point found must be always a negative end-point
            ! (i.e. the end of a contour). Intern boundaries are travelled
            ! in clockwise direction.

            do i_bnd = 0, nb_boundaries-1
               nb(i_bnd) = size(Boundaries(i_bnd)%pts_lst)
            end do

            allocate( EP_free(nb_curves) )
            EP_free(:) = .true.

            ! Estimation of the stack size: it should be large enough to
            ! contains all EPs and the minimum number of boundary nodes
            ! to represent the shape of the boundary.
            n = 2*nb_curves + size(tc%faces_boundary)
            allocate( stack(3,n) )

            do while( any(EP_free) )

               ! Find a free negative EP
 loop:         do i_bnd = 0, nb_boundaries-1
                  do i = 1, size(Boundaries(i_bnd)%pts_lst)
                     j = Boundaries(i_bnd)%pts_lst(i)
                     if( j < 0 ) then
                        if( EP_free(-j) ) then
                           exit loop
                        end if
                     end if
                  end do
               end do loop
               i_bnd_begin = i_bnd
               i_begin = i

               ! Examine now all elements in the pts_lst(:) arrays, pushing
               ! them onto a stack:
               !   - a negative EP is simply pushed on the stack.
               !   - a node is pushed on the stack only if the point currently
               !     at the top of the stack is negative, or is another node
               !     (the stack cannot be empty). A pushed node may overwrite
               !     the previous node at the top of the stack if these two
               !     nodes are colinear with the previous element in the stack
               !     (see the test below), because it brings no additional
               !     information about the shape of the boundary.
               !   - a positive EP is pushed on the stack. Immediately after
               !     that, check the corresponding negative EP: if it is used
               !     (i.e. on the stack) then the contour is closed and we can
               !     remove it (the stack becomes empty); if it is not used,
               !     go to the negative EP (perhaps located on a different
               !     boundary) and push it on the stack.

               ! 'i_bnd' is the boundary index. Let's begin by the boundary
               ! which contains  the first negative EP.
               i_bnd = i_bnd_begin

               ! 'i' is the node index (on any boundary).
               i = i_begin ! 1

               ! 'i_stack' is the current depth of the stack
               i_stack = 0

               do

                  ! Processing point 'i' in boundary 'i_bnd'...

                  if( is_negative_EP(i_bnd,i) ) then
                     itag = Boundaries(i_bnd)%pts_lst(i)
                     EP_free(-itag) = .false.
                     call push_in_stack(i_bnd,i,i_stack)
                  else if( is_positive_EP(i_bnd,i) ) then
                     if( i_stack >= 2 ) then
                        if( SP_is_node(stack(:,i_stack)) ) then
                           ! Colinear test.
                           if( is_new_point_colinear( EP_x_save, EP_y_save, &
                                                      i_bnd,i,i_stack) ) then
                              i_stack = i_stack - 1
                           end if
                        end if
                     end if
                     call push_in_stack(i_bnd,i,i_stack)
                     ! If the corresponding negative EP is at the bottom of
                     ! the stack, then remove this closed contour.
                     if( neg_EP_at_bottom(i_stack,i_bnd,i) ) then
                        XY_pos = XY_pos + 1
                        i_begin = XY_pos ! save location for [level,n]
                        n = 0 ! nb of points stored so far...
                        ! Process other items to be removed
                        ! (ignore bottom of stack, which is the corresponding
                        !  EP of the top)
                        do j = 1, i_stack-1
                           if( SP_is_node(stack(:,j)) ) then
                              node = stack(1,j)
                              if( XY_pos + 1 > XY_cn_size ) then
                                 call extend_tab2d_r8( XY_new, XY_cn_size, XY_pos + 1 )
                              end if
                              XY_new(:,XY_pos+1) = tc%n_xy(node,:)
                              XY_pos = XY_pos + 1
                              n = n + 1
                           else if( SP_is_negative_EP(stack(:,j)) ) then
                              i_cont = -stack(1,j)
                              ! Put all its nodes into the general array
                              i_off = XY_opened_offset(i_cont)
                              level = XY(1,i_off)
                              n2    = XY(2,i_off)
                              j1 = XY_pos + 1
                              j2 = XY_pos + n2
                              if( j2 > XY_cn_size ) then
                                 call extend_tab2d_r8( XY_new, XY_cn_size, j2 )
                              end if
                              XY_new(:,j1:j2) = XY(:,i_off+1:i_off+n2)
                              XY_pos = XY_pos + n2
                              n = n + n2
                           end if
                        end do
                        ! Closing and finalize the new contour
                        XY_pos = XY_pos + 1
                        if( XY_pos > XY_cn_size ) then
                           call extend_tab2d_r8( XY_new, XY_cn_size, XY_pos )
                        end if
                        XY_new(:,XY_pos) = XY_new(:,i_begin+1)
                        n = n + 1
                        XY_new(1,i_begin) = level
                        XY_new(2,i_begin) = n
                        i_stack = 0
                        exit
                     else
                        ! unconditional jump
                        i_bnd_new = Boundaries(i_bnd)%lnk_bnd(i)
                        i         = Boundaries(i_bnd)%bnd_pos(i)
                        i_bnd = i_bnd_new
                        cycle
                     end if
                  else ! node
                     if( i_stack >= 1 ) then
                        if( SP_is_negative_EP(stack(:,i_stack)) ) then
                           call push_in_stack(i_bnd,i,i_stack)
                        else if( SP_is_node(stack(:,i_stack)) ) then
                           if( i_stack >= 2 ) then
                              ! Colinear test.
                              if( is_new_point_colinear( EP_x_save, EP_y_save, &
                                                         i_bnd,i,i_stack) ) then
                                 i_stack = i_stack - 1
                              end if
                           end if
                           call push_in_stack(i_bnd,i,i_stack)
                        end if
                     end if
                  end if

                  call incr_pos(i_bnd,i)

               end do

            end do

            deallocate( EP_free )
            deallocate( EP_x_save, EP_y_save )
            do i_bnd = 0, nb_boundaries-1
               deallocate( Boundaries(i_bnd)%pts_lst )
               deallocate( Boundaries(i_bnd)%lnk_bnd )
               deallocate( Boundaries(i_bnd)%bnd_pos )
            end do
            deallocate( stack )

            ! Lastly, we have to include other contours already closed
            do i = 1, n_closed_cont
               ! Get offset
               i_off = XY_closed_offset(i)
               n     = XY(2,i_off)
               XY_pos = XY_pos + 1
               if( XY_pos > XY_cn_size ) then
                  call extend_tab2d_r8( XY_new, XY_cn_size, XY_pos )
               end if
               XY_new(:,XY_pos) = XY(:,i_off)
               j1 = XY_pos + 1
               j2 = XY_pos + n
               if( j2 > XY_cn_size ) then
                  call extend_tab2d_r8( XY_new, XY_cn_size, j2 )
               end if
               XY_new(:,j1:j2) = XY(:,i_off+1:i_off+n)
               XY_pos = XY_pos + n
            end do

         else ! no opened contour

            if( n_closed_cont > 0 ) then

               ! For this level, all contour are closed. Just copy them.
               k1 = lev_ptr(k_level)
               if( k_level == n_level ) then
                  k2 = XY_cont_current_pos
               else
                  k2 = lev_ptr(k_level+1) - 1
               end if
               ! We have to copy (k2-k1+1) elements... check that there is
               ! sufficient room for that.
               n = (k2-k1+1)
               j1 = XY_pos + 1
               j2 = XY_pos + n
               if( j2 > XY_cn_size ) then
                  call extend_tab2d_r8( XY_new, XY_cn_size, j2 )
               end if
               XY_new(:,j1:j2) = XY(:,k1:k2)
               XY_pos = XY_pos + n

            else

               ! No contour at all.
               ! We have to know if level is too low or too high.
               if( present(z_min) ) then
                  level = level_array(k_level)
                  if( level <= z_min ) then
                     ! Here we fill XY_new with points from the
                     ! exterior boundary only.
                     j_deb = tc%faces_boundary_ptr(1,1)
                     j_fin = tc%faces_boundary_ptr(1,2)
                     n = j_fin - j_deb + 1
                     XY_pos = XY_pos + 1
                     XY_new(1,XY_pos) = level
                     j1 = XY_pos + 1
                     j2 = XY_pos + n
                     if( j2 > XY_cn_size ) then
                        call extend_tab2d_r8( XY_new, XY_cn_size, j2 )
                     end if
                     ! Retrieve the (x,y) of the corresponding nodes
                     ! (but avoid points which are colinear)
                     jj = j1
                     do j = j_deb, j_fin
                        face = tc%faces_boundary(j)
                        node = tc%face_n(face,1)
                        if( j >= j_deb + 2 ) then
                           xx = tc%n_xy(node,1)
                           yy = tc%n_xy(node,2)
                           x1 = XY_new(1,jj-1)
                           y1 = XY_new(2,jj-1)
                           x2 = XY_new(1,jj-2)
                           y2 = XY_new(2,jj-2)
                           if( points_are_colinear(xx,yy,x1,y1,x2,y2) ) then
                              XY_new(:,jj-1) = [ xx, yy ]
                              n = n - 1
                           else
                              XY_new(:,jj) = [ xx, yy ]
                              jj = jj + 1
                           end if
                        else
                           XY_new(:,jj) = [ tc%n_xy(node,1), tc%n_xy(node,2) ]
                           jj = jj + 1
                        end if
                     end do
                     XY_new(2,XY_pos) = n
                     XY_pos = XY_pos + n
                  end if
               end if

            end if

         end if

      end do ! loop over levels

      call msRelease( val, ind )

   contains
      !_________________________________________________________________
      !
      subroutine build_lev_ptr( )

         integer :: i, k, n, k_max
         real(kind=MF_DOUBLE) :: level

         k_max = size(XY,2)

         k = 1
         do i = 1, n_level
            level = level_array(i)
            lev_ptr(i) = k
            do
               n = XY(2,k)
               k = k + 1 + n
               if( k > k_max ) return
               if( XY(1,k) /= level ) exit
            end do
         end do

      end subroutine build_lev_ptr
      !_________________________________________________________________
      !
      function opened_cont_nb( ) result( nb )

         integer :: nb
         !------ API end ------

         integer :: k, k_max, n

         nb = 0 ! no opened contour detected yet

         k = lev_ptr(k_level)
         if( k_level == n_level ) then
            k_max = XY_cont_current_pos
         else
            k_max = lev_ptr(k_level+1) - 1
         end if
         do ! Loop over contours

            ! Get infos for this contour
            if( k > k_max ) exit
            n = XY(2,k) ! nb of points
            if( n /= 0 ) then
               ! Check for an opened contour
               if( XY(1,k+1) /= XY(1,k+n) .or.               &
                  XY(2,k+1) /= XY(2,k+n) ) then
                  nb = nb + 1
               end if
            end if

            k = k + n + 1

         end do

      end function opened_cont_nb
      !_________________________________________________________________
      !
      function closed_cont_nb( ) result( nb )

         integer :: nb
         !------ API end ------

         integer :: k, k_max, n

         nb = 0 ! no closed contour detected yet

         k = lev_ptr(k_level)
         if( k_level == n_level ) then
            k_max = XY_cont_current_pos
         else
            k_max = lev_ptr(k_level+1) - 1
         end if
         do ! Loop over contours

            ! Get infos for this contour
            if( k > k_max ) exit
            n = XY(2,k) ! nb of points
            if( n /= 0 ) then
               ! Check for an closed contour
               if( XY(1,k+1) == XY(1,k+n) .and.              &
                  XY(2,k+1) == XY(2,k+n) ) then
                  nb = nb + 1
               end if
            end if

            k = k + n + 1

         end do

      end function closed_cont_nb
      !_________________________________________________________________
      !
      subroutine set_cont_offset( )

         integer :: nb1, nb2
         integer :: k, k_max, n

         nb1 = 0 ! current opened contour
         nb2 = 0 ! current closed contour

         k = lev_ptr(k_level)
         if( k_level == n_level ) then
            k_max = XY_cont_current_pos
         else
            k_max = lev_ptr(k_level+1) - 1
         end if
         do ! Loop over contours

            ! Get infos for this contour
            if( k > k_max ) exit
            n = XY(2,k) ! nb of points
            if( n == 0 ) cycle

            ! Check for the contour status: opened or closed...
            if( XY(1,k+1) /= XY(1,k+n) .or.               &
               XY(2,k+1) /= XY(2,k+n) ) then
               nb1 = nb1 + 1
               XY_opened_offset(nb1) = k
            else
               nb2 = nb2 + 1
               XY_closed_offset(nb2) = k
            end if

            k = k + n + 1

         end do

      end subroutine set_cont_offset
      !_________________________________________________________________
      !
      subroutine fill_EP_xy( )

         integer :: nb
         integer :: i, k, k_max, n
         real(kind=MF_DOUBLE) ::x_beg, y_beg, x_end, y_end

         nb = 0 ! current opened contour

         k = lev_ptr(k_level)
         if( k_level == n_level ) then
            k_max = XY_cont_current_pos
         else
            k_max = lev_ptr(k_level+1) - 1
         end if
         do ! Loop over contours

            ! Get infos for this contour
            if( k > k_max ) exit
            n = XY(2,k) ! nb of points
            if( n == 0 ) cycle

            ! Check for an opened contour
            x_beg = XY(1,k+1)
            y_beg = XY(2,k+1)
            x_end = XY(1,k+n)
            y_end = XY(2,k+n)
            if( x_beg /= x_end .or. y_beg /= y_end ) then
               nb = nb + 1
               i = 2*nb - 1
               EP_x(i) = x_beg
               EP_y(i) = y_beg
               i = 2*nb
               EP_x(i) = x_end
               EP_y(i) = y_end
            end if

            k = k + n + 1

         end do

      end subroutine fill_EP_xy
      !_________________________________________________________________
      !
      subroutine find_EP_in_bnd( x, y, bnd, face, lambda )

         real(kind=MF_DOUBLE),   intent(in)  :: x, y
         integer,            intent(out) :: bnd, face
         real(kind=MF_DOUBLE),   intent(out) :: lambda
         !------ API end ------

         ! For a given EP (x,y), find:
         !        bnd: the boundary it belongs (number >= 1)
         !       face: the face number
         !     lambda: the internal normalized position inside the face found
         ! Note: lambda is correctly oriented, i.e. clockwise for the
         !       exterior boundary, and counter-clockwise for the internal
         !       ones.

         integer :: n_bnd, j, j1, j2, n1, n2
         real(kind=MF_DOUBLE) :: x1, y1, x2, y2
         real(kind=MF_DOUBLE) :: u1, v1, u2, v2
         real(kind=MF_DOUBLE) :: dx, dy, area_ref, cross_product

         !-----------------------------------------------------------------

         n_bnd = size( tc%faces_boundary_ptr, 1 )
         do bnd = 1, n_bnd ! loop over boundaries

            ! start- and end-indices for searching
            j1 = tc%faces_boundary_ptr(bnd,1)
            j2 = tc%faces_boundary_ptr(bnd,2)

            do j = j1, j2 ! loop over the faces of boundary bnd
               face = tc%faces_boundary(j)

               ! Get coordinates of the two nodes
               n1 = tc%face_n(face,1)
               x1 = tc%n_xy(n1,1)
               y1 = tc%n_xy(n1,2)
               n2 = tc%face_n(face,2)
               x2 = tc%n_xy(n2,1)
               y2 = tc%n_xy(n2,2)

               ! Check if (x,y) is aligned with (x1,y1)-(x2,y2)
               dx = x2 - x1
               dy = y2 - y1
               area_ref = dx**2 + dy**2
               u1 = x - x1
               v1 = y - y1

               if( abs(dx) >= abs(dy) ) then
                  lambda = u1/dx
               else ! |dx| < |dy|
                  lambda = v1/dy
               end if

               ! First quick return
               if( lambda < -0.01d0 ) cycle
               if( lambda > +1.01d0 ) cycle

               ! Other quick return
               if( u1**2+v1**2 > 1.01d0*area_ref ) cycle

               u2 = x - x2
               v2 = y - y2
               cross_product = abs(u1*v2 - u2*v1)

! The test fails for this face (use area=1.0d-4 in fgl_test) when we
! enlarge EPS only with a factor equal to 100.
!!if( face == 257914 ) then
!!if( face == 6872 ) then
!!   print *, "YES, face 6872 found!"
!!   print *, "  cross_product/area_ref = ", cross_product/area_ref
!!end if
! Using a factor equal to 1e3, the previous test is ok down to area=1.0d-6 !
               ! The computation of the cross product is known to be
               ! numerically unstable ! Instead to use accurate (and
               ! expensive) formula, I prefer to enlarge the
               ! comparison...
               if( cross_product/area_ref < 1.0d3*MF_EPS ) then
                  if( 0.0d0 <= lambda .and. lambda <= 1.0d0 ) then
                     return
                  end if
               end if

            end do

         end do

         print "(/,A)", "[FGL] msTriContourF: internal error."
         print "(3X,A,2(ES10.3,2X))", "find_EP_in_bnd: ERROR: EP (x,y) = ", x, y
         print "(3X,A))", "cannot be located in boundary faces."
         pause "for debugging purpose only..."
         stop
!### TODO: Instead of stopping the program (bad choice!), it would be
!          preferable to compute again using the following stable test:
! cf.  https://math.stackexchange.com/questions/1143354/numerically-stable-method-for-angle-between-3d-vectors

      end subroutine find_EP_in_bnd
      !_________________________________________________________________
      !
      subroutine sub_sort_dble_list( list_1, i1_deb, i1_fin,            &
                                     list_2, i2_deb, i2_fin, perm )
         integer, intent(in) :: list_1(:), i1_deb, i1_fin
         integer, intent(in) :: list_2(:), i2_deb, i2_fin
         integer, allocatable :: perm(:)
         !------ API end ------

         ! Sort elements in list_2(i2_deb,i2_fin) according to the order
         ! of the elements in list_1(i1_deb,i1_fin).
         !
         ! Requirement: all elements in list_2(i2_deb,i2_fin) must belong
         ! to list_1(i1_deb,i1_fin).
         !
         ! list_2 is not modified; instead a list of indices is provided in
         ! the 'perm' array. (Though it is named 'perm', it is not a true
         ! permutation!)

         integer :: i1, i2, elem, ind

         !------------------------------------

         if( allocated(perm) ) then
            deallocate( perm )
         end if
         allocate( perm(i2_fin-i2_deb+1) )

         ind = 0 ! perm index
         do i1 = i1_fin, i1_deb, -1 ! all lists are travelled in reverse order
            elem = list_1(i1)
            ! find all occurences of elem in list_2
            do i2 = i2_deb, i2_fin ! travel list_2
               if( list_2(i2) == elem ) then
                  ind = ind + 1
                  if( ind > size(perm) ) then
                     print *, "sub_sort_dble_list: ERROR: index 'ind' out-of-range!"
                     pause "for debugging purpose only..."
                     stop
                  end if
                  perm(ind) = i2
               end if
            end do
         end do

         if( ind < size(perm) ) then
            print *, "sub_sort_dble_list: ERROR: perm is not entirely filled!"
            pause "for debugging purpose only..."
            stop
         end if

      end subroutine sub_sort_dble_list
      !_________________________________________________________________
      !
      function SP_is_node( item ) result( bool )

         integer, intent(in) :: item(3)
         logical             :: bool
         !------ API end ------

         if( item(2) == -1 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function SP_is_node
      !_________________________________________________________________
      !
      function is_positive_EP( i_bnd, i ) result( bool )

         integer, intent(in) :: i_bnd, i
         logical             :: bool
         !------ API end ------

         if( Boundaries(i_bnd)%pts_lst(i) > 0 .and.                     &
            Boundaries(i_bnd)%lnk_bnd(i) /= -1 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function is_positive_EP
      !_________________________________________________________________
      !
      function is_negative_EP( i_bnd, i ) result( bool )

         integer, intent(in) :: i_bnd, i
         logical             :: bool
         !------ API end ------

         if( Boundaries(i_bnd)%pts_lst(i) < 0 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function is_negative_EP
      !_________________________________________________________________
      !
      function is_new_point_colinear( EP_x_save, EP_y_save,             &
                                      i_bnd, i, i_stack )               &
      result( bool )

         real(kind=MF_DOUBLE), intent(in) :: EP_x_save(:), EP_y_save(:)
         integer,              intent(in) :: i_bnd, i, i_stack
         logical                          :: bool
         !------ API end ------

         integer :: j, node, node_1, node_2
         real(kind=MF_DOUBLE) :: xx, yy, xx1, yy1, xx2, yy2

         ! Check if the new point (i_bnd,i) -- either an EP or a node --
         ! is colinear to the previous stack points i_stack and i_stack-1.
         !   * i_stack must be a node
         !   * i_stack-1 may be a node or an EP

         ! Set the coordinates of the three points
         node = Boundaries(i_bnd)%pts_lst(i)
         if( Boundaries(i_bnd)%lnk_bnd(i) == -1 ) then
            ! this is a node
            xx = tc%n_xy(node,1)
            yy = tc%n_xy(node,2)
         else
            ! this is an EP (always positive, never negative)
            if( node < 0 ) then
               print *, "ERROR: is_new_point_colinear:"
               print *, "       -> (i_bnd,i) is a negative EP! impossible!"
               pause "for debugging purpose only..."
               stop
            end if
            j = 2*node - 1
            xx = EP_x_save(j)
            yy = EP_y_save(j)
         end if

         node_1 = stack(1,i_stack)
         if( SP_is_node(stack(:,i_stack)) ) then
            xx1 = tc%n_xy(node_1,1)
            yy1 = tc%n_xy(node_1,2)
         else
            print *, "ERROR: is_new_point_colinear:"
            print *, "       -> i_stack must be a node, not an EP!"
            pause "for debugging purpose only..."
            stop
         end if

         node_2 = stack(1,i_stack-1)
         if( SP_is_node(stack(:,i_stack-1)) ) then
            xx2 = tc%n_xy(node_2,1)
            yy2 = tc%n_xy(node_2,2)
         else
            ! this is an EP (always negative, never positive)
            if( node_2 > 0 ) then
               print *, "ERROR: is_new_point_colinear:"
               print *, "       -> i_stack-1 is a positive EP! impossible!"
               pause "for debugging purpose only..."
               stop
            end if
            j = -2*node_2
            xx2 = EP_x_save(j)
            yy2 = EP_y_save(j)
         end if

         bool = points_are_colinear( xx, yy, xx1, yy1, xx2, yy2 )

      end function is_new_point_colinear
      !_________________________________________________________________
      !
      function SP_is_positive_EP( item ) result( bool )

         integer, intent(in) :: item(3)
         logical             :: bool
         !------ API end ------

         if( item(1) > 0 .and. item(2) /= -1 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function SP_is_positive_EP
      !_________________________________________________________________
      !
      function SP_is_negative_EP( item ) result( bool )

         integer, intent(in) :: item(3)
         logical             :: bool
         !------ API end ------

         if( item(1) < 0 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function SP_is_negative_EP
      !_________________________________________________________________
      !
      subroutine push_in_stack( i_bnd, i, i_stack )

         integer, intent(in)     :: i_bnd, i
         integer, intent(in out) :: i_stack
         !------ API end ------

         i_stack = i_stack + 1
         if( i_stack > size(stack,dim=2) ) then
            print "(/,A)", "TriContourF_aux: push ERROR"
            print *, "     -> stack size is too small! Please increase its size!"
            pause "for debugging purpose only..."
            stop
         end if
         stack(1,i_stack) = Boundaries(i_bnd)%pts_lst(i)
         stack(2,i_stack) = Boundaries(i_bnd)%lnk_bnd(i)
         stack(3,i_stack) = Boundaries(i_bnd)%bnd_pos(i)

      end subroutine push_in_stack
      !_________________________________________________________________
      !
      function neg_EP_at_bottom( i_stack, i_bnd, i ) result( bool )

         integer, intent(in) :: i_stack, i_bnd, i
         logical             :: bool
         !------ API end ------

         integer :: itag

         ! First determine what is the attribute of the neg EP
         itag = -Boundaries(i_bnd)%pts_lst(i)

         if( stack(1,1) == itag .and. stack(2,1) /= -1 ) then
            bool = .true.
         else
            bool = .false.
         end if

      end function neg_EP_at_bottom
      !_________________________________________________________________
      !
      subroutine incr_pos( boundary, position )

         integer, intent(in)     :: boundary
         integer, intent(in out) :: position
         !------ API end ------

         if( position+1 <= nb(boundary) ) then
            position = position + 1
         else
            position = 1
         end if

      end subroutine incr_pos
      !_________________________________________________________________
      !
      subroutine extend_tab2d_r8( XY_new, XY_cn_size, at_least )

         real(kind=MF_DOUBLE), pointer :: XY_new(:,:)
         integer, intent(in out) :: XY_cn_size
         integer, intent(in), optional :: at_least
         !------ API end ------

         integer :: new_size
         real(kind=MF_DOUBLE), pointer :: tmp(:,:)

         new_size = 2*XY_cn_size
         if( present(at_least) ) then
            new_size = max( new_size, at_least )
         end if

         allocate( tmp(2,new_size) )
#ifndef _OPTIM
         tmp = 0
#endif

         tmp(1:2,1:XY_cn_size)  = XY_new(1:2,1:XY_cn_size)
         XY_cn_size = new_size

         deallocate( XY_new )
         XY_new => tmp

      end subroutine extend_tab2d_r8
      !_________________________________________________________________
      !
   end subroutine ProcessAllContours
!_______________________________________________________________________
!
   function points_are_colinear( x1, y1, x2, y2, x3, y3 ) result( bool )

      real(kind=MF_DOUBLE), intent(in) :: x1, y1, x2, y2, x3, y3
      logical                          :: bool
      !------ API end ------

      real(kind=MF_DOUBLE) :: u1, v1, u2, v2
      real(kind=MF_DOUBLE) :: xmin, ymin, xmax, ymax
      real(kind=MF_DOUBLE) :: area_ref, cross_product

   !------ end of declarations -- execution starts hereafter  ------

      xmin = min( x1, x2, x3 )
      xmax = max( x1, x2, x3 )
      ymin = min( y1, y2, y3 )
      ymax = max( y1, y2, y3 )
      u1 = x2 - x1
      v1 = y2 - y1
      u2 = x3 - x1
      v2 = y3 - y1
      cross_product = abs(u1*v2 - u2*v1)
      area_ref = max( (xmax-xmin), (ymax-ymin) )**2
      if( cross_product/area_ref < 100.0d0*MF_EPS ) then
         bool = .true.
      else
         bool = .false.
      end if

   end function points_are_colinear
!_______________________________________________________________________
!
   subroutine ProcessClosedPatches( XY, XY_pos, ind, ia,                &
                                    area, pos_area )

      real(kind=MF_DOUBLE),     pointer :: XY(:,:)
      integer,               intent(in) :: XY_pos
      integer,                  pointer :: ind(:), ia(:)
      real(kind=MF_DOUBLE), allocatable :: area(:)
      logical,                  pointer :: pos_area(:)
      !------ API end ------

      real(kind=MF_DOUBLE), pointer :: CS(:,:)
      real(kind=MF_DOUBLE), allocatable :: abs_area(:)
      type(mfArray) :: xp, yp
      integer :: i, ii, ncurves, nl

   !------ end of declarations -- execution starts hereafter  ------

      ! Find the indices of the curves in the CS matrix, and get the
      ! area of all closed curves in order to, after sorting them, draw
      ! patches correctly.
      CS => XY
      ii = 1
      ncurves = 0
      do while( ii < XY_pos )
         nl = CS( 2, ii )
         ncurves = ncurves + 1
         ii = ii + nl + 1
      end do
      allocate( ind(ncurves), area(ncurves) )

      ii = 1
      ncurves = 0
      do while( ii < XY_pos )
         nl = CS( 2, ii )
         ncurves = ncurves + 1
         ind(ncurves) = ii
         xp = CS( 1, ii+[(i, i = 1, nl)] )
         yp = CS( 2, ii+[(i, i = 1, nl)] )
         area(ncurves) = -mfSum( mfDiff(xp)*(mfGet(yp,1.to.nl-1)+mfGet(yp,2.to.nl))/2.0d0 )
         ii = ii + nl + 1
      end do
      call msRelease( xp, yp )

      allocate( abs_area(ncurves), pos_area(ncurves) )
      abs_area = abs(area)
      pos_area = area >= 0.0d0

      allocate( ia(ncurves) )
      ia = [(i, i = 1, ncurves)]
      call quick_sort_3( "des", abs_area, ia )

   end subroutine ProcessClosedPatches
!_______________________________________________________________________
!
   subroutine StoreInternalBoundShape( tc, intern_bnd_x, intern_bnd_y,  &
                                       intern_bnd_ptr )

      type(mfTriConnect), intent(in) :: tc
      real(kind=MF_DOUBLE), pointer :: intern_bnd_x(:), intern_bnd_y(:)
      integer,              pointer :: intern_bnd_ptr(:,:)
      !------ API end ------

      integer :: nb_boundaries, i, j, k, j_deb, j_fin,                  &
                 face, node, ii, nn, n

      real(kind=MF_DOUBLE), allocatable :: tmp_x(:), tmp_y(:)

   !------ end of declarations -- execution starts hereafter  ------

      nb_boundaries = size(tc%faces_boundary_ptr,1)

      allocate( intern_bnd_ptr(nb_boundaries-1,2) )

      nn = 0
      do i = 2, nb_boundaries
         ii = i - 1
         j_deb = tc%faces_boundary_ptr(i,1)
         j_fin = tc%faces_boundary_ptr(i,2)
         intern_bnd_ptr(ii,1) = nn + 1
         intern_bnd_ptr(ii,2) = nn + (j_fin-j_deb+1)
         nn = nn + (j_fin-j_deb+1)
      end do
      allocate( tmp_x(nn), tmp_y(nn) )

      do i = 2, nb_boundaries
         ii = i - 1
         j_deb = tc%faces_boundary_ptr(i,1)
         j_fin = tc%faces_boundary_ptr(i,2)
         ! Retrieve the (x,y) of the corresponding nodes
         do j = j_deb, j_fin
            face = tc%faces_boundary(j)
            node = tc%face_n(face,1)
            k = intern_bnd_ptr(ii,1) + j - j_deb
            tmp_x(k) = tc%n_xy(node,1)
            tmp_y(k) = tc%n_xy(node,2)
         end do
      end do

      do i = 2, nb_boundaries
         ii = i - 1
         j_deb = intern_bnd_ptr(ii,1)
         j_fin = intern_bnd_ptr(ii,2)
         ! Shrink the sub-lists of aligned points in (tmp_x,tmp_y) and
         ! update the second index in 'intern_bnd_ptr' (the first one is
         ! not modified).
         call ShrinkAlignedPoints( tmp_x, tmp_y, j_deb, j_fin )
         intern_bnd_ptr(ii,2) = j_fin
      end do

      nn = 0
      do i = 2, nb_boundaries
         ii = i - 1
         nn = nn + ( intern_bnd_ptr(ii,2) - intern_bnd_ptr(ii,1) + 1 )
      end do
      allocate( intern_bnd_x(nn), intern_bnd_y(nn) )

      nn = 0
      do i = 2, nb_boundaries
         ii = i - 1
         j_deb = intern_bnd_ptr(ii,1)
         j_fin = intern_bnd_ptr(ii,2)
         n = j_fin - j_deb + 1
         intern_bnd_x(nn+1:nn+n) = tmp_x(j_deb:j_fin)
         intern_bnd_y(nn+1:nn+n) = tmp_y(j_deb:j_fin)
         intern_bnd_ptr(ii,1) = nn + 1
         intern_bnd_ptr(ii,2) = nn + n
         nn = nn + n
      end do

   end subroutine StoreInternalBoundShape
!_______________________________________________________________________
!
   subroutine ShrinkAlignedPoints( x, y, i1, i2 )

      real(kind=MF_DOUBLE) :: x(:), y(:)
      integer,  intent(in) :: i1
      integer              :: i2
      !------ API end ------

      ! Given a sub-list of points, of coords (x,y) whom indices are
      ! in the range [i1:i2], remove most of the points which are
      ! colinear, beginning with the index i1+1 up to i2.
      ! Index i1 is not modified.
      ! Index i2 is updated to the new end of the sub-list.

      integer, allocatable :: stack(:)
      integer :: i_stack, i
      logical :: bool

   !------ end of declarations -- execution starts hereafter  ------

      allocate( stack(i2-i1+1) )

      ! Put all points on the stack. If one point is aligned with the
      ! two previous one, put it on the stack without increasing the
      ! depth (i.e. overwriting the previous point).
      stack(1) = i1
      stack(2) = i1 + 1
      i_stack = 2
      do i = i1+2, i2
         bool = points_are_colinear( x(i), y(i),                        &
                            x(stack(i_stack)),   y(stack(i_stack)),     &
                            x(stack(i_stack-1)), y(stack(i_stack-1)) )
         if( .not. bool ) then
            i_stack = i_stack + 1
         end if
         stack(i_stack) = i
      end do
      i2 = i1 + i_stack - 1

      x(i1:i2) = x(stack(1:i_stack))
      y(i1:i2) = y(stack(1:i_stack))

   end subroutine ShrinkAlignedPoints
