!_______________________________________________________________________
!
   function ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg,               &
                         draw_labels, lab_color, lab_size,              &
                         linewidth, n_level, levels_sto_pg,             &
                         z_min, z_max )                                 &
   result( handle )

      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer,              pointer :: tri_sto_pg(:,:)
      logical,                     intent(in) :: draw_labels
      integer,                     intent(in) :: lab_color
      real(kind=MF_DOUBLE),        intent(in) :: lab_size, linewidth
      integer,                     intent(in) :: n_level
      real(kind=MF_DOUBLE), pointer, optional :: levels_sto_pg(:)
      real(kind=MF_DOUBLE), intent(in), optional :: z_min, z_max

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: j, hdle
      real(kind=MF_DOUBLE) :: fact_level
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      character(len=20) :: string

      integer :: itmp, nb_boundaries, n, i
      character(len=3) :: answer
      logical :: device_has_cursor

      type(mfTriConnect) :: tc

      ! This is the old and classical multi-array, used only for labelling
      ! the contours.
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)
      integer :: XXYY_cn_current_pos

      ! This is the new additional multi-array used for drawing the filled
      ! contours (some of them may be closed).
      real(kind=MF_DOUBLE), pointer :: XXYY_cont_new(:,:)

      ! The following entities must be pointer, because they are
      ! used in a grobj.
      integer, pointer :: ind(:), ia(:)
      logical, pointer :: pos_area(:)

      real(kind=MF_DOUBLE), allocatable :: area(:)

      real(kind=MF_DOUBLE), pointer :: intern_bnd_x(:), intern_bnd_y(:)
      integer,              pointer :: intern_bnd_ptr(:,:)
      logical :: has_internal_boundaries, local_background

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( xy_sto_pg(:,1) )
      range(2) = maxval( xy_sto_pg(:,1) )
      range(3) = minval( xy_sto_pg(:,2) )
      range(4) = maxval( xy_sto_pg(:,2) )

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msTriContourF", "W",                 &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; please use the msCAxis routine to set an appropriate interval!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! here, only computation of the contours.

      ! on ré-initialise si besoin le stockage des contours...
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      ! Build the connectivity of the triangular mesh
      call msBuildTriConnect( mf(xy_sto_pg(:,1)), mf(xy_sto_pg(:,2)),   &
                              mf(tri_sto_pg), tc )
!!call msFigure(11)
!!call msAxis( "equal" )
!!call msAxis( [ -2.2d0, 2.2d0, -2.2d0, 2.2d0] )
!!call msTriMesh( tc, nod_num=.true., fac_num=.true. )
!!call msTitle( "tmp fig / opened in TriContourF_aux.f90, line 116" )
!!call msPanAndZoom()
!!call msPause( "in ContourFTri, line 122" )
!!call msFigure(1)

      deallocate( xy_sto_pg, tri_sto_pg )

      if( present(z_min) ) then
         local_background = level_array(1) <= z_min
         call ProcessAllContours( tc, z_sto_pg, level_array, n_level,   &
                                  XXYY_cont, XXYY_cont_new,             &
                                  XXYY_cn_current_pos,                  &
                                  z_min=z_min, z_max=z_max )
      else
         local_background = .false.
         call ProcessAllContours( tc, z_sto_pg, level_array, n_level,   &
                                  XXYY_cont, XXYY_cont_new,             &
                                  XXYY_cn_current_pos )
      end if

      nb_boundaries = size(tc%faces_boundary_ptr,1)
      has_internal_boundaries = nb_boundaries-1 > 0
      if( has_internal_boundaries ) then
         ! There exist internal boundaries; we have to store their
         ! contour with the minimum number of nodes
         call StoreInternalBoundShape( tc, intern_bnd_x, intern_bnd_y,  &
                                       intern_bnd_ptr )
      end if

      call msRelease( tc )

      call ProcessClosedPatches( XXYY_cont_new, XXYY_cn_current_pos,    &
                                 ind, ia, area, pos_area )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "tri_contour_filled"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XXYY_cn_current_pos

      grobj%struct%abs_mat => XXYY_cont
      grobj%struct%ord_mat => XXYY_cont_new

      grobj%struct%ir => ia
      grobj%struct%jc => ind
      grobj%struct%bool_vec => pos_area

      grobj%struct%bool2 = has_internal_boundaries
      if( has_internal_boundaries ) then
         grobj%struct%tab_2d_1 => intern_bnd_ptr
         grobj%struct%tm1_tab  => intern_bnd_x
         grobj%struct%tm2_tab  => intern_bnd_y
      end if

      grobj%struct%bool3 = local_background

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color
      grobj%struct%height_text = lab_size ! relat. size actually

      grobj%struct%lev_tab => level_array

      grobj%struct%linewidth = linewidth

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_tri_contourF_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function ContourFTri
!_______________________________________________________________________
!
   function ContourFTriConnect( z_sto_pg, tc,                           &
                                draw_labels, lab_color, lab_size,       &
                                linewidth, n_level, levels_sto_pg,      &
                                z_min, z_max )                          &
   result( handle )

      real(kind=MF_DOUBLE), pointer    :: z_sto_pg(:)
      type(mfTriConnect),   intent(in) :: tc
      logical,              intent(in) :: draw_labels
      integer,              intent(in) :: lab_color
      real(kind=MF_DOUBLE), intent(in) :: lab_size, linewidth
      integer,              intent(in) :: n_level
      real(kind=MF_DOUBLE), pointer, optional :: levels_sto_pg(:)
      real(kind=MF_DOUBLE), intent(in), optional :: z_min, z_max

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: j, hdle
      real(kind=MF_DOUBLE) :: fact_level
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      character(len=20) :: string

      integer :: itmp, nb_boundaries, n, i
      character(len=3) :: answer
      logical :: device_has_cursor

      ! This is the old and classical multi-array, used only for labelling
      ! the contours.
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)
      integer :: XXYY_cn_current_pos

      ! This is the new additional multi-array used for drawing the filled
      ! contours (some of them may be closed).
      real(kind=MF_DOUBLE), pointer :: XXYY_cont_new(:,:)

      ! The following entities must be pointer, because they are
      ! used in a grobj.
      integer, pointer :: ind(:), ia(:)
      logical, pointer :: pos_area(:)

      real(kind=MF_DOUBLE), allocatable :: area(:)

      real(kind=MF_DOUBLE), pointer :: intern_bnd_x(:), intern_bnd_y(:)
      integer,              pointer :: intern_bnd_ptr(:,:)
      logical :: has_internal_boundaries, local_background

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( tc%n_xy(:,1) )
      range(2) = maxval( tc%n_xy(:,1) )
      range(3) = minval( tc%n_xy(:,2) )
      range(4) = maxval( tc%n_xy(:,2) )

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msTriContourF", "W",                 &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; therefore the corresponding level curve", &
                      "will not be drawn!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! here, only computation of the contours.

      ! on ré-initialise si besoin le stockage des contours...
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      if( present(z_min) ) then
         local_background = level_array(1) <= z_min
         call ProcessAllContours( tc, z_sto_pg, level_array, n_level,   &
                                  XXYY_cont, XXYY_cont_new,             &
                                  XXYY_cn_current_pos,                  &
                                  z_min=z_min, z_max=z_max )
      else
         local_background = .false.
         call ProcessAllContours( tc, z_sto_pg, level_array, n_level,   &
                                  XXYY_cont, XXYY_cont_new,             &
                                  XXYY_cn_current_pos )
      end if

      nb_boundaries = size(tc%faces_boundary_ptr,1)
      has_internal_boundaries = nb_boundaries-1 > 0
      if( has_internal_boundaries ) then
         ! There exist internal boundaries; we have to store their
         ! contour with the minimum number of nodes
         call StoreInternalBoundShape( tc, intern_bnd_x, intern_bnd_y,  &
                                       intern_bnd_ptr )
      end if

      call ProcessClosedPatches( XXYY_cont_new, XXYY_cn_current_pos,    &
                                 ind, ia, area, pos_area )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "tri_contour_filled"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XXYY_cn_current_pos

      grobj%struct%abs_mat => XXYY_cont
      grobj%struct%ord_mat => XXYY_cont_new

      grobj%struct%ir => ia
      grobj%struct%jc => ind
      grobj%struct%bool_vec => pos_area

      grobj%struct%bool2 = has_internal_boundaries
      if( has_internal_boundaries ) then
         grobj%struct%tab_2d_1 => intern_bnd_ptr
         grobj%struct%tm1_tab  => intern_bnd_x
         grobj%struct%tm2_tab  => intern_bnd_y
      end if

      grobj%struct%bool3 = local_background

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color
      grobj%struct%height_text = lab_size ! relat. size actually

      grobj%struct%lev_tab => level_array

      grobj%struct%linewidth = linewidth

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_tri_contourF_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function ContourFTriConnect
!_______________________________________________________________________
!
