!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContourF_xyz( x, y, z, tri,                            &
                               nb_levels, levels, linewidth,            &
                               labels, labelscolor, labelsize )         &
   result( hdle_vec )
#endif
#ifdef _MF_SUBR
   subroutine msTriContourF_xyz( x, y, z, tri,                          &
                                 nb_levels, levels, linewidth,          &
                                 labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: x, y, z, tri
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer, allocatable :: hdle_vec(:)
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:), &
                                       tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:), itri_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: xy_ptr_tmp(:,:), z_ptr2(:)
      integer, pointer :: tri_ptr_tmp(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:), levels_ptr_tmp(:)

      type(mfArray) :: levels_sorted, mf_tmp

      real(kind=MF_DOUBLE) :: val, z_min, z_max
      logical :: z_is_finite
      integer :: i, nb_level_too_low, status, nb_zones, ind_1, ind_2,   &
                 j_row, j_col, k, isize, ind_max, inode

      integer, allocatable :: face_tri(:,:), tri_f(:,:)
      integer, allocatable :: new_tri(:), new_tri_ptr(:,:)
      integer, allocatable :: ind(:), ind_inv(:)

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z, tri )

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( z, z_ptr, no_crc=.true. )
      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y' and 'z' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(z_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'z' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( present(levels) ) then
            n_level = size(levels)
         else
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Here, we are sure that 'z' contains non-finite values.
         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr(:,1), y_ptr(:,1), z_ptr(:,1),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr(1,:), y_ptr(1,:), z_ptr(1,:),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( x, x_ptr )
            call msFreePointer( y, y_ptr )
            call msFreePointer( z, z_ptr )
            call msFreePointer( tri, tri_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

      else

         ! Here, 'z' doesn't contain non-finite values.
         ! We can copy all nodes, triangles and z-values in xy_sto_pg,
         ! z_sto_pg and tri_sto_pg...
         allocate( xy_sto_pg(nn,2), z_sto_pg(nn) )

         allocate( tri_sto_pg(ntri,3) )

         if( p_dim == 1 ) then
            xy_sto_pg(:,1) = x_ptr(:,1)
            xy_sto_pg(:,2) = y_ptr(:,1)
            z_sto_pg(:)   = z_ptr(:,1)
         else
            xy_sto_pg(:,1) = x_ptr(1,:)
            xy_sto_pg(:,2) = y_ptr(1,:)
            z_sto_pg(:)   = z_ptr(1,:)
         end if
         tri_sto_pg(:,:) = tri_ptr(:,:)

      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( tri, tri_ptr )

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then

         ! Get only unique values in 'levels' (without options, the
         ! resulting values are sorted in increasing order)
         levels_sorted = mfUnique(levels)

         ! Caution: count the number of levels under the minimum,
         ! and keep only one one them (min and max search may be
         ! used because, now, z_ptr contains only finite values).
         z_min = minval(z_ptr)
         z_max = maxval(z_ptr)
         nb_level_too_low = 0
         do i = 1, n_level
            val = mfGet( levels_sorted, i )
            if( val < z_min ) then
               nb_level_too_low = nb_level_too_low + 1
            end if
         end do
         ! Remove these 'too low' levels, except one
         if( nb_level_too_low > 1 ) then
            call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
         end if

         ! Extracting the levels' vector
         call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels_sorted, levels_ptr )
         call msRelease( levels_sorted )

      end if

!### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ###
!### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ###
! NEW PART FOR SUPPORTING NON CONNECTED PARTS IN A TRIANGULAR MESH
      ! Here, we have to check that the triangular mesh constitutes
      ! only one adjacent zone... Else, we will have to call many
      ! times the ContourFTri routine, for each independant zone...

      ! Partial connectivity: only face_tri, tri_f are required.
      call build_tri_conn_min( nn, tri_sto_pg, face_tri, tri_f )

      ! Prepare the discovering of disjoint triangular zones.
      call partition_in_disjoint_zones( tri_f, face_tri,                &
                                        new_tri, new_tri_ptr )

      nb_zones = size(new_tri_ptr,1)
!!print *, "TriContourF.F90, line 395: nb_zones = ", nb_zones
      allocate( hdle_vec(nb_zones) )
      if( nb_zones > 1 ) then
         ! Apply the partition to the original list of triangles
         tri_sto_pg(:,:) = tri_sto_pg(new_tri,:)

         do i = 1, nb_zones
            ind_1 = new_tri_ptr(i,1)
            ind_2 = new_tri_ptr(i,2)
!!print *, "Before renumbering:"
!!call msDisplay( xy_sto_pg, "xy_sto_pg   (nodes' definition)" )
!!call msDisplay( z_sto_pg, "z_sto_pg      (value at nodes)" )
!!call msDisplay( tri_sto_pg(ind_1:ind_2,:), "tri_sto_pg (triangles' definition)" )
            ! Find the nodes which are effectively used
            ! As tri_sto_pg(ind_1:ind_2,:) is a two-dimensional array,
            ! we have to setup a one-dimensional array, as required by
            ! the mfUnique function
            allocate( ind(3*(ind_2-ind_1+1)) )
            k = 0
            do j_col = 1, 3
               do j_row = ind_1, ind_2
                  k = k + 1
                  ind(k) = tri_sto_pg(j_row,j_col)
               end do
            end do
!!call msDisplay( ind, "ind (long column version of the previous array)" )
            mf_tmp = mfUnique( mf(ind) )
!!call msDisplay( mf_tmp, "ind (unique values)" )
            isize = size(mf_tmp)
            deallocate( ind) ; allocate( ind(isize) )
            ind = mf_tmp
            call msRelease( mf_tmp )

            ! Now, renumbering of the triangles' indices in tri_sto_pg
            ind_max = ind(isize)
            allocate( ind_inv(ind_max) )
            ind_inv = 0
            do k = 1, isize
               inode = ind(k)
               ind_inv(inode) = k
            end do
!!call msDisplay( ind_inv, "ind_inv" )
            do j_col = 1, 3
               do j_row = ind_1, ind_2
                  tri_sto_pg(j_row,j_col) = ind_inv(tri_sto_pg(j_row,j_col))
               end do
            end do

!!print *, "      calling 'ContourFTri' with:"
!!call msDisplay( xy_sto_pg(ind,:), "xy_sto_pg   (nodes' definition)" )
!!call msDisplay( z_sto_pg(ind), "z_sto_pg      (value at nodes)" )
!!call msDisplay( tri_sto_pg(ind_1:ind_2,:), "tri_sto_pg (triangles' definition)" )

            allocate( xy_ptr_tmp(isize,2) )
            xy_ptr_tmp = xy_sto_pg(ind,:)
            allocate( z_ptr2(isize) )
            z_ptr2 = z_sto_pg(ind)
            allocate( tri_ptr_tmp(ind_2-ind_1+1,3) )
            tri_ptr_tmp = tri_sto_pg(ind_1:ind_2,:)
!!call msDisplay( xy_ptr_tmp,  " xy_sto_pg copied as pointer" )
!!call msDisplay( z_ptr2,      "  z_sto_pg copied as pointer" )
!!call msDisplay( tri_ptr_tmp, "tri_sto_pg copied as pointer" )
            deallocate( ind, ind_inv )

            allocate( levels_ptr_tmp(n_level) )
            levels_ptr_tmp = levels_sto_pg

            if( present(levels) ) then
               hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level, levels_ptr_tmp, &
                                          z_min=z_min, z_max=z_max )
            else
               hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level )
            end if

         end do

         deallocate( xy_sto_pg, z_sto_pg, tri_sto_pg )
         if( present(levels) ) then
            deallocate( levels_sto_pg )
         end if
!### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ###
!### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ###

      else ! nb_zones = 1
         if( present(levels) ) then
            hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                       draw_labels, lab_color, lab_size, &
                                       linewidth_d, n_level, levels_sto_pg, &
                                       z_min=z_min, z_max=z_max )
         else
            hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                       draw_labels, lab_color, lab_size, &
                                       linewidth_d, n_level )
         end if
      end if

      call msFreePointer( z, z_ptr )

 99   continue

      call msFreeArgs( x, y, z, tri )
      call msAutoRelease( x, y, z, tri )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContourF_xyz
#endif
#ifdef _MF_SUBR
   end subroutine msTriContourF_xyz
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContourF_xyz_out( out, x, y, z, tri,                   &
                                   nb_levels, levels, linewidth,        &
                                   labels, labelscolor, labelsize )                  &
   result( hdle_vec )
#endif
#ifdef _MF_SUBR
   subroutine msTriContourF_xyz_out( out, x, y, z, tri,                 &
                                     nb_levels, levels, linewidth,      &
                                     labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: x, y, z, tri
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer, allocatable :: hdle_vec(:)
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:), &
                                       tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      real(kind=MF_DOUBLE), pointer :: xy_ptr_tmp(:,:), z_ptr2(:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr_tmp(:)

      integer, allocatable :: face_tri(:,:), tri_f(:,:)
      integer, allocatable :: new_tri(:), new_tri_ptr(:,:)
      integer, allocatable :: ind(:), ind_inv(:)
      integer, pointer :: tri_ptr_tmp(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      type(mfArray) :: levels_sorted, mf_tmp

      real(kind=MF_DOUBLE) :: val, z_min, z_max
      logical :: z_is_finite
      integer :: i, nb_level_too_low, status, ind_1, ind_2, nb_zones,   &
                 ind_max, inode, isize, k, j_row, j_col

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z, tri )

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x, y, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( z, z_ptr, no_crc=.true. )
      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y' and 'z' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(z_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'z' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( present(levels) ) then
            n_level = size(levels)
         else
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Here, we are sure that 'z' contains non-finite values.
         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr(:,1), y_ptr(:,1), z_ptr(:,1),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr(1,:), y_ptr(1,:), z_ptr(1,:),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( x, x_ptr )
            call msFreePointer( y, y_ptr )
            call msFreePointer( z, z_ptr )
            call msFreePointer( tri, tri_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

      else

         ! Here, 'z' doesn't contain non-finite values.
         ! We can copy all nodes, triangles and z-values in xy_sto_pg,
         ! z_sto_pg and tri_sto_pg...
         allocate( xy_sto_pg(nn,2), z_sto_pg(nn) )

         allocate( tri_sto_pg(ntri,3) )

         if( p_dim == 1 ) then
            xy_sto_pg(:,1) = x_ptr(:,1)
            xy_sto_pg(:,2) = y_ptr(:,1)
            z_sto_pg(:)   = z_ptr(:,1)
         else
            xy_sto_pg(:,1) = x_ptr(1,:)
            xy_sto_pg(:,2) = y_ptr(1,:)
            z_sto_pg(:)   = z_ptr(1,:)
         end if
         tri_sto_pg(:,:) = tri_ptr(:,:)

      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( tri, tri_ptr )

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then

         ! Get only unique values in 'levels'
         levels_sorted = mfUnique(levels)

         ! Caution: count the number of levels under the minimum,
         ! and keep only one one them (min and max search may be
         ! used because, now, z_ptr contains only finite values).
         z_min = minval(z_ptr)
         z_max = maxval(z_ptr)
         nb_level_too_low = 0
         do i = 1, n_level
            val = mfGet( levels_sorted, i )
            if( val < z_min ) then
               nb_level_too_low = nb_level_too_low + 1
            end if
         end do
         ! Remove these 'too low' levels, except one
         if( nb_level_too_low > 1 ) then
            call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
         end if

         ! Extracting the levels' vector
         call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels_sorted, levels_ptr )
         call msRelease( levels_sorted )

      end if

      ! Here, we have to check that the triangular mesh constitutes
      ! only one adjacent zone... Else, we will have to call many
      ! times the ContourFTri routine, for each independant zone...

      ! Partial connectivity: only face_tri, tri_f are required.
      call build_tri_conn_min( nn, tri_sto_pg, face_tri, tri_f )

      ! Prepare the discovering of disjoint triangular zones.
      call partition_in_disjoint_zones( tri_f, face_tri,                &
                                        new_tri, new_tri_ptr )

      nb_zones = size(new_tri_ptr,1)
      allocate( hdle_vec(nb_zones) )
      if( nb_zones > 1 ) then
         ! Apply the partition to the original list of triangles
         tri_sto_pg(:,:) = tri_sto_pg(new_tri,:)

         do i = 1, nb_zones
            ind_1 = new_tri_ptr(i,1)
            ind_2 = new_tri_ptr(i,2)
            ! Find the nodes which are effectively used
            ! As tri_sto_pg(ind_1:ind_2,:) is a two-dimensional array,
            ! we have to setup a one-dimensional array, as required by
            ! the mfUnique function
            allocate( ind(3*(ind_2-ind_1+1)) )
            k = 0
            do j_col = 1, 3
               do j_row = ind_1, ind_2
                  k = k + 1
                  ind(k) = tri_sto_pg(j_row,j_col)
               end do
            end do
            mf_tmp = mfUnique( mf(ind) )
            isize = size(mf_tmp)
            deallocate( ind) ; allocate( ind(isize) )
            ind = mf_tmp
            call msRelease( mf_tmp )

            ! Now, renumbering of the triangles' indices in tri_sto_pg
            ind_max = ind(isize)
            allocate( ind_inv(ind_max) )
            ind_inv = 0
            do k = 1, isize
               inode = ind(k)
               ind_inv(inode) = k
            end do
            do j_col = 1, 3
               do j_row = ind_1, ind_2
                  tri_sto_pg(j_row,j_col) = ind_inv(tri_sto_pg(j_row,j_col))
               end do
            end do

            allocate( xy_ptr_tmp(isize,2) )
            xy_ptr_tmp = xy_sto_pg(ind,:)
            allocate( z_ptr2(isize) )
            z_ptr2 = z_sto_pg(ind)
            allocate( tri_ptr_tmp(ind_2-ind_1+1,3) )
            tri_ptr_tmp = tri_sto_pg(ind_1:ind_2,:)
            deallocate( ind, ind_inv )

            allocate( levels_ptr_tmp(n_level) )
            levels_ptr_tmp = levels_sto_pg

            if( present(levels) ) then
               hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level, levels_ptr_tmp, &
                                          z_min=z_min, z_max=z_max )
            else
               hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level )
            end if

         end do

         deallocate( xy_sto_pg, z_sto_pg, tri_sto_pg )
         if( present(levels) ) then
            deallocate( levels_sto_pg )
         end if

      else ! nb_zones = 1
         if( present(levels) ) then
            hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                       draw_labels, lab_color, lab_size, &
                                       linewidth_d, n_level, levels_sto_pg, &
                                       z_min=z_min, z_max=z_max )
         else
            hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                       draw_labels, lab_color, lab_size, &
                                       linewidth_d, n_level )
         end if
      end if

      call msFreePointer( z, z_ptr )

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( x, y, z, tri )
      call msAutoRelease( x, y, z, tri )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContourF_xyz_out
#endif
#ifdef _MF_SUBR
   end subroutine msTriContourF_xyz_out
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContourF_tri_conn( z, tri_connect,                     &
                                    nb_levels, levels, linewidth,       &
                                    labels, labelscolor, labelsize )    &
   result( hdle_vec )
#endif
#ifdef _MF_SUBR
   subroutine msTriContourF_tri_conn( z, tri_connect,                   &
                                      nb_levels, levels, linewidth,     &
                                      labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: z
      type(mfTriConnect),   intent(in)           :: tri_connect
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer, allocatable :: hdle_vec(:)
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      ! pointers to avoid copy of data
      real(kind=MF_DOUBLE), pointer :: x_ptr(:), y_ptr(:)
      real(kind=MF_DOUBLE), pointer :: xy_ptr_tmp(:,:), z_ptr2(:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr_tmp(:)

      integer, pointer :: tri_ptr(:,:)
      integer, allocatable :: face_tri(:,:), tri_f(:,:)
      integer, allocatable :: new_tri(:), new_tri_ptr(:,:)
      integer, allocatable :: ind(:), ind_inv(:)
      integer, pointer :: tri_ptr_tmp(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      type(mfArray) :: levels_sorted, mf_tmp

      real(kind=MF_DOUBLE) :: val, z_min, z_max
      logical :: z_is_finite
      integer :: i, nb_level_too_low, status, ind_1, ind_2, nb_zones,   &
                 ind_max, inode, isize, k, j_row, j_col

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      if( .not. tri_connect%init ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri_connect' doesn't seem to be a valid triangle connectivity!",     &
                            "-> did you initialize it using msBuildTriConnect?" )
         go to 99
      end if

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      nn = size( tri_connect%n_xy, 1 )

      ! checking that 'z' has the appropriate size
      if( size(z_ptr) /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad size for 'z'!" )
         go to 99
      end if

      if( size(z_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( present(levels) ) then
            n_level = size(levels)
         else
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Using x_ptr, y_ptr and tri_ptr to re-use the same algorithm
         ! than used in the 'TriContour_xyz' routine.

         ! x_ptr doit pointer sur les valeurs de 'x' dans tri_connect%n_xy
         x_ptr => tri_connect%n_xy(:,1)

         ! y_ptr doit pointer sur les valeurs de 'y' dans tri_connect%n_xy
         y_ptr => tri_connect%n_xy(:,2)

         ! tri_ptr doit pointer sur la définition des triangles
         !         dans tri_connect%tri_n
         tri_ptr => tri_connect%tri_n

         ntri = size(tri_connect%tri_n,1)

         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(:,1), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(1,:), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         x_ptr => null()
         y_ptr => null()
         tri_ptr => null()

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( z, z_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

         if( present(levels) ) then

            ! Get only unique values in 'levels' (without options, the
            ! resulting values are sorted in increasing order)
            levels_sorted = mfUnique(levels)

            ! Caution: count the number of levels under the minimum,
            ! and keep only one one them (min and max search may be
            ! used because, now, z_ptr contains only finite values).
            z_min = minval(z_ptr)
            z_max = maxval(z_ptr)
            nb_level_too_low = 0
            do i = 1, n_level
               val = mfGet( levels_sorted, i )
               if( val < z_min ) then
                  nb_level_too_low = nb_level_too_low + 1
               end if
            end do
            ! Remove these 'too low' levels, except one
            if( nb_level_too_low > 1 ) then
               call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
            end if

            ! Extracting the levels' vector
            call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels_sorted, levels_ptr )
            call msRelease( levels_sorted )

         end if

         ! Here, we have to check that the triangular mesh constitutes
         ! only one adjacent zone... Else, we will have to call many
         ! times the ContourFTri routine, for each independant zone...

         ! Partial connectivity: only face_tri, tri_f are required.
         call build_tri_conn_min( nn, tri_sto_pg, face_tri, tri_f )

         ! Prepare the discovering of disjoint triangular zones.
         call partition_in_disjoint_zones( tri_f, face_tri,             &
                                           new_tri, new_tri_ptr )

         nb_zones = size(new_tri_ptr,1)
         allocate( hdle_vec(nb_zones) )

         if( nb_zones > 1 ) then
            ! Apply the partition to the original list of triangles
            tri_sto_pg(:,:) = tri_sto_pg(new_tri,:)

            do i = 1, nb_zones
               ind_1 = new_tri_ptr(i,1)
               ind_2 = new_tri_ptr(i,2)
               ! Find the nodes which are effectively used
               ! As tri_sto_pg(ind_1:ind_2,:) is a two-dimensional array,
               ! we have to setup a one-dimensional array, as required by
               ! the mfUnique function
               allocate( ind(3*(ind_2-ind_1+1)) )
               k = 0
               do j_col = 1, 3
                  do j_row = ind_1, ind_2
                     k = k + 1
                     ind(k) = tri_sto_pg(j_row,j_col)
                  end do
               end do
               mf_tmp = mfUnique( mf(ind) )
               isize = size(mf_tmp)
               deallocate( ind) ; allocate( ind(isize) )
               ind = mf_tmp
               call msRelease( mf_tmp )

               ! Now, renumbering of the triangles' indices in tri_sto_pg
               ind_max = ind(isize)
               allocate( ind_inv(ind_max) )
               ind_inv = 0
               do k = 1, isize
                  inode = ind(k)
                  ind_inv(inode) = k
               end do
               do j_col = 1, 3
                  do j_row = ind_1, ind_2
                     tri_sto_pg(j_row,j_col) = ind_inv(tri_sto_pg(j_row,j_col))
                  end do
               end do

               allocate( xy_ptr_tmp(isize,2) )
               xy_ptr_tmp = xy_sto_pg(ind,:)
               allocate( z_ptr2(isize) )
               z_ptr2 = z_sto_pg(ind)
               allocate( tri_ptr_tmp(ind_2-ind_1+1,3) )
               tri_ptr_tmp = tri_sto_pg(ind_1:ind_2,:)
               deallocate( ind, ind_inv )

               allocate( levels_ptr_tmp(n_level) )
               levels_ptr_tmp = levels_sto_pg

               if( present(levels) ) then
                  hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                             draw_labels, lab_color, lab_size, &
                                             linewidth_d, n_level, levels_ptr_tmp, &
                                             z_min=z_min, z_max=z_max )
               else
                  hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                             draw_labels, lab_color, lab_size, &
                                             linewidth_d, n_level )
               end if

            end do

            deallocate( xy_sto_pg, z_sto_pg, tri_sto_pg )
            if( present(levels) ) then
               deallocate( levels_sto_pg )
            end if

         else ! nb_zones = 1
            if( present(levels) ) then
               hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d,    n_level,      &
                                          levels_sto_pg=levels_sto_pg,  &
                                          z_min=z_min, z_max=z_max )
            else
               hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level )
            end if
         end if

      else

         allocate( z_sto_pg(nn) )

         if( p_dim == 1 ) then
            z_sto_pg(:)   = z_ptr(:,1)
         else
            z_sto_pg(:)   = z_ptr(1,:)
         end if

         ! On se restreint à une seule zone: on suppose donc que, puisque
         ! toutes les valeurs de 'z' sont finies (pas de NaNs ni de Inf),
         ! que le maillage triangulaire n'est pas partitionné en zones
         ! disjointes !
         allocate( hdle_vec(1) )

         if( present(levels) ) then

            ! Get only unique values in 'levels' (without options, the
            ! resulting values are sorted in increasing order)
            levels_sorted = mfUnique(levels)

            ! Caution: count the number of levels under the minimum,
            ! and keep only one one them (min and max search may be
            ! used because, now, z_ptr contains only finite values).
            z_min = minval(z_ptr)
            z_max = maxval(z_ptr)
            nb_level_too_low = 0
            do i = 1, n_level
               val = mfGet( levels_sorted, i )
               if( val < z_min ) then
                  nb_level_too_low = nb_level_too_low + 1
               end if
            end do
            ! Remove these 'too low' levels, except one
            if( nb_level_too_low > 1 ) then
               call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
            end if

            ! Extracting the levels' vector
            call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels_sorted, levels_ptr )
            call msRelease( levels_sorted )

            hdle_vec(1) = ContourFTriConnect( z_sto_pg,tri_connect,     &
                                 draw_labels, lab_color,                &
                                 lab_size, linewidth_d,                 &
                                 n_level, levels_sto_pg=levels_sto_pg,  &
                                 z_min=z_min, z_max=z_max )

         else

            hdle_vec(1) = ContourFTriConnect( z_sto_pg, tri_connect,    &
                                 draw_labels, lab_color,                &
                                 lab_size, linewidth_d, n_level )

         end if

      end if

      call msFreePointer( z, z_ptr )

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContourF_tri_conn
#endif
#ifdef _MF_SUBR
   end subroutine msTriContourF_tri_conn
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContourF_tri_conn_out( out, z, tri_connect,            &
                                        nb_levels, levels, linewidth,   &
                                        labels, labelscolor, labelsize ) &
   result( hdle_vec )
#endif
#ifdef _MF_SUBR
   subroutine msTriContourF_tri_conn_out( out, z, tri_connect,          &
                                          nb_levels, levels, linewidth, &
                                          labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: z
      type(mfTriConnect),   intent(in)           :: tri_connect
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer, allocatable :: hdle_vec(:)
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      ! pointers to avoid copy of data
      real(kind=MF_DOUBLE), pointer :: x_ptr(:), y_ptr(:)
      integer, pointer :: tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: xy_ptr_tmp(:,:), z_ptr2(:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr_tmp(:)

      integer, allocatable :: face_tri(:,:), tri_f(:,:)
      integer, allocatable :: new_tri(:), new_tri_ptr(:,:)
      integer, allocatable :: ind(:), ind_inv(:)
      integer, pointer :: tri_ptr_tmp(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      type(mfArray) :: levels_sorted, mf_tmp

      real(kind=MF_DOUBLE) :: val, z_min, z_max
      logical :: z_is_finite
      integer :: i, nb_level_too_low, status, ind_1, ind_2, nb_zones,   &
                 ind_max, inode, isize, k, j_row, j_col

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      if( .not. tri_connect%init ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri_connect' doesn't seem to be a valid triangle connectivity!",     &
                            "-> did you initialize it using msBuildTriConnect?" )
         go to 99
      end if

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      nn = size( tri_connect%n_xy, 1 )

      ! checking that 'z' has the appropriate size
      if( size(z_ptr) /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad size for 'z'!" )
         go to 99
      end if

      if( size(z_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( present(levels) ) then
            n_level = size(levels)
         else
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Using x_ptr, y_ptr and tri_ptr to re-use the same algorithm
         ! than used in the 'TriContour_xyz' routine.

         ! x_ptr doit pointer sur les valeurs de 'x' dans tri_connect%n_xy
         x_ptr => tri_connect%n_xy(:,1)

         ! y_ptr doit pointer sur les valeurs de 'y' dans tri_connect%n_xy
         y_ptr => tri_connect%n_xy(:,2)

         ! tri_ptr doit pointer sur la définition des triangles
         !         dans tri_connect%tri_n
         tri_ptr => tri_connect%tri_n

         ntri = size(tri_connect%tri_n,1)

         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(:,1), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(1,:), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         x_ptr => null()
         y_ptr => null()
         tri_ptr => null()

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( z, z_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

         if( present(levels) ) then

            ! Get only unique values in 'levels' (without options, the
            ! resulting values are sorted in increasing order)
            levels_sorted = mfUnique(levels)

            ! Caution: count the number of levels under the minimum,
            ! and keep only one one them (min and max search may be
            ! used because, now, z_ptr contains only finite values).
            z_min = minval(z_ptr)
            z_max = maxval(z_ptr)
            nb_level_too_low = 0
            do i = 1, n_level
               val = mfGet( levels_sorted, i )
               if( val < z_min ) then
                  nb_level_too_low = nb_level_too_low + 1
               end if
            end do
            ! Remove these 'too low' levels, except one
            if( nb_level_too_low > 1 ) then
               call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
            end if

            ! Extracting the levels' vector
            call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels_sorted, levels_ptr )
            call msRelease( levels_sorted )

         end if

         ! Here, we have to check that the triangular mesh constitutes
         ! only one adjacent zone... Else, we will have to call many
         ! times the ContourFTri routine, for each independant zone...

         ! Partial connectivity: only face_tri, tri_f are required.
         call build_tri_conn_min( nn, tri_sto_pg, face_tri, tri_f )

         ! Prepare the discovering of disjoint triangular zones.
         call partition_in_disjoint_zones( tri_f, face_tri,                &
                                          new_tri, new_tri_ptr )

         nb_zones = size(new_tri_ptr,1)
         allocate( hdle_vec(nb_zones) )

         if( nb_zones > 1 ) then
            ! Apply the partition to the original list of triangles
            tri_sto_pg(:,:) = tri_sto_pg(new_tri,:)

            do i = 1, nb_zones
               ind_1 = new_tri_ptr(i,1)
               ind_2 = new_tri_ptr(i,2)
               ! Find the nodes which are effectively used
               ! As tri_sto_pg(ind_1:ind_2,:) is a two-dimensional array,
               ! we have to setup a one-dimensional array, as required by
               ! the mfUnique function
               allocate( ind(3*(ind_2-ind_1+1)) )
               k = 0
               do j_col = 1, 3
                  do j_row = ind_1, ind_2
                     k = k + 1
                     ind(k) = tri_sto_pg(j_row,j_col)
                  end do
               end do
               mf_tmp = mfUnique( mf(ind) )
               isize = size(mf_tmp)
               deallocate( ind) ; allocate( ind(isize) )
               ind = mf_tmp
               call msRelease( mf_tmp )

               ! Now, renumbering of the triangles' indices in tri_sto_pg
               ind_max = ind(isize)
               allocate( ind_inv(ind_max) )
               ind_inv = 0
               do k = 1, isize
                  inode = ind(k)
                  ind_inv(inode) = k
               end do
               do j_col = 1, 3
                  do j_row = ind_1, ind_2
                     tri_sto_pg(j_row,j_col) = ind_inv(tri_sto_pg(j_row,j_col))
                  end do
               end do

               allocate( xy_ptr_tmp(isize,2) )
               xy_ptr_tmp = xy_sto_pg(ind,:)
               allocate( z_ptr2(isize) )
               z_ptr2 = z_sto_pg(ind)
               allocate( tri_ptr_tmp(ind_2-ind_1+1,3) )
               tri_ptr_tmp = tri_sto_pg(ind_1:ind_2,:)
               deallocate( ind, ind_inv )

               allocate( levels_ptr_tmp(n_level) )
               levels_ptr_tmp = levels_sto_pg

               if( present(levels) ) then
                  hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                             draw_labels, lab_color, lab_size, &
                                             linewidth_d, n_level, levels_ptr_tmp, &
                                             z_min=z_min, z_max=z_max )
               else
                  hdle_vec(i) = ContourFTri( xy_ptr_tmp, z_ptr2, tri_ptr_tmp, &
                                             draw_labels, lab_color, lab_size, &
                                             linewidth_d, n_level )
               end if

            end do

            deallocate( xy_sto_pg, z_sto_pg, tri_sto_pg )
            if( present(levels) ) then
               deallocate( levels_sto_pg )
            end if

         else ! nb_zones = 1
            if( present(levels) ) then
               hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level,         &
                                          levels_sto_pg=levels_sto_pg,  &
                                          z_min=z_min, z_max=z_max )
            else
               hdle_vec(1) = ContourFTri( xy_sto_pg, z_sto_pg, tri_sto_pg, &
                                          draw_labels, lab_color, lab_size, &
                                          linewidth_d, n_level )
            end if
         end if

      else

         allocate( z_sto_pg(nn) )

         if( p_dim == 1 ) then
            z_sto_pg(:) = z_ptr(:,1)
         else
            z_sto_pg(:) = z_ptr(1,:)
         end if

         ! On se restreint à une seule zone: on suppose donc que, puisque
         ! toutes les valeurs de 'z' sont finies (pas de NaNs ni de Inf),
         ! que le maillage triangulaire n'est pas partitionné en zones
         ! disjointes !
         allocate( hdle_vec(1) )

         if( present(levels) ) then

            ! Get only unique values in 'levels'
            levels_sorted = mfUnique(levels)

            ! Caution: count the number of levels under the minimum,
            ! and keep only one one them (min and max search may be
            ! used because, now, z_ptr contains only finite values).
            z_min = minval(z_ptr)
            z_max = maxval(z_ptr)
            nb_level_too_low = 0
            do i = 1, n_level
               val = mfGet( levels_sorted, i )
               if( val < z_min ) then
                  nb_level_too_low = nb_level_too_low + 1
               end if
            end do
            ! Remove these 'too low' levels, except one
            if( nb_level_too_low > 1 ) then
               call msSet( MF_EMPTY, levels_sorted, 1 .to. (nb_level_too_low-1) )
            end if

            ! Extracting the levels' vector
            call msPointer( levels_sorted, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels_sorted, levels_ptr )
            call msRelease( levels_sorted )

            hdle_vec(1) = ContourFTriConnect( z_sto_pg, tri_connect,    &
                                              draw_labels, lab_color,   &
                                              lab_size, linewidth_d,    &
                                              n_level, levels_sto_pg=levels_sto_pg, &
                                              z_min=z_min, z_max=z_max )

         else

            hdle_vec(1) = ContourFTriConnect( z_sto_pg, tri_connect,    &
                                              draw_labels, lab_color,   &
                                              lab_size, linewidth_d, n_level )

         end if

      end if

      call msFreePointer( z, z_ptr )

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContourF_tri_conn_out
#endif
#ifdef _MF_SUBR
   end subroutine msTriContourF_tri_conn_out
#endif
