!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContour_xyz( x, y, z, tri,                             &
                              nb_levels, levels,                        &
                              linespec, linewidth,                      &
                              labels, labelscolor, labelsize )          &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriContour_xyz( x, y, z, tri,                           &
                                nb_levels, levels,                      &
                                linespec, linewidth,                    &
                                labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: x, y, z, tri
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:), &
                                       tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: present_color
      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: icolor, istyle, idummy, n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      real(kind=MF_DOUBLE) :: val
      logical :: z_is_finite
      integer :: i, status

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z, tri )

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( z, z_ptr, no_crc=.true. )
      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y' and 'z' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(z_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'z' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, idummy )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Here, we are sure that 'z' contains non-finite values.
         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr(:,1), y_ptr(:,1), z_ptr(:,1),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr(1,:), y_ptr(1,:), z_ptr(1,:),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( x, x_ptr )
            call msFreePointer( y, y_ptr )
            call msFreePointer( z, z_ptr )
            call msFreePointer( tri, tri_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

      else

         ! Here, 'z' doesn't contain non-finite values.
         ! We can copy all nodes, triangles and z-values in xy_sto_pg,
         ! z_sto_pg and tri_sto_pg...
         allocate( xy_sto_pg(nn,2), z_sto_pg(nn) )

         allocate( tri_sto_pg(ntri,3) )

         if( p_dim == 1 ) then
            xy_sto_pg(:,1) = x_ptr(:,1)
            xy_sto_pg(:,2) = y_ptr(:,1)
            z_sto_pg(:)   = z_ptr(:,1)
         else
            xy_sto_pg(:,1) = x_ptr(1,:)
            xy_sto_pg(:,2) = y_ptr(1,:)
            z_sto_pg(:)   = z_ptr(1,:)
         end if
         tri_sto_pg(:,:) = tri_ptr(:,:)

      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( z, z_ptr )
      call msFreePointer( tri, tri_ptr )

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then
         ! Extracting the levels' vector
         call msPointer( levels, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels, levels_ptr )

         handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg, n_level, &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle,            &
                              linewidth_d,                              &
                              levels_sto_pg=levels_sto_pg )

      else
         handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg, n_level, &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle,            &
                              linewidth_d )
      end if

 99   continue

      call msFreeArgs( x, y, z, tri )
      call msAutoRelease( x, y, z, tri )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContour_xyz
#endif
#ifdef _MF_SUBR
   end subroutine msTriContour_xyz
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContour_xyz_out( out, x, y, z, tri,                    &
                                  nb_levels, levels,                    &
                                  linespec, linewidth,                  &
                                  labels, labelscolor, labelsize )                  &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriContour_xyz_out( out, x, y, z, tri,                  &
                                    nb_levels, levels,                  &
                                    linespec, linewidth,                &
                                    labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: x, y, z, tri
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:), &
                                       tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: present_color
      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: icolor, istyle, idummy, n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      real(kind=MF_DOUBLE) :: val
      logical :: z_is_finite
      integer :: i, status
#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z, tri )

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x, y, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'tri' is allocated
      if( mfIsEqual(tri,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' not allocated!" )
         go to 99
      end if

      ! 'tri' must be Real
      if( .not. mfIsReal(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' must be real!" )
         go to 99
      end if

      ! 'tri' cannot be sparse
      if( mfIsSparse(tri) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )
      call msPointer( z, z_ptr, no_crc=.true. )
      call msPointer( tri, tri_ptr, no_crc=.true. )

      ! checking that 'x' is a vector
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a vector!" )
         go to 99
      end if

      ! checking that 'y' is a vector
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a vector!" )
         go to 99
      end if

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      ! checking that 'x', 'y' and 'z' have the same shape
      if( any( shape(x_ptr) /= shape(y_ptr) ) .or.                      &
          any( shape(x_ptr) /= shape(z_ptr) ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'z' must have the same shape!" )
         go to 99
      end if

      if( size(x_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      nn = size(x_ptr,p_dim)
      ntri = size(tri,1)

      ! checking that 'tri' array is a valid triangulation
      if( size(tri,2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "(array must have 3 columns)" )
         go to 99
      end if
      index_min = minval(tri_ptr)
      index_max = maxval(tri_ptr)
      if( index_min /= 1 .and. index_max /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri' is not a valid triangulation!",      &
                            "('tri' indexes must be ranged between 1 and nb of elements in 'x')" )
         go to 99
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, idummy )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Here, we are sure that 'z' contains non-finite values.
         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr(:,1), y_ptr(:,1), z_ptr(:,1),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr(1,:), y_ptr(1,:), z_ptr(1,:),   &
                                  int(tri_ptr),                         &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call msFreePointer( x, x_ptr )
            call msFreePointer( y, y_ptr )
            call msFreePointer( z, z_ptr )
            call msFreePointer( tri, tri_ptr )
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

      else

         ! Here, 'z' doesn't contain non-finite values.
         ! We can copy all nodes, triangles and z-values in xy_sto_pg,
         ! z_sto_pg and tri_sto_pg...
         allocate( xy_sto_pg(nn,2), z_sto_pg(nn) )

         allocate( tri_sto_pg(ntri,3) )

         if( p_dim == 1 ) then
            xy_sto_pg(:,1) = x_ptr(:,1)
            xy_sto_pg(:,2) = y_ptr(:,1)
            z_sto_pg(:)   = z_ptr(:,1)
         else
            xy_sto_pg(:,1) = x_ptr(1,:)
            xy_sto_pg(:,2) = y_ptr(1,:)
            z_sto_pg(:)   = z_ptr(1,:)
         end if
         tri_sto_pg(:,:) = tri_ptr(:,:)

      end if

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )
      call msFreePointer( z, z_ptr )
      call msFreePointer( tri, tri_ptr )

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then
         ! Extracting the levels' vector
         call msPointer( levels, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels, levels_ptr )

         handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg, n_level, &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle,            &
                              linewidth_d,                              &
                              levels_sto_pg=levels_sto_pg )

      else
         handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg, n_level, &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle,            &
                              linewidth_d )
      end if

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( x, y, z, tri )
      call msAutoRelease( x, y, z, tri )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContour_xyz_out
#endif
#ifdef _MF_SUBR
   end subroutine msTriContour_xyz_out
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContour_tri_conn( z, tri_connect,                      &
                                   nb_levels, levels,                   &
                                   linespec, linewidth,                 &
                                   labels, labelscolor, labelsize )     &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriContour_tri_conn( z, tri_connect,                    &
                                     nb_levels, levels,                 &
                                     linespec, linewidth,               &
                                     labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: z
      type(mfTriConnect),   intent(in)           :: tri_connect
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      ! pointers to avoid copy of data
      real(kind=MF_DOUBLE), pointer :: x_ptr(:), y_ptr(:)
      integer, pointer :: tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: present_color
      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: icolor, istyle, idummy, n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      real(kind=MF_DOUBLE) :: val
      logical :: z_is_finite
      integer :: i, status

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      if( .not. tri_connect%init ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri_connect' doesn't seem to be a valid triangle connectivity!",     &
                            "-> did you initialize it using msBuildTriConnect?" )
         go to 99
      end if

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      nn = size( tri_connect%n_xy, 1 )

      ! checking that 'z' has the appropriate size
      if( size(z_ptr) /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad size for 'z'!" )
         go to 99
      end if

      if( size(z_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, idummy )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Using x_ptr, y_ptr and tri_ptr to re-use the same algorithm
         ! than used in the 'TriContour_xyz' routine.

         ! x_ptr doit pointer sur les valeurs de 'x' dans tri_connect%n_xy
         x_ptr => tri_connect%n_xy(:,1)

         ! y_ptr doit pointer sur les valeurs de 'y' dans tri_connect%n_xy
         y_ptr => tri_connect%n_xy(:,2)

         ! tri_ptr doit pointer sur la définition des triangles
         !         dans tri_connect%tri_n
         tri_ptr => tri_connect%tri_n

         ntri = size(tri_connect%tri_n,1)

         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(:,1), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(1,:), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         x_ptr => null()
         y_ptr => null()
         call msFreePointer( z, z_ptr )
         tri_ptr => null()

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

         if( present(levels) ) then
            ! Extracting the levels' vector
            call msPointer( levels, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels, levels_ptr )

            handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg,       &
                            n_level, draw_labels, lab_color, lab_size,  &
                            icolor, present_color, istyle,              &
                            linewidth_d,                                &
                            levels_sto_pg=levels_sto_pg )

         else
            handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg,       &
                            n_level, draw_labels, lab_color, lab_size,  &
                            icolor, present_color, istyle,              &
                            linewidth_d )
         end if

      else

         allocate( z_sto_pg(nn) )

         if( p_dim == 1 ) then
            z_sto_pg(:)   = z_ptr(:,1)
         else
            z_sto_pg(:)   = z_ptr(1,:)
         end if

         call msFreePointer( z, z_ptr )

         if( present(levels) ) then
            ! Extracting the levels' vector
            call msPointer( levels, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels, levels_ptr )

            handle = ContourTriConnect( tri_connect%n_xy, z_sto_pg,     &
                              tri_connect%tri_n, tri_connect%face_n,    &
                              tri_connect%face_tri, tri_connect%tri_f,  &
                              draw_labels, lab_color, lab_size, icolor, &
                              present_color, istyle, linewidth_d,       &
                              n_level, levels_sto_pg=levels_sto_pg )
         else
            handle = ContourTriConnect( tri_connect%n_xy, z_sto_pg,     &
                              tri_connect%tri_n, tri_connect%face_n,    &
                              tri_connect%face_tri, tri_connect%tri_f,  &
                              draw_labels, lab_color, lab_size, icolor, &
                              present_color, istyle, linewidth_d,       &
                              n_level )
         end if

      end if

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContour_tri_conn
#endif
#ifdef _MF_SUBR
   end subroutine msTriContour_tri_conn
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfTriContour_tri_conn_out( out, z, tri_connect,             &
                                       nb_levels, levels,               &
                                       linespec, linewidth,             &
                                       labels, labelscolor, labelsize ) &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msTriContour_tri_conn_out( out, z, tri_connect,           &
                                         nb_levels, levels,             &
                                         linespec, linewidth,           &
                                         labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: z
      type(mfTriConnect),   intent(in)           :: tri_connect
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! tracé d'isovaleurs sur un maillage triangulaire.

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      ! pointers to avoid copy of data
      real(kind=MF_DOUBLE), pointer :: x_ptr(:), y_ptr(:)
      integer, pointer :: tri_ptr(:,:)

      integer :: mf_message_level_save
      integer :: p_dim, index_min, index_max, nn, ntri
      real(kind=MF_DOUBLE), pointer :: xy_sto_pg(:,:), z_sto_pg(:)
      integer, pointer :: tri_sto_pg(:,:)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      logical :: present_color
      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: icolor, istyle, idummy, n_level
      real(kind=MF_DOUBLE) :: linewidth_d
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)

      real(kind=MF_DOUBLE) :: val
      logical :: z_is_finite
      integer :: i, status

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfTriContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msTriContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )

      if( .not. tri_connect%init ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'tri_connect' doesn't seem to be a valid triangle connectivity!",     &
                            "-> did you initialize it using msBuildTriConnect?" )
         go to 99
      end if

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be Real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ! checking that 'z' is a vector
      if( size(z_ptr,1)/=1 .and. size(z_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be a vector!" )
         go to 99
      end if

      nn = size( tri_connect%n_xy, 1 )

      ! checking that 'z' has the appropriate size
      if( size(z_ptr) /= nn ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad size for 'z'!" )
         go to 99
      end if

      if( size(z_ptr,1) /= 1 ) then
         p_dim = 1
      else
         p_dim = 2
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, idummy )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      ! To support NaN or Inf values in the z array, we have to check the
      ! presence of non finite values.
      z_is_finite = .true.
      do i = 1, nn
         if( p_dim == 1 ) then
            val = z_ptr(i,1)
         else
            val = z_ptr(1,i)
         end if
         if( .not. isfinite(val) ) then
            z_is_finite = .false.
            exit
         end if
      end do

      if( .not. z_is_finite ) then

         ! Using x_ptr, y_ptr and tri_ptr to re-use the same algorithm
         ! than used in the 'TriContour_xyz' routine.

         ! x_ptr doit pointer sur les valeurs de 'x' dans tri_connect%n_xy
         x_ptr => tri_connect%n_xy(:,1)

         ! y_ptr doit pointer sur les valeurs de 'y' dans tri_connect%n_xy
         y_ptr => tri_connect%n_xy(:,2)

         ! tri_ptr doit pointer sur la définition des triangles
         !         dans tri_connect%tri_n
         tri_ptr => tri_connect%tri_n

         ntri = size(tri_connect%tri_n,1)

         ! We have to store in xy_sto_pg, z_sto_pg and tri_sto_pg
         ! only the valid elements...
         if( p_dim == 1 ) then
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(:,1), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         else
            call clean_x_y_z_tri( x_ptr, y_ptr, z_ptr(1,:), tri_ptr,    &
                                  xy_sto_pg, z_sto_pg, tri_sto_pg,      &
                                  status )
         end if

         x_ptr => null()
         y_ptr => null()
         call msFreePointer( z, z_ptr )
         tri_ptr => null()

         if( status == -1 ) then
            ! new number of triangles is zero, so it is safe to quit
            ! (*_sto_pg arrays are already deallocated)
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "due to the great number of non-finite values in 'z',", &
                               "there is no more valid triangle in the mesh." )
            go to 99
         end if

         if( present(levels) ) then
            ! Extracting the levels' vector
            call msPointer( levels, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels, levels_ptr )

            handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg,       &
                            n_level, draw_labels, lab_color, lab_size,  &
                            icolor, present_color, istyle,              &
                            linewidth_d,                                &
                            levels_sto_pg=levels_sto_pg )

         else
            handle = ContourTri( xy_sto_pg, z_sto_pg, tri_sto_pg,       &
                            n_level, draw_labels, lab_color, lab_size,  &
                            icolor, present_color, istyle,              &
                            linewidth_d )
         end if

      else

         allocate( z_sto_pg(nn) )

         if( p_dim == 1 ) then
            z_sto_pg(:) = z_ptr(:,1)
         else
            z_sto_pg(:) = z_ptr(1,:)
         end if

         call msFreePointer( z, z_ptr )

         if( present(levels) ) then
            ! Extracting the levels' vector
            call msPointer( levels, levels_ptr, no_crc=.true. )
            if( size(levels_ptr,1) == 1 ) then
               n_level = size(levels_ptr,2)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(1,:)
            else
               n_level = size(levels_ptr,1)
               allocate( levels_sto_pg(n_level) )

               levels_sto_pg(:) = levels_ptr(:,1)
            end if
            call msFreePointer( levels, levels_ptr )

            handle = ContourTriConnect( tri_connect%n_xy, z_sto_pg,     &
                              tri_connect%tri_n, tri_connect%face_n,    &
                              tri_connect%face_tri, tri_connect%tri_f,  &
                              draw_labels, lab_color, lab_size, icolor, &
                              present_color, istyle, linewidth_d,       &
                              n_level, levels_sto_pg=levels_sto_pg )
         else
            handle = ContourTriConnect( tri_connect%n_xy, z_sto_pg,     &
                              tri_connect%tri_n, tri_connect%face_n,    &
                              tri_connect%face_tri, tri_connect%tri_f,  &
                              draw_labels, lab_color, lab_size, icolor, &
                              present_color, istyle, linewidth_d,       &
                              n_level )
         end if

      end if

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfTriContour_tri_conn_out
#endif
#ifdef _MF_SUBR
   end subroutine msTriContour_tri_conn_out
#endif
