!_______________________________________________________________________
!
   subroutine mf_text_draw( grobj, rxbox, rybox )

      type(grobj_elem), intent(in)   :: grobj
      real(kind=MF_DOUBLE), optional :: rxbox(4), rybox(4)
      !------ API end ------

      ! grobj type = "text"

      type(mf_win_info), pointer :: win

      character(len=1024) :: text, text2
      character :: c
      integer :: ic, j, len_text
      integer :: ibgcol
      real(kind=MF_DOUBLE) :: x_s, y_s, relative_height
      logical :: pixvoffset

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( associated(grobj%struct%text) ) then
         len_text = size(grobj%struct%text)
      else
         len_text = 0
      end if
      text = ""
      text2 = ""
      do j = 1, len_text
         c = grobj%struct%text(j)
         text(j:j) = c
         ! avoid putting non printable character (which
         ! will be interpreted as binary characters) in the
         ! ISO-8859-15 EPS and PDF documents: text2 is modified!
         ic = iachar(c)
         if( ic < 32 .or. ic == 127 ) then
            text2(j:j) = " "
         else
            text2(j:j) = c
         end if
      end do

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, '%-- begin of Text: "'//trim(text2)//'"', 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, '%-- begin of Text: "'//trim(text2)//'"', 0 )
         end if
         gr_pdf_color_intent = 2 ! Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(rxbox) .neqv. present(rybox) ) then
         print "(/,A)", "(Muesli FGL) mf_text_draw: internal error."
         print "(   )", "             args 'rxbox' and 'rybox must be both present or absent!"
         pause "for debugging purpose only"
         stop
      end if

      call grsci(grobj%struct%color) ! set color index
      ibgcol = grobj%struct%linestyle
      call pgstbg( ibgcol )
      relative_height = grobj%struct%height_text
      call pgsch( relative_height * win%char_height_factor ) ! char. height
      x_s = grobj%struct%x_text
      y_s = grobj%struct%y_text
      if( win%axis_scale_x == 2 ) then
         x_s = log10(x_s)
      end if
      if( win%axis_scale_y == 2 ) then
         y_s = log10(y_s)
      end if
      pixvoffset = grobj%struct%bool2

      if( present(rxbox) ) then
         call pgptxt( x_s, y_s, grobj%struct%ang_text,                  &
                      grobj%struct%just_text, grobj%struct%just_vert_text, &
                      text, clipping=grobj%struct%bool1,                &
                      rxbox=rxbox, rybox=rybox, pix_voffset=pixvoffset )
      else
         call pgptxt( x_s, y_s, grobj%struct%ang_text,                  &
                      grobj%struct%just_text, grobj%struct%just_vert_text, &
                      text, clipping=grobj%struct%bool1,                &
                      pix_voffset=pixvoffset )
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Text", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Text", 0 )
         end if
      end if

   end subroutine mf_text_draw
