!_______________________________________________________________________
!
   function TextCore( x, y, text, angle, just, just_vert, icol, ibgcol, &
                      height, clipped, rxbox, rybox, pixvoffset )                                         &
   result( handle )

      real(kind=MF_DOUBLE), intent(in) :: x, y
      character(len=*),     intent(in) :: text

      ! angle in degrees
      ! just for horizontal justification (continuous)
      ! just_vert for horizontal justification (continuous)
      ! 0. for left (default), 0.5 for centered, 1. for right
      real(kind=MF_DOUBLE), intent(in) :: angle, just, just_vert

      ! color convention is the same as for msPlot (or Matlab), i.e.
      ! "b" = blue
      ! "r" = red, etc.
      integer, intent(in) :: icol   ! foreground
      integer, intent(in) :: ibgcol ! background
      ! char height (default : 1.0)
      ! in MFPLOT, unit is 1/40 the height of the view surface (in
      ! landscape mode), only if mode is relative...
      real(kind=MF_DOUBLE), intent(in) :: height
      real(kind=MF_DOUBLE)             :: rxbox(4), rybox(4)
      logical, intent(in) :: clipped, pixvoffset

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: len_text
      character(len=len(text)) :: text_latin_1

      real(kind=MF_DOUBLE) :: x_s, y_s, angle_s, just_s, just_vert_s
      real(kind=MF_DOUBLE) :: relative_height
      integer :: i, hdle, n_trim
      real(kind=MF_DOUBLE) :: x2_s, y2_s

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( "mfText", "E",                              &
                            "no X11 device selected." )
         handle = 0
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( .not. clipped ) then
         win%at_least_one_grobj_not_clipped = .true.
      end if

      if( win%char_height_factor < 0.0d0 ) then
         ! must be defined
         call char_height_factor_update( CURRENT_WIN_ID )
      end if

      x_s = x
      y_s = y

      angle_s = angle
      just_s = just
      just_vert_s = just_vert

      relative_height = height

      ! contrary to the case of 'PlotCore', there is no need to prepare
      ! axes; the default behavior is then: text is superimposed on the
      ! graph and there is no need to hold the plot.

      if( UTF8_ENCODING ) then
         text_latin_1  = utf8_to_latin_1( trim(text) )
      else
         text_latin_1 = trim(text)
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "text"
      len_text = len_trim(text_latin_1)
      allocate( grobj%struct%text(len_text) )

      do i = 1, len_text
         grobj%struct%text(i) = text_latin_1(i:i)
      end do
      grobj%struct%x_text = x_s
      grobj%struct%y_text = y_s
      grobj%struct%ang_text = angle_s
      grobj%struct%just_text = just_s
      grobj%struct%just_vert_text = just_vert_s
      grobj%struct%height_text = relative_height
      grobj%struct%color = icol
      grobj%struct%linestyle = ibgcol
      grobj%struct%bool1 = clipped
      grobj%struct%bool2 = pixvoffset

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_text_draw( grobj, rxbox, rybox )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

      if( win%axis_scale_x == 2 ) then
         rxbox = 10.0d0 ** rxbox
      end if
      if( win%axis_scale_y == 2 ) then
         rybox = 10.0d0 ** rybox
      end if
      if( ibgcol > 0 ) then
         call pgstbg( -1 )
      end if

   end function TextCore
