!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_real_1_str_2_str( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_real_1_str_2_str( x, y, text,                  &
                               angle, just, just_vert, pix_voffset,     &
                               color, bg, height, clipping, xbox, ybox )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      character(len=*),     intent(in)           :: color
      ! same for background
      character(len=*),     intent(in)           :: bg

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4

      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      integer :: icol, ibgcol, ier
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just is out of [-1,+1]!",               &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(text color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = 1 ! foreground color
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( len_trim(bg) == 1 .or. bg(1:1) == "\" ) then
         call decode_linespec( bg, ibgcol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'bg' argument!",                     &
                              "(background color will be set to transparent)" )
            ibgcol = -127
         end if
      else
         call decode_col_name( bg, ibgcol )
      end if

      if( ibgcol == -127 ) then
         ibgcol = -1 ! default background is transparent
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x, y, text,                                    &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

#ifdef _MF_FUNC
   end function mfText_pos_real_1_str_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_real_1_str_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_real_1_str_2_rgb( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_real_1_str_2_rgb( x, y, text,                  &
                               angle, just, just_vert, pix_voffset,     &
                               color, bg, height, clipping, xbox, ybox )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      character(len=*),     intent(in)           :: color
      ! same for background
      real(kind=MF_DOUBLE), intent(in), optional :: bg(3)

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4

      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      integer :: icol, ibgcol, ier
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just is out of [-1,+1]!",               &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(text color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = 1 ! foreground color
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( present(bg) ) then
         call decode_col_rgb( bg, ibgcol )
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x, y, text,                                    &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

#ifdef _MF_FUNC
   end function mfText_pos_real_1_str_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_real_1_str_2_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_real_1_rgb_2_str( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_real_1_rgb_2_str( x, y, text,                  &
                               angle, just, just_vert, pix_voffset,     &
                               color, bg, height, clipping, xbox, ybox )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      ! same for background
      character(len=*),     intent(in)           :: bg

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4

      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      integer :: icol, ibgcol, ier
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just is out of [-1,+1]!",               &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( len_trim(bg) == 1 .or. bg(1:1) == "\" ) then
         call decode_linespec( bg, ibgcol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'bg' argument!",                  &
                              "(background color will be set to transparent)" )
            ibgcol = -127
         end if
      else
         call decode_col_name( bg, ibgcol )
      end if

      if( ibgcol == -127 ) then
         ibgcol = -1 ! default background is transparent
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x, y, text,                                    &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

#ifdef _MF_FUNC
   end function mfText_pos_real_1_rgb_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_real_1_rgb_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_real_1_rgb_2_rgb( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_real_1_rgb_2_rgb( x, y, text,                  &
                               angle, just, just_vert, pix_voffset,     &
                               color, bg, height, clipping, xbox, ybox )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      ! same for background
      real(kind=MF_DOUBLE), intent(in), optional :: bg(3)

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4

      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      integer :: icol, ibgcol, ier
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just is out of [-1,+1]!",               &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( present(bg) ) then
         call decode_col_rgb( bg, ibgcol )
      end if

      if( ibgcol == -127 ) then
         ibgcol = -1 ! default background is transparent
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x, y, text,                                    &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

#ifdef _MF_FUNC
   end function mfText_pos_real_1_rgb_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_real_1_rgb_2_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_mf_1_str_2_str( x, y, text,                      &
                           angle, just, just_vert, pix_voffset,         &
                           color, bg, height, clipping, xbox, ybox )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_mf_1_str_2_str( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )
#endif

      type(mfArray),        intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      character(len=*),     intent(in)           :: color
      ! same for background
      character(len=*),     intent(in)           :: bg

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4
      !
      ! If the string is far away from the current viewport, then
      ! xbox and ybox may contain NaN values.

      real(kind=MF_DOUBLE) :: x_d, y_d
      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      real(kind=MF_DOUBLE) :: vec_d(1)
      integer :: icol, ibgcol, ier
      integer :: status
      character(len=80) :: string
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is of a scalar
      if( Size(x) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( x, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      x_d = vec_d(1)

      ! checking that 'y' is of a scalar
      if( Size(y) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( y, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      y_d = vec_d(1)

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "justification is out of [-1,+1]!",      &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(text color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = 1 ! foreground color
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( len_trim(bg) == 1 .or. bg(1:1) == "\" ) then
         call decode_linespec( bg, ibgcol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'bg' argument!",                     &
                              "(background color will be set to transparent)" )
            ibgcol = -127
         end if
      else
         call decode_col_name( bg, ibgcol )
      end if

      if( ibgcol == -127 ) then
         ibgcol = -1 ! default background is transparent
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x_d, y_d, text,                                &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfText_pos_mf_1_str_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_mf_1_str_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_mf_1_str_2_rgb( x, y, text,                      &
                           angle, just, just_vert, pix_voffset,         &
                           color, bg, height, clipping, xbox, ybox )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_mf_1_str_2_rgb( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )
#endif

      type(mfArray),        intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      character(len=*),     intent(in)           :: color
      ! same for background
      real(kind=MF_DOUBLE), intent(in), optional :: bg(3)

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4
      !
      ! If the string is far away from the current viewport, then
      ! xbox and ybox may contain NaN values.

      real(kind=MF_DOUBLE) :: x_d, y_d
      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      real(kind=MF_DOUBLE) :: vec_d(1)
      integer :: icol, ibgcol, ier
      integer :: status
      character(len=80) :: string
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is of a scalar
      if( Size(x) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( x, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      x_d = vec_d(1)

      ! checking that 'y' is of a scalar
      if( Size(y) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( y, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      y_d = vec_d(1)

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "justification is out of [-1,+1]!",      &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default values
      icol = 1 ! foreground color

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(text color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = 1 ! foreground color
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( present(bg) ) then
         call decode_col_rgb( bg, ibgcol )
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x_d, y_d, text,                                &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfText_pos_mf_1_str_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_mf_1_str_2_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_mf_1_rgb_2_str( x, y, text,                      &
                           angle, just, just_vert, pix_voffset,         &
                           color, bg, height, clipping, xbox, ybox )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_mf_1_rgb_2_str( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )
#endif

      type(mfArray),        intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      ! same for background
      character(len=*),     intent(in)           :: bg

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4
      !
      ! If the string is far away from the current viewport, then
      ! xbox and ybox may contain NaN values.

      real(kind=MF_DOUBLE) :: x_d, y_d
      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      real(kind=MF_DOUBLE) :: vec_d(1)
      integer :: icol, ibgcol, ier
      integer :: status
      character(len=80) :: string
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is of a scalar
      if( Size(x) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( x, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      x_d = vec_d(1)

      ! checking that 'y' is of a scalar
      if( Size(y) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( y, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      y_d = vec_d(1)

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "justification is out of [-1,+1]!",      &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default value
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      ! default values
      ibgcol = -1 ! transparent

      if( len_trim(bg) == 1 .or. bg(1:1) == "\" ) then
         call decode_linespec( bg, ibgcol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'bg' argument!",                     &
                              "(background color will be set to transparent)" )
            ibgcol = -127
         end if
      else
         call decode_col_name( bg, ibgcol )
      end if

      if( ibgcol == -127 ) then
         ibgcol = -1 ! default background is transparent
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x_d, y_d, text,                                &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfText_pos_mf_1_rgb_2_str
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_mf_1_rgb_2_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfText_pos_mf_1_rgb_2_rgb( x, y, text,                      &
                           angle, just, just_vert, pix_voffset,         &
                           color, bg, height, clipping, xbox, ybox )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msText_pos_mf_1_rgb_2_rgb( x, y, text,                    &
                             angle, just, just_vert, pix_voffset,       &
                             color, bg, height, clipping, xbox, ybox )
#endif

      type(mfArray),        intent(in)           :: x, y
      character(len=*),     intent(in)           :: text

      ! optional arg. : angle in degrees
      real(kind=MF_DOUBLE), intent(in), optional :: angle

      ! optional args. : just for horizontal justification
      !                  just_vert for vertical just. (both continuous)
      !           -1 for left (default), 0 for centered, 1 for right
      ! [MFPLOT choice is:
      !       0. for left (default), 0.5 for centered, 1. for right]
      real(kind=MF_DOUBLE), intent(in), optional :: just, just_vert

      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      ! same for background
      real(kind=MF_DOUBLE), intent(in), optional :: bg(3)

      ! character height depends on the 'char_height_pixel' property
      ! (see subroutine msCharInPixels)
      real(kind=MF_DOUBLE), intent(in), optional :: height

      logical,              intent(in), optional :: clipping, pix_voffset
      real(kind=MF_DOUBLE),             optional :: xbox(4), ybox(4)

      integer :: handle
      !------ API end ------

      ! xbox(4) and ybox(4) are the user-coordinates of a bounding
      ! box for the string. The order of the four corners is:
      !
      !                2 +----------------------------+ 3
      !                  |                            |
      !                  |                            |
      !                1 +----------------------------+ 4
      !
      ! If the string is far away from the current viewport, then
      ! xbox and ybox may contain NaN values.

      real(kind=MF_DOUBLE) :: x_d, y_d
      real(kind=MF_DOUBLE) :: angle_d, just_d, just_vert_d, height_d
      real(kind=MF_DOUBLE) :: vec_d(1)
      integer :: icol, ibgcol
      integer :: status
      character(len=80) :: string
      logical :: clipped, pixvoffset
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: rxbox(4), rybox(4)
      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfText"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msText"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      call msInitArgs( x, y )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is of a scalar
      if( Size(x) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( x, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      x_d = vec_d(1)

      ! checking that 'y' is of a scalar
      if( Size(y) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be a scalar!" )
         go to 99
      end if

      call extract_vector_from_mfArray( y, vec_d, status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y'" // trim(string) )
         go to 99
      end if
      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if
      y_d = vec_d(1)

      if( present(angle) ) then
         angle_d = angle
      else
         angle_d = 0.0d0
      end if

      if( present(just) ) then
         if( just < -1.0d0 .or. +1.0d0 < just ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "justification is out of [-1,+1]!",      &
                               "-> string will be left justified" )
            return
            just_d = 0.0d0
         else
            just_d = (just+1.0d0)/2.0d0
         end if
      else
         just_d = 0.0d0
      end if

      if( present(just_vert) ) then
         if( just_vert < -1.0d0 .or. +1.0d0 < just_vert ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "just_vert is out of [-1,+1]!",          &
                               "-> string will be left justified" )
            return
            just_vert_d = 0.0d0
         else
            just_vert_d = (just_vert+1.0d0)/2.0d0
         end if
      else
         just_vert_d = 0.0d0
      end if

      ! default value
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      ! default value
      ibgcol = -1 ! transparent

      if( present(bg) ) then
         call decode_col_rgb( bg, ibgcol )
      end if

      if( present(height) ) then
         height_d = height
      else
         height_d = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( present(pix_voffset) ) then
         pixvoffset = pix_voffset
      else
         pixvoffset = .false.
      end if

      handle = TextCore( x_d, y_d, text,                                &
                         angle_d, just_d, just_vert_d, icol, ibgcol,    &
                         height_d, clipped, rxbox, rybox, pixvoffset )

      if( present(xbox) ) then
         xbox(1:4) = rxbox(1:4)
      end if
      if( present(ybox) ) then
         ybox(1:4) = rybox(1:4)
      end if

 99   continue

      call msFreeArgs( x, y )
      call msAutoRelease( x, y )

#ifdef _MF_FUNC
   end function mfText_pos_mf_1_rgb_2_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msText_pos_mf_1_rgb_2_rgb
#endif
