!_______________________________________________________________________
!
   subroutine mf_streamline_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "streamline"

      integer :: k, n, n_arrow
      real(kind=MF_DOUBLE) :: x_pg_4(4), y_pg_4(4)
      integer :: icol_pg_4(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Streamline", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Streamline", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color)
      n = size(grobj%struct%val_mat,1)
      if( n == 1 ) then
         call grsms( 1.0d0 )
         call pgpt( n, grobj%struct%val_mat(:,1),                       &
                       grobj%struct%val_mat(:,2), symbol=1 )
      else
         call grslw(grobj%struct%linewidth)
         call grsls( grobj%struct%linestyle ) ! set line style
         call pgline( n, grobj%struct%val_mat(:,1),                     &
                         grobj%struct%val_mat(:,2) )
         call pgsch(grobj%struct%height_text)
         n_arrow = grobj%struct%marker
         do k = 1, n_arrow
            call pgarro_head_only( grobj%struct%abs_mat(k,1),           &
                                   grobj%struct%abs_mat(k,2),           &
                                   grobj%struct%abs_mat(k,3) )
         end do
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Streamline", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Streamline", 0 )
         end if
      end if

   end subroutine mf_streamline_draw
