!
! codes pour mf_win_redraw : (et get_true_min_max)
!
!   grobj%struct%npt3 = -1 : vertex centered [default]
!                       -2 :   cell centered
!

!_______________________________________________________________________
!
   function StreamlineCore( x, y, u, v, start, direction, n_arrow,      &
                            icol, istyle, linewidth, arrow_head,        &
                            tri_connect, range,                         &
                            npt_max, curv_tol, stop_zone )                         &
   result( handle )

      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:), u(:), v(:)
      real(kind=MF_DOUBLE), intent(in) :: start(2)
      integer,              intent(in) :: direction, n_arrow, icol, istyle
      real(kind=MF_DOUBLE), intent(in) :: linewidth, arrow_head
      type(mfTriConnect),   intent(in) :: tri_connect
      real(kind=MF_DOUBLE), intent(in) :: range(4), curv_tol
      integer,              intent(in) :: npt_max

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer :: handle
      !------ API end ------

      ! Here, 'tri_connect'  (triangles connectivity) doesn't need to be
      ! complete. The following components of the mfTriConnect derived type
      ! may be left empty (i.e. not allocated):
      !        'n_xy', 'nodes_sorted_x', 'nodes_sorted_y' and 'n_tri'
      !
      ! This is the case when the current routine is called from a structured
      ! mesh (cf. Streamline.F90)

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      ! 'direction' of integration:
      !   1 : only forward
      !   2 : only backward
      !   3 : both

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      integer :: i, hdle

      real(kind=MF_DOUBLE), pointer :: coords(:,:)

      integer :: k, n, status, kk, n_arrow_0
      real(kind=MF_DOUBLE) :: x0, y0, ss, x1, y1, xm, ym, angle, dx, dy
      real(kind=MF_DOUBLE), allocatable :: s(:)
      logical :: x_axes_inverted, y_axes_inverted
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor
      character(len=80) :: string

   !------ end of declarations -- execution starts hereafter  ------

      x0 = start(1)
      y0 = start(2)

      call mf_save_and_disable_fpe( )

      call stream_main( x, y, u, v, tri_connect, x0, y0,                &
                        npt_max, curv_tol, direction, n,                &
                        coords, status, stop_zone )

      if( status == -2 ) then
         write(string,"(A,G0.4,A,G0.4,A)") "Start point (", x0, ", ", y0, &
                                           ") is outside the domain!"
         call PrintMessage( "Streamline", "W",                          &
                            trim(string) )
         ! Coords is not allocated: cannot continue
         handle = 0
         return
      end if

      if( n == 1 ) then
         call PrintMessage( "Streamline", "I",                          &
                            "The path is reduced to only one point!" )
      end if

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      ! Plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! Caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      if( n > 1 ) then

         ! Travel through the nodes for computing the pseudo curvilinear
         ! abscissa.
         allocate( s(n) )
         s(1) = 0.
         do i = 2, n
            s(i) = s(i-1) + sqrt( (coords(i,1)-coords(i-1,1))**2        &
                                + (coords(i,2)-coords(i-1,2))**2 )
         end do

         if( n_arrow == 0 ) then

            ! The user may have chose a zero value to remove the arrow heads
            n_arrow_0 = 0

         else

            ! Arrows are added at equal intervals (total curve length is
            ! divided in 2*n_arrow segments) and they are located at
            ! abscissa 1, 3, ... till 2*n_arrow-1

            ! This imply a sufficient nb of points in the path: we must have
            !                       n >= 2*n_arrow+1
            ! therefore
            !                 n_arrow <= (n-1)/2
            !
            ! However, as the abscissa may be strongly unequal, it is
            ! preferable to add some guard-indices (see below)
            if( n >= 2*n_arrow+3 ) then
               n_arrow_0 = n_arrow
            else
               ! Avoid a zero number of arrows
               n_arrow_0 = max( 1, (n-3)/2 )
               call PrintMessage( "Streamline", "I",                    &
                                  "Due to the small number of points in the path,", &
                                  "the number of arrows has been reduced!" )
            end if

            ! Used to save indices for arrow location on the streamline path
            allocate( grobj%struct%abs_mat(n_arrow_0,3) )

         end if

         ! The arrow head direction depends on axis orientation
         if( win%current_axes(1) < win%current_axes(2) ) then
            x_axes_inverted = .false.
         else
            x_axes_inverted = .true.
         end if
         if( win%current_axes(3) < win%current_axes(4) ) then
            y_axes_inverted = .false.
         else
            y_axes_inverted = .true.
         end if

         kk = 0
         do k = 1, 2*n_arrow_0-1, 2

            ss = k*s(n)/(2*n_arrow_0)
            ! Search for index i such that s(i)=ss
            do i = 1, n
               if( s(i) > ss ) exit
            end do
            i = i - 1
            kk = kk + 1
            if( i < 1 .or. n < i ) cycle
            x0 = coords(i,1)
            y0 = coords(i,2)
            if( i+1 > n ) cycle
            x1 = coords(i+1,1)
            y1 = coords(i+1,2)
            xm = (x0+x1)/2.
            ym = (y0+y1)/2.
            if( x_axes_inverted ) then
               dx = x0 - x1
            else
               dx = x1 - x0
            end if
            if( y_axes_inverted ) then
               dy = y0 - y1
            else
               dy = y1 - y0
            end if
            angle = atan2( dy, dx )

            grobj%struct%abs_mat(kk,:) = [ xm, ym, angle ]

         end do

         deallocate( s )

      end if ! n > 1

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! The creation of the grobj is located before the computation
      ! of the pseudo curvilinear abscissa.

      grobj%struct%cmd = "streamline"
      grobj%struct%range = range
      grobj%struct%val_mat => coords

      grobj%struct%color = icol
      grobj%struct%linewidth = linewidth
      grobj%struct%linestyle = istyle
      grobj%struct%marker = n_arrow_0
      grobj%struct%height_text = arrow_head

      grobj%struct%npt3 = -1

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_streamline_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

      call mf_restore_fpe( )

   end function StreamlineCore
!_______________________________________________________________________
!
   subroutine stream_main( x, y, u, v, tri_connect, x0, y0,             &
                           npt_max, curv_tol, direction,                &
                           n, coords, status, stop_zone )

      real(kind=MF_DOUBLE), intent(in)  :: x(:), y(:), u(:), v(:)
      type(mfTriConnect)                :: tri_connect
      real(kind=MF_DOUBLE), intent(in)  :: x0, y0
      integer,              intent(in)  :: npt_max, direction
      real(kind=MF_DOUBLE), intent(in)  :: curv_tol
      integer,              intent(out) :: n
      real(kind=MF_DOUBLE), pointer     :: coords(:,:)
      integer,              intent(out) :: status

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface
      !------ API end ------

      real(kind=MF_DOUBLE), allocatable :: coords_1(:,:) ! for forward integration (if needed)
      real(kind=MF_DOUBLE), allocatable :: coords_2(:,:) ! for backward integration (if needed)

      real(kind=MF_DOUBLE), parameter :: outside_tol = 1.0d-2

      integer :: n1, n2, i, j

   !------ end of declarations -- execution starts hereafter  ------

      status = 0

      n1 = 0 ! keep this value (if no forward path)
      n2 = 0 ! keep this value (if no backward path)

      if( direction == 1 .or. direction == 3 ) then

         allocate( coords_1(25,2) ) ! will be extended if needed

         call TriStream( x, y, u, v, tri_connect, x0, y0,               &
                         npt_max, outside_tol, curv_tol, .false.,       &
                         n1, coords_1, status, stop_zone )

      end if

      if( status /= -1 ) then ! skipping a cycling path already computed
         if( direction == 2 .or. direction == 3 ) then

            allocate( coords_2(25,2) ) ! will be extended if needed

            call TriStream( x, y, u, v, tri_connect, x0, y0,            &
                            npt_max, outside_tol, curv_tol, .true.,     &
                            n2, coords_2, status, stop_zone )

         end if
      end if

      if( allocated(coords_1) .and. allocated(coords_2) ) then
         ! merging the two lists of points in coords
         n = n1 + n2 - 1
         allocate( coords(n,2) )
         do i = n2, 1, -1
            j = n2 - i + 1
            coords(j,1) = coords_2(i,1)
            coords(j,2) = coords_2(i,2)
         end do
         ! removing one starting point (stored twice)
         do i = 2, n1
            j = n2 + i - 1
            coords(j,1) = coords_1(i,1)
            coords(j,2) = coords_1(i,2)
         end do
      else if( allocated(coords_1) ) then
         n = n1
         allocate( coords(n,2) )
         do i = 1, n1
            coords(i,1) = coords_1(i,1)
            coords(i,2) = coords_1(i,2)
         end do
      else if( allocated(coords_2) ) then
         n = n2
         allocate( coords(n,2) )
         do i = n2, 1, -1
            j = n2 - i + 1
            coords(j,1) = coords_2(i,1)
            coords(j,2) = coords_2(i,2)
         end do
      end if

   end subroutine stream_main
!_______________________________________________________________________
!
#include "../../mfplot/src/TriStream/TriStream.inc"
