!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfStreamline_uv_str( u, v, start, direction,                &
                                 n_arrow, color, linestyle, linewidth,  &
                                 arrow_head, npt_max, curv_tol,         &
                                 stop_zone )                            &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msStreamline_uv_str( u, v, start, direction,              &
                                   n_arrow, color, linestyle, linewidth, &
                                   arrow_head, npt_max, curv_tol,       &
                                   stop_zone )
#endif
      type(mfArray)                              :: u, v, start
      integer,              intent(in), optional :: n_arrow
      character(len=*),     intent(in), optional :: direction
      character(len=*),     intent(in)           :: color
      character(len=*),     intent(in), optional :: linestyle
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head
      integer,              intent(in), optional :: npt_max
      real(kind=MF_DOUBLE), intent(in), optional :: curv_tol
                                        optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: u_ptr(:,:), v_ptr(:,:)
      integer :: i, j, k, ier
      integer :: ni, nj, i_curve, n_curve
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, handle_0, npt_max_0
      integer :: mf_message_level_save
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfTriConnect) :: tri_connect

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( u, v, start )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to grey)" )
            icol = MFPLOT_LIGHT_GREY
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ni = size(u_ptr,1)
      nj = size(u_ptr,2)

      ! les [nouveaux] axes doivent être prêts
      range(:) = [ 1, nj, ni, 1 ]

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! build unstructured coordinates
      allocate( x_long(ni*nj), y_long(ni*nj), u_long(ni*nj), v_long(ni*nj) )
      k = 0
      do i = 1, ni
         do j = 1, nj
            k = k + 1
            x_long(k) = j
            y_long(k) = i
            u_long(k) =  u_ptr(i,j)
!############## pour être cohérent avec MeshGrid et Gradient
            v_long(k) = -v_ptr(i,j)
         end do
      end do

      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      call build_tri_from_rect( ni, nj, x_long, y_long, tri_connect )

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve

         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect, range, &
                              npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      call msRelease( tri_connect )

 99   continue

      call msFreeArgs( u, v, start )
      call msAutoRelease( u, v, start )

#ifdef _MF_FUNC
   end function mfStreamline_uv_str
#endif
#ifdef _MF_SUBR
   end subroutine msStreamline_uv_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfStreamline_uv_rgb( u, v, start, direction,                &
                                 n_arrow, color, linestyle, linewidth,  &
                                 arrow_head, npt_max, curv_tol,         &
                                 stop_zone )                            &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msStreamline_uv_rgb( u, v, start, direction,              &
                                   n_arrow, color, linestyle, linewidth, &
                                   arrow_head, npt_max, curv_tol,       &
                                   stop_zone )
#endif
      type(mfArray)                              :: u, v, start
      integer,              intent(in), optional :: n_arrow
      character(len=*),     intent(in), optional :: direction
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      character(len=*),     intent(in), optional :: linestyle
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head
      integer,              intent(in), optional :: npt_max
      real(kind=MF_DOUBLE), intent(in), optional :: curv_tol
                                        optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: u_ptr(:,:), v_ptr(:,:)
      integer :: i, j, k
      integer :: ni, nj, i_curve, n_curve
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, handle_0, npt_max_0
      integer :: mf_message_level_save
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfTriConnect) :: tri_connect

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( u, v, start )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      else
         icol = -127
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ni = size(u_ptr,1)
      nj = size(u_ptr,2)

      ! les [nouveaux] axes doivent être prêts
      range(:) = [ 1, nj, ni, 1 ]

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! build unstructured coordinates
      allocate( x_long(ni*nj), y_long(ni*nj), u_long(ni*nj), v_long(ni*nj) )
      k = 0
      do i = 1, ni
         do j = 1, nj
            k = k + 1
            x_long(k) = j
            y_long(k) = i
            u_long(k) =  u_ptr(i,j)
!############## pour être cohérent avec MeshGrid et Gradient
            v_long(k) = -v_ptr(i,j)
         end do
      end do

      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      call build_tri_from_rect( ni, nj, x_long, y_long, tri_connect )

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve

         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect, range, &
                              npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      call msRelease( tri_connect )

 99   continue

      call msFreeArgs( u, v, start )
      call msAutoRelease( u, v, start )

#ifdef _MF_FUNC
   end function mfStreamline_uv_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msStreamline_uv_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfStreamline_xyuv_str( x, y, u, v, start, direction,        &
                                   n_arrow, color, linestyle, linewidth, &
                                   arrow_head, npt_max, curv_tol,       &
                                   stop_zone )                          &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msStreamline_xyuv_str( x, y, u, v, start, direction,      &
                                     n_arrow, color, linestyle, linewidth, &
                                     arrow_head, npt_max, curv_tol,     &
                                     stop_zone )
#endif
      type(mfArray)                              :: x, y, u, v, start
      integer,              intent(in), optional :: n_arrow
      character(len=*),     intent(in), optional :: direction
      character(len=*),     intent(in)           :: color
      character(len=*),     intent(in), optional :: linestyle
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head
      integer,              intent(in), optional :: npt_max
      real(kind=MF_DOUBLE), intent(in), optional :: curv_tol
                                        optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)

      logical :: full_matrix
      integer :: i, j, k, ier
      integer :: ni, nj, i_curve, n_curve, nx_pg, ny_pg, p_dim
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

!### TODO: voir Quiver et Quiver_aux :
!    (2021-05-22) je crois qu'il n'y a pas d'utilité à introduire "cell_centered"
      logical :: cell_centered = .false.

      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, handle_0, npt_max_0
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfTriConnect) :: tri_connect

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      call msInitArgs( x, y, u, v, start )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ni = size(u_ptr,1)
      nj = size(u_ptr,2)

      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_abs-1 .or. nj /= nx_abs-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, shape of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_abs .or. nj /= nx_abs ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
      else                                               ! vector
         full_matrix = .false.
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         if( cell_centered ) then
            if( nj /= nx_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( nj /= nx_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
      end if

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_ord-1 .or. nj /= nx_ord-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_ord .or. nj /= nx_ord ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         if( cell_centered ) then
            if( ni /= ny_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if

      end if

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to grey)" )
            icol = MFPLOT_LIGHT_GREY
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ! les [nouveaux] axes doivent être prêts
      if( full_matrix ) then
         range(1) = minval( x_ptr ) ! x_min
         range(2) = maxval( x_ptr ) ! x_max
         range(3) = minval( y_ptr ) ! y_min
         range(4) = maxval( y_ptr ) ! y_max
      else
         if( p_dim == 1 ) then
            range(1) = min( x_ptr(1,1), x_ptr(nj,1) ) ! x_min
            range(2) = max( x_ptr(1,1), x_ptr(nj,1) ) ! x_max
            range(3) = min( y_ptr(1,1), y_ptr(nj,1) ) ! y_min
            range(4) = max( y_ptr(1,1), y_ptr(nj,1) ) ! y_max
         else ! p_dim = 2
            range(1) = min( x_ptr(1,1), x_ptr(1,nj) ) ! x_min
            range(2) = max( x_ptr(1,1), x_ptr(1,nj) ) ! x_max
            range(3) = min( y_ptr(1,1), y_ptr(1,nj) ) ! y_min
            range(4) = max( y_ptr(1,1), y_ptr(1,nj) ) ! y_max
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! build unstructured coordinates
      allocate( x_long(ni*nj), y_long(ni*nj), u_long(ni*nj), v_long(ni*nj) )
      k = 0
      do i = 1, ni
         do j = 1, nj
            k = k + 1
            if( full_matrix ) then
               x_long(k) = x_ptr(i,j)
               y_long(k) = y_ptr(i,j)
            else
               if( p_dim == 1 ) then
                  x_long(k) = x_ptr(j,1)
                  y_long(k) = y_ptr(i,1)
               else ! p_dim = 2
                  x_long(k) = x_ptr(1,j)
                  y_long(k) = y_ptr(1,i)
               end if
            end if
            u_long(k) = u_ptr(i,j)
            v_long(k) = v_ptr(i,j)
         end do
      end do

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      call build_tri_from_rect( ni, nj, x_long, y_long, tri_connect )

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve

         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect, range, &
                              npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      call msRelease( tri_connect )

 99   continue

      call msFreeArgs( x, y, u, v, start )
      call msAutoRelease( x, y, u, v, start )

#ifdef _MF_FUNC
   end function mfStreamline_xyuv_str
#endif
#ifdef _MF_SUBR
   end subroutine msStreamline_xyuv_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfStreamline_xyuv_rgb( x, y, u, v, start, direction,        &
                                   n_arrow, color, linestyle, linewidth, &
                                   arrow_head, npt_max, curv_tol,       &
                                   stop_zone )                          &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msStreamline_xyuv_rgb( x, y, u, v, start, direction,      &
                                     n_arrow, color, linestyle, linewidth, &
                                     arrow_head, npt_max, curv_tol,     &
                                     stop_zone )
#endif
      type(mfArray)                              :: x, y, u, v, start
      integer,              intent(in), optional :: n_arrow
      character(len=*),     intent(in), optional :: direction
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      character(len=*),     intent(in), optional :: linestyle
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head
      integer,              intent(in), optional :: npt_max
      real(kind=MF_DOUBLE), intent(in), optional :: curv_tol
                                        optional :: stop_zone

      interface
         logical function stop_zone( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      integer, allocatable :: handle(:)
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)

      logical :: full_matrix
      integer :: i, j, k
      integer :: ni, nj, i_curve, n_curve, nx_pg, ny_pg, p_dim
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

!### TODO: voir Quiver et Quiver_aux :
!    (2021-05-22) je crois qu'il n'y a pas d'utilité à introduire "cell_centered"
      logical :: cell_centered = .false.

      real(kind=MF_DOUBLE) :: start_0(2)
      integer :: direction_0, n_arrow_0, icol, istyle, handle_0, npt_max_0
      integer :: i_dummy_1, i_dummy_2
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0, curv_tol_0

      real(kind=MF_DOUBLE) :: range(4)
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), allocatable :: x_long(:), y_long(:), u_long(:), v_long(:)
      type(mfTriConnect) :: tri_connect

      abstract interface
         logical function stop_zone_intf( x, y )
            import MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in) :: x, y
         end function
      end interface

      procedure(stop_zone_intf), pointer :: stop_zone_ptr => null ()

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfStreamline"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msStreamline"
#endif

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      call msInitArgs( x, y, u, v, start )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! 'u' cannot contain NaN values
      if( Any(mfIsNaN(u)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot contain NaN values!" )
         go to 99
      end if

      ! 'v' cannot contain NaN values
      if( Any(mfIsNaN(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( u, u_ptr, no_crc=.true. )
      call msPointer( v, v_ptr, no_crc=.true. )

      ni = size(u_ptr,1)
      nj = size(u_ptr,2)

      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_abs-1 .or. nj /= nx_abs-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, shape of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_abs .or. nj /= nx_abs ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
      else                                               ! vector
         full_matrix = .false.
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         if( cell_centered ) then
            if( nj /= nx_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( nj /= nx_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
      end if

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_ord-1 .or. nj /= nx_ord-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_ord .or. nj /= nx_ord ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         if( cell_centered ) then
            if( ni /= ny_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, dimension of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if

      end if

      ! checking that 'start' is allocated
      if( mfIsEqual(start,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' not allocated!" )
         go to 99
      end if

      ! 'start' must be Real
      if( .not. mfIsReal(start) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must be real!" )
         go to 99
      end if

      ! 'start' must have two columns
      if( size(start,2) /= 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'start' must have two columns!" )
         go to 99
      end if

      n_curve = size(start,1)
#ifdef _MF_FUNC
      allocate( handle(n_curve) )
      handle(:) = 0
#endif

      if( present(n_arrow) ) then
         n_arrow_0 = n_arrow
      else
         n_arrow_0 = 3
      end if

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      else
         icol = -127
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linestyle) ) then
         call decode_linespec( linestyle, i_dummy_1, istyle, i_dummy_2 )
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         istyle = 1 ! continuous
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = 1.0
      end if

      ! les [nouveaux] axes doivent être prêts
      if( full_matrix ) then
         range(1) = minval( x_ptr ) ! x_min
         range(2) = maxval( x_ptr ) ! x_max
         range(3) = minval( y_ptr ) ! y_min
         range(4) = maxval( y_ptr ) ! y_max
      else
         if( p_dim == 1 ) then
            range(1) = min( x_ptr(1,1), x_ptr(nj,1) ) ! x_min
            range(2) = max( x_ptr(1,1), x_ptr(nj,1) ) ! x_max
            range(3) = min( y_ptr(1,1), y_ptr(nj,1) ) ! y_min
            range(4) = max( y_ptr(1,1), y_ptr(nj,1) ) ! y_max
         else ! p_dim = 2
            range(1) = min( x_ptr(1,1), x_ptr(1,nj) ) ! x_min
            range(2) = max( x_ptr(1,1), x_ptr(1,nj) ) ! x_max
            range(3) = min( y_ptr(1,1), y_ptr(1,nj) ) ! y_min
            range(4) = max( y_ptr(1,1), y_ptr(1,nj) ) ! y_max
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! build unstructured coordinates
      allocate( x_long(ni*nj), y_long(ni*nj), u_long(ni*nj), v_long(ni*nj) )
      k = 0
      do i = 1, ni
         do j = 1, nj
            k = k + 1
            if( full_matrix ) then
               x_long(k) = x_ptr(i,j)
               y_long(k) = y_ptr(i,j)
            else
               if( p_dim == 1 ) then
                  x_long(k) = x_ptr(j,1)
                  y_long(k) = y_ptr(i,1)
               else ! p_dim = 2
                  x_long(k) = x_ptr(1,j)
                  y_long(k) = y_ptr(1,i)
               end if
            end if
            u_long(k) = u_ptr(i,j)
            v_long(k) = v_ptr(i,j)
         end do
      end do

      call msFreePointer( x, x_ptr )
      call msFreePointer( y, y_ptr )

      call msFreePointer( u, u_ptr )
      call msFreePointer( v, v_ptr )

      call build_tri_from_rect( ni, nj, x_long, y_long, tri_connect )

      if( present(direction) ) then
         if( direction(1:4) == "forw" ) then
            direction_0 = 1 ! forward
         else if( direction(1:4) == "back" ) then
            direction_0 = 2 ! backward
         else if( direction(1:4) == "both" ) then
            direction_0 = 3 ! both
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'direction' must be equal to 'forward', 'backward' or 'both'!" )
            go to 99
         end if
      else
         direction_0 = 3 ! both
      end if

      if( present(curv_tol) ) then
         curv_tol_0 = curv_tol
      else
         curv_tol_0 = MF_TRISTREAM_CURV_TOL
      end if

      if( present(npt_max) ) then
         npt_max_0 = npt_max
      else
         npt_max_0 = 1000
      end if

      if( present(stop_zone) ) then
         stop_zone_ptr => stop_zone
      else
         stop_zone_ptr => always_false
      end if

      do i_curve = 1, n_curve

         mf_message_level_save = mf_message_level
         mf_message_level = 0
         start_0 = mfGet( start, i_curve, MF_ALL )
         mf_message_level = mf_message_level_save

         handle_0 = StreamlineCore( x_long, y_long, u_long, v_long, start_0, &
                              direction_0, n_arrow_0, icol, istyle,     &
                              linewidth_0, arrow_head_0, tri_connect, range, &
                              npt_max_0, curv_tol_0, stop_zone_ptr )

#ifdef _MF_FUNC
         handle(i_curve) = handle_0
#endif
      end do

      call msRelease( tri_connect )

 99   continue

      call msFreeArgs( x, y, u, v, start )
      call msAutoRelease( x, y, u, v, start )

#ifdef _MF_FUNC
   end function mfStreamline_xyuv_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msStreamline_xyuv_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   logical function always_false( x, y )
      real(kind=MF_DOUBLE), intent(in) :: x, y
      always_false = .false.
   end function always_false
#endif
