!_______________________________________________________________________
!
   subroutine mf_pcolor_spy_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor_spy"

      integer :: i, j, k, nx, ny
      real(kind=MF_DOUBLE) :: x_pg_4(4), y_pg_4(4)
      integer :: icol_pg_4(4)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy", 0 )
         end if
         call EPS_clip_on_viewport_beg() ! for PatchRectCorePS()
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy", 0 )
         end if
      end if

      nx = grobj%struct%npt
      ny = grobj%struct%npt2
      do i = 1, ny
         do j = 1, nx
            k = (j-1)*ny + i
            x_pg_4(:) = [ j-0.45d0, j+0.45d0, j+0.45d0, j-0.45d0 ]
            y_pg_4(:) = [ i-0.45d0, i-0.45d0, i+0.45d0, i+0.45d0 ]
            icol_pg_4(:) = grobj%struct%col_tab(k)
            call PatchRectCore( x_pg_4, y_pg_4, icol_pg_4,              &
                                opacity=1.0d0, flat=.true. )
         end do
      end do

      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_end()
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy", 0 )
         end if
      end if

   end subroutine mf_pcolor_spy_draw
!_______________________________________________________________________
!
   subroutine mf_pcolor_spy_sparse_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor_spy_sparse"

      type(mf_win_info), pointer :: win

      integer :: i, j, k, nx, ny
      integer :: i_min, i_max, j_min, j_max

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy_Sparse", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy_Sparse", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      nx = grobj%struct%npt
      ny = grobj%struct%npt2
      ! Quick return: les valeurs (i_min,i_max) et (j_min,j_max)
      ! évitent de parcourir toute la matrice creuse : gain de temps
      ! très important !
      j_min = max(  1, nint(win%current_axes(1)) )
      j_max = min( ny, nint(win%current_axes(2)) )
      i_min = max(  1, nint(win%current_axes(4)) )
      i_max = min( nx, nint(win%current_axes(3)) )
      do j = j_min, j_max
         do k = grobj%struct%jc(j), grobj%struct%jc(j+1)-1
            i = grobj%struct%ir(k)
            if( i < i_min .or. i_max < i ) cycle

            gr_pdf_color_intent = 2 ! Fill
            call grsci(grobj%struct%col_tab(k)) ! set color index
            call grrect( j-0.45d0, i-0.45d0, j+0.45d0, i+0.45d0, filled=.true. )

         end do
      end do

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy_Sparse", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy_Sparse", 0 )
         end if
      end if

   end subroutine mf_pcolor_spy_sparse_draw
!_______________________________________________________________________
!
   subroutine mf_pcolor_spy_sparse_2_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "pcolor_spy_sparse_2"

      type(mf_win_info), pointer :: win

      integer :: i, j, k, nx, ny
      integer :: i_min, i_max, j_min, j_max
      integer :: dx, dy

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy_Sparse_2", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Pcolor_Spy_Sparse_2", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      nx = grobj%struct%npt
      ny = grobj%struct%npt2
      dx = ny/grobj%struct%x_text
      dy = nx/grobj%struct%y_text
      gr_pdf_color_intent = 2 ! Fill
      call grsci(1) ! set color index to foreground
      ! Quick return: les valeurs (i_min,i_max) et (j_min,j_max)
      ! évitent de parcourir toute la matrice creuse : gain de temps
      ! très important !
      j_min = max(  1, nint(win%current_axes(1)) )
      j_max = min( ny, nint(win%current_axes(2)) )
      i_min = max(  1, nint(win%current_axes(4)) )
      i_max = min( nx, nint(win%current_axes(3)) )
      do j = j_min, j_max
         do k = grobj%struct%jc(j), grobj%struct%jc(j+1)-1
            i = grobj%struct%ir(k)
            if( i < i_min .or. i_max < i ) cycle

            call grrect( dble(j), dble(i), dble(j+dx), dble(i+dy), filled=.true. )

         end do
      end do

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy_Sparse_2", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Pcolor_Spy_Sparse_2", 0 )
         end if
      end if

   end subroutine mf_pcolor_spy_sparse_2_draw
!_______________________________________________________________________
!
   subroutine mf_plot_spy_sparse_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "plot_spy_sparse"

      type(mf_win_info), pointer :: win

      integer :: i, j, k, nx, ny
      integer :: i_min, i_max, j_min, j_max
      integer :: dx, dy

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Plot_Spy_Sparse", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Plot_Spy_Sparse", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      nx = grobj%struct%npt
      ny = grobj%struct%npt2
      call grsci(grobj%struct%color) ! set color index
      ! draw only markers
      call grsms(grobj%struct%markersize) ! set marker size
      ! les valeurs (i_min,i_max) et (j_min,j_max) évitent
      ! de parcourir toute la matrice creuse : gain de temps
      ! très important !
      j_min = max(  1, nint(win%current_axes(1)) )
      j_max = min( ny, nint(win%current_axes(2)) )
      i_min = max(  1, nint(win%current_axes(4)) )
      i_max = min( nx, nint(win%current_axes(3)) )
      do j = j_min, j_max
         do k = grobj%struct%jc(j), grobj%struct%jc(j+1)-1
            i = grobj%struct%ir(k)
            if( i < i_min .or. i_max < i ) cycle

            call pgpt( 1, [dble(j)], [dble(i)], grobj%struct%marker )

         end do
      end do

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Plot_Spy_Sparse", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Plot_Spy_Sparse", 0 )
         end if
      end if

   end subroutine mf_plot_spy_sparse_draw
