!_______________________________________________________________________
!
   function PcolorCoreSpy( mat, is_finite ) result( handle )

      real(kind=MF_DOUBLE), pointer    :: mat(:,:)
      logical,              intent(in) :: is_finite
      integer                          :: handle
      !------ API end ------

      ! Attention : convention
      ! x ->  j
      ! y -> -i

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)
      integer, pointer :: icol_sto_pg(:)

      real(kind=MF_DOUBLE) :: x_pg(4), y_pg(4)
      integer :: icol_red = 2

      integer :: i, j, k, nx, ny, hdle
      real(kind=MF_DOUBLE) :: fact, val
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      nx = size(mat,2)
      ny = size(mat,1)

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      range(:) = [ 0.45d0, nx+0.55d0, ny+0.55d0, 0.45d0 ]

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      fact = (win%colormap_ci_high-win%colormap_ci_low) /               &
             (win%color_axes(2)-win%color_axes(1))

      ! ATTENTION : on stocke les indices de couleur dans un vecteur
      allocate( icol_sto_pg(nx*ny) )

      do i = 1, ny
         do j = 1, nx

            k = (j-1)*ny + i

            x_pg(:) = [ j-0.45d0, j+0.45d0, j+0.45d0, j-0.45d0 ]
            y_pg(:) = [ i-0.45d0, i-0.45d0, i+0.45d0, i+0.45d0 ]

            val = mat(i,j)
            if( is_finite ) then
               ! val : finite
               icol_sto_pg(k) = nint( win%colormap_ci_low +             &
                                      fact*(val-win%color_axes(1)) )
            else
               if( mf_isfinite(val) ) then
                  ! val : finite
                  icol_sto_pg(k) = nint( win%colormap_ci_low +          &
                                         fact*(val-win%color_axes(1)) )
               else
                  ! val : IEEE special values (+/-Inf or NaN)
                  icol_sto_pg(k) = icol_red
               end if
            end if

         end do
      end do

      ! no further needs of mat
      deallocate( mat )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_spy"
      grobj%struct%col_tab => icol_sto_pg

      grobj%struct%npt  = nx
      grobj%struct%npt2 = ny

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_spy_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! icol_sto_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreSpy
!_______________________________________________________________________
!
   function PcolorCoreSpySparse( nx, ny,                                &
                                 ir_sto_pg, jc_sto_pg, val_sto_pg,      &
                                 is_finite )                            &
   result( handle )

      integer,              intent(in) :: nx, ny
      integer,              pointer    :: ir_sto_pg(:), jc_sto_pg(:)
      real(kind=MF_DOUBLE), pointer    :: val_sto_pg(:)
      logical,              intent(in) :: is_finite
      integer                          :: handle
      !------ API end ------

      ! idem PcolorCoreSpy, mais adapté pour une matrice creuse
      !
      ! ici, les tableaux: ir_sto_pg(:), jc_sto_pg(:), val_sto_pg(:)
      ! décrivent la matrice creuse A au format CSC

      ! Attention : convention de Matlab (idem Contour)
      ! x -> j
      ! y -> i

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)
      integer, pointer :: icol_sto_pg(:)

      integer :: icol_red = 2

      integer :: i, j, k, nnz, hdle
      real(kind=MF_DOUBLE) :: fact, val
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      range(:) = [ 0.45d0, ny+0.55d0, nx+0.55d0, 0.45d0 ]

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         call X11_clip_on_viewport()
      end if

      fact = (win%colormap_ci_high-win%colormap_ci_low) /               &
             (win%color_axes(2)-win%color_axes(1))

      nnz = size(ir_sto_pg)
      allocate( icol_sto_pg(nnz) )

      do j = 1, ny
         do k = jc_sto_pg(j), jc_sto_pg(j+1)-1

            i = ir_sto_pg(k)
            val = val_sto_pg(k)

            if( is_finite ) then
               ! val : finite
               icol_sto_pg(k) = nint( win%colormap_ci_low +             &
                                      fact*(val-win%color_axes(1)) )
            else
               if( mf_isfinite(val) ) then
                  ! val : finite
                  icol_sto_pg(k) = nint( win%colormap_ci_low +          &
                                         fact*(val-win%color_axes(1)) )
               else
                  ! val : IEEE special values (+/-Inf or NaN)
                  icol_sto_pg(k) = icol_red
               end if
            end if

         end do
      end do

      ! no further needs of val_sto_pg
      deallocate( val_sto_pg )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_spy_sparse"
      grobj%struct%ir => ir_sto_pg
      grobj%struct%jc => jc_sto_pg
      grobj%struct%col_tab => icol_sto_pg

      grobj%struct%npt = nx
      grobj%struct%npt2 = ny

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_spy_sparse_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! ir_sto_pg, jc_sto_pg and icol_sto_pg already deallocated
         ! by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreSpySparse
!_______________________________________________________________________
!
   function PcolorCoreSpySparse2( nrow, ncol, ir_sto_pg, jc_sto_pg,     &
                                  pix_width, pix_height )               &
   result( handle )

      integer,              intent(in) :: nrow, ncol
      integer,              pointer    :: ir_sto_pg(:), jc_sto_pg(:)
      real(kind=MF_DOUBLE), intent(in) :: pix_width, pix_height
      integer                          :: handle
      !------ API end ------

      ! idem PcolorCoreSpySparse, mais dessine des carrés noirs
      ! pour les valeurs non nulles; de plus la taille de ces carrés
      ! est adaptée à une impression bitmap, dont la taille finale
      ! de l'image est donnée par (pix_width,pix_height).
      !
      ! ici, les tableaux: ir_sto_pg(:), jc_sto_pg(:) décrivent la
      ! structure de la matrice creuse A au format CSC

      ! Attention : convention de Matlab (idem Contour)
      ! x -> j
      ! y -> i

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      integer :: hdle
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      range(:) = [ 0.5d0, ncol+0.5d0, nrow+0.5d0, 0.5d0 ]

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "pcolor_spy_sparse_2"
      grobj%struct%ir => ir_sto_pg
      grobj%struct%jc => jc_sto_pg

      grobj%struct%npt = nrow
      grobj%struct%npt2 = ncol
      grobj%struct%x_text = pix_width
      grobj%struct%y_text = pix_height

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_pcolor_spy_sparse_2_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! ir_sto_pg and jc_sto_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PcolorCoreSpySparse2
!_______________________________________________________________________
!
   function PlotSpySparse( nx, ny, ir_sto_pg, jc_sto_pg,                &
                           linecolor, marker, markersize )              &
   result( handle )

      integer,              intent(in) :: nx, ny
      integer,              pointer    :: ir_sto_pg(:), jc_sto_pg(:)
      integer,              intent(in) :: linecolor, marker
      real(kind=MF_DOUBLE), intent(in) :: markersize
      integer                          :: handle
      !------ API end ------

      ! ici, les tableaux: ir_sto_pg(:), jc_sto_pg(:)
      ! décrivent la structure creuse (CSC) de la matrice A

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)
      integer :: i, j, k, itmp, hdle
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      call pgbbuf()

      win => mf_win_db(CURRENT_WIN_ID)

      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      range(:) = [ 0.45d0, ny+0.55d0, nx+0.55d0, 0.45d0 ]

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         call X11_clip_on_viewport()
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "plot_spy_sparse"
      grobj%struct%ir => ir_sto_pg
      grobj%struct%jc => jc_sto_pg

      grobj%struct%color = linecolor
      grobj%struct%marker = marker
      grobj%struct%markersize = markersize
      grobj%struct%npt = nx
      grobj%struct%npt2 = ny

      if( win%mf_win_db_active ) then

         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )

      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_plot_spy_sparse_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! ir_sto_pg and jc_sto_pg already deallocated by 'delete_grobj_inside'
      end if

      win%blank = .false.
      win%empty = .false.

   end function PlotSpySparse
!_______________________________________________________________________
!
   subroutine set_colorbar_log( )

      ! from : msColorbar
      !        (without argument -- for internal usage)

      character(len=2) :: colorbar_pos
      real(kind=MF_DOUBLE) :: emin, emax, disp
      integer :: i

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      ibuf(1) = 0 ! no clipping (used only in X11 driver)
      call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr )
      CLIPPING_IN_AXES = .false.

      win => mf_win_db(CURRENT_WIN_ID)

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! default : colorbar is "vert" / "i" is for "image" i.e. color
      colorbar_pos = "ri"

      ! the following color axis are in log10, so we must revert to
      ! true values
      ! color axes are already in log10
      emin = win%color_axes(1)
      emax = win%color_axes(2)
      call grsci(1) ! default foreground color
      call grslw( 1.0d0 ) ! default linewidth
      call grsls( 1 ) ! default line style
      ! Shift in y to encompass the ticks and the numerical labels
      ! (unit is axis_font_size); depends also on 'xy'/'ij' axis mode.
      if( win%colorbar_pos(1:1) == "b" ) then
         if( win%axis_mode_xy ) then
            disp = 2.75d0
            if( win%xlabel_exist ) then
               ! additional shift to encompass the descriptive label
               disp = disp + 1.5d0*(win%label_font_size/win%axis_font_size)
            end if
         else ! 'ij'
            disp = 2.0d0
         end if
      else ! "vert"
         disp = 2.25d0
      end if
      ! Very important: the axis font size must be selected just before
      !                 calling pgwedg.
      call pgsch( win%axis_font_size * win%char_height_factor )
PGBOX_IN_COLORBAR = .true.
      call pgwedg( colorbar_pos, disp, 3.5d0, emin, emax, "", 2 )
PGBOX_IN_COLORBAR = .false.
      call pgsch( 1.0d0 ) ! default character height

      win%colorbar = 2 ! log
      win%colorbar_pos = colorbar_pos
      win%colorbar_label = ""

      win%blank = .false.
      win%empty = .false.

   end subroutine set_colorbar_log
