!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfSpy( A, symbolspec, bitmap,                               &
                   continuous, color_scale,                             &
                   show_nnz, nz_threshold )                             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msSpy( A, symbolspec, bitmap,                             &
                     continuous, color_scale,                           &
                     show_nnz, nz_threshold )
#endif

      type(mfArray), target, intent(in)           :: A
      character(len=*),      intent(in), optional :: symbolspec
      character(len=*),      intent(in), optional :: bitmap
      logical,               intent(in), optional :: continuous
      character(len=*),      intent(in), optional :: color_scale
      logical,               intent(in), optional :: show_nnz
      real(kind=MF_DOUBLE),  intent(in), optional :: nz_threshold
      integer :: handle
      !------ API end ------

      ! mapping between values and colors : color_scale
      !   "lin" (linear:default) or "log" (logarithmic)

      ! 'bitmap' is the  bitmap size (in pixels) to be printed,
      ! e.g. "1000x1000" ("WIDTHxHEIGHT")
      !
      ! to be valid, the image size in pixels must be smaller
      ! than the matrix size, else nothing is plotted!
      ! (a warning is emitted)
      ! As a consequence, this option is useful only for large,
      ! sparse matrices.

      type(mf_win_info), pointer :: win
      integer :: nrow, ncol, nnz, i, j, k, new_nnz
      integer, pointer :: ir_sto_pg(:), jc_sto_pg(:)
      real(kind=MF_DOUBLE), pointer :: val_sto_pg(:)
      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)
      integer :: linecolor, linestyle, marker
      real(kind=MF_DOUBLE) :: rmin, rmax, val, markersize
      character(len=80) :: string
      logical :: is_finite, show_nnz_in_label, color_scale_log
      logical :: use_pix_size, coloring
      real(kind=MF_DOUBLE) :: pix_width, pix_height
      real(kind=MF_DOUBLE) :: nonzero_threshold

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfSpy"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msSpy"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( A )

      ! checking that 'A' is allocated
      if( mfIsEqual(A,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'A' not allocated!" )
         go to 99
      end if

      if( .not. mfIsReal(A) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'A' must be real!" )
         go to 99
      end if

      if( present(show_nnz) ) then
         show_nnz_in_label = show_nnz
         if( mfIsSparse(A) ) then
            call PrintMessage( trim(ROUTINE_NAME), "I",                 &
                               "for a sparse matrix, 'nnz' is always shown." )
         end if
      else
         show_nnz_in_label = .false.
      end if

      if( present(continuous) ) then
         coloring = continuous
      else
         coloring = .false.
      end if

      nrow = A%shape(1)
      ncol = A%shape(2)

      if( present(bitmap) ) then
         k = index( bitmap, "x" )
         if( k == 0 ) then
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'bitmap' string must contain the separator 'x'!" )
               return
            end if
         end if
         read(bitmap(1:k-1),*) pix_width
         read(bitmap(k+1:),*) pix_height
         if( pix_width < ncol .or. pix_height < nrow ) then
            if( CURRENT_WIN_ID == 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'bitmap' is too small!",             &
                                  "[this optional arg is useful only for large sparse matrices]" )
               return
            end if
         end if
         use_pix_size = .true.
      else
         use_pix_size = .false.
      end if

      if( present(color_scale) ) then
         if( color_scale == "log" ) then
            color_scale_log = .true.
         else
            color_scale_log = .false.
         end if
      else
         color_scale_log = .false.
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot open a window!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 .or. win%axis_scale_y == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "you are going to use a different scaling of axis", &
                            "from a previous plot on the same figure: you may", &
                            "obtain some unexpected results!" )
         go to 99
      end if

      ! prepare scaling for axes. Default: linear
      ! scale index : 0 = undef., 1 = linear, 2 = log10
      if( win%axis_scale_x == 0 ) then
         win%axis_scale_x = 1
      end if
      if( win%axis_scale_y == 0 ) then
         win%axis_scale_y = 1
      end if

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.

      win%axis_equal = .true.
      win%shading = "flat"

INTEGER_XLABEL( CURRENT_WIN_ID ) = .true.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .true.

      if( coloring ) then

         is_finite = .true.

         if( mfIsSparse(A) ) then
            ! avoid using mfFull() which may lead to memory overflow
            nnz = mfNnz(A)

            allocate( jc_sto_pg(ncol+1) )

            allocate( ir_sto_pg(nnz) )

            allocate( val_sto_pg(nnz) )

            jc_sto_pg(:) = A%j(1:ncol+1)
            ir_sto_pg(:) = A%i(1:nnz)
            val_sto_pg(:) = abs( A%a(1:nnz) )
!### TODO 2: et pour une matrice toute à zéro, que pasa?
            rmin = huge(1.0) ! should be strictly positive
            rmax = 0.0 ! will be the max finite value of |A|
                       ! (cannot use 'maxval' intrinsic, because A
                       !  may contain Inf or NaN values)
            do k = 1, nnz
               val = val_sto_pg(k)
               if( mf_isfinite(val) ) then
                  if( val > rmax ) then
                     rmax = val
                  end if
                  if( val /= 0.0 .and. val < rmin ) then
                     rmin = val
                  end if
               else
                  is_finite = .false.
               end if
            end do

            if( .not. win%colormap_init ) then
               call msColormap( "grey" )
               ! set image transfer function
               ! (Default: 0=linear, but 2=square_root is more
               !  adapted for the grey scale)
               call pgsitf(2)
            end if

            if( present(nz_threshold) ) then
               if( nz_threshold == -1.0d0 ) then
                  nonzero_threshold = rmin
               else if( nz_threshold < 0.0d0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                    "nz_threshold must be positive!",   &
                                    "(only the special value -1 can be used)" )
                  go to 99
               else
                  nonzero_threshold = nz_threshold
               end if
            ! else : value defined below (depending of color_scale_log)
            end if

            if( color_scale_log ) then
               if( .not. present(nz_threshold) ) then
                  nonzero_threshold = rmax*MF_EPS
               end if
               rmin = nonzero_threshold
               ! log10 of 'mat_sto_pg', but taking care of zero values
               where( val_sto_pg <= rmin )
                  val_sto_pg = log10(rmin)
               elsewhere
                  val_sto_pg = log10(val_sto_pg)
               end where
               if( rmax == 0.0 .or. rmin == 0.0d0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                     "cannot use log color axis, because matrix is null", &
                                     "or have too small values!" )
                  go to 99
               else
                  if( BLACK_ON_WHITE == 1 ) then
                     win%color_axes(:) = [ log10(rmax), log10(rmin) ]
                  else
                     win%color_axes(:) = [ log10(rmin), log10(rmax) ]
                  end if
               end if
            else
               if( .not. present(nz_threshold) ) then
                  nonzero_threshold = 0.0d0
               end if
               rmin = nonzero_threshold
               if( rmax == 0.0 ) then
                  ! for the case of a zeroed matrix
                  rmax = 1.0d-6
               end if
               if( BLACK_ON_WHITE == 1 ) then
                  win%color_axes(:) = [ rmax, rmin ]
               else
                  win%color_axes(:) = [ rmin, rmax ]
               end if
            end if

            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            handle = PcolorCoreSpySparse( nrow, ncol,                   &
                                          ir_sto_pg, jc_sto_pg, val_sto_pg, &
                                          is_finite )
            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

PGBOX_IN_COLORBAR = .true.
            if( color_scale_log ) then
               call set_colorbar_log( )
            else
               call msColorbar( "on" )
            end if
PGBOX_IN_COLORBAR = .false.

            if( nonzero_threshold /= 0.0d0 ) then
               new_nnz = 0
               do k = 1, nnz
                  if( abs(A%a(k)) >= nonzero_threshold ) then
                     new_nnz = new_nnz + 1
                  end if
               end do
               write(string,"(A,I0,A,ES8.1,A)")                         &
                   "sparse matrix: nb of non-zero elements = ", new_nnz, &
                   " (using threshold=", nonzero_threshold, ")"
            else
               write(string,"(A,I0)") "sparse matrix: nb of non-zero elements = ", nnz
            end if

            call msXLabel( string )

         else ! dense matrix

            allocate( mat_sto_pg(nrow,ncol) )

!### TODO 2: et pour une matrice toute à zéro, que pasa?
            rmin = huge(1.0) ! should be strictly positive
            rmax = 0.0 ! will be the max finite value of A
                       ! (cannot use 'maxval' intrinsic)
            do j = 1, ncol
               do i = 1, nrow
                  val = abs( A%double(i,j) )
                  mat_sto_pg(i,j) = val
                  if( mf_isfinite(val) ) then
                     if( val > rmax ) then
                        rmax = val
                     end if
                  if( val /= 0.0 .and. val < rmin ) then
                     rmin = val
                  end if
                  else
                     is_finite = .false.
                  end if
               end do
            end do

            if( .not. win%colormap_init ) then
               call msColormap( "grey" )
               ! set image transfer function
               ! (Default: 0=linear, but 2=square_root is more
               !  adapted for the grey scale)
               call pgsitf(2)
            end if

            if( present(nz_threshold) ) then
               if( nz_threshold == -1.0d0 ) then
                  nonzero_threshold = rmin
               else if( nz_threshold < 0.0d0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                    "nz_threshold must be positive!",   &
                                    "(only the special value -1 can be used)" )
                  go to 99
               else
                  nonzero_threshold = nz_threshold
               end if
            ! else : value defined below (depending of color_scale_log)
            end if

            if( color_scale_log ) then
               if( .not. present(nz_threshold) ) then
                  nonzero_threshold = rmax*MF_EPS
               end if
               rmin = nonzero_threshold
               ! log10 of 'mat_sto_pg', but taking care of zero values
               where( mat_sto_pg <= rmin )
                  mat_sto_pg = log10(rmin)
               elsewhere
                  mat_sto_pg = log10(mat_sto_pg)
               end where
               if( rmax == 0.0 .or. rmin == 0.0d0 ) then
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                     "cannot use log color axis, because matrix is null", &
                                     "or have too small values!" )
                  go to 99
               else
                  if( BLACK_ON_WHITE == 1 ) then
                     win%color_axes(:) = [ log10(rmax), log10(rmin) ]
                  else
                     win%color_axes(:) = [ log10(rmin), log10(rmax) ]
                  end if
               end if
            else
               if( .not. present(nz_threshold) ) then
                  nonzero_threshold = 0.0d0
               end if
               rmin = nonzero_threshold
               if( rmax == 0.0d0 ) then
                  ! for the case of a zeroed matrix
                  rmax = 1.0d-6
               end if
               if( BLACK_ON_WHITE == 1 ) then
                  win%color_axes(:) = [ rmax, rmin ]
               else
                  win%color_axes(:) = [ rmin, rmax ]
               end if
            end if

            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            handle = PcolorCoreSpy( mat_sto_pg, is_finite )
            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

PGBOX_IN_COLORBAR = .true.
            if( color_scale_log ) then
               call set_colorbar_log( )
            else
               call msColorbar( "on" )
            end if
PGBOX_IN_COLORBAR = .false.

            if( show_nnz_in_label ) then
               nnz = 0
               do j = 1, ncol
                  do i = 1, nrow
                     if( abs(A%double(i,j)) >= nonzero_threshold ) then
                        nnz = nnz + 1
                     end if
                  end do
               end do
               if( present(nz_threshold) ) then
                  write(string,"(A,I0,A,ES8.1,A)")                      &
                         "full matrix: nb of non-zero elements = ", nnz, &
                         " (using threshold=", nonzero_threshold, ")"
               else
                  write(string,"(A,I0)") "full matrix: nb of non-zero elements = ", nnz
               end if
            else
               write(string,"(A)") "full matrix"
            end if
            call msXLabel( string )

         end if

      else ! basic usage (as in Matlab)

         if( .not. mfIsSparse(A) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "basic usage is restricted to a sparse matrix!", &
                               "use the 'continuous' arg for a dense matrix" )
            go to 99
         end if

         nnz = mfNnz(A)

         allocate( jc_sto_pg(ncol+1) )

         allocate( ir_sto_pg(nnz) )

         jc_sto_pg(:) = A%j(1:ncol+1)
         ir_sto_pg(:) = A%i(1:nnz)

         if( use_pix_size ) then

            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            handle = PcolorCoreSpySparse2( nrow, ncol, ir_sto_pg, jc_sto_pg, &
                                           pix_width, pix_height )
            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

         else

            ! plot markers for non-zero values
            if( present(symbolspec) ) then
               call decode_linespec( symbolspec,                        &
                                     linecolor, linestyle, marker )
               if( marker == -127 ) then
                  marker = 3 ! star
               end if
            else
               marker = 3 ! star
               linecolor = COL_CYCLE_TAB_3(1) ! first color of scheme 3
            end if
            markersize = 1.0d0

            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            handle = PlotSpySparse( nrow, ncol, ir_sto_pg, jc_sto_pg,   &
                                    linecolor, marker, markersize )
            !+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

         end if

         write(string,"(A,I0)") "sparse matrix: nb of non-zero elements = ", nnz
         call msXLabel( string )

      end if

INTEGER_XLABEL( CURRENT_WIN_ID ) = .false.
INTEGER_YLABEL( CURRENT_WIN_ID ) = .false.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#ifdef _MF_FUNC
   end function mfSpy
#endif
#ifdef _MF_SUBR
   end subroutine msSpy
#endif
