!_______________________________________________________________________
!
   subroutine msSetXAxisUserLabels_chars( labels  )

      character(len=*), intent(in) :: labels(:)
      !------ API end ------

      ! Set the ticks labels for the X-axis only (linear mode)

      type(mf_win_info), pointer :: win

      character(len=3) :: get_ticks
      character(len=80) :: string
      integer :: i, j, nb, i1, i2

      character(len=*), parameter :: ROUTINE_NAME = "msSetXAxisUserLabels"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X-axis scaling cannot be of logarithmic type!" )
         return
      end if

      if( USER_TICKS_ALL(pgid) ) then
         if( X_ALL_TICKS_IND_START(pgid) == -666 .or.                   &
             X_ALL_TICKS_IND_END(pgid) == -666 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Cannot get the ticks number to check the nb of your labels!", &
                               "-> it works only for a linear X-axis, once a valid figure has been drawn." )
            return
         end if
         nb = X_ALL_TICKS_IND_END(pgid) - X_ALL_TICKS_IND_START(pgid) + 1
      else ! major ticks only
         if( X_MAJ_TICKS_IND_START(pgid) == -666 .or.                   &
             X_MAJ_TICKS_IND_END(pgid) == -666 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Cannot get the ticks number to check the nb of your labels!", &
                               "-> it works only for a linear X-axis, once a valid figure has been drawn." )
            return
         end if
         nb = X_MAJ_TICKS_IND_END(pgid) - X_MAJ_TICKS_IND_START(pgid) + 1
      end if

      if( size(labels) /= nb ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad number of labels" )
         return
      end if

      if( allocated(USER_TICKS_LABELS(pgid)%labels) ) then
         deallocate( USER_TICKS_LABELS(pgid)%labels )
         deallocate( USER_TICKS_LABELS(pgid)%length )
      end if

      if( USER_TICKS_ALL(pgid) ) then
         i1 = X_ALL_TICKS_IND_START(pgid)
         i2 = X_ALL_TICKS_IND_END(pgid)
      else ! major ticks only
         i1 = X_MAJ_TICKS_IND_START(pgid)
         i2 = X_MAJ_TICKS_IND_END(pgid)
      end if
      allocate( USER_TICKS_LABELS(pgid)%labels(i1:i2),                  &
                USER_TICKS_LABELS(pgid)%length(i1:i2) )

      do i = i1, i2
         j = i - i1 + 1
         if( len_trim(labels(j)) >= 6 ) then
            write(string,"(I0)") j
            string = "label " // trim(string) // " has more than 6 chars."
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               trim(string), "-> it will be truncated." )
         end if
         USER_TICKS_LABELS(pgid)%labels(i) = labels(j)
         USER_TICKS_LABELS(pgid)%length(i) =                            &
            len_trim(USER_TICKS_LABELS(pgid)%labels(i))
      end do

      USER_TICKS(pgid) = .true.

      ! must redraw all the plot (cannot erase the box only)
      call mf_win_redraw( CURRENT_WIN_ID )

   end subroutine msSetXAxisUserLabels_chars
!_______________________________________________________________________
!
   subroutine msSetXAxisUserLabels_bool( bool )

      logical, intent(in) :: bool
      !------ API end ------

      ! Reset the ticks labels for the X-axis only (linear mode), to
      ! their default numerical values.

      character(len=*), parameter :: ROUTINE_NAME = "msSetXAxisUserLabels"

   !------ end of declarations -- execution starts hereafter  ------

      if( bool ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "when arg. is a boolean, it must be equal to FALSE" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      USER_TICKS(pgid) = .false.

   end subroutine msSetXAxisUserLabels_bool
