!_______________________________________________________________________
!
   subroutine msSetX11Device( flag )

      character(len=*), intent(in) :: flag
      !------ API end ------

      character(len=*), parameter :: ROUTINE_NAME = "msSetX11Device"

   !------ end of declarations -- execution starts hereafter  ------

      if( MF_INIT_FGL == 1 ) then
         if( to_lower(flag) == "off" ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "X11 device cannot be disabled between ", &
                              "'msInitFgl' and 'msExitFgl'." )
            return
         end if
      end if

      if( to_lower(flag) == "on" ) then
#ifdef _NO_X11
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device has been disabled during compilation!", &
                            "-> it cannot be set to 'on'." )
         return
#else
         X11_DEVICE = .true.
         NULL_DEVICE = .false.
#endif
      else if( to_lower(flag) == "off" ) then
         X11_DEVICE = .false.
         NULL_DEVICE = .true.
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad arg. ! (must be ""on"" or ""off"")" )
         return
      end if

   end subroutine msSetX11Device
