!_______________________________________________________________________
!
   subroutine msSetWinProp_real( property, data )

      character(len=*), intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data
      !------ API end ------

      character(len=*), parameter :: ROUTINE_NAME = "msSetWinProp"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      select case( to_lower(property) )

         case("axis_font_size")
            mf_win_db(CURRENT_WIN_ID)%axis_font_size = data

         case("axis_line_width")
            mf_win_db(CURRENT_WIN_ID)%axis_line_width = data

         case("label_font_size")
            mf_win_db(CURRENT_WIN_ID)%label_font_size = data

         case("title_font_size")
            mf_win_db(CURRENT_WIN_ID)%title_font_size = data

         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad property for this window!" )
            return

      end select

      ! after this routine, the user must redraw the figure himself...

   end subroutine msSetWinProp_real
!_______________________________________________________________________
!
   subroutine msSetWinProp_char( property, data )

      character(len=*), intent(in) :: property
      character(len=*), intent(in) :: data
      !------ API end ------

      character(len=96) :: text_latin_1
      integer :: j, len_text_latin_1, len_text
      type(mf_win_info), pointer :: win
      type(grobj_struct), pointer :: grobj2

      character(len=*), parameter :: ROUTINE_NAME = "msSetWinProp"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      if( UTF8_ENCODING ) then
         text_latin_1  = utf8_to_latin_1( trim(data) )
      else
         text_latin_1 = trim(data)
      end if
      len_text_latin_1 = len_trim(text_latin_1)

      win => mf_win_db(CURRENT_WIN_ID)

      select case( to_lower(property) )

         case("xlabel")
            if( win%xlabel_exist ) then
               len_text = size(win%xlabel_grobj%text)
               if( len_text /= len_text_latin_1 ) then
                  deallocate( win%xlabel_grobj%text )
                  allocate( win%xlabel_grobj%text(len_text_latin_1) )
               end if
            else
               allocate( grobj2 )
               win%xlabel_grobj => grobj2
               allocate( win%xlabel_grobj%text(len_text_latin_1) )
               win%xlabel_exist = .true.
            end if
            do j = 1, len_text_latin_1
               win%xlabel_grobj%text(j) = text_latin_1(j:j)
            end do

         case("ylabel")
            if( win%ylabel_exist ) then
               len_text = size(win%ylabel_grobj%text)
               if( len_text /= len_text_latin_1 ) then
                  deallocate( win%ylabel_grobj%text )
                  allocate( win%ylabel_grobj%text(len_text_latin_1) )
               end if
            else
               allocate( grobj2 )
               win%ylabel_grobj => grobj2
               allocate( win%ylabel_grobj%text(len_text_latin_1) )
               win%ylabel_exist = .true.
            end if
            do j = 1, len_text_latin_1
               win%ylabel_grobj%text(j) = text_latin_1(j:j)
            end do

         case("title")
            if( win%title_exist ) then
               len_text = size(win%title_grobj%text)
               if( len_text /= len_text_latin_1 ) then
                  deallocate( win%title_grobj%text )
                  allocate( win%title_grobj%text(len_text_latin_1) )
               end if
            else
               allocate( grobj2 )
               win%title_grobj => grobj2
               allocate( win%title_grobj%text(len_text_latin_1) )
               win%title_exist = .true.
            end if
            do j = 1, len_text_latin_1
               win%title_grobj%text(j) = text_latin_1(j:j)
            end do

         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad property for this window!" )
            return

      end select

      ! after this routine, the user must redraw the figure himself...

   end subroutine msSetWinProp_char
