!_______________________________________________________________________
!
   subroutine msSetPdfOC_hdl_scalar_int( handle, name,                  &
                                         mutex, persistent, super_group )

      integer,          intent(in)           :: handle
      character(len=*), intent(in), optional :: name
      character(len=*), intent(in), optional :: mutex, super_group
      logical,                      optional :: persistent
      !------ API end ------

      character(len=80) :: name_latin_1, mutex_latin_1, sg_latin_1
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: value, hdle, win_id0

      character(len=*), parameter :: ROUTINE_NAME = "msSetPdfOC"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      if( present(mutex) ) then
         if( present(super_group) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'mutex' and 'super_group' names cannot be both present!" )
            return
         end if
      end if

      if( present(persistent) ) then
         if( present(name) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'persistent' and 'name' names cannot be both present!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      ! do handle exist?
      if( hdle < 1 .or. size(win%handles) < hdle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(hdle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      !---------------------

      if( grobj%struct%PDF_OC ) then
         ! this grobj was already tagged as OC, this is now just an update...
      else
         grobj%struct%PDF_OC = .true.
         win%pdf_ocg_nb = win%pdf_ocg_nb + 1
         grobj%struct%PDF_OC_num = win%pdf_ocg_nb
      end if

      if( present(name) ) then
         if( len_trim(name) > 80 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "argument 'name': length too large!",    &
                               "(it will be truncated to 80 chars.)" )
         end if
         if( UTF8_ENCODING ) then
            name_latin_1 = utf8_to_latin_1( name )
         else
            name_latin_1 = name
         end if
      else
         write(name_latin_1,"(I0)") hdle
         name_latin_1 = "handle " // trim(name_latin_1)
      end if
      grobj%struct%PDF_OC_name = name_latin_1

      if( grobj%struct%visible ) then
         grobj%struct%PDF_OC_value = 1
      else
         grobj%struct%PDF_OC_value = 0
      end if

      if( present(mutex) ) then
         grobj%struct%PDF_OC_mutex = 1
         if( UTF8_ENCODING ) then
            grobj%struct%PDF_OC_RBGroups_name = utf8_to_latin_1( mutex )
         else
            grobj%struct%PDF_OC_RBGroups_name = mutex
         end if
      else
         grobj%struct%PDF_OC_mutex = 0
      end if

      if( present(super_group) ) then
         grobj%struct%PDF_OC_sg = 1
         if( UTF8_ENCODING ) then
            grobj%struct%PDF_OC_sg_name = utf8_to_latin_1( super_group )
         else
            grobj%struct%PDF_OC_sg_name = super_group
         end if
      else
         grobj%struct%PDF_OC_sg = 0
      end if

      if( present(persistent) ) then
         if( persistent ) then
            grobj%struct%PDF_OC_mutex_default = 1
         end if
      end if

   end subroutine msSetPdfOC_hdl_scalar_int
!_______________________________________________________________________
!
   subroutine msSetPdfOC_hdl_vector_int( handle, merge, name,           &
                                         mutex, persistent, super_group )

      integer,          intent(in)           :: handle(:)
      logical,                      optional :: merge, persistent
      character(len=*), intent(in), optional :: name
      character(len=*), intent(in), optional :: mutex, super_group
      !------ API end ------

      character(len=80) :: name_latin_1, mutex_latin_1, sg_latin_1
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: value, n, i, h, win_id0
      logical :: legend, merge0

      character(len=*), parameter :: ROUTINE_NAME = "msSetPdfOC"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      if( present(mutex) ) then
         if( present(super_group) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'mutex' and 'super_group' names cannot be both present!" )
            return
         end if
      end if

      if( present(persistent) ) then
         if( present(name) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'persistent' and 'name' names cannot be both present!" )
            return
         end if
         if( .not. present(mutex) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "when arg 'persistent' is present, 'mutex' also must be present!" )
            return
         end if
      end if

      if( present(merge) ) then
         if( .not. present(name) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "when arg 'merge' is present, 'name' also must be present!" )
            return
         end if
         merge0 = merge
      else
         if( present(mutex) ) then
            merge0 = .true.
         else
            if( present(name) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                 "when arg 'merge' is not present, 'name' cannot be present!" )
               return
            end if
            merge0 = .false.
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      n = size(handle)

      if( merge0 ) then

         ! check if a legend exists...
         if( associated(mf_win_db(CURRENT_WIN_ID)%legend) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "A legend exists... hope it doesn't concern these graphic objects!" )
         end if

         ! all grobjs will have the same PDF OCG number
         win%pdf_ocg_nb = win%pdf_ocg_nb + 1

         if( present(name) ) then
            if( len_trim(name) > 80 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "argument 'name': length too large!", &
                                  "(it will be truncated to 80 chars.)" )
            end if
            if( UTF8_ENCODING ) then
               name_latin_1 = utf8_to_latin_1( name )
            else
               name_latin_1 = name
            end if
         end if

         do i = 1, n

            call decode_handle( handle(i), win_id0, h )
            if( win_id0 /= CURRENT_WIN_ID ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad grobj handle!" )
               return
            end if

            ! do handle exist?
            if( h < 1 .or. size(win%handles) < h ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "handle out of range!" )
               return
            end if

            grobj => win%handles(h)%ptr

            ! do grobj exist?
            if( .not. associated( grobj ) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "bad handle!" )
               return
            end if

            grobj%struct%PDF_OC = .true.
            grobj%struct%PDF_OC_num = win%pdf_ocg_nb
            if( present(name) ) then
               grobj%struct%PDF_OC_name = name_latin_1
            else if( present(persistent) ) then
               grobj%struct%PDF_OC_mutex_default = 1
            end if

            if( grobj%struct%visible ) then
               grobj%struct%PDF_OC_value = 1
            else
               grobj%struct%PDF_OC_value = 0
            end if

            if( present(mutex) ) then
               grobj%struct%PDF_OC_mutex = 1
               if( UTF8_ENCODING ) then
                  grobj%struct%PDF_OC_RBGroups_name = utf8_to_latin_1( mutex )
               else
                  grobj%struct%PDF_OC_RBGroups_name = mutex
               end if
            else
               grobj%struct%PDF_OC_mutex = 0
            end if

            if( present(super_group) ) then
               grobj%struct%PDF_OC_sg = 1
               if( UTF8_ENCODING ) then
                  grobj%struct%PDF_OC_sg_name = utf8_to_latin_1( super_group )
               else
                  grobj%struct%PDF_OC_sg_name = super_group
               end if
            else
               grobj%struct%PDF_OC_sg = 0
            end if

         end do

      else

         ! check if a legend exists...
         if( associated(mf_win_db(CURRENT_WIN_ID)%legend) ) then
            legend = .true.
         else
            legend = .false.
         end if

         do i = 1, n

            ! get the 'name' from the legend
            if( legend ) then
               if( i > size( mf_win_db(CURRENT_WIN_ID)%legend%legends ) ) then
                  call decode_handle( handle(i), win_id0, h )
                  write(name_latin_1,"(I0)") h
                  name_latin_1 = "handle " // trim(name_latin_1)
               else
                  name_latin_1 = mf_win_db(CURRENT_WIN_ID)%legend%legends(i)
               end if
            else
               if( present(name) ) then
                  name_latin_1 = name
               else
                  call decode_handle( handle(i), win_id0, h )
                  write(name_latin_1,"(I0)") h
                  name_latin_1 = "handle " // trim(name_latin_1)
               end if
            end if

            if( present(super_group) ) then
               call msSetPdfOC_hdl_scalar_int( handle(i), name_latin_1, &
                                               super_group=super_group )
            else
               call msSetPdfOC_hdl_scalar_int( handle(i), name_latin_1 )
            end if

         end do

      end if

   end subroutine msSetPdfOC_hdl_vector_int
