!_______________________________________________________________________
!
   subroutine msGSet_grobj( win, handle, property, data )

      type(mf_win_info), pointer    :: win
      integer,           intent(in) :: handle
      character(len=*),  intent(in) :: property
      character(len=*),  intent(in) :: data
      !------ API end ------

      type(grobj_elem), pointer :: grobj, tmp, tmp2
      integer :: color, i, l, nb_handle, linestyle, marker, ind,        &
                 cap_style, join_style

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! do handle exist?
      if( handle < 1 .or. size(win%handles) < handle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(handle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      select case( to_lower(property) )
         case( "visible" )
            if( to_lower(data) == "on" ) then
               grobj%struct%visible = .true.
            else
               grobj%struct%visible = .false.
            end if
         case( "linestyle" )
            select case( to_lower(data) )
               case( "-" ) ! continuous
                  linestyle = 1
               case( "--" ) ! dashed
                  linestyle = 2
               case( "-." ) ! dashdot
                  linestyle = 3
               case( ":" ) ! dotted
                  linestyle = 4
               case default
                  linestyle = 1 ! continuous
            end select
            grobj%struct%linestyle = linestyle
         case( "cap_style" )
            select case( to_lower(data) )
               case( "capbutt" )
                  cap_style = 0
               case( "capround" )
                  cap_style = 1
               case( "capprojecting" )
                  cap_style = 2
               case default
                  cap_style = MF_DEFAULT_CAP_STYLE
            end select
            grobj%struct%cap_style = cap_style
         case( "join_style" )
            select case( to_lower(data) )
               case( "joinmiter" )
                  join_style = 0
               case( "joinround" )
                  join_style = 1
               case( "joinbevel" )
                  join_style = 2
               case default
                  join_style = MF_DEFAULT_JOIN_STYLE
            end select
            grobj%struct%join_style = join_style
         case( "marker" )
            select case( to_lower(data) )
               case( "." ) ! point
                  marker = 1
               case( "+" ) ! plus
                  marker = 2
               case( "*" ) ! star
                  marker = 3
               case( "o" ) ! circle
                  marker = 4
               case( "x" ) ! x-mark
                  marker = 5
               case( "s" ) ! square
                  marker = 6
               case( "^" ) ! triangle (up)
                  marker = 7
               case( "d" ) ! diamond
                  marker = 11
               case( "\" ) ! color from the current scheme
!### TODO 1: to be completed
print *, '(SetGrObj_aux.f90) line 100: "marker": case not yet implemented!'
pause "only for debugging purpose"
stop
               case default
                  marker = 4 ! circle
            end select
            grobj%struct%marker = marker
         case( "color" )
            call decode_colorspec( to_lower(data), color )
            grobj%struct%color = color
         case( "col_name" )
            call decode_col_name( to_lower(data), color )
            grobj%struct%color = color
         case( "text" )
            l = len_trim(data)
            if( size(grobj%struct%text) /= l ) then
               deallocate( grobj%struct%text )
               allocate( grobj%struct%text(l) )
            end if
            do i = 1, l
               grobj%struct%text(i) = data(i:i)
            end do
         case( "position" )
            ! must count the handles
            nb_handle = 0
            tmp => win%grobj_head
            do
               if( .not. associated(tmp) ) then
                  exit
               end if
               nb_handle = nb_handle + 1
               tmp => tmp%next
            end do
            if( nb_handle >= 2 ) then
               select case( to_lower(data) )
                  case( "first" ) ! must be drawn at last
                     call isolate_grobj()
                     ! insert the object at the end
                     call move_grobj_at_end()
                  case( "last" ) ! must be drawn at first
                     call isolate_grobj()
                     ! insert the object at the beginning
                     call move_grobj_at_beginning()
                  case( "up" )
                     tmp => grobj%next
                     if( .not. associated(tmp) ) then
                        ! grobj is already at the end
                     else
                        call isolate_grobj()
                        tmp2 => tmp%next
                        if( .not. associated(tmp2) ) then
                           ! moving grobj at the end
                           call move_grobj_at_end()
                        else
                           tmp%next => grobj
                           grobj%prev => tmp
                           tmp2%prev => grobj
                           grobj%next => tmp2
                        end if
                     end if
                  case( "down" )
                     tmp => grobj%prev
                     if( .not. associated(tmp) ) then
                        ! grobj is already at the beginning
                     else
                        call isolate_grobj()
                        tmp2 => tmp%prev
                        if( .not. associated(tmp2) ) then
                           ! moving grobj at the beginning
                           call move_grobj_at_beginning()
                        else
                           tmp%prev => grobj
                           grobj%next => tmp
                           tmp2%next => grobj
                           grobj%prev => tmp2
                        end if
                     end if
               end select
            end if
         case( "eps_user_comment" )
            grobj%struct%add_user_comment_in_EPS = .true.
            grobj%struct%user_comment_in_EPS = data
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Bad property for graphic object",       &
                               'Given the data type, should be: "visible", "color", "col_name",', &
                               '"linestyle", "marker", "text", "position" or "EPS_user_comment"', &
                               'but found: "' // trim(to_lower(property)) // '"' )
            return
      end select

   contains
      !_________________________________________________________________
      !
      subroutine isolate_grobj()

         if( .not. associated( grobj%prev ) ) then
            ! grobj is at the beginning
            win%grobj_head => grobj%next
            win%grobj_head%prev => null()
         else if( .not. associated( grobj%next ) ) then
            ! grobj is at the end
            win%grobj_tail => grobj%prev
            win%grobj_tail%next => null()
         else
            grobj%prev%next => grobj%next
            grobj%next%prev => grobj%prev
         end if

      end subroutine isolate_grobj
      !_________________________________________________________________
      !
      subroutine move_grobj_at_beginning()

         grobj%prev => null()
         grobj%next => win%grobj_head
         win%grobj_head%prev => grobj
         win%grobj_head => grobj

      end subroutine move_grobj_at_beginning
      !_________________________________________________________________
      !
      subroutine move_grobj_at_end()

         grobj%prev => win%grobj_tail
         grobj%next => null()
         win%grobj_tail%next => grobj
         win%grobj_tail => grobj

      end subroutine move_grobj_at_end
      !_________________________________________________________________
      !
   end subroutine msGSet_grobj
!_______________________________________________________________________
!
   subroutine msGSet_grobj_val( win, handle, property, data )

      type(mf_win_info),    pointer    :: win
      integer,              intent(in) :: handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data
      !------ API end ------

      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: transp
      integer :: linewidth

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! do handle exist?
      if( handle < lbound(win%handles,1) .or.                           &
                   ubound(win%handles,1) < handle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(handle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      select case( to_lower(property) )
         case( "opacity" )
            transp = data
            if( transp < 0.0d0 .or. 1.0d0 < transp ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "opacity must be in [0,1]" )
               transp = max( min(0.0d0,transp), 1.0d0 )
            end if
            grobj%struct%alpha_transp = transp
         case( "linewidth" )
            linewidth = data
            if( linewidth < 0.0d0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "linewidth must be strictly positive" )
               return
            end if
            grobj%struct%linewidth = linewidth
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Bad property for graphic object",       &
                               'Given the data type, should be: "opacity" or "linewidth",', &
                               'but found: "' // trim(to_lower(property)) // '"' )
            return
      end select

   end subroutine msGSet_grobj_val
!_______________________________________________________________________
!
   subroutine msGSet_grobj_val2( win, handle, property, data )

      type(mf_win_info),    pointer    :: win
      integer,              intent(in) :: handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data(2)
      !------ API end ------

      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: d_x, d_y
      integer :: color

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! do handle exist?
      if( handle < lbound(win%handles,1) .or.                           &
                   ubound(win%handles,1) < handle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(handle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      select case( to_lower(property) )
         case( "coordinates" )
            grobj%struct%x_text = data(1)
            grobj%struct%y_text = data(2)
         case( "relat_coords" )
            ! only for handled-legend
            if( grobj%struct%cmd == "legend" ) then
               d_x = data(1) - grobj%struct%legend%x0
               d_y = data(2) - grobj%struct%legend%y0
               grobj%struct%legend%x0 = data(1)
               grobj%struct%legend%y0 = data(2)
               grobj%struct%legend%xmin = grobj%struct%legend%xmin + d_x
               grobj%struct%legend%xmax = grobj%struct%legend%xmax + d_x
               grobj%struct%legend%ymin = grobj%struct%legend%ymin + d_y
               grobj%struct%legend%ymax = grobj%struct%legend%ymax + d_y
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "Only a legend created with 'mf/msLegend' may accept", &
                                  'the "relat_coords" property!' )
            end if
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Bad property for graphic object",       &
                               'Given the data type, should be: "coordinates" or "relat_coords",', &
                               'but found: "' // trim(to_lower(property)) // '"' )
      end select

   end subroutine msGSet_grobj_val2
!_______________________________________________________________________
!
   subroutine msGSet_grobj_val3( win, handle, property, data )

      type(mf_win_info),    pointer    :: win
      integer,              intent(in) :: handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data(3)
      !------ API end ------

      type(grobj_elem), pointer :: grobj

      integer :: color

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! do handle exist?
      if( handle < lbound(win%handles,1) .or.                           &
                   ubound(win%handles,1) < handle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(handle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      select case( to_lower(property) )
         case( "col_rgb" )
            call decode_col_rgb( data, color )
            grobj%struct%color = color
         case default
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Bad property for graphic object",       &
                               'Given the data type, should be: "col_rgb",', &
                               'but found: "' // trim(to_lower(property)) // '"' )
            return
      end select

   end subroutine msGSet_grobj_val3
!_______________________________________________________________________
!
   subroutine msGSet_grobj_coords( win, handle, x, y )

      type(mf_win_info),    pointer    :: win
      integer,              intent(in) :: handle
      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:)
      !------ API end ------

      type(grobj_elem), pointer :: grobj

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! do handle exist?
      if( handle < lbound(win%handles,1) .or.                           &
                   ubound(win%handles,1) < handle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(handle)%ptr

      ! do grobj exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      ! input vector x must have the same size as abs_tab
      if( size(x) /= size(grobj%struct%abs_tab) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data1' has a bad size!" )
      end if

      ! input vector x must have the same size as abs_tab
      if( size(y) /= size(grobj%struct%ord_tab) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data2' has a bad size!" )
      end if

      grobj%struct%abs_tab = x

      grobj%struct%ord_tab = y

   end subroutine msGSet_grobj_coords
