!_______________________________________________________________________
!
   subroutine msSetGrObj_scalar_int_text( handle, property, data )

      integer,          intent(in) :: handle
      character(len=*), intent(in) :: property
      character(len=*), intent(in) :: data
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: hdle, win_id0

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      call msGSet_grobj( win, hdle, property, data )

   end subroutine msSetGrObj_scalar_int_text
!_______________________________________________________________________
!
   subroutine msSetGrObj_vector_int_text( handle, property, data )

      integer,          intent(in) :: handle(:)
      character(len=*), intent(in) :: property
      character(len=*), intent(in) :: data
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: i, hdle, win_id0

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      do i = 1, size(handle)

         call decode_handle( handle(i), win_id0, hdle )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle!" )
            return
         end if

         call msGSet_grobj( win, hdle, property, data )

      end do

   end subroutine msSetGrObj_vector_int_text
!_______________________________________________________________________
!
   subroutine msSetGrObj_mfArray_text( mf_handle, property, data )

      type(mfArray),    intent(in) :: mf_handle
      character(len=*), intent(in) :: property
      character(len=*), intent(in) :: data
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: mf_handle_ptr(:,:)
      integer :: p_dim

      type(mf_win_info), pointer :: win

      integer :: i, n, handle, hdle, win_id0
      integer :: mf_message_level_save

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call msInitArgs( mf_handle )

      ! checking that 'mf_handle' is allocated
      if( mfIsEqual(mf_handle,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' not allocated!" )
         go to 99
      end if

      ! 'mf_handle' must be real
      if( .not. mfIsReal(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' must be real!" )
         go to 99
      end if

      ! 'mf_handle' cannot be sparse
      if( mfIsSparse(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' cannot be sparse!" )
         go to 99
      end if

      call msPointer( mf_handle, mf_handle_ptr, no_crc=.true. )
      if( size(mf_handle_ptr,1) == 1 ) then
         p_dim = 2
      else
         p_dim = 1
      end if

      n = size(mf_handle_ptr,p_dim)
      do i = 1, n
         if( p_dim == 1 ) then
            handle = mf_handle_ptr(i,1)
         else
            handle = mf_handle_ptr(1,i)
         end if
         call decode_handle( handle, win_id0, hdle )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle!" )
            return
         end if
         call msGSet_grobj( win, hdle, property, data )
      end do

      call msFreePointer( mf_handle, mf_handle_ptr )

 99   continue

      call msFreeArgs( mf_handle )
      call msAutoRelease( mf_handle )

   end subroutine msSetGrObj_mfArray_text
!_______________________________________________________________________
!
   subroutine msSetGrObj_scalar_int_real( handle, property, data )

      integer,              intent(in) :: handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data
      !------ API end ------

      real(kind=MF_DOUBLE) :: data_s

      type(mf_win_info), pointer :: win
      integer :: hdle, win_id0

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      data_s = data

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      call msGSet_grobj_val( win, hdle, property, data_s )

   end subroutine msSetGrObj_scalar_int_real
!_______________________________________________________________________
!
   subroutine msSetGrObj_mfArray_real( mf_handle, property, data )

      type(mfArray),        intent(in) :: mf_handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data
      !------ API end ------

      real(kind=MF_DOUBLE) :: data_s

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: mf_handle_ptr(:,:)
      integer :: p_dim

      type(mf_win_info), pointer :: win

      integer :: i, n, handle, hdle, win_id0
      integer :: mf_message_level_save

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call msInitArgs( mf_handle )

      ! checking that 'mf_handle' is allocated
      if( mfIsEqual(mf_handle,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' not allocated!" )
         go to 99
      end if

      ! 'mf_handle' must be real
      if( .not. mfIsReal(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' must be real!" )
         go to 99
      end if

      ! 'mf_handle' cannot be sparse
      if( mfIsSparse(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' cannot be sparse!" )
         go to 99
      end if

      call msPointer( mf_handle, mf_handle_ptr, no_crc=.true. )
      if( size(mf_handle_ptr,1) == 1 ) then
         p_dim = 2
      else
         p_dim = 1
      end if

      data_s = data

      n = size(mf_handle_ptr,p_dim)
      do i = 1, n
         if( p_dim == 1 ) then
            handle = mf_handle_ptr(i,1)
         else
            handle = mf_handle_ptr(1,i)
         end if
         call decode_handle( handle, win_id0, hdle )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle!" )
            return
         end if
         call msGSet_grobj_val( win, hdle, property, data_s )
      end do

      call msFreePointer( mf_handle, mf_handle_ptr )

 99   continue

      call msFreeArgs( mf_handle )
      call msAutoRelease( mf_handle )

   end subroutine msSetGrObj_mfArray_real
!_______________________________________________________________________
!
   subroutine msSetGrObj_scalar_int_vec( handle, property, data )

      integer,              intent(in) :: handle
      character(len=*),     intent(in) :: property
      real(kind=MF_DOUBLE), intent(in) :: data(:)
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: hdle, win_id0

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      if( size(data) == 2 ) then
         call msGSet_grobj_val2( win, hdle, property, data )
      else if( size(data) == 3 ) then
         call msGSet_grobj_val3( win, hdle, property, data )
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "when 'data' is a vector, its size must be 2 or 3!" )
         return
      end if

   end subroutine msSetGrObj_scalar_int_vec
!_______________________________________________________________________
!
   subroutine msSetGrObj_scalar_int_coords( handle, prop1, data1,       &
                                                    prop2, data2 )

      integer,              intent(in) :: handle
      character(len=1),     intent(in) :: prop1, prop2
      type(mfArray)                    :: data1, data2
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: hdle, win_id0

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:) => null(),            &
                                       y_ptr(:,:) => null()

      integer :: p_dim, status_alloc

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle!" )
         return
      end if

      if( prop1 /= "x" .or. prop2 /= "y" ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "when calling with multiple properties, the only", &
                            "possible case concerns the change of coordinates;", &
                            'in such a case, first property must be "x" and the', &
                            'second one "y".')
         return
      end if

      call msInitArgs( data1, data2 )

      if( .not. mfIsNumeric(data1) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data1' must be numeric!" )
         go to 99
      end if

      if( mfIsSparse(data1) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data1' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( data1, x_ptr, status_alloc )

      ! checking that 'data1' is a 1-D array
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data1' must be a rank-1 array" )
         go to 99
      else
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
      end if

      if( .not. mfIsNumeric(data2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data2' must be numeric!" )
         go to 99
      end if

      if( mfIsSparse(data2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data2' cannot be sparse!" )
         go to 99
      end if

      call msPointer_real_only( data2, y_ptr, status_alloc )

      ! checking that 'data2' is a 1-D array
      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'data2' must be a rank-1 array" )
         go to 99
      else
         if( p_dim == 1 ) then
            if( size(x_ptr,2) /= 1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'data2' must have the same shape as 'data1'" )
               go to 99
            end if
            call msGSet_grobj_coords( win, hdle, x_ptr(:,1), y_ptr(:,1) )
         else ! p_dim = 2
            if( size(x_ptr,1) /= 1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'data2' must have the same shape as 'data1'" )
               go to 99
            end if
            call msGSet_grobj_coords( win, hdle, x_ptr(1,:), y_ptr(1,:) )
         end if
      end if


 99   continue

      call msFreeArgs( data1, data2 )

   end subroutine msSetGrObj_scalar_int_coords
