!_______________________________________________________________________
!
   subroutine msSetClipBox_real_range( dp_range )

      real(kind=MF_DOUBLE), intent(in) :: dp_range(:)

      ! define a new clipping box inside the viewport (no tests!)
      ! with the values : x_min, x_max, y_min, y_max

      ! only the first four values in the array 'dp_range' are used.

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: bbox(4)

      character(len=*), parameter :: ROUTINE_NAME = "msSetClipBox"

   !------ end of declarations -- execution starts hereafter  ------

      if( size(dp_range) /= 4 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "length of arg. 'dp_range' must be 4!" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no window selected!" )
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! change order
      bbox(1) = dp_range(1)
      bbox(2) = dp_range(3)
      bbox(3) = dp_range(2)
      bbox(4) = dp_range(4)

      call change_viewport( bbox(1:4), win%viewport(1:4) )

      ! create a new grobj
      call create_grobj( win, grobj )

      grobj%struct%cmd = "set_clip_box"
      allocate( grobj%struct%abs_tab(4) )
      grobj%struct%abs_tab(:) = bbox(:)

      ! pas besoin de handle pour ce grobj

   end subroutine msSetClipBox_real_range
