!_______________________________________________________________________
!
   subroutine msSetBackgroundColor( color_string )

      character(len=*), intent(in) :: color_string
      !------ API end ------

      character(len=*), parameter :: ROUTINE_NAME = "msSetBackgroundColor"

   !------ end of declarations -- execution starts hereafter  ------

      ! Current routine cannot be called more than once time,
      ! before opening any window.
      if( BLACK_ON_WHITE /= -1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "background color must be set",             &
                            "before opening all windows!" )
         return
      end if

      if( color_string == "white" ) then
         BLACK_ON_WHITE = 1
         ! this is the default value of MFPLOT
         MFPLOT_QUASI_BACKGROUND = MFPLOT_QUASI_WHITE
      else if( color_string == "black" ) then
         BLACK_ON_WHITE = 0
         ! the call of 'set_mfplot_background_color' is delayed just
         ! before the device opening.
         MFPLOT_QUASI_BACKGROUND = MFPLOT_QUASI_BLACK
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "color must be 'black' or 'white'!" )
      end if

   end subroutine msSetBackgroundColor
