!_______________________________________________________________________
!
   function mfSelectTypeGrObj( handles, grobj_type ) result( grobj_hdle )

      integer,          intent(in) :: handles(:)
      character(len=*), intent(in) :: grobj_type
      integer, allocatable         :: grobj_hdle(:)
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: hdle, win_id0, i, k
      character(len=5) :: i_str

      character(len=*), parameter :: ROUTINE_NAME = "msSetGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no figure selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! count grobj who match the required type
      k = 0
      do i = 1, size(handles)
         call decode_handle( handles(i), win_id0, hdle )
         if( win_id0 /= CURRENT_WIN_ID ) then
            write(i_str,"(I0)") i
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle!",                     &
                               "(element " // i_str // "in handle_vec)" )
            return
         end if
         grobj => win%handles(hdle)%ptr
         if( trim(grobj%struct%cmd) == trim(grobj_type) ) k = k + 1
      end do

      ! allocate the integer array
      allocate( grobj_hdle(k) )

      ! fill the mfArray with the handles
      k = 0
      do i = 1, size(handles)
         call decode_handle( handles(i), win_id0, hdle )
         grobj => win%handles(hdle)%ptr
         if( trim(grobj%struct%cmd) == trim(grobj_type) ) then
            k = k + 1
            grobj_hdle(k) = handles(i)
         end if
      end do

   end function mfSelectTypeGrObj
