!_______________________________________________________________________
!
   subroutine msResizeWindow( width, height )

      integer, intent(in), optional :: width, height
      !------ API end ------

      double precision :: rbuf(1)
      integer :: ibuf(3), lchr
      character :: chr

      ! The two following parameter must match the same values in the X11 driver
      integer, parameter :: XW_MIN_WIDTH  = 200 ! Minimum width (pixels)
      integer, parameter :: XW_MIN_HEIGHT = 150 ! Minimum height (pixels)

      character(len=*), parameter :: ROUTINE_NAME = "msResizeWindow"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no selected device!" )
         return
      end if

      if( present(width) .neqv. present(height) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'width' and 'height' optional arguments must be",                &
                               "both present." )
            return
      end if

      if( present(width) ) then

         ibuf(1) = 1
         ibuf(2) = width
         if( ibuf(2) < XW_MIN_WIDTH ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "width is too small",                    &
                               "(it has been set to 200 pixels)" )
         end if
         ibuf(3) = height
         if( ibuf(3) < XW_MIN_HEIGHT ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "height is too small",                   &
                               "(it has been set to 150 pixels)" )
         end if
         call grexec( grgtyp, WIN_RESIZE, rbuf, ibuf, chr, lchr )

      else ! interactive part

         if( .not. X11_DEVICE ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "X11 device is ""off"".",                &
                               "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
            return
         end if

         call set_focus_mfplot_win( 1 )

         write(STDOUT,*)
         write(STDOUT,"(A,I0,A)") "  Entering interactive mode in Figure ", &
                                  CURRENT_WIN_ID, " ... (ESC to quit)"
         write(STDOUT,*) " [you can now resize the window]"
         write(STDOUT,*)

         ibuf(1) = 0
         call grexec( grgtyp, WIN_RESIZE, rbuf, ibuf, chr, lchr )

      end if

      call pgpage()

      call mf_win_redraw( CURRENT_WIN_ID )

      call set_focus_mfplot_win( 0 )

   end subroutine msResizeWindow
