!_______________________________________________________________________
!
   subroutine msRemoveGrObj_scalar_int( handle, redraw )

      integer                       :: handle
      logical, intent(in), optional :: redraw
      !------ API end ------

      ! Remove a Graphic Object in the figure  ('delete' of Matlab)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer :: hdle, win_id0
      logical :: redraw_loc

      character(len=*), parameter :: ROUTINE_NAME = "msRemoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! Get the current window
      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call decode_handle( handle, win_id0, hdle )
      if( win_id0 /= CURRENT_WIN_ID ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad grobj handle or bad selected window!" )
         return
      end if

      ! Do handle exist?
      if( hdle < 1 .or. size(win%handles) < hdle ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "handle out of range!" )
         return
      end if

      grobj => win%handles(hdle)%ptr

      ! Do object exist?
      if( .not. associated( grobj ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad handle!" )
         return
      end if

      if( present(redraw) ) then
         redraw_loc = redraw
      else
         redraw_loc = .true.
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "msRemoveGrObj implies an inconditional redraw of all objects", &
                            "in the window." )
      end if

      ! Deallocating the structure, ...
      call delete_grobj_inside( grobj )

      ! ... update the double linked list, ...
      if( .not. associated( grobj%prev ) .and.                          &
          .not. associated( grobj%next ) ) then
         ! the list contains only one element
         win%grobj_head => null()
         win%grobj_tail => null()
      else if( .not. associated( grobj%prev ) ) then
         ! the element is at the beginning
         win%grobj_head => grobj%next
         win%grobj_head%prev => null()
      else if( .not. associated( grobj%next ) ) then
         ! the element is at the end
         win%grobj_tail => grobj%prev
         win%grobj_tail%next => null()
      else
         ! general case
         grobj%prev%next => grobj%next
         grobj%next%prev => grobj%prev
      end if

      ! ... and remove the grobj itself.
      deallocate( grobj )

      ! Update the handles vector
      win%handles(hdle)%ptr => null()

      ! Save the index value for a future usage
      if( .not. associated(win%handles_free) ) then
         call mf_win_handles_free_init(CURRENT_WIN_ID)
      end if
      win%hdle_free_last_ind = win%hdle_free_last_ind + 1
      if( win%hdle_free_last_ind > size(win%handles_free) ) then
         call mf_win_handles_free_increase_size( CURRENT_WIN_ID )
      end if
      win%handles_free(win%hdle_free_last_ind) = hdle

      handle = 0

      if( redraw_loc ) then
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

   end subroutine msRemoveGrObj_scalar_int
!_______________________________________________________________________
!
   subroutine msRemoveGrObj_vector_int( handle, redraw )

      integer                       :: handle(:)
      logical, intent(in), optional :: redraw
      !------ API end ------

      ! Remove two Graphic Objects in the figure  ('delete' of Matlab)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      integer, allocatable :: hdle(:)
      integer :: win_id0, i, n
      logical :: redraw_loc
      character(len=6) :: i_str

      character(len=*), parameter :: ROUTINE_NAME = "msRemoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      ! Get the current window
      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      n = size(handle)
      allocate( hdle(n) )

      do i = 1, n

         write(i_str,"(I0)") i

         call decode_handle( handle(i), win_id0, hdle(i) )
         if( win_id0 /= CURRENT_WIN_ID ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad grobj handle #" // trim(i_str) // " or bad selected window!" )
            return
         end if

         ! Do handles exist?
         if( hdle(i) < 1 .or. size(win%handles) < hdle(i) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "handle #" // trim(i_str) // " is out-of-range!" )
            return
         end if

      end do

      if( present(redraw) ) then
         redraw_loc = redraw
      else
         redraw_loc = .true.
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "msRemoveGrObj implies an inconditional redraw of all objects", &
                            "in the window." )
      end if

      do i = 1, n

         grobj => win%handles(hdle(i))%ptr

         ! Do object exist?
         if( .not. associated( grobj ) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad handle!" )
            return
         end if

         ! Deallocating the structure, ...
         call delete_grobj_inside( grobj )

         ! ... update the double linked list, ...
         if( .not. associated( grobj%prev ) .and.                       &
             .not. associated( grobj%next ) ) then
            ! the list contains only one element
            win%grobj_head => null()
            win%grobj_tail => null()
         else if( .not. associated( grobj%prev ) ) then
            ! the element is at the beginning
            win%grobj_head => grobj%next
            win%grobj_head%prev => null()
         else if( .not. associated( grobj%next ) ) then
            ! the element is at the end
            win%grobj_tail => grobj%prev
            win%grobj_tail%next => null()
         else
            ! general case
            grobj%prev%next => grobj%next
            grobj%next%prev => grobj%prev
         end if

         ! ... and remove the grobj itself.
         deallocate( grobj )

         ! Update the handles vector
         win%handles(hdle(i))%ptr => null()

         ! Save the index value for a future usage
         if( .not. associated(win%handles_free) ) then
            call mf_win_handles_free_init(CURRENT_WIN_ID)
         end if
         win%hdle_free_last_ind = win%hdle_free_last_ind + 1
         if( win%hdle_free_last_ind > size(win%handles_free) ) then
            call mf_win_handles_free_increase_size( CURRENT_WIN_ID )
         end if
         win%handles_free(win%hdle_free_last_ind) = hdle(i)

      end do

      handle(:) = 0

      if( redraw_loc ) then
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

   end subroutine msRemoveGrObj_vector_int
!_______________________________________________________________________
!
   subroutine msRemoveGrObj_mfArray( mf_handle, redraw )

      type(mfArray)                 :: mf_handle
      logical, intent(in), optional :: redraw
      !------ API end ------

      ! Remove a set of graphic objects ('delete' of Matlab)

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: mf_handle_ptr(:,:)
      integer :: p_dim
      logical :: redraw_loc

      integer :: i, n, handle
      integer :: mf_message_level_save

      character(len=*), parameter :: ROUTINE_NAME = "msRemoveGrObj"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( mf_handle )

      ! Checking that 'mf_handle' is allocated
      if( mfIsEqual(mf_handle,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' not allocated!" )
         go to 99
      end if

      ! 'mf_handle' must be Real
      if( .not. mfIsReal(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' must be real!" )
         go to 99
      end if

      ! 'mf_handle' cannot be sparse
      if( mfIsSparse(mf_handle) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_handle' cannot be sparse!" )
         go to 99
      end if

      call msPointer( mf_handle, mf_handle_ptr, no_crc=.true. )
      if( size(mf_handle_ptr,1) == 1 ) then
         p_dim = 2
      else
         p_dim = 1
      end if

      n = size(mf_handle_ptr,p_dim)
      do i = 1, n

         if( p_dim == 1 ) then
            handle = mf_handle_ptr(i,1)
         else
            handle = mf_handle_ptr(1,i)
         end if

         call msRemoveGrObj_scalar_int( handle, redraw=.false. )

         if( p_dim == 1 ) then
            mf_handle_ptr(i,1) = 0
         else
            mf_handle_ptr(1,i) = 0
         end if

      end do

      call msFreePointer( mf_handle, mf_handle_ptr )

      if( present(redraw) ) then
         redraw_loc = redraw
      else
         redraw_loc = .true.
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "msRemoveGrObj implies an inconditional redraw of all objects", &
                            "in the window." )
      end if

      if( redraw_loc ) then
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

 99   continue

      call msFreeArgs( mf_handle )
      call msAutoRelease( mf_handle )

   end subroutine msRemoveGrObj_mfArray
