!_______________________________________________________________________
!
   subroutine mf_quiver_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "quiver"

      type(mf_win_info), pointer :: win

      integer :: i, j, nx, ny, step
      real(kind=MF_DOUBLE) :: fact, arrow_head
      real(kind=MF_DOUBLE) :: x_start_pg, y_start_pg, x_end_pg, y_end_pg
      real(kind=MF_DOUBLE), pointer :: xx(:,:), yy(:,:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Quiver", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Quiver", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      nx = size(grobj%struct%val_mat,1)
      ny = size(grobj%struct%val_mat,2)
      fact = grobj%struct%x_text
      call grsci(grobj%struct%color)
      call grslw(grobj%struct%linewidth)
      arrow_head = grobj%struct%y_text
      ! *** under a zoom, we must increase the arrow head size...
      arrow_head = arrow_head * win%abs_zoom_factor
      call pgsch(arrow_head) ! automatic setting for arrow head
      if( fact /= 0.0d0 ) then
         step = grobj%struct%linestyle
         do i = 1, nx, step
            do j = 1, ny, step
               ! Quick return if any component is NaN
               if( isnan(grobj%struct%val_mat(i,j)) ) cycle
               if( isnan(grobj%struct%val_mat_2(i,j)) ) cycle
               if( grobj%struct%npt == -1 ) then ! (x,y) present
                  if( grobj%struct%npt2 == -1 ) then ! (x,y) mat
                     if( grobj%struct%npt3 == -2 ) then ! cell centered
                        xx => grobj%struct%abs_mat
                        yy => grobj%struct%ord_mat
                        call center_quadrangle( xx(i,j),     yy(i,j),   &
                                                xx(i+1,j),   yy(i+1,j), &
                                                xx(i+1,j+1), yy(i+1,j+1), &
                                                xx(i,j+1),   yy(i,j+1), &
                                                x_start_pg, y_start_pg )
                        x_start_pg = ( grobj%struct%abs_tab(j) + grobj%struct%abs_tab(j+1) ) / 2.
                        y_start_pg = ( grobj%struct%ord_tab(i) + grobj%struct%ord_tab(i+1) ) / 2.
                     else ! vertex centered
                        x_start_pg = grobj%struct%abs_mat(i,j)
                        y_start_pg = grobj%struct%ord_mat(i,j)
                     end if
                  else ! (x,y) vec
                     if( grobj%struct%npt3 == -2 ) then ! cell centered
                        x_start_pg = ( grobj%struct%abs_tab(j) + grobj%struct%abs_tab(j+1) ) / 2.
                        y_start_pg = ( grobj%struct%ord_tab(i) + grobj%struct%ord_tab(i+1) ) / 2.
                     else ! vertex centered
                        x_start_pg = grobj%struct%abs_tab(j)
                        y_start_pg = grobj%struct%ord_tab(i)
                     end if
                  end if
               else ! (x,y) not present
                  if( grobj%struct%npt3 == -2 ) then
                     x_start_pg = j+0.5
                     y_start_pg = i+0.5
                  else
                     x_start_pg = j
                     y_start_pg = i
                  end if
               end if
               x_end_pg = x_start_pg + fact*grobj%struct%val_mat(i,j)
               y_end_pg = y_start_pg + fact*grobj%struct%val_mat_2(i,j)
               ! Quick return (but not optimized!)
               if( MF_QR_in_aux_pixmap ) then
                  ! x_..._QR , y_..._QR defined in Pan or PanAndZoom
               else
                  x_left_QR   = win%current_axes(1)
                  x_right_QR  = win%current_axes(2)
                  y_bottom_QR = win%current_axes(3)
                  y_top_QR    = win%current_axes(4)
               end if
               if( win%current_axes(1) > win%current_axes(2) ) then ! x inverted
                  if( max(x_start_pg,x_end_pg) < x_right_QR ) cycle
                  if( min(x_start_pg,x_end_pg) > x_left_QR ) cycle
               else ! x not inverted
                  if( max(x_start_pg,x_end_pg) < x_left_QR ) cycle
                  if( min(x_start_pg,x_end_pg) > x_right_QR ) cycle
               end if
               if( win%current_axes(3) > win%current_axes(4) ) then ! y inverted
                  if( max(y_start_pg,y_end_pg) < y_top_QR ) cycle
                  if( min(y_start_pg,y_end_pg) > y_bottom_QR ) cycle
               else ! y not inverted
                  if( max(y_start_pg,y_end_pg) < y_bottom_QR ) cycle
                  if( min(y_start_pg,y_end_pg) > y_top_QR ) cycle
               end if
               ! draw an arrow; the headsize is proportional to char. height
               call pgarro( x_start_pg, y_start_pg, x_end_pg, y_end_pg, &
                            clipping=.true. )
            end do
         end do
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Quiver", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Quiver", 0 )
         end if
      end if

   contains
   !____________________________________________________________________
   !
      subroutine center_quadrangle( x1, y1, x2, y2, x3, y3, x4, y4,     &
                                    xc, yc )
         real(kind=MF_DOUBLE), intent(in) :: x1, y1, x2, y2, x3, y3, x4, y4
         real(kind=MF_DOUBLE)             :: xc, yc
         !------ API end ------

         ! Compute a center of a given quadrangle.
         ! This is not the true center of mass of a plate which have the
         ! same shape, but the center of mass of four masses located at each
         ! vertex of the quadrangle.

         xc = 0.25d0*( x1 + x2 + x3 + x4 )
         yc = 0.25d0*( y1 + y2 + y3 + y4 )

      end subroutine center_quadrangle
   !____________________________________________________________________
   !
   end subroutine mf_quiver_draw
