!
! codes pour mf_win_redraw : (et get_true_min_max)
!
!   grobj%struct%npt  = -1 : (x,y) present
!                       -2 : (x,y) not present
!
!   grobj%struct%npt2 = -1 : (x,y) mat
!                       -2 : (x,y) vec
!
!   grobj%struct%npt3 = -1 : vertex centered [default]
!                       -2 :   cell centered
!

!_______________________________________________________________________
!
   function QuiverCoreMat( u, v, cell_centered, icol, arrow_length,     &
                           step, linewidth, arrow_head, x, y )          &
   result( handle )

      real(kind=MF_DOUBLE), pointer, intent(in)     :: u(:,:), v(:,:)
      logical,                       intent(in)     :: cell_centered
      integer,                       intent(in)     :: icol
      real(kind=MF_DOUBLE),          intent(in)     :: arrow_length
      integer,                       intent(in)     :: step
      real(kind=MF_DOUBLE),          intent(in)     :: linewidth
      real(kind=MF_DOUBLE),          intent(in out) :: arrow_head
      real(kind=MF_DOUBLE), pointer                 :: x(:,:), y(:,:)

      integer :: handle
      !------ API end ------

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      real(kind=MF_DOUBLE) :: x_start_pg, y_start_pg, x_end_pg, y_end_pg

      integer :: i, j, nj, ni, hdle
      real(kind=MF_DOUBLE) :: uv_max, fact
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ni = size(u,1) ! rows    = ny
      nj = size(u,2) ! columns = nx

      call pgbbuf()

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x(:,:) ) ! x_min
      range(2) = maxval( x(:,:) ) ! x_max
      range(3) = minval( y(:,:) ) ! y_min
      range(4) = maxval( y(:,:) ) ! y_max

      win => mf_win_db(CURRENT_WIN_ID)

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      uv_max = sqrt( maxval( u(:,:)**2 + v(:,:)**2 ) )
      if( uv_max == 0.0d0 ) then
         fact = 0.
      else
         fact = min( (range(2)-range(1))/(nj-1),                        &
                     (range(4)-range(3))/(ni-1) ) /uv_max
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ! user multiplicative factor for the arrow length
      fact = fact*arrow_length

      if( arrow_head == -1.0 ) then
         ! this means that the user didn't use this argument...
         ! automatic selection
         arrow_head = 10.0/max(nj,ni) * arrow_length
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "quiver"
      grobj%struct%range = range
      grobj%struct%val_mat => u
      grobj%struct%val_mat_2 => v
      grobj%struct%color = icol
      grobj%struct%x_text = fact
      grobj%struct%y_text = arrow_head
      grobj%struct%linestyle = step
      grobj%struct%linewidth = linewidth

      grobj%struct%npt = -1
      grobj%struct%npt2 = -1
      grobj%struct%abs_mat => x
      grobj%struct%ord_mat => y

      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else
         grobj%struct%npt3 = -1
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_quiver_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function QuiverCoreMat
!_______________________________________________________________________
!
   function QuiverCoreVec( u, v, cell_centered, icol, arrow_length,     &
                           step, linewidth, arrow_head, x, y )          &
   result( handle )

      real(kind=MF_DOUBLE), pointer, intent(in)     :: u(:,:), v(:,:)
      logical,                       intent(in)     :: cell_centered
      integer,                       intent(in)     :: icol
      real(kind=MF_DOUBLE),          intent(in)     :: arrow_length
      integer,                       intent(in)     :: step
      real(kind=MF_DOUBLE),          intent(in)     :: linewidth
      real(kind=MF_DOUBLE),          intent(in out) :: arrow_head
      real(kind=MF_DOUBLE), pointer,       optional :: x(:), y(:)

      integer :: handle
      !------ API end ------

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: range(4)

      real(kind=MF_DOUBLE) :: x_start_pg, y_start_pg, x_end_pg, y_end_pg

      integer :: i, j, nj, ni, hdle
      logical :: x_and_y_present
      real(kind=MF_DOUBLE) :: uv_max, fact
      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ni = size(u,1) ! rows    = ny
      nj = size(u,2) ! columns = nx

      call pgbbuf()

      x_and_y_present = present(x) .and. present(y)

      ! les [nouveaux] axes doivent être prêts
      if( present(x) .and. present(y) ) then
         range(1) = min( x(1), x(nj) ) ! x_min
         range(2) = max( x(1), x(nj) ) ! x_max
         range(3) = min( y(1), y(ni) ) ! y_min
         range(4) = max( y(1), y(ni) ) ! y_max
      else
         if( cell_centered ) then
            range(:) = [ 1, nj+1, ni+1, 1 ]
         else ! vertex centered
            range(:) = [ 1, nj, ni, 1 ]
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      win%axis_scale_x = 1 ! lin
      win%axis_scale_y = 1 ! lin

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      uv_max = sqrt( maxval( u(:,:)**2 + v(:,:)**2 ) )
      if( uv_max == 0.0d0 ) then
         fact = 0.
      else
         if( present(x) .and. present(y) ) then
            fact = min( (range(2)-range(1))/(nj-1),                     &
                        (range(4)-range(3))/(ni-1) ) /uv_max
         else
            fact = 1.0/uv_max
         end if
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ! user multiplicative factor for the arrow length
      fact = fact*arrow_length

      if( arrow_head == -1.0 ) then
         ! this means that the user didn't use this argument...
         ! automatic selection
         arrow_head = 10.0/max(nj,ni) * arrow_length
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "quiver"
      grobj%struct%range = range
      grobj%struct%val_mat => u
      grobj%struct%val_mat_2 => v
      grobj%struct%color = icol
      grobj%struct%x_text = fact
      grobj%struct%y_text = arrow_head
      grobj%struct%linestyle = step
      grobj%struct%linewidth = linewidth

      if( present(x) .and. present(y) ) then
         grobj%struct%npt = -1
         grobj%struct%npt2 = -2
         grobj%struct%abs_tab => x
         grobj%struct%ord_tab => y
      else
         grobj%struct%npt = -2
      end if

      if( cell_centered ) then
         grobj%struct%npt3 = -2
      else
         grobj%struct%npt3 = -1
      end if

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_quiver_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

   end function QuiverCoreVec
