!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfQuiver_uv( u, v, data_centering, color,                   &
                         arrow_length, step, linewidth, arrow_head )                        &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msQuiver_uv( u, v, data_centering, color,                 &
                           arrow_length, step, linewidth, arrow_head )
#endif

      type(mfArray)                              :: u, v
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: color
      real(kind=MF_DOUBLE), intent(in), optional :: arrow_length
      integer,              intent(in), optional :: step
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: u_ptr(:,:), v_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: u_sto_pg(:,:), v_sto_pg(:,:)
      integer :: ni, nj, icol
      logical :: cell_centered

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

      real(kind=MF_DOUBLE) :: arrow_length_0
      integer :: step_0
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfQuiver"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msQuiver"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( u, v )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      ! default value
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if
      if( present(color) ) then
         call decode_colorspec( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(arrow_length) ) then
         arrow_length_0 = arrow_length
      else
         arrow_length_0 = 1.0 ! default arrow length factor
      end if

      if( present(step) ) then
         step_0 = step
      else
         step_0 = 1 ! default step for displaying arrows
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = -1.0
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! added test for icol (for black or white, no problem)
      if( .not. win%colormap_init .and. (icol /= 0 .and. icol /= 1) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and EPS)" )
      end if

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      call msPointer( u, u_ptr, no_crc=.true. )

      call msPointer( v, v_ptr, no_crc=.true. )

      ni = size(u_ptr,1)
      nj = size(u_ptr,2)
      allocate( u_sto_pg(ni,nj) )

      u_sto_pg(:,:) = u_ptr(:,:)

      allocate( v_sto_pg(ni,nj) )

!############## pour être cohérent avec MeshGrid et Gradient
      v_sto_pg(:,:) = -v_ptr(:,:)

      call msFreePointer( u, u_ptr )

      call msFreePointer( v, v_ptr )

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      handle = QuiverCoreVec( u_sto_pg, v_sto_pg, cell_centered, icol,  &
                              arrow_length_0, step_0,                   &
                              linewidth_0, arrow_head_0 )

 99   continue

      call msFreeArgs( u, v )
      call msAutoRelease( u, v )

#ifdef _MF_FUNC
   end function mfQuiver_uv
#endif
#ifdef _MF_SUBR
   end subroutine msQuiver_uv
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfQuiver_xyuv( x, y, u, v, data_centering, color, arrow_length, &
                           step, linewidth, arrow_head )                &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msQuiver_xyuv( x, y, u, v, data_centering, color,         &
                             arrow_length, step, linewidth, arrow_head )
#endif

      type(mfArray)                              :: x, y, u, v
      character(len=*),     intent(in), optional :: data_centering
      character(len=*),     intent(in), optional :: color
      real(kind=MF_DOUBLE), intent(in), optional :: arrow_length
      integer,              intent(in), optional :: step
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, arrow_head

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:),          &
                                       u_ptr(:,:), v_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:),                        &
                       u_sto_pg(:,:), v_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      logical :: full_matrix
      integer :: ni, nj, icol, nx_pg, ny_pg, p_dim
      integer :: nx_abs, ny_abs, nx_ord, ny_ord

      type(mf_win_info), pointer :: win
      integer :: mf_message_level_save

      logical :: cell_centered

      real(kind=MF_DOUBLE) :: arrow_length_0
      integer :: step_0
      real(kind=MF_DOUBLE) :: linewidth_0, arrow_head_0

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfQuiver"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msQuiver"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      call msInitArgs( x, y, u, v )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! optional data centering
      if( present(data_centering) ) then
         if( data_centering == "cell" ) then
            cell_centered = .true.
         else if( data_centering == "vertex" ) then
            cell_centered = .false.
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'data_centering' must be equal to 'vertex' or 'cell'!" )
            go to 99
         end if
      else
         cell_centered = .false.
      end if

      ! default value
      if( BLACK_ON_WHITE == 1 ) then
         icol = 1
      else
         icol = 0
      end if
      if( present(color) ) then
         call decode_colorspec( color, icol )
      end if

      if( present(arrow_length) ) then
         arrow_length_0 = arrow_length
      else
         arrow_length_0 = 1.0 ! default arrow length factor
      end if

      if( present(step) ) then
         step_0 = step
      else
         step_0 = 1 ! default step for displaying arrows
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0
      end if

      if( present(arrow_head) ) then
         arrow_head_0 = arrow_head
      else
         arrow_head_0 = -1.0
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! added test for icol (for black or white, no problem)
      if( .not. win%colormap_init .and. (icol /= 0 .and. icol /= 1) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and EPS)" )
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be Real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      ! checking that 'u' is allocated
      if( mfIsEqual(u,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' not allocated!" )
         go to 99
      end if

      ! checking that 'v' is allocated
      if( mfIsEqual(v,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' not allocated!" )
         go to 99
      end if

      ! 'u' and 'v' must have the same shape
      if( any(shape(u) /= shape(v)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' and 'v' must have the same shape!" )
         go to 99
      end if

      ! 'u' must be Real
      if( .not. mfIsReal(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' must be real!" )
         go to 99
      end if

      ! 'v' must be Real
      if( .not. mfIsReal(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' must be real!" )
         go to 99
      end if

      ! 'u' cannot be sparse
      if( mfIsSparse(u) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'u' cannot be sparse!" )
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'v' cannot be sparse!" )
         go to 99
      end if

      ni = size(u,1)
      nj = size(u,2)

      if( .not. cell_centered ) then
         if( ni < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of rows is too small!",          &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
         if( nj < 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "number of columns is too small!",       &
                               '(hint: use data_centering="cell")' )
            go to 99
         end if
      end if

      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_abs-1 .or. nj /= nx_abs-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, shape of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_abs .or. nj /= nx_abs ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_abs_sto_pg(ny_abs,nx_abs) )

         mat_abs_sto_pg(:,:) = x_ptr(:,:)
      else                                               ! vector
         full_matrix = .false.
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         if( cell_centered ) then
            if( nj /= nx_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, size of 'x'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( nj /= nx_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "dimension of 'x' and 'u' don't match!" )
               go to 99
            end if
         end if
         allocate( x_sto_pg(nx_pg) )

         if( p_dim == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         if( cell_centered ) then
            if( ni /= ny_ord-1 .or. nj /= nx_ord-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, shape of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_ord .or. nj /= nx_ord ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "shape of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if
         allocate( mat_ord_sto_pg(ny_ord,nx_ord) )

         mat_ord_sto_pg(:,:) = y_ptr(:,:)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         if( cell_centered ) then
            if( ni /= ny_pg-1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "in the 'cell_centered option, size of 'y'", &
                                  "must be consistent with those of 'u'!" )
               go to 99
            end if
         else
            if( ni /= ny_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "size of 'y' and 'u' don't match!" )
               go to 99
            end if
         end if
         allocate( y_sto_pg(ny_pg) )

         if( p_dim == 1 ) then
            y_sto_pg(:) = y_ptr(:,1)
         else
            y_sto_pg(:) = y_ptr(1,:)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( u, u_ptr, no_crc=.true. )

      call msPointer( v, v_ptr, no_crc=.true. )

      allocate( u_sto_pg(ni,nj) )

      u_sto_pg(:,:) = u_ptr(:,:)

      allocate( v_sto_pg(ni,nj) )

      v_sto_pg(:,:) = v_ptr(:,:)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      if( full_matrix ) then
         ! matrix case
         handle = QuiverCoreMat( u_sto_pg, v_sto_pg, cell_centered, icol, &
                                 arrow_length_0, step_0, linewidth_0, arrow_head_0, &
                                 mat_abs_sto_pg, mat_ord_sto_pg )
      else
         ! vector case
         handle = QuiverCoreVec( u_sto_pg, v_sto_pg, cell_centered, icol, &
                                 arrow_length_0, step_0, linewidth_0, arrow_head_0, &
                                 x_sto_pg, y_sto_pg )
      end if

      call msFreePointer( u, u_ptr )

      call msFreePointer( v, v_ptr )

 99   continue

      call msFreeArgs( x, y, u, v )
      call msAutoRelease( x, y, u, v )

#ifdef _MF_FUNC
   end function mfQuiver_xyuv
#endif
#ifdef _MF_SUBR
   end subroutine msQuiver_xyuv
#endif
